/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.IMethodProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ListenerList;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.util.TimerTests;

public abstract class ProxyFactoryRegistry {
    protected boolean fIsValid = true;
    protected ListenerList registryListeners = new ListenerList();
    protected IStandardBeanProxyFactory fCurrentStandardBeanProxyFactory;
    protected final Hashtable fRegisteredExtensionBeanProxyFactories = new Hashtable();
    protected IStandardBeanTypeProxyFactory fCurrentStandardBeanTypeProxyFactory;
    protected final Hashtable fRegisteredExtensionBeanTypeProxyFactories = new Hashtable();
    protected IMethodProxyFactory fMethodProxyFactory = null;
    protected final Hashtable fRegisteredConstants = new Hashtable();

    public void addRegistryListener(IRegistryListener listener) {
        this.registryListeners.add(listener);
    }

    public void removeRegistryListener(IRegistryListener listener) {
        this.registryListeners.remove(listener);
    }

    protected void fireRegistryTerminated() {
        if (!this.registryListeners.isEmpty()) {
            Object[] list = this.registryListeners.getListeners();
            int i = 0;
            while (i < list.length) {
                ((IRegistryListener)list[i]).registryTerminated(this);
                ++i;
            }
        }
    }

    public IStandardBeanProxyFactory getBeanProxyFactory() {
        if (this.fCurrentStandardBeanProxyFactory == null) {
            throw new RuntimeException(ProxyMessages.ProxyFactory_EXC__NoBeanProxyFactory);
        }
        return this.fCurrentStandardBeanProxyFactory;
    }

    public IBeanProxyFactory getBeanProxyFactoryExtension(String packageName) {
        return (IBeanProxyFactory)this.fRegisteredExtensionBeanProxyFactories.get(packageName);
    }

    public IStandardBeanTypeProxyFactory getBeanTypeProxyFactory() {
        if (this.fCurrentStandardBeanTypeProxyFactory == null) {
            throw new RuntimeException(ProxyMessages.ProxyFactory_EXC__NoBeanTypeProxyFactory);
        }
        return this.fCurrentStandardBeanTypeProxyFactory;
    }

    public IBeanTypeProxyFactory getBeanTypeProxyFactoryExtension(String packageName) {
        return (IBeanTypeProxyFactory)this.fRegisteredExtensionBeanTypeProxyFactories.get(packageName);
    }

    public Object getConstants(Object key) {
        return this.fRegisteredConstants.get(key);
    }

    public IMethodProxyFactory getMethodProxyFactory() {
        return this.fMethodProxyFactory;
    }

    public void registerConstants(Object key, Object constant) {
        this.fRegisteredConstants.put(key, constant);
    }

    public void deregisterConstants(Object key) {
        this.fRegisteredConstants.remove(key);
    }

    public void releaseProxy(IBeanProxy proxy) {
        if (this.fCurrentStandardBeanProxyFactory != null) {
            this.fCurrentStandardBeanProxyFactory.releaseProxy(proxy);
        }
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public final void terminateRegistry() {
        this.terminateRegistry(false);
    }

    public final void terminateRegistry(boolean wait) {
        if (!this.fIsValid) {
            return;
        }
        this.fIsValid = false;
        if (this.fCurrentStandardBeanTypeProxyFactory != null) {
            this.fCurrentStandardBeanTypeProxyFactory.terminateFactory(wait);
            this.fCurrentStandardBeanTypeProxyFactory = null;
        }
        if (this.fCurrentStandardBeanProxyFactory != null) {
            this.fCurrentStandardBeanProxyFactory.terminateFactory(wait);
            this.fCurrentStandardBeanProxyFactory = null;
        }
        if (this.fMethodProxyFactory != null) {
            this.fMethodProxyFactory.terminateFactory(wait);
            this.fMethodProxyFactory = null;
        }
        Iterator itr = this.fRegisteredExtensionBeanTypeProxyFactories.values().iterator();
        while (itr.hasNext()) {
            ((IBeanProxyFactory)itr.next()).terminateFactory(wait);
        }
        this.fRegisteredExtensionBeanTypeProxyFactories.clear();
        itr = this.fRegisteredExtensionBeanProxyFactories.values().iterator();
        while (itr.hasNext()) {
            ((IBeanProxyFactory)itr.next()).terminateFactory(wait);
        }
        this.fRegisteredExtensionBeanProxyFactories.clear();
        this.fRegisteredConstants.clear();
        TimerTests.basicTest.startStep("Registry Terminated");
        this.registryTerminated(wait);
        TimerTests.basicTest.stopStep("Registry Terminated");
        this.fireRegistryTerminated();
    }

    protected abstract void registryTerminated(boolean var1);

    public abstract ICallbackRegistry getCallbackRegistry();

    public static interface IRegistryListener {
        public void registryTerminated(ProxyFactoryRegistry var1);
    }
}

