/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.servertype.definition.Property;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.GenericUiPlugin;
import org.eclipse.jst.server.generic.ui.internal.SWTUtil;
import org.eclipse.jst.server.generic.ui.internal.editor.UpdateServerPropertyOperation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerPropertiesEditorSection
extends ServerEditorSection {
    private static final String MESSAGE_ID_SERVER_RUNNING = "server_running";
    protected GenericServer fServer;
    private PropertyChangeListener fPropertyChangeListener;
    private ILaunchesListener2 fLaunchListener;
    private Map fControls = new HashMap();
    protected boolean fUpdating;
    static /* synthetic */ Class class$0;

    public void init(final IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fServer = (GenericServer)this.server.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
        }
        this.fPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("generic_server_instance_properties") && !ServerPropertiesEditorSection.this.fUpdating) {
                    ServerPropertiesEditorSection.this.fUpdating = true;
                    ServerPropertiesEditorSection.this.updateControls();
                    ServerPropertiesEditorSection.this.fUpdating = false;
                }
            }
        };
        this.server.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fLaunchListener = new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
            }

            private ILaunchConfiguration getServerLaunchConfig(ILaunch[] launches) {
                int i = 0;
                while (i < launches.length) {
                    ILaunchConfiguration launchConfig = launches[i].getLaunchConfiguration();
                    if (launchConfig != null) {
                        try {
                            String serverId = launchConfig.getAttribute("server-id", null);
                            if (ServerPropertiesEditorSection.this.fServer.getServer().getId().equals(serverId)) {
                                return launchConfig;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++i;
                }
                return null;
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
                ILaunchConfiguration lc = this.getServerLaunchConfig(launches);
                try {
                    if (lc != null) {
                        if ("true".equals(lc.getAttribute("stop-server", "false"))) {
                            site.getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    IManagedForm managedForm = ServerPropertiesEditorSection.access$0(2.access$0(this.this$1));
                                    managedForm.getMessageManager().removeMessage((Object)"server_running");
                                    managedForm.getMessageManager().update();
                                }
                            });
                        } else {
                            site.getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(this){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    ServerPropertiesEditorSection.access$0(2.access$0(this.this$1)).getMessageManager().addMessage((Object)"server_running", GenericServerUIMessages.serverRunningCanNotSave, null, 2);
                                }
                            });
                        }
                    }
                }
                catch (CoreException e) {
                    GenericUiPlugin.getDefault().getLog().log(e.getStatus());
                }
            }

            public void launchesTerminated(ILaunch[] launches) {
                if (this.getServerLaunchConfig(launches) != null) {
                    site.getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ServerPropertiesEditorSection.access$0(2.access$0(this.this$1)).getMessageManager().removeMessage((Object)"server_running");
                        }
                    });
                }
            }

            static /* synthetic */ ServerPropertiesEditorSection access$0(2 var0) {
                return var0.ServerPropertiesEditorSection.this;
            }
        };
        this.getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchListener);
    }

    protected void updateControls() {
        EList props = this.fServer.getServerDefinition().getProperty();
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            String value;
            Property property = (Property)iter.next();
            if (!property.getContext().equals("server")) continue;
            if ("boolean".equals(property.getType())) {
                Button b = (Button)this.fControls.get(property.getId());
                b.setSelection("true".equals(this.getPropertyValue(property)));
                continue;
            }
            if ("select".equals(property.getType()) || "combo".equals(property.getType())) {
                Combo c = (Combo)this.fControls.get(property.getId());
                value = this.getPropertyValue(property) == null ? "" : this.getPropertyValue(property);
                c.setText(value);
                continue;
            }
            Text t = (Text)this.fControls.get(property.getId());
            value = this.getPropertyValue(property) == null ? "" : this.getPropertyValue(property);
            t.setText(value);
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit formToolkit = this.getFormToolkit(parent.getDisplay());
        Section section = formToolkit.createSection(parent, 458);
        section.setText(GenericServerUIMessages.ServerEditorSectionTitle);
        section.setDescription(GenericServerUIMessages.ServerEditorSectionDescription);
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite = formToolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        EList props = this.fServer.getServerDefinition().getProperty();
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.getContext().equals("server")) continue;
            this.createPropertyControl(composite, property, formToolkit);
        }
        formToolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        if (this.getExistingLaunch() != null) {
            this.getManagedForm().getMessageManager().addMessage((Object)MESSAGE_ID_SERVER_RUNNING, GenericServerUIMessages.serverRunningCanNotSave, null, 2);
        }
    }

    protected void executeUpdateOperation(String propertyName, String propertyValue) {
        if (!this.fUpdating) {
            this.fUpdating = true;
            this.execute((IUndoableOperation)new UpdateServerPropertyOperation(this.server, GenericServerUIMessages.UpdateOperationDescription, propertyName, propertyValue));
            this.fUpdating = false;
        }
    }

    private void createPropertyControl(Composite parent, final Property property, FormToolkit toolkit) {
        if ("directory".equals(property.getType())) {
            final Text path = SWTUtil.createLabeledPath(property.getLabel(), this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), path);
            path.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), path.getText());
                }
            });
        } else if ("file".equals(property.getType())) {
            final Text file = SWTUtil.createLabeledFile(property.getLabel(), this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), file);
            file.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), file.getText());
                }
            });
        } else if ("boolean".equals(property.getType())) {
            final Button bool = SWTUtil.createLabeledCheck(property.getLabel(), "true".equals(this.getPropertyValue(property)), parent, toolkit);
            this.fControls.put(property.getId(), bool);
            bool.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), Boolean.toString(bool.getSelection()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if ("select".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            int tokenCount = tokenizer.countTokens();
            String[] values = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens() && i < tokenCount) {
                values[i] = tokenizer.nextToken();
                ++i;
            }
            final Combo combo = SWTUtil.createLabeledCombo(property.getLabel(), values, parent, toolkit);
            this.fControls.put(property.getId(), combo);
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }
            });
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if ("combo".equals(property.getType())) {
            StringTokenizer tokenizer = new StringTokenizer(property.getDefault(), ",");
            int tokenCount = tokenizer.countTokens();
            String[] values = new String[tokenCount];
            int i = 0;
            while (tokenizer.hasMoreTokens() && i < tokenCount) {
                values[i] = tokenizer.nextToken();
                ++i;
            }
            final Combo combo = SWTUtil.createLabeledEditableCombo(property.getLabel(), values, this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), combo);
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }
            });
            combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), combo.getText());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            final Text defaultText = SWTUtil.createLabeledText(property.getLabel(), this.getPropertyValue(property), parent, toolkit);
            this.fControls.put(property.getId(), defaultText);
            defaultText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServerPropertiesEditorSection.this.executeUpdateOperation(property.getId(), defaultText.getText());
                }
            });
        }
    }

    private String getPropertyValue(Property property) {
        return (String)this.fServer.getServerInstanceProperties().get(property.getId());
    }

    public void dispose() {
        super.dispose();
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchListener);
    }

    public ILaunch getExistingLaunch() {
        ILaunchManager launchManager = this.getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int size = launches.length;
        int i = 0;
        while (i < size) {
            ILaunchConfiguration launchConfig = launches[i].getLaunchConfiguration();
            try {
                if (launchConfig != null) {
                    String serverId = launchConfig.getAttribute("server-id", null);
                    if (this.fServer.getServer().getId().equals(serverId) && !launches[i].isTerminated()) {
                        return launches[i];
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    private ILaunchManager getLaunchManager() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager;
    }

    private IStatus validate() {
        if (this.getExistingLaunch() != null) {
            return new Status(2, "org.eclipse.jst.server.generic.ui", GenericServerUIMessages.serverRunningCanNotSave);
        }
        return null;
    }

    public IStatus[] getSaveStatus() {
        IStatus status = this.validate();
        if (status != null) {
            IStatus[] statusArray = new IStatus[]{status};
            return statusArray;
        }
        return super.getSaveStatus();
    }

    static /* synthetic */ IManagedForm access$0(ServerPropertiesEditorSection serverPropertiesEditorSection) {
        return serverPropertiesEditorSection.getManagedForm();
    }
}

