/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.connection;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.core.context.persistence.Property;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.connection.BatchWriting;
import org.eclipse.jpt.eclipselink.core.internal.context.connection.Connection;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkConnection
extends EclipseLinkPersistenceUnitProperties
implements Connection {
    private PersistenceUnitTransactionType transactionType;
    private String jtaDataSource;
    private String nonJtaDataSource;
    private BatchWriting batchWriting;
    private Boolean nativeSql;
    private Boolean cacheStatements;
    private Integer cacheStatementsSize;
    private String driver;
    private String url;
    private String user;
    private String password;
    private Boolean bindParameters;
    private Boolean readConnectionsShared;
    private Integer readConnectionsMin;
    private Integer readConnectionsMax;
    private Integer writeConnectionsMin;
    private Integer writeConnectionsMax;

    public EclipseLinkConnection(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super(parent, propertyListAdapter);
    }

    @Override
    protected void initializeProperties() {
        this.transactionType = this.persistenceUnit().getSpecifiedTransactionType();
        this.jtaDataSource = this.persistenceUnit().getJtaDataSource();
        this.nonJtaDataSource = this.persistenceUnit().getNonJtaDataSource();
        this.batchWriting = (BatchWriting)this.getEnumValue("eclipselink.jdbc.batch-writing", BatchWriting.values());
        this.nativeSql = this.getBooleanValue("eclipselink.jdbc.native-sql");
        this.cacheStatements = this.getBooleanValue("eclipselink.jdbc.cache-statements");
        this.cacheStatementsSize = this.getIntegerValue("eclipselink.jdbc.cache-statements.size");
        this.driver = this.getStringValue("eclipselink.jdbc.driver");
        this.url = this.getStringValue("eclipselink.jdbc.url");
        this.user = this.getStringValue("eclipselink.jdbc.user");
        this.password = this.getStringValue("eclipselink.jdbc.password");
        this.bindParameters = this.getBooleanValue("eclipselink.jdbc.bind-parameters");
        this.readConnectionsShared = this.getBooleanValue("eclipselink.jdbc.read-connections.shared");
        this.readConnectionsMin = this.getIntegerValue("eclipselink.jdbc.read-connections.min");
        this.readConnectionsMax = this.getIntegerValue("eclipselink.jdbc.read-connections.max");
        this.writeConnectionsMin = this.getIntegerValue("eclipselink.jdbc.write-connections.min");
        this.writeConnectionsMax = this.getIntegerValue("eclipselink.jdbc.write-connections.max");
    }

    @Override
    protected void initialize(PersistenceUnit parent, ListValueModel<Property> propertyListAdapter) {
        super.initialize(parent, propertyListAdapter);
        this.persistenceUnit().addPropertyChangeListener("transactionType", this.buildTransactionTypeChangeListener());
        this.persistenceUnit().addPropertyChangeListener("jtaDataSource", this.buildJtaDataSourceChangeListener());
        this.persistenceUnit().addPropertyChangeListener("nonJtaDataSource", this.buildNonJtaDataSourceChangeListener());
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.jdbc.native-sql", "nativeSqlProperty");
        propertyNames.put("eclipselink.jdbc.batch-writing", "batchWritingProperty");
        propertyNames.put("eclipselink.jdbc.cache-statements", "cacheStatementsProperty");
        propertyNames.put("eclipselink.jdbc.cache-statements.size", "cacheStatementsSizeProperty");
        propertyNames.put("eclipselink.jdbc.driver", "driverProperty");
        propertyNames.put("eclipselink.jdbc.url", "urlProperty");
        propertyNames.put("eclipselink.jdbc.user", "userProperty");
        propertyNames.put("eclipselink.jdbc.password", "passwordProperty");
        propertyNames.put("eclipselink.jdbc.bind-parameters", "bindParametersProperty");
        propertyNames.put("eclipselink.jdbc.read-connections.shared", "readConnectionsSharedProperty");
        propertyNames.put("eclipselink.jdbc.read-connections.min", "readConnectionsMinProperty");
        propertyNames.put("eclipselink.jdbc.read-connections.max", "readConnectionsMaxProperty");
        propertyNames.put("eclipselink.jdbc.write-connections.min", "writeConnectionsMinProperty");
        propertyNames.put("eclipselink.jdbc.write-connections.max", "writeConnectionsMaxProperty");
    }

    public void propertyChanged(PropertyChangeEvent event) {
        String aspectName = event.getAspectName();
        if (aspectName.equals("nativeSqlProperty")) {
            this.nativeSqlChanged(event);
        } else if (aspectName.equals("batchWritingProperty")) {
            this.batchWritingChanged(event);
        } else if (aspectName.equals("cacheStatementsProperty")) {
            this.cacheStatementsChanged(event);
        } else if (aspectName.equals("driverProperty")) {
            this.driverChanged(event);
        } else if (aspectName.equals("urlProperty")) {
            this.urlChanged(event);
        } else if (aspectName.equals("userProperty")) {
            this.userChanged(event);
        } else if (aspectName.equals("passwordProperty")) {
            this.passwordChanged(event);
        } else if (aspectName.equals("bindParametersProperty")) {
            this.bindParametersChanged(event);
        } else if (aspectName.equals("readConnectionsSharedProperty")) {
            this.readConnectionsSharedChanged(event);
        } else if (aspectName.equals("cacheStatementsSizeProperty")) {
            this.cacheStatementsSizeChanged(event);
        } else if (aspectName.equals("readConnectionsMinProperty")) {
            this.readConnectionsMinChanged(event);
        } else if (aspectName.equals("readConnectionsMaxProperty")) {
            this.readConnectionsMaxChanged(event);
        } else if (aspectName.equals("writeConnectionsMinProperty")) {
            this.writeConnectionsMinChanged(event);
        } else if (aspectName.equals("writeConnectionsMaxProperty")) {
            this.writeConnectionsMaxChanged(event);
        }
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public void setTransactionType(PersistenceUnitTransactionType newTransactionType) {
        PersistenceUnitTransactionType old = this.transactionType;
        this.transactionType = newTransactionType;
        this.persistenceUnit().setSpecifiedTransactionType(newTransactionType);
        this.firePropertyChanged("transactionTypeProperty", old, newTransactionType);
    }

    private void transactionTypeChanged(PropertyChangeEvent event) {
        PersistenceUnitTransactionType newValue = (PersistenceUnitTransactionType)event.getNewValue();
        PersistenceUnitTransactionType old = this.transactionType;
        this.transactionType = newValue;
        this.firePropertyChanged("transactionTypeProperty", old, newValue);
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return DEFAULT_TRANSACTION_TYPE;
    }

    protected PropertyChangeListener buildTransactionTypeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                EclipseLinkConnection.this.transactionTypeChanged(event);
            }
        };
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String newJtaDataSource) {
        String old = this.jtaDataSource;
        this.jtaDataSource = newJtaDataSource;
        this.persistenceUnit().setJtaDataSource(newJtaDataSource);
        this.firePropertyChanged("jtaDataSourceProperty", old, newJtaDataSource);
    }

    private void jtaDataSourceChanged(PropertyChangeEvent event) {
        String newValue = (String)event.getNewValue();
        String old = this.jtaDataSource;
        this.jtaDataSource = newValue;
        this.firePropertyChanged("jtaDataSourceProperty", old, newValue);
    }

    @Override
    public String getDefaultJtaDataSource() {
        return "";
    }

    protected PropertyChangeListener buildJtaDataSourceChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                EclipseLinkConnection.this.jtaDataSourceChanged(event);
            }
        };
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String newNonJtaDataSource) {
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = newNonJtaDataSource;
        this.persistenceUnit().setNonJtaDataSource(newNonJtaDataSource);
        this.firePropertyChanged("nonJtaDataSourceProperty", old, newNonJtaDataSource);
    }

    private void nonJtaDataSourceChanged(PropertyChangeEvent event) {
        String newValue = (String)event.getNewValue();
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = newValue;
        this.firePropertyChanged("nonJtaDataSourceProperty", old, newValue);
    }

    @Override
    public String getDefaultNonJtaDataSource() {
        return "";
    }

    protected PropertyChangeListener buildNonJtaDataSourceChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                EclipseLinkConnection.this.nonJtaDataSourceChanged(event);
            }
        };
    }

    @Override
    public Boolean getNativeSql() {
        return this.nativeSql;
    }

    @Override
    public void setNativeSql(Boolean newNativeSql) {
        Boolean old = this.nativeSql;
        this.nativeSql = newNativeSql;
        this.putProperty("nativeSqlProperty", newNativeSql);
        this.firePropertyChanged("nativeSqlProperty", old, newNativeSql);
    }

    private void nativeSqlChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.nativeSql;
        this.nativeSql = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultNativeSql() {
        return DEFAULT_NATIVE_SQL;
    }

    @Override
    public BatchWriting getBatchWriting() {
        return this.batchWriting;
    }

    @Override
    public void setBatchWriting(BatchWriting newBatchWriting) {
        BatchWriting old = this.batchWriting;
        this.batchWriting = newBatchWriting;
        this.putProperty("batchWritingProperty", (Object)newBatchWriting);
        this.firePropertyChanged("batchWritingProperty", (Object)old, (Object)newBatchWriting);
    }

    private void batchWritingChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        BatchWriting newValue = (BatchWriting)EclipseLinkConnection.getEnumValueOf((String)stringValue, (Enum[])BatchWriting.values());
        BatchWriting old = this.batchWriting;
        this.batchWriting = newValue;
        this.firePropertyChanged(event.getAspectName(), (Object)old, (Object)newValue);
    }

    @Override
    public BatchWriting getDefaultBatchWriting() {
        return DEFAULT_BATCH_WRITING;
    }

    @Override
    public Boolean getCacheStatements() {
        return this.cacheStatements;
    }

    @Override
    public void setCacheStatements(Boolean newCacheStatements) {
        Boolean old = this.cacheStatements;
        this.cacheStatements = newCacheStatements;
        this.putProperty("cacheStatementsProperty", newCacheStatements);
        this.firePropertyChanged("cacheStatementsProperty", old, newCacheStatements);
    }

    private void cacheStatementsChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.cacheStatements;
        this.cacheStatements = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultCacheStatements() {
        return DEFAULT_CACHE_STATEMENTS;
    }

    @Override
    public Integer getCacheStatementsSize() {
        return this.cacheStatementsSize;
    }

    @Override
    public void setCacheStatementsSize(Integer newCacheStatementsSize) {
        Integer old = this.cacheStatementsSize;
        this.cacheStatementsSize = newCacheStatementsSize;
        this.putProperty("cacheStatementsSizeProperty", newCacheStatementsSize);
        this.firePropertyChanged("cacheStatementsSizeProperty", old, newCacheStatementsSize);
    }

    private void cacheStatementsSizeChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.cacheStatementsSize;
        this.cacheStatementsSize = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Integer getDefaultCacheStatementsSize() {
        return DEFAULT_CACHE_STATEMENTS_SIZE;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(String newDriver) {
        String old = this.driver;
        this.driver = newDriver;
        this.putProperty("driverProperty", newDriver);
        this.firePropertyChanged("driverProperty", old, newDriver);
    }

    private void driverChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.driver;
        this.driver = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultDriver() {
        return "";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String newUrl) {
        String old = this.url;
        this.url = newUrl;
        this.putProperty("urlProperty", newUrl);
        this.firePropertyChanged("urlProperty", old, newUrl);
    }

    private void urlChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.url;
        this.url = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultUrl() {
        return "";
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String newUser) {
        String old = this.user;
        this.user = newUser;
        this.putProperty("userProperty", newUser);
        this.firePropertyChanged("userProperty", old, newUser);
    }

    private void userChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.user;
        this.user = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultUser() {
        return "";
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        String old = this.password;
        this.password = newPassword;
        this.putProperty("passwordProperty", newPassword);
        this.firePropertyChanged("passwordProperty", old, newPassword);
    }

    private void passwordChanged(PropertyChangeEvent event) {
        String newValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        String old = this.password;
        this.password = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public Boolean getBindParameters() {
        return this.bindParameters;
    }

    @Override
    public void setBindParameters(Boolean newBindParameters) {
        Boolean old = this.bindParameters;
        this.bindParameters = newBindParameters;
        this.putProperty("bindParametersProperty", newBindParameters);
        this.firePropertyChanged("bindParametersProperty", old, newBindParameters);
    }

    private void bindParametersChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.bindParameters;
        this.bindParameters = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultBindParameters() {
        return DEFAULT_BIND_PARAMETERS;
    }

    @Override
    public Boolean getReadConnectionsShared() {
        return this.readConnectionsShared;
    }

    @Override
    public void setReadConnectionsShared(Boolean newReadConnectionsShared) {
        Boolean old = this.readConnectionsShared;
        this.readConnectionsShared = newReadConnectionsShared;
        this.putProperty("readConnectionsSharedProperty", newReadConnectionsShared);
        this.firePropertyChanged("readConnectionsSharedProperty", old, newReadConnectionsShared);
    }

    private void readConnectionsSharedChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Boolean newValue = EclipseLinkConnection.getBooleanValueOf(stringValue);
        Boolean old = this.readConnectionsShared;
        this.readConnectionsShared = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Boolean getDefaultReadConnectionsShared() {
        return DEFAULT_READ_CONNECTIONS_SHARED;
    }

    @Override
    public Integer getReadConnectionsMin() {
        return this.readConnectionsMin;
    }

    @Override
    public void setReadConnectionsMin(Integer newReadConnectionsMin) {
        Integer old = this.readConnectionsMin;
        this.readConnectionsMin = newReadConnectionsMin;
        this.putProperty("readConnectionsMinProperty", newReadConnectionsMin);
        this.firePropertyChanged("readConnectionsMinProperty", old, newReadConnectionsMin);
    }

    private void readConnectionsMinChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.readConnectionsMin;
        this.readConnectionsMin = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Integer getDefaultReadConnectionsMin() {
        return DEFAULT_READ_CONNECTIONS_MIN;
    }

    @Override
    public Integer getReadConnectionsMax() {
        return this.readConnectionsMax;
    }

    @Override
    public void setReadConnectionsMax(Integer newReadConnectionsMax) {
        Integer old = this.readConnectionsMax;
        this.readConnectionsMax = newReadConnectionsMax;
        this.putProperty("readConnectionsMaxProperty", newReadConnectionsMax);
        this.firePropertyChanged("readConnectionsMaxProperty", old, newReadConnectionsMax);
    }

    private void readConnectionsMaxChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.readConnectionsMax;
        this.readConnectionsMax = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Integer getDefaultReadConnectionsMax() {
        return DEFAULT_READ_CONNECTIONS_MAX;
    }

    @Override
    public Integer getWriteConnectionsMin() {
        return this.writeConnectionsMin;
    }

    @Override
    public void setWriteConnectionsMin(Integer newWriteConnectionsMin) {
        Integer old = this.writeConnectionsMin;
        this.writeConnectionsMin = newWriteConnectionsMin;
        this.putProperty("writeConnectionsMinProperty", newWriteConnectionsMin);
        this.firePropertyChanged("writeConnectionsMinProperty", old, newWriteConnectionsMin);
    }

    private void writeConnectionsMinChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.writeConnectionsMin;
        this.writeConnectionsMin = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Integer getDefaultWriteConnectionsMin() {
        return DEFAULT_WRITE_CONNECTIONS_MIN;
    }

    @Override
    public Integer getWriteConnectionsMax() {
        return this.writeConnectionsMax;
    }

    @Override
    public void setWriteConnectionsMax(Integer newWriteConnectionsMax) {
        Integer old = this.writeConnectionsMax;
        this.writeConnectionsMax = newWriteConnectionsMax;
        this.putProperty("writeConnectionsMaxProperty", newWriteConnectionsMax);
        this.firePropertyChanged("writeConnectionsMaxProperty", old, newWriteConnectionsMax);
    }

    private void writeConnectionsMaxChanged(PropertyChangeEvent event) {
        String stringValue = event.getNewValue() == null ? null : ((Property)event.getNewValue()).getValue();
        Integer newValue = EclipseLinkConnection.getIntegerValueOf(stringValue);
        Integer old = this.writeConnectionsMax;
        this.writeConnectionsMax = newValue;
        this.firePropertyChanged(event.getAspectName(), old, newValue);
    }

    @Override
    public Integer getDefaultWriteConnectionsMax() {
        return DEFAULT_WRITE_CONNECTIONS_MAX;
    }
}

