/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.validation;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.jst.jsp.core.tests.taglibindex.BundleResourceUtil;
import org.eclipse.jst.jsp.core.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.core.tests.validation.ValidationContextForTest;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class JSPBatchValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "batchvalidation";
    Object originalWorkspaceValue = null;
    IEclipsePreferences workspaceScope = null;
    IEclipsePreferences projectScope = null;

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!this.getProject().exists()) {
            BundleResourceUtil.createSimpleProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            BundleResourceUtil.copyBundleEntriesIntoWorkspace("/testfiles/batchvalidation", "/batchvalidation");
        }
        JSPBatchValidatorTest.assertTrue((String)"project could not be created", (boolean)this.getProject().exists());
        String filePath = "/batchvalidation/WebContent/header.jspf";
        IFile fragment = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        String qualifier = JSPCorePlugin.getDefault().getBundle().getSymbolicName();
        this.workspaceScope = new InstanceScope().getNode(qualifier);
        this.projectScope = new ProjectScope(fragment.getProject()).getNode(qualifier);
        this.originalWorkspaceValue = this.workspaceScope.get("validateFragments", null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
        this.projectScope.remove("validateFragments");
        this.projectScope.remove("validation.use-project-settings");
        if (this.originalWorkspaceValue != null) {
            this.workspaceScope.put("validateFragments", this.originalWorkspaceValue.toString());
        } else {
            this.workspaceScope.remove("validateFragments");
        }
    }

    public void testValidating2Files() throws Exception {
        JSPJavaValidator validator = new JSPJavaValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath1 = "/batchvalidation/WebContent/ihaveerrors.jsp";
        IFile file1 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath1));
        JSPBatchValidatorTest.assertTrue((boolean)file1.exists());
        String filePath2 = "/batchvalidation/WebContent/ihaveerrors2.jsp";
        IFile file2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath1));
        JSPBatchValidatorTest.assertTrue((boolean)file2.exists());
        helper.setURIs(new String[]{filePath1, filePath2});
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPBatchValidatorTest.assertTrue((String)"jsp errors were not found in both files", (reporter.getMessages().size() == 2 ? 1 : 0) != 0);
    }

    public void testFragmentValidationPreferenceOnProject() throws Exception {
        String filePath = "/batchvalidation/WebContent/header.jspf";
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        this.workspaceScope.putBoolean("validateFragments", true);
        this.projectScope.putBoolean("validation.use-project-settings", true);
        this.projectScope.putBoolean("validateFragments", false);
        ValidationFramework.getDefault().validate(new IProject[]{this.getProject()}, true, false, (IProgressMonitor)new NullProgressMonitor());
        IMarker[] problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        StringBuffer buffer = new StringBuffer("Problem markers found while fragment validation was disabled in project");
        int i = 0;
        while (i < problemMarkers.length) {
            buffer.append("\n");
            buffer.append(problemMarkers[i].getAttribute("message"));
            ++i;
        }
        JSPBatchValidatorTest.assertEquals((String)buffer.toString(), (int)0, (int)problemMarkers.length);
        this.workspaceScope.putBoolean("validateFragments", false);
        this.projectScope.putBoolean("validation.use-project-settings", true);
        this.projectScope.putBoolean("validateFragments", true);
        JSPFContentProperties.setProperty((String)"validateFragments", (IResource)file, (String)Boolean.toString(true));
        ValidationFramework.getDefault().validate(new IProject[]{this.getProject()}, true, false, (IProgressMonitor)new NullProgressMonitor());
        problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        JSPBatchValidatorTest.assertTrue((String)"problem markers not found while fragment validation was enabled in project", (problemMarkers.length != 0 ? 1 : 0) != 0);
    }

    public void testFragmentValidationPreferenceOnWorkspace() throws Exception {
        String filePath = "/batchvalidation/WebContent/header.jspf";
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        this.workspaceScope.putBoolean("validateFragments", false);
        ValidationFramework.getDefault().validate(new IProject[]{this.getProject()}, true, false, (IProgressMonitor)new NullProgressMonitor());
        IMarker[] problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        StringBuffer buffer = new StringBuffer("Problem markers found while fragment validation was disabled");
        int i = 0;
        while (i < problemMarkers.length) {
            buffer.append("\n");
            buffer.append(problemMarkers[i].getAttribute("message"));
            ++i;
        }
        JSPBatchValidatorTest.assertEquals((String)buffer.toString(), (int)0, (int)problemMarkers.length);
        this.workspaceScope.putBoolean("validateFragments", true);
        ValidationFramework.getDefault().validate(new IProject[]{this.getProject()}, true, false, (IProgressMonitor)new NullProgressMonitor());
        problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        JSPBatchValidatorTest.assertTrue((String)"Problem markers not found while fragment validation was enabled", (problemMarkers.length != 0 ? 1 : 0) != 0);
        this.workspaceScope.remove("validateFragments");
        this.projectScope.remove("validateFragments");
        this.projectScope.remove("validation.use-project-settings");
        ValidationFramework.getDefault().validate(new IProject[]{this.getProject()}, true, false, (IProgressMonitor)new NullProgressMonitor());
        problemMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        JSPBatchValidatorTest.assertTrue((String)"Problem markers not found while fragment validation was default", (problemMarkers.length != 0 ? 1 : 0) != 0);
    }

    private IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
    }
}

