/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WebModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.internal.WrappedException;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class DefectVerificationTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public DefectVerificationTests() {
    }

    public DefectVerificationTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.DefectVerificationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testFilterMappingTranslator() throws Exception {
        String archive = String.valueOf(AutomatedBVT.baseDirectory) + "QIDefectsNew.ear";
        String name = "QIDefects.war";
        CommonarchiveFactory archiveFactory = (CommonarchiveFactory)CommonarchivePackage.eINSTANCE.getEFactoryInstance();
        ArchiveOptions options = new ArchiveOptions();
        options.setRendererType(1);
        options.setUseJavaReflection(false);
        EARFile earFile = archiveFactory.openEARFile(options, archive);
        WebModuleRef warFile = null;
        Iterator i = earFile.getModuleRefs().iterator();
        while (i.hasNext()) {
            ModuleRef mref = (ModuleRef)i.next();
            if (!name.equals(mref.getUri())) continue;
            warFile = (WebModuleRef)mref;
        }
        WebApp dd = (WebApp)warFile.getDeploymentDescriptor();
        EList filterMappings = dd.getFilterMappings();
        DefectVerificationTests.assertTrue((String)"The test requires two filter mappings.", (filterMappings.size() == 2 ? 1 : 0) != 0);
        FilterMapping filterMapping1 = (FilterMapping)filterMappings.get(0);
        DefectVerificationTests.assertNotNull((String)("A URL Pattern was not found for filter with name " + filterMapping1.getFilter().getName()), (Object)filterMapping1.getUrlPattern());
        FilterMapping filterMapping2 = (FilterMapping)filterMappings.get(1);
        DefectVerificationTests.assertNotNull((String)("A Servlet name was not found for filter with name " + filterMapping2.getFilter().getName()), (Object)filterMapping2.getServletName());
        DefectVerificationTests.assertNotNull((String)("A Servlet was not found for filter with name " + filterMapping2.getFilter().getName()), (Object)filterMapping2.getServlet());
    }

    public void testFormerDefect297() throws Exception {
        ArchiveOptions options = new ArchiveOptions();
        options.setRendererType(2);
        String earPath = String.valueOf(AutomatedBVT.baseDirectory) + "sample.ear";
        CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
        EARFile earFile = pkg.getCommonarchiveFactory().openEARFile(options, earPath);
        earFile.extractNoReopen(126);
    }

    public void testFormerDefect1459() throws Exception {
        ArchiveOptions options = new ArchiveOptions();
        options.setRendererType(2);
        CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
        CommonarchiveFactory factory = pkg.getCommonarchiveFactory();
        EARFile earFile = factory.createEARFileInitialized(options, "Test.ear");
        earFile.saveAs("C:\\Test.ear");
    }

    /*
     * Exception decompiling
     */
    private void readFile(File file) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 58->62)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testSavingEARWhileDeploying() throws Exception {
        try {
            ArchiveOptions options = new ArchiveOptions();
            options.setRendererType(1);
            options.setUseJavaReflection(true);
            String earPath = String.valueOf(AutomatedBVT.baseDirectory) + "AuctionApp.ear";
            CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
            EARFile earFile = pkg.getCommonarchiveFactory().openEARFile(options, earPath);
            this.printFiles((Container)earFile);
            earFile.save();
            earFile.reopen();
        }
        catch (WrappedException we) {
            Logger.getLogger().logError((Throwable)we);
            Logger.getLogger().logError(we.getMessage());
            if (we.getCause() != null) {
                Logger.getLogger().logError(we.getCause());
            }
            if (we.getNestedException() != null) {
                Logger.getLogger().logError((Throwable)we.getNestedException());
            }
            if (we.getNestedException() != null) {
                Logger.getLogger().logError(we.getConcatenatedMessages());
            }
            throw we;
        }
    }

    public void testCreatingEARFile() throws Exception {
        CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
        CommonarchiveFactory factory = pkg.getCommonarchiveFactory();
        String earPath = String.valueOf(AutomatedBVT.baseDirectory) + "InitializedEAR.ear";
        ArchiveOptions options = new ArchiveOptions();
        options.setIsReadOnly(true);
        options.setRendererType(2);
        EARFile earFile = factory.createEARFileInitialized(options, earPath);
        earFile.getDeploymentDescriptor();
    }

    public void testServiceQNameTranslator() throws Exception {
        try {
            ArchiveOptions options = new ArchiveOptions();
            options.setRendererType(1);
            String earPath = String.valueOf(AutomatedBVT.baseDirectory) + "WSSecured_InsuranceServices_EJB_WS.ear";
            CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
            CommonarchiveFactory factory = pkg.getCommonarchiveFactory();
            EARFile earFile = factory.openEARFile(options, earPath);
            this.printFiles((Container)earFile);
            String tmp = "C:\\temp\\" + System.currentTimeMillis();
            earFile.extractTo(tmp, 0);
            List ejbModuleRefs = earFile.getEJBModuleRefs();
            int i = 0;
            while (i < ejbModuleRefs.size()) {
                EJBModuleRef ejbmodref = (EJBModuleRef)ejbModuleRefs.get(i);
                if (ejbmodref.getUri().equals("WSInsSession20EJB.jar")) {
                    Resource res = ejbmodref.getMofResource("META-INF/webservicesclient.xml");
                    System.err.println(res.getURI());
                }
                ++i;
            }
        }
        catch (WrappedException we) {
            Logger.getLogger().logError((Throwable)we);
            Logger.getLogger().logError(we.getMessage());
            if (we.getCause() != null) {
                Logger.getLogger().logError(we.getCause());
            }
            if (we.getNestedException() != null) {
                Logger.getLogger().logError((Throwable)we.getNestedException());
            }
            if (we.getNestedException() != null) {
                Logger.getLogger().logError(we.getConcatenatedMessages());
            }
            throw we;
        }
    }

    public void testReadCrimsonCase() throws Exception {
        try {
            ArchiveOptions options = new ArchiveOptions();
            options.setRendererType(2);
            String earPath = String.valueOf(AutomatedBVT.baseDirectory) + "ejb_sam_Hello.ear";
            CommonarchivePackage pkg = CommonarchivePackage.eINSTANCE;
            EARFile earFile = pkg.getCommonarchiveFactory().openEARFile(options, earPath);
            Application app = earFile.getDeploymentDescriptor();
            DefectVerificationTests.assertNotNull((String)"Could not read deployment descriptor.", (Object)app);
            System.err.println("\n\n******************Printing files from " + app.getDisplayName());
            DefectVerificationTests.assertNotNull((String)"Could not read display name from deployment descriptor.", (Object)app.getDisplayName());
            this.printFiles((Container)earFile);
            earFile.extractTo(String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/temp", 0);
            earFile.reopen();
        }
        catch (WrappedException we) {
            Logger.getLogger().logError((Throwable)we);
            Logger.getLogger().logError(we.getMessage());
            if (we.getCause() != null) {
                Logger.getLogger().logError(we.getCause());
            }
            if (we.getNestedException() != null) {
                Logger.getLogger().logError((Throwable)we.getNestedException());
            }
            if (we.getNestedException() != null) {
                Logger.getLogger().logError(we.getConcatenatedMessages());
            }
            throw we;
        }
    }

    private void printFiles(Container ar) {
        EList files = ar.getFiles();
        int i = 0;
        while (i < files.size()) {
            System.err.println(files.get(i));
            if (files.get(i) instanceof Container) {
                Container tainer = (Container)files.get(i);
                this.printFiles(tainer);
            }
            ++i;
        }
    }
}

