/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.util;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.common.util.JDTBeanIntrospector;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.common.util.JDTBeanPropertyWorkingCopy;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestJDTBeanIntrospector
extends TestCase {
    private JDTTestEnvironment _jdtTestEnvironment;
    private IType _testBean1Type;
    private IType _testBeanSubclassType;
    private IType _testBeanGenericType;
    private Map<String, JDTBeanProperty> _properties;
    private Map<String, JDTBeanProperty> _subClassProperties;
    private Map<String, JDTBeanProperty> _genericTypeProperties;
    private static final String srcFolderName = "src";
    private static final String packageName1 = "com.test";
    private static final String testBeanName1 = "TestBean1";
    private static final String testBeanSubclassName1 = "TestBean1Subclass";
    private static final String testAnotherBeanName = "AnotherBean";
    private static final String testBeanGenericName = "TestBeanGeneric";

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJDTBeanIntrospector_" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        projectTestEnvironment.createProject(true);
        this._jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1.java.data");
        String code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanName1, code);
        this._testBean1Type = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1");
        TestJDTBeanIntrospector.assertNotNull((Object)this._testBean1Type);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBean1Subclass.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanSubclassName1, code);
        this._testBeanSubclassType = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBean1Subclass");
        TestJDTBeanIntrospector.assertNotNull((Object)this._testBeanSubclassType);
        TestJDTBeanIntrospector.assertNotSame((Object)this._testBean1Type, (Object)this._testBeanSubclassType);
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/AnotherBean.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testAnotherBeanName, code);
        TestJDTBeanIntrospector.assertNotNull((Object)this._jdtTestEnvironment.getJavaProject().findType("com.test.AnotherBean"));
        codeRes = new TestFileResource();
        codeRes.load(TestsPlugin.getDefault().getBundle(), "/testfiles/TestBeanGeneric.java.data");
        code = codeRes.toString();
        this._jdtTestEnvironment.addSourceFile(srcFolderName, packageName1, testBeanGenericName, code);
        this._testBeanGenericType = this._jdtTestEnvironment.getJavaProject().findType("com.test.TestBeanGeneric");
        TestJDTBeanIntrospector.assertNotNull((Object)this._testBeanGenericType);
        JDTBeanIntrospector beanIntrospector = new JDTBeanIntrospector(this._testBean1Type);
        this._properties = beanIntrospector.getProperties();
        beanIntrospector = new JDTBeanIntrospector(this._testBeanSubclassType);
        this._subClassProperties = beanIntrospector.getProperties();
        beanIntrospector = new JDTBeanIntrospector(this._testBeanGenericType);
        this._genericTypeProperties = beanIntrospector.getProperties();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IProject project = this._jdtTestEnvironment.getJavaProject().getProject();
        try {
            project.close(null);
            project.delete(true, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace(System.err);
        }
    }

    public void testMapSanity() {
        this.checkMapSanity(this._properties, 15);
        this.checkMapSanity(this._subClassProperties, 16);
        this.checkMapSanity(this._genericTypeProperties, 6);
    }

    private void checkMapSanity(Map<String, JDTBeanProperty> properties, int numProps) {
        TestJDTBeanIntrospector.assertEquals((String)"Check extra or missing properties", (int)numProps, (int)properties.size());
        TestJDTBeanIntrospector.assertNull((String)"Empty string is invalid property name", (Object)properties.get(""));
        TestJDTBeanIntrospector.assertNull((String)"Null is not a valid property name", (Object)properties.get(null));
        for (JDTBeanProperty value : properties.values()) {
            TestJDTBeanIntrospector.assertFalse((boolean)(value instanceof JDTBeanPropertyWorkingCopy));
        }
    }

    public void testStringProp1() {
        this.testStringProp1(this._properties);
    }

    public void testStringProp1SubClass() {
        this.testStringProp1(this._subClassProperties);
    }

    private void testStringProp1(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("stringProp1");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"IType should resolve", (Object)property.getType());
    }

    public void testBooleanIsProp1() {
        this.testBooleanIsProp1(this._properties);
    }

    public void testBooleanIsProp1SubClass() {
        this.testBooleanIsProp1(this._subClassProperties);
    }

    private void testBooleanIsProp1(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("booleanIsProp1");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNull((String)"IType won't resolve", (Object)property.getType());
    }

    public void testBooleanIsProp2() {
        this.testBooleanIsProp2(this._properties);
    }

    public void testBooleanIsProp2SubClass() {
        this.testBooleanIsProp2(this._subClassProperties);
    }

    private void testBooleanIsProp2(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("booleanIsProp2");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNull((String)"IType won't resolve", (Object)property.getType());
        TestJDTBeanIntrospector.assertEquals((String)"Make sure the is getter is chosen", (String)"isBooleanIsProp2", (String)property.getGetter().getElementName());
    }

    public void testNotBooleanIsProp1() {
        this.testNotBooleanIsProp1(this._properties);
    }

    public void testNotBooleanIsProp1SubClass() {
        this.testNotBooleanIsProp1(this._subClassProperties);
    }

    private void testNotBooleanIsProp1(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("notBooleanIsProp1");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNull((String)"IType won't resolve", (Object)property.getType());
        TestJDTBeanIntrospector.assertEquals((String)"Make sure the get getter is chosen", (String)"getNotBooleanIsProp1", (String)property.getGetter().getElementName());
    }

    public void testStringProperty2() {
        this.testStringProperty2(this._properties);
    }

    public void testStringProperty2SubClass() {
        this.testStringProperty2(this._subClassProperties);
    }

    private void testStringProperty2(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("stringProperty2");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertFalse((String)"No setter for this property", (boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"IType should resolve", (Object)property.getType());
    }

    public void testReadonlyStringProperty() {
        this.testReadonlyStringProperty(this._properties);
    }

    public void testReadonlyStringPropertySubClass() {
        this.testReadonlyStringProperty(this._subClassProperties);
    }

    private void testReadonlyStringProperty(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("readonlyStringProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertFalse((String)"No setter for this property", (boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"IType should resolve", (Object)property.getType());
    }

    public void testReadonlyBooleanProperty() {
        this.testReadonlyBooleanProperty(this._properties);
    }

    public void testReadonlyBooleanPropertySubClass() {
        this.testReadonlyBooleanProperty(this._subClassProperties);
    }

    private void testReadonlyBooleanProperty(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("readonlyBooleanProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertFalse((String)"No setter for this property", (boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a boolean", (String)"Z", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNull((String)"IType won't resolve", (Object)property.getType());
    }

    public void testWriteonlyStringProperty() {
        this.testWriteonlyStringProperty(this._properties);
    }

    public void testWriteonlyStringPropertySubClass() {
        this.testWriteonlyStringProperty(this._subClassProperties);
    }

    private void testWriteonlyStringProperty(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("writeonlyStringProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertFalse((String)"No getter for this property", (boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"IType should resolve", (Object)property.getType());
    }

    public void testStringArrayProperty() {
        this.testStringArrayProperty(this._properties);
    }

    public void testStringArrayPropertySubClass() {
        this.testStringArrayProperty(this._subClassProperties);
    }

    private void testStringArrayProperty(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("stringArrayProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a String[]", (String)"[Ljava.lang.String;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"Should resolve the base type", (Object)property.getType());
        TestJDTBeanIntrospector.assertEquals((int)1, (int)property.getArrayCount());
    }

    public void testCollectionProperty() {
        this.testCollectionProperty(this._properties);
    }

    public void testCollectionPropertySubClass() {
        this.testCollectionProperty(this._subClassProperties);
    }

    private void testCollectionProperty(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("collectionProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a Collection", (String)"Ljava.util.Collection;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"Should have a type", (Object)property.getType());
    }

    public void testMapProperty() {
        this.testMapProperty(this._properties);
    }

    public void testMapPropertySubClass() {
        this.testMapProperty(this._subClassProperties);
    }

    private void testMapProperty(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("mapProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a Map", (String)"Ljava.util.Map;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"Should have a type", (Object)property.getType());
    }

    public void testAnotherBean() {
        this.testAnotherBean(this._properties);
    }

    public void testAnotherBeanSubClass() {
        this.testAnotherBean(this._subClassProperties);
    }

    private void testAnotherBean(Map<String, JDTBeanProperty> properties) {
        JDTBeanProperty property = properties.get("anotherBean");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertTrue((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for com.test.AnotherBean", (String)"Lcom.test.AnotherBean;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"Should have a type", (Object)property.getType());
    }

    public void testSubclassOnly() {
        TestJDTBeanIntrospector.assertNull((Object)this._properties.get("locallyDefinedProperty"));
        JDTBeanProperty property = this._subClassProperties.get("locallyDefinedProperty");
        TestJDTBeanIntrospector.assertNotNull((Object)property);
        TestJDTBeanIntrospector.assertTrue((boolean)property.isReadable());
        TestJDTBeanIntrospector.assertFalse((boolean)property.isWritable());
        TestJDTBeanIntrospector.assertEquals((String)"Signature must be for a String", (String)"Ljava.lang.String;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertNotNull((String)"Should have a type", (Object)property.getType());
    }

    public void testGenericListOfStringProperty() throws Exception {
        JDTBeanProperty property = this._genericTypeProperties.get("listOfStrings");
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.List;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertEquals((int)1, (int)property.getTypeParameterSignatures().size());
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.lang.String;", (String)((String)property.getTypeParameterSignatures().get(0)));
    }

    public void testGenericArrayListOfStringProperty() throws Exception {
        JDTBeanProperty property = this._genericTypeProperties.get("arrayListOfStrings");
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.ArrayList;", (String)property.getTypeSignature());
        TestJDTBeanIntrospector.assertEquals((int)1, (int)property.getTypeParameterSignatures().size());
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.lang.String;", (String)((String)property.getTypeParameterSignatures().get(0)));
    }

    public void testGenericListOfListOfStringProperty() throws Exception {
        JDTBeanProperty property = this._genericTypeProperties.get("listOfListOfStrings");
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.List;", (String)property.getTypeSignature(true));
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.List<Ljava.util.List<Ljava.lang.String;>;>;", (String)property.getTypeSignature(false));
        TestJDTBeanIntrospector.assertEquals((int)1, (int)property.getTypeParameterSignatures().size());
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.List<Ljava.lang.String;>;", (String)((String)property.getTypeParameterSignatures().get(0)));
    }

    public void testGenericMapOfString_StringProperty() throws Exception {
        JDTBeanProperty property = this._genericTypeProperties.get("mapOfString_String");
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.Map;", (String)property.getTypeSignature(true));
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.Map<Ljava.lang.String;Ljava.lang.String;>;", (String)property.getTypeSignature(false));
        TestJDTBeanIntrospector.assertEquals((int)2, (int)property.getTypeParameterSignatures().size());
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.lang.String;", (String)((String)property.getTypeParameterSignatures().get(0)));
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.lang.String;", (String)((String)property.getTypeParameterSignatures().get(1)));
    }

    public void testUnboundedProperty_List() throws Exception {
        JDTBeanProperty property = this._genericTypeProperties.get("unboundedList");
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.List;", (String)property.getTypeSignature(true));
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.util.List<Ljava.lang.Object;>;", (String)property.getTypeSignature(false));
        TestJDTBeanIntrospector.assertEquals((int)1, (int)property.getTypeParameterSignatures().size());
        TestJDTBeanIntrospector.assertEquals((String)"Ljava.lang.Object;", (String)((String)property.getTypeParameterSignatures().get(0)));
    }
}

