/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.tests.JavaProjectUtil;
import org.eclipse.jem.tests.JavaTestsPlugin;

public class JDK5ReflectionTests
extends TestCase {
    private static final String PROJECT_NAME = "JDK5Tests";
    private IJavaProject javaProject;
    private ResourceSet resourceSet;
    private boolean oldAutoBuildingState;
    protected boolean isReflectingSource = true;

    public JDK5ReflectionTests() {
    }

    public JDK5ReflectionTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.isReflectingSource) {
            this.setUpForSource();
        } else {
            this.setUpForNoSource();
        }
    }

    protected void setUpForSource() throws CoreException, IOException, MalformedURLException {
        this.oldAutoBuildingState = JavaProjectUtil.setAutoBuild(true);
        URL installURL = JavaTestsPlugin.getPlugin().getBundle().getEntry("/");
        String[] zipPaths = new String[]{FileLocator.toFileURL((URL)new URL(installURL, "testdata/JDK5Tests.zip")).getFile()};
        IProject[] projects = JavaProjectUtil.importProjects(new String[]{PROJECT_NAME}, zipPaths);
        JDK5ReflectionTests.assertNotNull((Object)projects[0]);
        JavaProjectUtil.waitForAutoBuild();
        this.javaProject = JavaCore.create((IProject)projects[0]);
        this.javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", "1.5");
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getAdapterFactories().add((Object)new JavaJDOMAdapterFactory(this.javaProject));
    }

    protected void setUpForNoSource() throws CoreException, IOException, MalformedURLException {
        this.oldAutoBuildingState = JavaProjectUtil.setAutoBuild(true);
        URL installURL = JavaTestsPlugin.getPlugin().getBundle().getEntry("/");
        String[] jarPaths = new String[]{FileLocator.toFileURL((URL)new URL(installURL, "testdata/JDK5BinTests.jar")).getFile()};
        IProject project = JavaProjectUtil.createEmptyJavaProject(ResourcesPlugin.getWorkspace(), (IPath)new Path(PROJECT_NAME), null);
        JDK5ReflectionTests.assertNotNull((Object)project);
        JavaProjectUtil.waitForAutoBuild();
        this.javaProject = JavaCore.create((IProject)project);
        this.javaProject.setOption("org.eclipse.jdt.core.compiler.compliance", "1.5");
        ArrayList<IClasspathEntry> classpath = new ArrayList<IClasspathEntry>(Arrays.asList(this.javaProject.getRawClasspath()));
        classpath.add(JavaCore.newLibraryEntry((IPath)new Path(jarPaths[0]), null, null));
        this.javaProject.setRawClasspath(classpath.toArray(new IClasspathEntry[0]), null);
        JavaProjectUtil.waitForAutoBuild();
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getAdapterFactories().add((Object)new JavaJDOMAdapterFactory(this.javaProject));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaProjectUtil.deleteProject(JDK5ReflectionTests.this.javaProject.getProject());
            }
        }, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 0, null);
        JavaProjectUtil.setAutoBuild(this.oldAutoBuildingState);
    }

    private JavaHelpers reflectClass(String qualifiedName) {
        return JavaRefFactory.eINSTANCE.reflectType(qualifiedName, this.resourceSet);
    }

    public void test1() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JDK5ReflectionTests.assertFalse((boolean)testHelper.isPrimitive());
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = testClass.getMethod("test1", Collections.EMPTY_LIST);
        JDK5ReflectionTests.assertNotNull((Object)method);
        JavaHelpers returnType = method.getReturnType();
        JDK5ReflectionTests.assertEquals((String)"java.util.Collection", (String)returnType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Collection", (String)returnType.getSimpleName());
    }

    public void test2() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test2")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        JavaHelpers returnType = method.getReturnType();
        JDK5ReflectionTests.assertNotNull((Object)returnType);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 1 ? 1 : 0) != 0);
        JavaParameter param = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param.getName().equals("aCollection"));
        }
        JavaHelpers paramType = param.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)paramType);
        JDK5ReflectionTests.assertEquals((String)"java.util.Collection", (String)paramType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Collection", (String)paramType.getSimpleName());
    }

    public void test3() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test3")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        JavaHelpers returnType = method.getReturnType();
        JDK5ReflectionTests.assertNotNull((Object)returnType);
        JDK5ReflectionTests.assertEquals((String)"test.dependents.IFoo", (String)returnType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"IFoo", (String)returnType.getSimpleName());
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 3 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("aClass"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class", (String)param1Type.getSimpleName());
        JavaParameter param2 = (JavaParameter)params.get(1);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertEquals((String)"s", (String)param2.getName());
        }
        JavaHelpers param2Type = param2.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param2Type);
        JavaHelpers listType = this.reflectClass("java.util.List");
        JavaParameter param3 = (JavaParameter)params.get(2);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertEquals((String)"aList", (String)param3.getName());
        }
        JavaHelpers param3Type = param3.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param3Type);
        JDK5ReflectionTests.assertEquals((Object)listType, (Object)param3Type);
    }

    public void test4() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test4")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        JavaHelpers returnType = method.getReturnType();
        JDK5ReflectionTests.assertNotNull((Object)returnType);
        JDK5ReflectionTests.assertEquals((String)"java.util.Map", (String)returnType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Map", (String)returnType.getSimpleName());
    }

    public void test5() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test5")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 1 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("aList"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param1Type.getSimpleName());
    }

    public void test6() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test6")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertEquals((int)4, (int)params.size());
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("aClassArray"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertTrue((((ArrayType)param1Type).getArrayDimensions() == 1 ? 1 : 0) != 0);
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class[]", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class[]", (String)param1Type.getSimpleName());
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class", (String)((ArrayType)param1Type).getComponentTypeAsHelper().getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class", (String)((ArrayType)param1Type).getComponentTypeAsHelper().getSimpleName());
        JavaParameter param2 = (JavaParameter)params.get(1);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param2.getName().equals("anArrayOfListsOfString"));
        }
        JavaHelpers param2Type = param2.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param2Type);
        JDK5ReflectionTests.assertTrue((((ArrayType)param2Type).getArrayDimensions() == 1 ? 1 : 0) != 0);
        JDK5ReflectionTests.assertEquals((String)"java.util.List[]", (String)param2Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List[]", (String)param2Type.getSimpleName());
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)((ArrayType)param2Type).getComponentTypeAsHelper().getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)((ArrayType)param2Type).getComponentTypeAsHelper().getSimpleName());
        JavaParameter param3 = (JavaParameter)params.get(2);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param3.getName().equals("aWildcardClassArray"));
        }
        JavaHelpers param3Type = param3.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param3Type);
        JDK5ReflectionTests.assertTrue((((ArrayType)param3Type).getArrayDimensions() == 1 ? 1 : 0) != 0);
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class[]", (String)param3Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class[]", (String)param3Type.getSimpleName());
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class", (String)((ArrayType)param3Type).getComponentTypeAsHelper().getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class", (String)((ArrayType)param3Type).getComponentTypeAsHelper().getSimpleName());
        JavaParameter param4 = (JavaParameter)params.get(3);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param4.getName().equals("aMultiDimWildcardArray"));
        }
        JavaHelpers param4Type = param4.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param4Type);
        JDK5ReflectionTests.assertTrue((((ArrayType)param4Type).getArrayDimensions() == 3 ? 1 : 0) != 0);
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class[][][]", (String)param4Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class[][][]", (String)param4Type.getSimpleName());
        JavaHelpers componentType = ((ArrayType)param4Type).getComponentTypeAsHelper();
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class[][]", (String)componentType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class[][]", (String)componentType.getSimpleName());
        componentType = ((ArrayType)componentType).getComponentTypeAsHelper();
        JDK5ReflectionTests.assertEquals((String)"java.lang.Class[]", (String)componentType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Class[]", (String)componentType.getSimpleName());
        componentType = ((ArrayType)componentType).getComponentTypeAsHelper();
    }

    public void test7() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test7")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 3 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("aListOfListOfString"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param1Type.getSimpleName());
        JavaParameter param2 = (JavaParameter)params.get(1);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param2.getName().equals("aListOfListOfT"));
        }
        JavaHelpers param2Type = param2.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param2Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param2Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param2Type.getSimpleName());
        JavaParameter param3 = (JavaParameter)params.get(2);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param3.getName().equals("aMap"));
        }
        JavaHelpers param3Type = param3.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param3Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.Map", (String)param3Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Map", (String)param3Type.getSimpleName());
    }

    public void test8() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test8")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 1 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("aList"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param1Type.getSimpleName());
    }

    public void test9() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test9")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 3 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("aListOfListOfString"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param1Type.getSimpleName());
        JavaParameter param2 = (JavaParameter)params.get(1);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param2.getName().equals("aListOfListOfT"));
        }
        JavaHelpers param2Type = param2.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param2Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param2Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param2Type.getSimpleName());
        JavaParameter param3 = (JavaParameter)params.get(2);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param3.getName().equals("aMap"));
        }
        JavaHelpers param3Type = param3.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param3Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.Map", (String)param3Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Map", (String)param3Type.getSimpleName());
    }

    public void test10() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test10")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        JavaHelpers returnType = method.getReturnType();
        JDK5ReflectionTests.assertEquals((String)"test.dependents.Tester", (String)returnType.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Tester", (String)returnType.getSimpleName());
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 1 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("list"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.util.List", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"List", (String)param1Type.getSimpleName());
    }

    public void test11() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test11")) break;
            method = null;
            ++i;
        }
    }

    public void test12() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test12")) break;
            method = null;
            ++i;
        }
    }

    public void test13() {
        JavaHelpers testHelper = this.reflectClass("test.me.Test");
        JavaClass testClass = (JavaClass)testHelper;
        JDK5ReflectionTests.assertTrue((boolean)testClass.isExistingType());
        Method method = null;
        EList methods = testClass.getMethods();
        int i = 0;
        while (i < methods.size()) {
            method = (Method)methods.get(i);
            if (method.getName().equals("test13")) break;
            method = null;
            ++i;
        }
        JDK5ReflectionTests.assertNotNull(method);
        EList params = method.getParameters();
        JDK5ReflectionTests.assertTrue((params.size() == 1 ? 1 : 0) != 0);
        JavaParameter param1 = (JavaParameter)params.get(0);
        if (this.isReflectingSource) {
            JDK5ReflectionTests.assertTrue((boolean)param1.getName().equals("param"));
        }
        JavaHelpers param1Type = param1.getJavaType();
        JDK5ReflectionTests.assertNotNull((Object)param1Type);
        JDK5ReflectionTests.assertEquals((String)"java.io.Serializable", (String)param1Type.getQualifiedName());
        JDK5ReflectionTests.assertEquals((String)"Serializable", (String)param1Type.getSimpleName());
    }
}

