/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.internal.validation.EARValidationMessageResourceHandler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.ServerSelectionUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntimeChecker;

public class ValidationUtils {
    public static final int VALIDATE_NONE = 0;
    public static final int VALIDATE_ALL = 1;
    public static final int VALIDATE_SERVER_RUNTIME_CHANGES = 2;
    public static final int VALIDATE_PROJECT_CHANGES = 3;
    public static final int VALIDATE_SCALE_CHANGES = 4;

    public int getNewValidationState(int currentValidationState, int requestedValidationState) {
        int newValidationState = currentValidationState == 0 || currentValidationState == requestedValidationState ? requestedValidationState : 1;
        return newValidationState;
    }

    public IStatus checkMissingFieldStatus(int validationState, String typeId, String serviceImpl, String runtimeId, String serverId, String projectName, boolean needEar, String earProjectName, String projectTypeId, boolean isClient) {
        if (validationState == 1 && !isClient && serviceImpl.length() == 0) {
            int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(typeId);
            if (scenario == 0) {
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_NO_OBJECT_SELECTION);
            }
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_NO_SERVICE_SELECTION);
        }
        if (!(validationState != 1 && validationState != 2 || runtimeId != null && runtimeId.length() != 0)) {
            if (isClient) {
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_RUNTIME, (Object[])new String[]{ConsumptionUIMessages.MSG_CLIENT_SUB}));
            }
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_RUNTIME, (Object[])new String[]{ConsumptionUIMessages.MSG_SERVICE_SUB}));
        }
        if (validationState == 1 || validationState == 3) {
            if (projectName == null || projectName.length() == 0) {
                if (isClient) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_PROJECT_EMPTY, (Object[])new String[]{""}));
                }
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_PROJECT_EMPTY, (Object[])new String[]{""}));
            }
            IProject project = ProjectUtilities.getProject((String)projectName);
            if (!(project.exists() || projectTypeId != null && projectTypeId.length() != 0)) {
                if (isClient) {
                    return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_CLIENT_PROJECT_TYPE_EMPTY);
                }
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_SERVICE_PROJECT_TYPE_EMPTY);
            }
            if (needEar && (earProjectName == null || earProjectName.length() == 0)) {
                if (isClient) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_EAR_EMPTY, (Object[])new String[]{""}));
                }
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_EAR_EMPTY, (Object[])new String[]{""}));
            }
        }
        if (!(validationState != 1 && validationState != 2 && validationState != 3 || serverId != null && serverId.length() != 0)) {
            RuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getRuntimeById(runtimeId);
            if (desc.getServerRequired()) {
                if (isClient) {
                    StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_SERVER, (Object[])new String[]{ConsumptionUIMessages.MSG_CLIENT_SUB}));
                } else {
                    StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_SERVER, (Object[])new String[]{ConsumptionUIMessages.MSG_SERVICE_SUB}));
                }
            } else {
                IProject project = ProjectUtilities.getProject((String)projectName);
                if (!project.exists()) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_PROJECT_MUST_EXIST, (Object[])new String[]{projectName}));
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus checkErrorStatus(int validationState, String typeId, String runtimeId, String serverId, String serverInstanceId, String projectName, String initialProjectName, boolean needEar, String earProjectName, String projectTypeId, boolean isClient) {
        String serverLabel = "";
        if (serverId != null && serverId.length() > 0) {
            serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId);
        }
        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(runtimeId);
        if ((validationState == 1 || validationState == 2) && serverId != null && serverId.length() > 0) {
            if (isClient) {
                if (!WebServiceRuntimeExtensionUtils2.isServerClientRuntimeTypeSupported(serverId, runtimeId, typeId)) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
                }
            } else {
                if (!WebServiceRuntimeExtensionUtils2.isServerRuntimeTypeSupported(serverId, runtimeId, typeId)) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
                }
                if (initialProjectName != "" && serverId != null && !projectName.equals(initialProjectName) && WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(typeId) == 0 && J2EEUtils.isJavaComponent((IProject)ProjectUtilities.getProject((String)initialProjectName)) && !this.doesServerSupportProject(serverId, initialProjectName)) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_SERVER_DOES_NOT_SUPPORT_JAVAPROJECT, (Object[])new String[]{serverLabel, initialProjectName}));
                }
            }
        }
        if (validationState == 1 || validationState == 2 || validationState == 3) {
            ValidationUtils valUtils = new ValidationUtils();
            IProject project = ProjectUtilities.getProject((String)projectName);
            if (project.exists()) {
                if (isClient) {
                    if (!WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportProject(typeId, runtimeId, projectName)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_RUNTIME_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{runtimeLabel, projectName}));
                    }
                    if (serverId != null && serverId.length() > 0 && !valUtils.doesServerSupportProject(serverId, projectName)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_SERVER_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{serverLabel, projectName}));
                    }
                } else {
                    if (!WebServiceRuntimeExtensionUtils2.doesServiceTypeAndRuntimeSupportProject(typeId, runtimeId, projectName)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_RUNTIME_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{runtimeLabel, projectName}));
                    }
                    if (serverId != null && serverId.length() > 0 && !valUtils.doesServerSupportProject(serverId, projectName)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_SERVER_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{serverLabel, projectName}));
                    }
                }
            } else {
                String templateId = projectTypeId;
                String templateLabel = FacetUtils.getTemplateLabelById((String)templateId);
                if (isClient) {
                    if (!WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportTemplate(typeId, runtimeId, templateId)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_RUNTIME_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{runtimeLabel, templateLabel}));
                    }
                    if (serverId != null && serverId.length() > 0 && !valUtils.doesServerSupportTemplate(serverId, templateId)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_SERVER_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{serverLabel, templateLabel}));
                    }
                } else {
                    if (!WebServiceRuntimeExtensionUtils2.doesServiceTypeAndRuntimeSupportTemplate(typeId, runtimeId, templateId)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_RUNTIME_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{runtimeLabel, templateLabel}));
                    }
                    if (serverId != null && serverId.length() > 0 && !valUtils.doesServerSupportTemplate(serverId, templateId)) {
                        return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_SERVER_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{serverLabel, templateLabel}));
                    }
                }
            }
        }
        if ((validationState == 1 || validationState == 3) && needEar) {
            boolean associateStatus;
            IProject project = ProjectUtilities.getProject((String)projectName);
            IProject ep = ProjectUtilities.getProject((String)earProjectName);
            IStatus canCreateEARStatus = J2EEUtils.canCreateEAR((IProject)ep);
            if (!canCreateEARStatus.isOK()) {
                return canCreateEARStatus;
            }
            if (project.exists() && ep.exists() && !J2EEUtils.isComponentAssociated((IProject)ep, (IProject)project) && !(associateStatus = J2EEUtils.canAssociateProjectToEARWithoutWarning((IProject)project, (IProject)ep))) {
                return StatusUtils.warningStatus((String)NLS.bind((String)EARValidationMessageResourceHandler.MESSAGE_INCOMPATIBLE_SPEC_WARNING_, (Object[])new String[]{projectName, ep.getName()}));
            }
        }
        if (validationState == 1 || validationState == 2 || validationState == 3) {
            TypeRuntimeServer trs = new TypeRuntimeServer();
            trs.setTypeId(typeId);
            trs.setRuntimeId(runtimeId);
            trs.setServerId(serverId);
            IWebServiceRuntimeChecker runtimeChecker = null;
            if (isClient) {
                String clientRuntimeId = WebServiceRuntimeExtensionUtils2.getClientRuntimeId(trs, projectName, projectTypeId);
                runtimeChecker = WebServiceRuntimeExtensionUtils2.getClientRuntimeChecker(clientRuntimeId);
            } else {
                String serviceRuntimeId = WebServiceRuntimeExtensionUtils2.getServiceRuntimeId(trs, projectName, projectTypeId);
                runtimeChecker = WebServiceRuntimeExtensionUtils2.getServiceRuntimeChecker(serviceRuntimeId);
            }
            if (runtimeChecker != null) {
                return runtimeChecker.checkRuntimeCompatibility(serverId, serverInstanceId, projectName, projectTypeId, earProjectName);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus checkWarningStatus(int validationState, int scaleSetting, String serverId, String serverInstanceId, boolean isClient) {
        if (validationState == 1 || validationState == 4 || validationState == 2) {
            if (serverId == null || serverId.length() == 0) {
                if (scaleSetting < 4) {
                    if (isClient) {
                        return StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_WARN_NO_CLIENT_SERVER, (Object[])new String[0]));
                    }
                    return StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_WARN_NO_SERVICE_SERVER, (Object[])new String[0]));
                }
            } else {
                IServerType serverType = ServerCore.findServerType((String)serverId);
                if (serverType != null) {
                    IRuntime nonStubRuntime = ServerUtils.getNonStubRuntime((String)serverId);
                    if (scaleSetting < 3 && nonStubRuntime == null && serverInstanceId == null) {
                        String servertypeLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId);
                        return StatusUtils.warningStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_WARN_STUB_ONLY, (Object[])new String[]{servertypeLabel}));
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    public boolean doesServerSupportProject(String serverFactoryId, String projectName) {
        Set facets = FacetUtils.getFacetsForProject((String)projectName);
        if (facets == null) {
            return true;
        }
        return this.doesServerSupportFacets(serverFactoryId, facets);
    }

    public boolean doesServerSupportFacets(String serverFactoryId, Set facets) {
        Set runtimes = FacetUtils.getRuntimes((Set[])new Set[]{facets});
        Iterator itr = runtimes.iterator();
        IServerType st = ServerCore.findServerType((String)serverFactoryId);
        String runtimeTypeId = st.getRuntimeType().getId();
        while (itr.hasNext()) {
            IRuntimeType runtimeType;
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)itr.next();
            IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
            if (sRuntime == null || (runtimeType = sRuntime.getRuntimeType()) == null || !runtimeTypeId.equals(runtimeType.getId())) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean doesServerSupportTemplate(String serverFactoryId, String templateId) {
        template = ProjectFacetsManager.getTemplate((String)templateId);
        templateFacets = template.getFixedProjectFacets();
        templateFacetsItr = templateFacets.iterator();
        while (templateFacetsItr.hasNext()) {
            block7: {
                serverSupportsThisOne = false;
                fixedFacet = (IProjectFacet)templateFacetsItr.next();
                versions = null;
                try {
                    versions = fixedFacet.getSortedVersions(true);
                    break block7;
                }
                catch (VersionFormatException v0) {
                    versionSet = fixedFacet.getVersions();
                    itr = versionSet.iterator();
                    versions = new ArrayList<E>();
                    ** while (itr.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    versions.add(itr.next());
                    continue;
lbl19:
                    // 1 sources

                    break block7;
                }
                catch (CoreException v1) {
                    versionSet = fixedFacet.getVersions();
                    itr = versionSet.iterator();
                    versions = new ArrayList<E>();
                    ** while (itr.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    versions.add(itr.next());
                    continue;
                }
            }
            for (IProjectFacetVersion pfv : versions) {
                pfvs = new HashSet<IProjectFacetVersion>();
                pfvs.add(pfv);
                if (!this.doesServerSupportFacets(serverFactoryId, pfvs)) continue;
                serverSupportsThisOne = true;
                break;
            }
            if (serverSupportsThisOne) continue;
            return false;
        }
        return true;
    }

    public boolean projectOrProjectTypeNeedsEar(String projectName, String projectTypeId) {
        IProject project;
        if (projectName != null && projectName.length() > 0 && (project = ResourceUtils.getWorkspaceRoot().getProject(projectName)).exists() && FacetUtils.isJavaProject((IProject)project)) {
            return false;
        }
        String templateId = projectTypeId;
        return templateId == null || templateId.length() <= 0 || !FacetUtils.isUtilityTemplate((String)templateId);
    }

    public boolean serverNeedsEAR(String serverTypeId) {
        String targetId;
        if (serverTypeId == null) {
            return false;
        }
        return serverTypeId.length() <= 0 || (targetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverTypeId)) == null || targetId.length() <= 0 || ServerUtils.isTargetValidForEAR((String)targetId, (String)"13");
    }

    public IStatus validateProjectTargetAndJ2EE(String projectName, String compName, String earName, String earCompName, String serverFactoryId, String j2eeLevel) {
        IProject p = ProjectUtilities.getProject((String)projectName);
        IProject earP = null;
        if (earName != null && !earName.equalsIgnoreCase("")) {
            earP = ProjectUtilities.getProject((String)earName);
        }
        IStatus targetStatus = this.doesProjectTargetMatchServerType(p, serverFactoryId);
        if (earP != null && targetStatus.getSeverity() == 0) {
            IStatus earTargetStatus = this.doesProjectTargetMatchServerType(earP, serverFactoryId);
            if (earTargetStatus.getSeverity() == 4) {
                return earTargetStatus;
            }
        } else {
            return targetStatus;
        }
        IStatus j2eeStatus = this.doesProjectMatchJ2EELevel(p, compName, j2eeLevel);
        if (earP != null && j2eeStatus.getSeverity() == 0) {
            IStatus earJ2EEStatus = this.doesProjectMatchJ2EELevel(earP, earCompName, j2eeLevel);
            if (earJ2EEStatus.getSeverity() == 4) {
                return earJ2EEStatus;
            }
        } else {
            return j2eeStatus;
        }
        return Status.OK_STATUS;
    }

    private IStatus doesProjectTargetMatchServerType(IProject p, String serverFactoryId) {
        IRuntime projectTarget;
        if (p != null && p.exists() && (projectTarget = ServerSelectionUtils.getRuntimeTarget(p.getName())) != null) {
            String projectTargetId = projectTarget.getRuntimeType().getId();
            String serverTargetId = ServerUtils.getRuntimeTargetIdFromFactoryId((String)serverFactoryId);
            if (serverTargetId != null && serverTargetId.length() > 0 && !projectTargetId.equals(serverTargetId)) {
                return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVER_TARGET_MISMATCH, (Object[])new String[]{p.getName()}));
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus doesProjectMatchJ2EELevel(IProject p, String compName, String j2eeLevel) {
        try {
            int projectJ2EELevel;
            if (p != null && p.exists() && (projectJ2EELevel = J2EEUtils.getJ2EEVersion((IProject)p)) != -1) {
                String projectJ2EELevelString = String.valueOf(projectJ2EELevel);
                if (j2eeLevel != null && j2eeLevel.length() > 0 && !projectJ2EELevelString.equals(j2eeLevel)) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_J2EE_MISMATCH, (Object[])new String[]{p.getName()}));
                }
            }
        }
        catch (Exception exception) {}
        return Status.OK_STATUS;
    }

    public IStatus validateProjectType(String projectName, SelectionListChoices runtime2ClientTypes) {
        IStatus status = Status.OK_STATUS;
        IProject p = ProjectUtilities.getProject((String)projectName);
        if (p == null || !p.exists()) {
            return status;
        }
        String[] projectNames = runtime2ClientTypes.getChoice().getChoice().getList().getList();
        int i = 0;
        while (i < projectNames.length) {
            if (projectName.equals(projectNames[i])) {
                return status;
            }
            ++i;
        }
        String clientTypeLabel = this.getClientTypeLabel(runtime2ClientTypes.getChoice().getList().getSelection());
        String message = NLS.bind((String)ConsumptionUIMessages.MSG_WRONG_CLIENT_PROJECT_TYPE, (Object[])new String[]{projectName, clientTypeLabel});
        IStatus eStatus = StatusUtils.errorStatus((String)message);
        return eStatus;
    }

    private String getClientTypeLabel(String type) {
        if (type.equals("jst.web")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_WEB;
        }
        if (type.equals("jst.ejb")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_EJB;
        }
        if (type.equals("jst.appclient")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_APP_CLIENT;
        }
        if (type.equals("jst.utility")) {
            return ConsumptionUIMessages.LABEL_CLIENT_COMP_TYPE_CONTAINERLESS;
        }
        return type;
    }

    public boolean isProjectServiceProject(IProject p, String wsdlURL, WebServicesParser parser) {
        if (p == null || wsdlURL == null || wsdlURL.length() == 0 || parser == null) {
            return false;
        }
        IResource wsXML = this.getWebServcesXML(p);
        if (wsXML == null) {
            return false;
        }
        if (!(wsXML instanceof IFile)) {
            return false;
        }
        Resource res = WorkbenchResourceHelperBase.getResource((IFile)((IFile)wsXML), (boolean)true);
        WsddResource wsddRes = (WsddResource)res;
        WebServices webServices = wsddRes.getWebServices();
        Iterator wsDescs = webServices.getWebServiceDescriptions().iterator();
        ArrayList<QualifiedName> wsdlPortList = new ArrayList<QualifiedName>();
        while (wsDescs.hasNext()) {
            WebServiceDescription wsDesc = (WebServiceDescription)wsDescs.next();
            for (PortComponent pc : wsDesc.getPortComponents()) {
                WSDLPort wsdlPort = pc.getWsdlPort();
                wsdlPortList.add(new QualifiedName(wsdlPort.getNamespaceURI(), wsdlPort.getLocalPart()));
            }
        }
        ArrayList portList = this.getPortNamesFromWsdl(wsdlURL, parser);
        Object[] ports = portList.toArray();
        Object[] wsdlPorts = wsdlPortList.toArray();
        int i = 0;
        while (i < ports.length) {
            QualifiedName portName = (QualifiedName)ports[i];
            int j = 0;
            while (j < wsdlPorts.length) {
                QualifiedName wsdlPortName = (QualifiedName)wsdlPorts[j];
                if (portName.equals(wsdlPortName)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private IResource getWebServcesXML(IProject p) {
        IResource moduleRoot = this.getModuleRoot(p);
        if (!(moduleRoot instanceof IContainer)) {
            return null;
        }
        IResource webServicesXML = null;
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)p)) {
            StringBuffer wsPath = new StringBuffer();
            wsPath.append("WEB-INF/");
            wsPath.append("webservices.xml");
            webServicesXML = ((IContainer)moduleRoot).findMember(wsPath.toString());
        } else {
            StringBuffer wsPath = new StringBuffer();
            wsPath.append("META-INF/");
            wsPath.append("webservices.xml");
            webServicesXML = ((IContainer)moduleRoot).findMember(wsPath.toString());
        }
        return webServicesXML;
    }

    private IResource getModuleRoot(IProject p) {
        IPath modulePath = null;
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)p);
            if (vc != null) {
                modulePath = vc.getRootFolder().getWorkspaceRelativePath();
            }
        }
        catch (Exception exception) {}
        IResource res = ResourceUtils.findResource(modulePath);
        return res;
    }

    private ArrayList getPortNamesFromWsdl(String wsdlURL, WebServicesParser parser) {
        ArrayList<QualifiedName> portNameList = new ArrayList<QualifiedName>();
        Definition def = parser.getWSDLDefinition(wsdlURL);
        Map services = def.getServices();
        Service service2 = null;
        for (Service service2 : services.values()) {
            String namespace = service2.getQName().getNamespaceURI();
            Map ports = service2.getPorts();
            for (Port port : ports.values()) {
                portNameList.add(new QualifiedName(namespace, port.getName()));
            }
        }
        return portNameList;
    }

    private class QualifiedName {
        String namespaceURI;
        String localPart;

        public QualifiedName(String namespaceURI, String localPart) {
            this.namespaceURI = namespaceURI;
            this.localPart = localPart;
        }

        public String getLocalPart() {
            return this.localPart;
        }

        public void setLocalPart(String localPart) {
            this.localPart = localPart;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        public boolean equals(QualifiedName qn) {
            return qn.getNamespaceURI().equals(this.namespaceURI) && qn.getLocalPart().equals(this.localPart);
        }
    }
}

