/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorDiagnosticFactory;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeComparator {
    private final TypeComparatorDiagnosticFactory _factory;

    public TypeComparator(TypeComparatorDiagnosticFactory factory) {
        this._factory = factory;
    }

    public Diagnostic calculateTypeCompatibility(CompositeType firstType, CompositeType secondType) {
        CompositeType boxedFirstType = TypeTransformer.transformBoxPrimitives(firstType);
        CompositeType boxedSecondType = TypeTransformer.transformBoxPrimitives(secondType);
        String[] mustBeSatisfied = boxedFirstType.getSignatures();
        String[] testSignatures = boxedSecondType.getSignatures();
        List<String> mustbeMethods = Collections.emptyList();
        List<String> mustbeTypes = Collections.emptyList();
        String[] stringArray = mustBeSatisfied;
        int n = mustBeSatisfied.length;
        int n2 = 0;
        while (n2 < n) {
            String mustbeSignature = stringArray[n2];
            if (TypeUtil.isMethodSignature(mustbeSignature)) {
                if (mustbeMethods.isEmpty()) {
                    mustbeMethods = new ArrayList(mustbeSignature.length());
                }
                mustbeMethods.add(mustbeSignature);
            } else {
                if (mustbeTypes.isEmpty()) {
                    mustbeTypes = new ArrayList(mustbeSignature.length());
                }
                mustbeTypes.add(mustbeSignature);
            }
            ++n2;
        }
        boolean mustbeWriteable = firstType.isLHS();
        SignatureTestResult bestResult = null;
        String[] stringArray2 = testSignatures;
        int n3 = testSignatures.length;
        int n4 = 0;
        while (n4 < n3) {
            SignatureTestResult testResult;
            String isSignature = stringArray2[n4];
            if (TypeUtil.isMethodSignature(isSignature)) {
                testResult = this.checkMethodSignature(isSignature, mustbeTypes, mustbeMethods);
                if (testResult.diagnostic.getSeverity() == 0) {
                    return testResult.diagnostic;
                }
            } else {
                testResult = this.checkTypeSignature(isSignature, mustbeTypes, mustbeMethods, mustbeWriteable);
                if (testResult.diagnostic.getSeverity() == 0) {
                    return this.checkAssignability(firstType, secondType);
                }
            }
            if (bestResult == null || bestResult.matchQuality < testResult.matchQuality) {
                bestResult = testResult;
            }
            ++n4;
        }
        return bestResult.diagnostic;
    }

    private SignatureTestResult checkTypeSignature(String isSignature, List<String> mustbeTypes, List<String> mustbeMethods, boolean mustbeWriteable) {
        if (mustbeTypes.isEmpty()) {
            Diagnostic diag = this._factory.create_METHOD_EXPRESSION_EXPECTED();
            return new SignatureTestResult(diag, 0);
        }
        for (String mustbeSignature : mustbeTypes) {
            if (!mustbeSignature.equals(isSignature) && !TypeComparator.canCoerce(isSignature, mustbeSignature, mustbeWriteable)) continue;
            Diagnostic diag = Diagnostic.OK_INSTANCE;
            return new SignatureTestResult(diag, 5);
        }
        Object[] params = new String[]{TypeComparator.readableSignatures(mustbeTypes), Signature.toString((String)isSignature)};
        Diagnostic diag = this._factory.create_INCOMPATIBLE_TYPES(params);
        return new SignatureTestResult(diag, 1);
    }

    private SignatureTestResult checkMethodSignature(String isSignature, List<String> mustbeTypes, List<String> mustbeMethods) {
        if (mustbeMethods.isEmpty()) {
            Diagnostic diag = this._factory.create_VALUE_EXPRESSION_EXPECTED();
            return new SignatureTestResult(diag, 0);
        }
        for (String mustbeSignature : mustbeMethods) {
            if (!TypeComparator.methodSignaturesMatch(mustbeSignature, isSignature)) continue;
            Diagnostic diag = Diagnostic.OK_INSTANCE;
            return new SignatureTestResult(diag, 5);
        }
        Object[] params = new String[]{TypeComparator.readableSignatures(mustbeMethods), Signature.toString((String)isSignature, (String)"method", null, (boolean)false, (boolean)true)};
        Diagnostic diag = this._factory.create_INCOMPATIBLE_METHOD_TYPES(params);
        return new SignatureTestResult(diag, 1);
    }

    private static String readableSignatures(List<String> signatures) {
        StringBuilder res = null;
        for (String sig : signatures) {
            String sigText = TypeUtil.isMethodSignature(sig) ? Signature.toString((String)sig, (String)"method", null, (boolean)false, (boolean)true) : Signature.toString((String)sig);
            if (res == null) {
                res = new StringBuilder(sigText);
                continue;
            }
            res.append(", ").append(sigText);
        }
        return res != null ? res.toString() : "[no signature]";
    }

    private static boolean canCoerce(String testType, String checkType, boolean checkTypeIsWritable) {
        boolean canCoerce = TypeComparator.canCoerce(testType, checkType);
        if (canCoerce && checkTypeIsWritable) {
            canCoerce &= TypeComparator.canCoerce(checkType, testType);
        }
        return canCoerce;
    }

    private static boolean canCoerce(String testType, String checkType) {
        if (TypeCoercer.typeIsString(checkType)) {
            return true;
        }
        if (TypeCoercer.typeIsNumeric(checkType)) {
            return TypeComparator.canCoerceNumeric(testType);
        }
        if (TypeCoercer.typeIsBoolean(checkType)) {
            return TypeCoercer.canCoerceToBoolean(testType);
        }
        return false;
    }

    private static boolean canCoerceNumeric(String testType) {
        try {
            TypeCoercer.coerceToNumber(testType);
            return true;
        }
        catch (TypeCoercionException typeCoercionException) {
            return false;
        }
    }

    private static boolean methodSignaturesMatch(String firstMethodSig, String secondMethodSig) {
        String secondReturn;
        String[] secondMethodParams;
        if (firstMethodSig.equals(secondMethodSig)) {
            return true;
        }
        String[] firstMethodParams = Signature.getParameterTypes((String)firstMethodSig);
        if (firstMethodParams.length != (secondMethodParams = Signature.getParameterTypes((String)secondMethodSig)).length) {
            return false;
        }
        int i = 0;
        while (i < firstMethodParams.length) {
            String secondMethodParam;
            String firstMethodParam = TypeTransformer.transformBoxPrimitives(firstMethodParams[i]);
            if (!firstMethodParam.equals(secondMethodParam = TypeTransformer.transformBoxPrimitives(secondMethodParams[i]))) {
                return false;
            }
            ++i;
        }
        String firstReturn = TypeTransformer.transformBoxPrimitives(Signature.getReturnType((String)firstMethodSig));
        return firstReturn.equals(secondReturn = TypeTransformer.transformBoxPrimitives(Signature.getReturnType((String)secondMethodSig)));
    }

    private Diagnostic checkAssignability(CompositeType firstType, CompositeType secondType) {
        if (firstType.isRHS() && !secondType.isRHS()) {
            return this._factory.create_PROPERTY_NOT_READABLE();
        }
        if (firstType.isLHS() && !secondType.isLHS()) {
            return this._factory.create_PROPERTY_NOT_WRITABLE();
        }
        return Diagnostic.OK_INSTANCE;
    }

    private static class SignatureTestResult {
        private final Diagnostic diagnostic;
        private final int matchQuality;

        public SignatureTestResult(Diagnostic diagnostic, int matchQuality) {
            this.diagnostic = diagnostic;
            this.matchQuality = matchQuality;
        }
    }
}

