/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.internet.monitor.core.internal.AcceptThread;
import org.eclipse.wst.internet.monitor.core.internal.IMemento;
import org.eclipse.wst.internet.monitor.core.internal.Messages;
import org.eclipse.wst.internet.monitor.core.internal.Monitor;
import org.eclipse.wst.internet.monitor.core.internal.MonitorPlugin;
import org.eclipse.wst.internet.monitor.core.internal.MonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.XMLMemento;
import org.eclipse.wst.internet.monitor.core.internal.http.ResendHTTPRequest;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorManager {
    private static final int ADD = 0;
    private static final int CHANGE = 1;
    private static final int REMOVE = 2;
    protected List<IMonitor> monitors;
    protected Map<IMonitor, AcceptThread> threads = new HashMap<IMonitor, AcceptThread>();
    protected List<IMonitorListener> monitorListeners = new ArrayList<IMonitorListener>();
    private Preferences.IPropertyChangeListener pcl;
    protected boolean ignorePreferenceChanges = false;
    protected Map<Request, List<ResendHTTPRequest>> resendMap = new HashMap<Request, List<ResendHTTPRequest>>();
    protected static MonitorManager instance;

    static {
        MonitorPlugin.getInstance().executeStartups();
    }

    public static MonitorManager getInstance() {
        if (instance == null) {
            instance = new MonitorManager();
            instance.startMonitors();
        }
        return instance;
    }

    private MonitorManager() {
        this.loadMonitors();
        this.pcl = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (MonitorManager.this.ignorePreferenceChanges) {
                    return;
                }
                String property = event.getProperty();
                if (property.equals("monitors")) {
                    MonitorManager.this.loadMonitors();
                }
            }
        };
        MonitorPlugin.getInstance().getPluginPreferences().addPropertyChangeListener(this.pcl);
    }

    protected void dispose() {
        MonitorPlugin.getInstance().getPluginPreferences().removePropertyChangeListener(this.pcl);
    }

    public IMonitorWorkingCopy createMonitor() {
        return new MonitorWorkingCopy();
    }

    public List<IMonitor> getMonitors() {
        return new ArrayList<IMonitor>(this.monitors);
    }

    protected synchronized void addMonitor(IMonitor monitor) {
        if (!this.monitors.contains(monitor)) {
            this.monitors.add(monitor);
        }
        this.fireMonitorEvent(monitor, 0);
        this.saveMonitors();
    }

    protected boolean isRunning(IMonitor monitor) {
        return this.threads.get(monitor) != null;
    }

    public void startMonitor(IMonitor monitor) throws CoreException {
        if (!this.monitors.contains(monitor)) {
            return;
        }
        if (AcceptThread.isPortInUse(monitor.getLocalPort())) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.internet.monitor.core", 0, NLS.bind((String)Messages.errorPortInUse, (Object)String.valueOf(monitor.getLocalPort())), null));
        }
        AcceptThread thread = new AcceptThread(monitor);
        thread.startServer();
        this.threads.put(monitor, thread);
    }

    public void stopMonitor(IMonitor monitor) {
        if (!this.monitors.contains(monitor)) {
            return;
        }
        AcceptThread thread = this.threads.get(monitor);
        if (thread != null) {
            thread.stopServer();
            this.threads.remove(monitor);
        }
    }

    protected synchronized void removeMonitor(IMonitor monitor) {
        if (monitor.isRunning()) {
            this.stopMonitor(monitor);
        }
        this.monitors.remove(monitor);
        this.fireMonitorEvent(monitor, 2);
        this.saveMonitors();
    }

    protected synchronized void monitorChanged(IMonitor monitor) {
        this.fireMonitorEvent(monitor, 1);
        this.saveMonitors();
    }

    protected boolean exists(IMonitor monitor) {
        return this.monitors.contains(monitor);
    }

    public synchronized void addMonitorListener(IMonitorListener listener) {
        if (!this.monitorListeners.contains(listener)) {
            this.monitorListeners.add(listener);
        }
    }

    public synchronized void removeMonitorListener(IMonitorListener listener) {
        if (this.monitorListeners.contains(listener)) {
            this.monitorListeners.remove(listener);
        }
    }

    protected void fireMonitorEvent(IMonitor monitor, int type) {
        IMonitorListener[] obj;
        IMonitorListener[] iMonitorListenerArray = obj = this.monitorListeners.toArray(new IMonitorListener[this.monitorListeners.size()]);
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            IMonitorListener listener = iMonitorListenerArray[n2];
            if (type == 0) {
                listener.monitorAdded(monitor);
            } else if (type == 1) {
                listener.monitorChanged(monitor);
            } else if (type == 2) {
                listener.monitorRemoved(monitor);
            }
            ++n2;
        }
    }

    protected synchronized void loadMonitors() {
        Trace.trace((byte)3, "Loading monitors");
        this.monitors = new ArrayList<IMonitor>();
        Preferences prefs = MonitorPlugin.getInstance().getPluginPreferences();
        String xmlString = prefs.getString("monitors");
        if (xmlString != null && xmlString.length() > 0) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
                IMemento memento = XMLMemento.loadMemento(in);
                IMemento[] children = memento.getChildren("monitor");
                if (children != null) {
                    int size = children.length;
                    int i = 0;
                    while (i < size) {
                        Monitor monitor = new Monitor();
                        monitor.load(children[i]);
                        this.monitors.add(monitor);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Trace.trace((byte)1, "Could not load monitors", e);
            }
        }
    }

    protected synchronized void saveMonitors() {
        try {
            this.ignorePreferenceChanges = true;
            XMLMemento memento = XMLMemento.createWriteRoot("monitors");
            for (Monitor monitor : this.monitors) {
                IMemento child = memento.createChild("monitor");
                monitor.save(child);
            }
            String string = memento.saveToString();
            Preferences prefs = MonitorPlugin.getInstance().getPluginPreferences();
            prefs.setValue("monitors", string);
            MonitorPlugin.getInstance().savePluginPreferences();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not save browsers", e);
        }
        this.ignorePreferenceChanges = false;
    }

    public static ResendHTTPRequest createResendRequest(Request request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        return new ResendHTTPRequest((Monitor)request.getMonitor(), request);
    }

    public void addResendRequest(Request request, ResendHTTPRequest resendReq) {
        if (request == null || resendReq == null) {
            return;
        }
        List<ResendHTTPRequest> list = null;
        try {
            list = this.resendMap.get(request);
        }
        catch (Exception exception) {}
        if (list == null) {
            list = new ArrayList<ResendHTTPRequest>();
            this.resendMap.put(request, list);
        }
        list.add(resendReq);
    }

    public ResendHTTPRequest[] getResendRequests(Request request) {
        List<ResendHTTPRequest> list = this.resendMap.get(request);
        if (list != null) {
            return list.toArray(new ResendHTTPRequest[list.size()]);
        }
        return new ResendHTTPRequest[0];
    }

    public synchronized void startMonitors() {
        MonitorManager manager = MonitorManager.getInstance();
        List<IMonitor> monitorList = manager.getMonitors();
        for (IMonitor monitor : monitorList) {
            if (!monitor.isAutoStart()) continue;
            try {
                monitor.start();
            }
            catch (CoreException e) {
                Trace.trace((byte)2, "Failed to start monitor:" + monitor.toString(), e);
            }
        }
    }
}

