/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.StringLiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.symbol.internal.util.IObjectSymbolBasedValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.Messages;
import org.eclipse.jst.jsf.validation.internal.el.operators.RelationalBinaryOperator;

abstract class EqualityRelationalBinaryOperator
extends RelationalBinaryOperator {
    EqualityRelationalBinaryOperator(DiagnosticFactory diagnosticFactory, String jsfVersion) {
        super(diagnosticFactory, jsfVersion);
    }

    protected abstract boolean doRealOperation(Boolean var1, Boolean var2);

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) || TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return BooleanLiteralType.FALSE;
        }
        String boxedFirstType = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondType = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstType) || "Ljava.math.BigDecimal;".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, BigDecimal.class);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstType) || "Ljava.lang.Float;".equals(boxedFirstType) || "Ljava.lang.Double;".equals(boxedSecondType) || "Ljava.lang.Float;".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, Double.class);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstType) || "Ljava.math.BigInteger;".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, BigInteger.class);
        }
        if ("Ljava.lang.Long;".equals(boxedFirstType) || "Ljava.lang.Long;".equals(boxedSecondType) || "Ljava.lang.Integer;".equals(boxedFirstType) || "Ljava.lang.Integer;".equals(boxedSecondType) || "Ljava.lang.Short;".equals(boxedFirstType) || "Ljava.lang.Short;".equals(boxedSecondType) || "Ljava.lang.Byte;".equals(boxedFirstType) || "Ljava.lang.Byte;".equals(boxedSecondType) || "Ljava.lang.Character".equals(boxedFirstType) || "Ljava.lang.Character".equals(boxedSecondType)) {
            return this.handleNumericComparison(firstArg, secondArg, Long.class);
        }
        if ("Ljava.lang.Boolean;".equals(boxedFirstType) || "Ljava.lang.Boolean;".equals(boxedSecondType)) {
            return this.handleBooleanComparison(firstArg, secondArg);
        }
        if (firstArg.isEnumType() || secondArg.isEnumType()) {
            return this.handleEnumComparison(firstArg, secondArg);
        }
        if ("Ljava.lang.String;".equals(boxedFirstType) || "Ljava.lang.String;".equals(boxedSecondType)) {
            return this.handleStringComparison(firstArg, secondArg);
        }
        return new ValueType("Z", 2);
    }

    private ValueType handleEnumComparison(ValueType firstArg, ValueType secondArg) {
        assert (firstArg.isEnumType() || secondArg.isEnumType());
        if (!firstArg.isEnumType()) {
            return this.handleComparsionOfEnumAndNonEnum(secondArg, firstArg);
        }
        if (!secondArg.isEnumType()) {
            return this.handleComparsionOfEnumAndNonEnum(firstArg, secondArg);
        }
        if (TypeUtil.canNeverBeEqual((String)firstArg.getSignature(), (String)secondArg.getSignature())) {
            boolean result = this.doRealOperation("foo", "notFoo");
            return BooleanLiteralType.valueOf((boolean)result);
        }
        return new ValueType("Z", 2);
    }

    private ValueType handleComparsionOfEnumAndNonEnum(ValueType enumType, ValueType nonEnumType) {
        if (nonEnumType instanceof LiteralType) {
            assert (nonEnumType instanceof StringLiteralType);
            Diagnostic result = this.validateIfEnumToStringComparison(((StringLiteralType)nonEnumType).getLiteralValue(), enumType);
            if (result != null) {
                return BooleanLiteralType.valueOf((boolean)this.doRealOperation("foo", "foo_"));
            }
            return new ValueType("Z", 2);
        }
        if (nonEnumType.isInstanceOf("Ljava.lang.String;")) {
            return new ValueType("Z", 2);
        }
        return BooleanLiteralType.valueOf((boolean)this.doRealOperation("foo", "foo_"));
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) || TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            boolean result = this.doRealOperation(4, null);
            return this._diagnosticFactory.create_BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME(Boolean.toString(result));
        }
        String boxedFirstType = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondType = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstType) || "Ljava.math.BigDecimal;".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, BigDecimal.class);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstType) || "Ljava.lang.Float;".equals(boxedFirstType) || "Ljava.lang.Double;".equals(boxedSecondType) || "Ljava.lang.Float;".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, Double.class);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstType) || "Ljava.math.BigInteger;".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, BigInteger.class);
        }
        if ("Ljava.lang.Long;".equals(boxedFirstType) || "Ljava.lang.Long;".equals(boxedSecondType) || "Ljava.lang.Integer;".equals(boxedFirstType) || "Ljava.lang.Integer;".equals(boxedSecondType) || "Ljava.lang.Short;".equals(boxedFirstType) || "Ljava.lang.Short;".equals(boxedSecondType) || "Ljava.lang.Byte;".equals(boxedFirstType) || "Ljava.lang.Byte;".equals(boxedSecondType) || "Ljava.lang.Character".equals(boxedFirstType) || "Ljava.lang.Character".equals(boxedSecondType)) {
            return this.validateNumericComparison(firstArg, secondArg, Long.class);
        }
        if ("Ljava.lang.Boolean;".equals(boxedFirstType) || "Ljava.lang.Boolean;".equals(boxedSecondType)) {
            return this.validateBooleanComparison(firstArg, secondArg);
        }
        if (firstArg.isEnumType() || secondArg.isEnumType()) {
            return this.validateEnumComparison(firstArg, secondArg);
        }
        if ("Ljava.lang.String;".equals(boxedFirstType) || "Ljava.lang.String;".equals(boxedSecondType)) {
            return this.validateStringComparison(firstArg, secondArg);
        }
        return Diagnostic.OK_INSTANCE;
    }

    private ValueType handleBooleanComparison(ValueType firstArg, ValueType secondArg) {
        boolean canCoerceFirstArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
        boolean canCoerceSecondArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
        if (!canCoerceFirstArg || !canCoerceSecondArg) {
            return null;
        }
        if (firstArg instanceof LiteralType && secondArg instanceof LiteralType) {
            try {
                Boolean firstValue = ((LiteralType)firstArg).coerceToBoolean();
                Boolean secondValue = ((LiteralType)secondArg).coerceToBoolean();
                if (firstValue != null && secondValue != null) {
                    boolean result = this.doRealOperation(firstValue, secondValue);
                    return result ? BooleanLiteralType.TRUE : BooleanLiteralType.FALSE;
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"should never get here; have already checked coercability above");
            }
        }
        return new ValueType("Z", 2);
    }

    private Diagnostic validateBooleanComparison(ValueType firstType, ValueType secondType) {
        boolean canCoerceFirstArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)firstType.getSignature()));
        boolean canCoerceSecondArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)secondType.getSignature()));
        if (!canCoerceFirstArg) {
            return this._diagnosticFactory.create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN(Messages.getString("EqualityRelationalBinaryOperator.FirstArgument"));
        }
        if (!canCoerceSecondArg) {
            return this._diagnosticFactory.create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN(Messages.getString("EqualityRelationalBinaryOperator.SecondArgument"));
        }
        if (firstType instanceof LiteralType && secondType instanceof LiteralType) {
            try {
                Boolean firstValue = ((LiteralType)firstType).coerceToBoolean();
                Boolean secondValue = ((LiteralType)secondType).coerceToBoolean();
                if (firstValue != null && secondValue != null) {
                    boolean result = this.doRealOperation(firstValue, secondValue);
                    return this._diagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(this.getOperationName(), Boolean.toString(result));
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"should never get here; have already checked coercability above");
            }
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic validateStringComparison(ValueType firstType, ValueType secondType) {
        Diagnostic result;
        String firstValue = null;
        if (firstType instanceof LiteralType) {
            firstValue = ((LiteralType)firstType).getLiteralValue();
        }
        String secondValue = null;
        if (secondType instanceof LiteralType) {
            secondValue = ((LiteralType)secondType).getLiteralValue();
        }
        if (firstValue != null && (result = this.validateIfEnumToStringComparison(firstValue, secondType)) != null) {
            return result;
        }
        if (secondValue != null && (result = this.validateIfEnumToStringComparison(secondValue, firstType)) != null) {
            return result;
        }
        return super.validateStringComparison(firstType, secondType);
    }

    protected ValueType handleStringComparison(ValueType firstType, ValueType secondType) {
        Diagnostic result;
        String firstValue = null;
        if (firstType instanceof LiteralType) {
            firstValue = ((LiteralType)firstType).getLiteralValue();
        }
        String secondValue = null;
        if (secondType instanceof LiteralType) {
            secondValue = ((LiteralType)secondType).getLiteralValue();
        }
        if (firstValue != null && (result = this.validateIfEnumToStringComparison(firstValue, secondType)) != null) {
            return this.handleIfEnumToNonMemberStringComparison(firstValue, secondType);
        }
        if (secondValue != null && (result = this.validateIfEnumToStringComparison(secondValue, firstType)) != null) {
            return this.handleIfEnumToNonMemberStringComparison(secondValue, firstType);
        }
        return super.handleStringComparison(firstType, secondType);
    }

    private Diagnostic validateEnumComparison(ValueType firstArg, ValueType secondArg) {
        assert (firstArg.isEnumType() || secondArg.isEnumType());
        if (!firstArg.isEnumType()) {
            return this.validateComparsionOfEnumAndNonEnum(firstArg, secondArg);
        }
        if (!secondArg.isEnumType()) {
            return this.validateComparsionOfEnumAndNonEnum(secondArg, firstArg);
        }
        if (TypeUtil.canNeverBeEqual((String)firstArg.getSignature(), (String)secondArg.getSignature())) {
            return this._diagnosticFactory.create_BINARY_COMPARISON_WITH_TWO_ENUMS_ALWAYS_SAME(this.getOperationName(), this.doRealOperation("foo", "notFoo"), TypeUtil.getFullyQualifiedName((String)firstArg.getSignature()), TypeUtil.getFullyQualifiedName((String)secondArg.getSignature()));
        }
        return Diagnostic.OK_INSTANCE;
    }

    private Diagnostic validateComparsionOfEnumAndNonEnum(ValueType nonEnumType, ValueType enumType) {
        if (nonEnumType instanceof LiteralType) {
            assert (nonEnumType instanceof StringLiteralType);
            Diagnostic result = this.validateIfEnumToStringComparison(((StringLiteralType)nonEnumType).getLiteralValue(), enumType);
            if (result != null) {
                return result;
            }
            return Diagnostic.OK_INSTANCE;
        }
        if (nonEnumType.isInstanceOf("Ljava.lang.String;")) {
            return Diagnostic.OK_INSTANCE;
        }
        return this._diagnosticFactory.create_BINARY_COMPARISON_WITH_ENUM_AND_UNCOERCABLE_NONCONST_ALWAYS_SAME(this.getOperationName(), this.doRealOperation("foo", "notFoo"), TypeUtil.getFullyQualifiedName((String)enumType.getSignature()), TypeUtil.getFullyQualifiedName((String)nonEnumType.getSignature()));
    }

    private Diagnostic validateIfEnumToStringComparison(String literalValue, ValueType validateIfEnum) {
        IObjectSymbolBasedValueType symbolValueType;
        IType type;
        if (validateIfEnum.isEnumType() && validateIfEnum instanceof IObjectSymbolBasedValueType && (type = (symbolValueType = (IObjectSymbolBasedValueType)validateIfEnum).getSymbol().getTypeDescriptor().resolveType(symbolValueType.getSymbol().getTypeDescriptor().getTypeSignature())) != null && !TypeUtil.isEnumMember((IType)type, (String)literalValue)) {
            return this._diagnosticFactory.create_BINARY_COMPARISON_WITH_ENUM_AND_CONST_ALWAYS_SAME(this.getOperationName(), this.doRealOperation(literalValue, String.valueOf(literalValue) + "_"), TypeUtil.getFullyQualifiedName((String)validateIfEnum.getSignature()), literalValue);
        }
        return null;
    }

    private ValueType handleIfEnumToNonMemberStringComparison(String literalValue, ValueType enumValueType) {
        return BooleanLiteralType.valueOf((boolean)this.doRealOperation(literalValue, String.valueOf(literalValue) + "_"));
    }
}

