/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTransfer;

public class PasteAction
extends SelectionProviderAction {
    private Clipboard clipboard;

    public PasteAction(Shell shell, ISelectionProvider sp, Clipboard clipboard) {
        super(sp, Messages.actionPaste);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.clipboard = clipboard;
    }

    public void selectionChanged(IStructuredSelection sel) {
        ServerTransfer serverTransfer = ServerTransfer.getInstance();
        IServer[] servers = (IServer[])this.clipboard.getContents((Transfer)serverTransfer);
        this.setEnabled(servers != null && servers.length > 0);
    }

    public void run() {
        ServerTransfer serverTransfer = ServerTransfer.getInstance();
        IServer[] servers = (IServer[])this.clipboard.getContents((Transfer)serverTransfer);
        if (servers == null) {
            return;
        }
        int size = servers.length;
        int i = 0;
        while (i < size) {
            try {
                IServerWorkingCopy wc = servers[i].createWorkingCopy();
                ((ServerWorkingCopy)wc).disassociate();
                wc.setName("Temp");
                ServerUtil.setServerDefaultName((IServerWorkingCopy)wc);
                wc.save(false, null);
            }
            catch (CoreException ce) {
                Trace.trace((byte)3, "Failure to copy server", ce);
            }
            ++i;
        }
    }
}

