/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views.structure;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.SelectionManagerFactory;
import org.eclipse.jpt.ui.internal.views.structure.JpaStructurePage;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class JpaStructureView
extends PageBookView {
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        JpaSelectionManager selectionManager = SelectionManagerFactory.getSelectionManager(this.getViewSite().getWorkbenchWindow());
        selectionManager.register((IWorkbenchPart)this);
        this.select(selectionManager.getCurrentSelection());
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(JptUiMessages.JpaStructureView_structureNotAvailable);
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        JpaStructureProvider structureProvider = this.structureProvider(part);
        if (structureProvider != null) {
            JpaStructurePage page = new JpaStructurePage(this, structureProvider);
            this.initPage((IPageBookViewPage)page);
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    private JpaStructureProvider structureProvider(IWorkbenchPart part) {
        JpaFile jpaFile = (JpaFile)part.getAdapter(JpaFile.class);
        if (jpaFile == null) {
            return null;
        }
        JpaPlatformUi platformUi = JptUiPlugin.getPlugin().jpaPlatformUi(jpaFile.getJpaProject().getJpaPlatform());
        return platformUi.buildStructureProvider(jpaFile);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        JpaStructurePage page = (JpaStructurePage)pageRecord.page;
        this.removeSelectionChangedListener(page);
        page.dispose();
        pageRecord.dispose();
    }

    public JpaSelection getJpaSelection() {
        if (this.getCurrentPage() != this.getDefaultPage()) {
            return ((JpaStructurePage)this.getCurrentPage()).getJpaSelection();
        }
        return JpaSelection.NULL_SELECTION;
    }

    public void select(JpaSelection newSelection) {
        if (this.getCurrentPage() != this.getDefaultPage()) {
            ((JpaStructurePage)this.getCurrentPage()).select(newSelection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionProvider().addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionProvider().removeSelectionChangedListener(listener);
    }
}

