/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.tests.performance.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public abstract class ServerPerformanceTestCase
extends PerformanceTestCase {
    protected void closeIntro() {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart introPart = introManager.getIntro();
        if (introPart != null) {
            introManager.closeIntro(introPart);
        }
    }

    protected IRuntimeWorkingCopy createRuntime(String runtimeTypeId, String runtimeTypeLocation) throws CoreException {
        if (runtimeTypeId == null) {
            throw new IllegalArgumentException();
        }
        IRuntimeWorkingCopy runtimeCopy = ServerCore.findRuntimeType((String)runtimeTypeId).createRuntime(runtimeTypeId, null);
        runtimeCopy.setLocation((IPath)new Path(runtimeTypeLocation));
        runtimeCopy.setReadOnly(false);
        runtimeCopy.save(false, null);
        return runtimeCopy;
    }

    protected IServer createServer(String serverTypeId) throws CoreException {
        if (serverTypeId == null) {
            throw new IllegalArgumentException();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IServerType serverType = ServerCore.findServerType((String)serverTypeId);
        IServerWorkingCopy serverCopy = serverType.createServer(serverTypeId, null, (IProgressMonitor)monitor);
        return serverCopy.saveAll(false, (IProgressMonitor)monitor);
    }

    protected IServer getFirstServer(String serverTypeId) {
        IServer[] servers = ServerCore.getServers();
        ServerPerformanceTestCase.assertTrue((servers.length > 0 ? 1 : 0) != 0);
        IServer server = servers[0];
        ServerPerformanceTestCase.assertNotNull((Object)server);
        ServerPerformanceTestCase.assertTrue((boolean)server.getServerType().getId().equals(serverTypeId));
        return server;
    }
}

