/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.errorcustomization;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidator;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ElementInformation;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ErrorCustomizationManager;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ErrorCustomizationManagerWrapper;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ErrorCustomizationRegistry;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.IErrorMessageCustomizer;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.SampleErrorMessageCustomizer;
import org.eclipse.wst.xml.validation.tests.internal.XMLValidatorTestsPlugin;

public class ErrorCustomizationManagerTest
extends TestCase {
    public void testStartElement() {
        String namespace1 = "http://namespace1";
        String localname1 = "localname";
        ErrorCustomizationManagerWrapper manager = new ErrorCustomizationManagerWrapper();
        ErrorCustomizationManagerTest.assertEquals((String)"1. The element information stack is not empty to start.", (int)0, (int)manager.getElementInformationStack().size());
        manager.startElement(namespace1, localname1);
        ElementInformation elemInfo = (ElementInformation)manager.getElementInformationStack().pop();
        ErrorCustomizationManagerTest.assertEquals((String)"1. The element information stack is not empty to after popping the top element.", (int)0, (int)manager.getElementInformationStack().size());
        ErrorCustomizationManagerTest.assertEquals((String)("1. The namespace specified on the element information is not http://namespace1 it is " + elemInfo.getNamespace()), (String)namespace1, (String)elemInfo.getNamespace());
        ErrorCustomizationManagerTest.assertEquals((String)("1. The local name specified on the element information is not localname it is " + elemInfo.getLocalname()), (String)localname1, (String)elemInfo.getLocalname());
        String localname2 = "localname2";
        ErrorCustomizationManagerWrapper manager2 = new ErrorCustomizationManagerWrapper();
        ErrorCustomizationManagerTest.assertEquals((String)"2. The element information stack is not empty to start.", (int)0, (int)manager2.getElementInformationStack().size());
        manager2.startElement(namespace1, localname1);
        manager2.startElement(namespace1, localname2);
        ErrorCustomizationManagerTest.assertEquals((String)"2. The element information stack does not contain 2 elements.", (int)2, (int)manager2.getElementInformationStack().size());
        ElementInformation elemInfo2 = (ElementInformation)manager2.getElementInformationStack().pop();
        ErrorCustomizationManagerTest.assertEquals((String)"2. The element information stack does not contain 1 element after popping the top element.", (int)1, (int)manager2.getElementInformationStack().size());
        ErrorCustomizationManagerTest.assertEquals((String)("2. The namespace specified on the element information child is not http://namespace1 it is " + elemInfo2.getNamespace()), (String)namespace1, (String)elemInfo2.getNamespace());
        ErrorCustomizationManagerTest.assertEquals((String)("2. The local name specified on the element information child is not localname2 it is " + elemInfo2.getLocalname()), (String)localname2, (String)elemInfo2.getLocalname());
        ElementInformation elemInfo3 = (ElementInformation)manager2.getElementInformationStack().pop();
        ErrorCustomizationManagerTest.assertEquals((String)"2. The element information stack does not contain 0 elements after popping the top element.", (int)0, (int)manager2.getElementInformationStack().size());
        ErrorCustomizationManagerTest.assertEquals((String)("2. The namespace specified on the element information is not http://namespace1 it is " + elemInfo3.getNamespace()), (String)namespace1, (String)elemInfo3.getNamespace());
        ErrorCustomizationManagerTest.assertEquals((String)("2. The local name specified on the element information is not localname it is " + elemInfo3.getLocalname()), (String)localname1, (String)elemInfo3.getLocalname());
        ErrorCustomizationManagerTest.assertEquals((String)("2. The element information does not contain 1 child element it contains " + elemInfo3.getChildren().size()), (int)1, (int)elemInfo3.getChildren().size());
        ElementInformation elemInfo4 = (ElementInformation)elemInfo3.getChildren().get(0);
        ErrorCustomizationManagerTest.assertEquals((String)("2. The namespace specified on the element information's child is not http://namespace1 it is " + elemInfo4.getNamespace()), (String)namespace1, (String)elemInfo4.getNamespace());
        ErrorCustomizationManagerTest.assertEquals((String)("2. The local name specified on the element information's child is not localname2 it is " + elemInfo4.getLocalname()), (String)localname2, (String)elemInfo4.getLocalname());
    }

    public void testEndElement() {
        String namespace1 = "http://namespace1";
        String localname1 = "localname";
        ErrorCustomizationManagerWrapper manager = new ErrorCustomizationManagerWrapper();
        manager.getElementInformationStack().push(new ElementInformation(namespace1, localname1));
        manager.endElement(namespace1, localname1);
        ErrorCustomizationManagerTest.assertEquals((String)"1. The stack still contains an element.", (int)0, (int)manager.getElementInformationStack().size());
        String namespace2 = "XMLValidationTestSampleNamespace";
        ErrorCustomizationRegistry.getInstance().addErrorMessageCustomizer(namespace2, (IErrorMessageCustomizer)new SampleErrorMessageCustomizer());
        ErrorCustomizationManagerWrapper manager2 = new ErrorCustomizationManagerWrapper();
        manager2.getElementInformationStack().push(new ElementInformation(namespace2, localname1));
        ErrorCustomizationManager.ErrorMessageInformation emi = new ErrorCustomizationManager.ErrorMessageInformation((ErrorCustomizationManager)manager2);
        emi.message = new ValidationMessage("SampleMessage", 1, 2, namespace2);
        manager2.setMessageForConsideration(emi);
        manager2.endElement(namespace2, localname1);
        ErrorCustomizationManagerTest.assertEquals((String)("2. The message was not customized to AAAA. The message is " + emi.message.getMessage()), (String)"AAAA", (String)emi.message.getMessage());
        String namespace3 = "XMLValidationTestSampleNamespace3";
        ErrorCustomizationManagerWrapper manager3 = new ErrorCustomizationManagerWrapper();
        manager3.getElementInformationStack().push(new ElementInformation(namespace3, localname1));
        ErrorCustomizationManager.ErrorMessageInformation emi2 = new ErrorCustomizationManager.ErrorMessageInformation((ErrorCustomizationManager)manager3);
        emi2.message = new ValidationMessage("SampleMessage", 1, 2, namespace3);
        manager3.setMessageForConsideration(emi2);
        manager3.endElement(namespace3, localname1);
        ErrorCustomizationManagerTest.assertEquals((String)("3. The message did not retain its value of SampleMessage. The message is " + emi2.message.getMessage()), (String)"SampleMessage", (String)emi2.message.getMessage());
    }

    public void testConsiderReportedError() {
        String namespace1 = "http://namespace1";
        ErrorCustomizationManagerWrapper manager = new ErrorCustomizationManagerWrapper();
        ValidationInfo valinfo = new ValidationInfo(namespace1);
        manager.considerReportedError(valinfo, "key", null);
        ErrorCustomizationManagerTest.assertNull((String)"1. The messageForConsideration is not null when no validation messages exist.", (Object)manager.getMessageForConsideration());
        ErrorCustomizationManagerWrapper manager2 = new ErrorCustomizationManagerWrapper();
        ValidationInfo valinfo2 = new ValidationInfo(namespace1);
        valinfo2.addError("message", 1, 1, namespace1);
        manager2.considerReportedError(valinfo2, "key", null);
        ErrorCustomizationManagerTest.assertNotNull((String)"2. The messageForConsideration is null when a validation message exists.", (Object)manager2.getMessageForConsideration());
    }

    public void testErrorReportedOnCorrectElement() {
        IErrorMessageCustomizer testCustomizer = new IErrorMessageCustomizer(){

            public String customizeMessage(ElementInformation elementInfo, String key, Object[] arguments) {
                if (elementInfo.getLocalname().equals("child1")) {
                    ErrorCustomizationManagerTest.fail((String)"An error was reported for the child1 element.");
                }
                return null;
            }
        };
        ErrorCustomizationRegistry registry = ErrorCustomizationRegistry.getInstance();
        registry.addErrorMessageCustomizer("http://www.example.org/simplenested", testCustomizer);
        try {
            String PLUGIN_ABSOLUTE_PATH = String.valueOf(XMLValidatorTestsPlugin.getPluginLocation().toString()) + "/";
            String uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/bugfixes/CustomErrorReportedOnCorrectElement/simplenested.xml";
            XMLValidator validator = new XMLValidator();
            validator.validate(uri, null, new XMLValidationConfiguration());
            validator.validate(uri, null, new XMLValidationConfiguration());
        }
        catch (IOException e) {
            ErrorCustomizationManagerTest.fail((String)("An exception occurred while running the test:" + e));
        }
    }
}

