/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operation.extensionui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.AbstractRegistryDescriptor;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageGroupHandler;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.IDMPageHandler;
import org.eclipse.wst.common.frameworks.internal.enablement.IdentifiableComparator;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.DMWizardPageGroupFactoryElement;

public class DMWizardPageGroupElement
extends AbstractRegistryDescriptor
implements Comparable {
    static final String ELEMENT_PAGE_GROUP = "wizardPageGroup";
    static final String ATT_PAGE_ID = "pageGroupID";
    static final String ATT_WIZARD_ID = "wizardID";
    static final String ATT_REQUIRES_DATA_OPERATION_ID = "requiresDataOperationId";
    static final String ATT_DATA_MODEL_IDS = "dataModelIds";
    static final String ATT_ALLOWS_EXTENDED_PAGES_AFTER = "allowsExtendedPagesAfter";
    static final String ATT_PAGE_INSERTION_ID = "pageGroupInsertionID";
    static final String ELEMENT_FACTORY = "factory";
    protected DMWizardPageGroupFactoryElement wizardPageFactoryElement;
    protected String pluginID;
    protected String wizardID;
    public String pageGroupID;
    protected String wizardFactoryElement;
    protected boolean allowsExtendedPagesAfter;
    protected String requiresDataOperationId;
    protected Set dataModelIDs;
    protected String pageInsertionID;
    private int loadOrder;
    private static int loadOrderCounter;
    private int type;

    public DMWizardPageGroupElement(IConfigurationElement element1) {
        super(element1);
        this.pluginID = element1.getDeclaringExtension().getNamespace();
        this.wizardID = element1.getAttribute(ATT_WIZARD_ID);
        this.pageGroupID = element1.getAttribute(ATT_PAGE_ID);
        this.requiresDataOperationId = element1.getAttribute(ATT_REQUIRES_DATA_OPERATION_ID);
        this.dataModelIDs = this.getDataModelIds(element1);
        this.readAllowsExtendedPageAfter(element1);
        this.pageInsertionID = element1.getAttribute(ATT_PAGE_INSERTION_ID);
        this.readFactory(element1);
        this.validateSettings();
        this.loadOrder = loadOrderCounter++;
    }

    private Set getDataModelIds(IConfigurationElement element) {
        HashSet<String> ids = new HashSet<String>();
        String idList = element.getAttribute(ATT_DATA_MODEL_IDS);
        if (idList != null) {
            String[] dataModelIDs = idList.split(" *");
            int index = 0;
            while (index < dataModelIDs.length) {
                ids.add(dataModelIDs[index]);
                ++index;
            }
        }
        return ids;
    }

    private void validateSettings() {
        if (this.wizardID == null || this.wizardPageFactoryElement == null) {
            Logger.getLogger().logError("Incomplete page extension specification.");
        }
    }

    private void readAllowsExtendedPageAfter(IConfigurationElement element1) {
        String allowsPageAfterValue = element1.getAttribute(ATT_ALLOWS_EXTENDED_PAGES_AFTER);
        this.allowsExtendedPagesAfter = allowsPageAfterValue == null ? false : Boolean.valueOf(allowsPageAfterValue);
    }

    private void readFactory(IConfigurationElement element1) {
        IConfigurationElement[] factories = element1.getChildren(ELEMENT_FACTORY);
        if (factories != null && factories.length > 0) {
            this.wizardPageFactoryElement = new DMWizardPageGroupFactoryElement(factories[0], this.pageGroupID);
        }
    }

    public IDMPageHandler createPageHandler(IDataModel dataModel) {
        if (this.wizardPageFactoryElement != null) {
            return this.wizardPageFactoryElement.createPageHandler(dataModel);
        }
        return null;
    }

    public DataModelWizardPage[] createPageGroup(IDataModel dataModel) {
        if (this.wizardPageFactoryElement != null) {
            return this.wizardPageFactoryElement.createPageGroup(dataModel);
        }
        return null;
    }

    public IDMPageGroupHandler createPageGroupHandler(IDataModel dataModel) {
        return this.wizardPageFactoryElement == null ? null : this.wizardPageFactoryElement.createPageGroupHandler(dataModel);
    }

    public int compareTo(Object o) {
        return IdentifiableComparator.getInstance().compare((Object)this, o);
    }

    public boolean allowsExtendedPagesAfter() {
        return this.allowsExtendedPagesAfter;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String getPageID() {
        return this.pageGroupID;
    }

    public String getPageInsertionID() {
        return this.pageInsertionID;
    }

    public int getType() {
        return this.type;
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public boolean isAllowsExtendedPagesAfter() {
        return this.allowsExtendedPagesAfter;
    }

    public void setAllowsExtendedPagesAfter(boolean allowsExtendedPagesAfter) {
        this.allowsExtendedPagesAfter = allowsExtendedPagesAfter;
    }

    public String getRequiresDataOperationId() {
        return this.requiresDataOperationId;
    }

    public void setRequiresDataOperationId(String dataOperationId) {
        this.requiresDataOperationId = dataOperationId;
    }

    public Set getDataModelIDs() {
        return this.dataModelIDs;
    }

    public void setDataModelID(Set newDataModelIDs) {
        this.dataModelIDs = newDataModelIDs;
    }

    public String getWizardFactoryElement() {
        return this.wizardFactoryElement;
    }

    public void setWizardFactoryElement(String wizardFactoryElement) {
        this.wizardFactoryElement = wizardFactoryElement;
    }

    public String getWizardID() {
        return this.wizardID;
    }

    public void setWizardID(String wizardID) {
        this.wizardID = wizardID;
    }

    public DMWizardPageGroupFactoryElement getWizardPageFactoryElement() {
        return this.wizardPageFactoryElement;
    }

    public void setWizardPageFactoryElement(DMWizardPageGroupFactoryElement wizardPageFactoryElement) {
        this.wizardPageFactoryElement = wizardPageFactoryElement;
    }

    public void setPageID(String pageID) {
        this.pageGroupID = pageID;
    }

    public String getID() {
        return this.getPageID();
    }
}

