/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.model;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.Preferences;

public abstract class FilterRule
implements IAdaptable {
    protected String _pattern;
    protected static final String PortableFileDelim = "/";

    public static FilterRule create(String name) {
        if ("fileext".equals(name)) {
            return new FileExt();
        }
        if ("projectNature".equals(name)) {
            return new ProjectNature();
        }
        if ("file".equals(name)) {
            return new File();
        }
        if ("contentType".equals(name)) {
            return new ContentType();
        }
        if ("facet".equals(name)) {
            return new Facet();
        }
        if ("pattern".equals(name)) {
            return new FilePattern();
        }
        return null;
    }

    public static FilterRule create(Deserializer des) {
        String type = des.getString();
        FilterRule fr = FilterRule.create(type);
        if (fr != null) {
            fr.load(des);
        }
        return fr;
    }

    public static FilterRule createFile(String pattern, boolean caseSensitive, int type) {
        File ext = new File();
        ext.setData(pattern);
        ext.setCaseSensitive(caseSensitive);
        ext.setType(type);
        return ext;
    }

    public static FilterRule createFileExt(String pattern, boolean caseSensitive) {
        FileExt ext = new FileExt();
        ext.setData(pattern);
        ext.setCaseSensitive(caseSensitive);
        return ext;
    }

    public static FilterRule createFacet(String facetId) {
        Facet facet = new Facet();
        facet.setData(facetId);
        return facet;
    }

    public static FilterRule createProject(String projectNature) {
        ProjectNature pn = new ProjectNature();
        pn.setData(projectNature);
        return pn;
    }

    public static FilterRule createContentType(String contentType, boolean exactMatch) {
        ContentType ct = new ContentType();
        ct.setData(contentType);
        ct.setExactMatch(exactMatch);
        return ct;
    }

    public abstract void setData(IConfigurationElement var1);

    public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
        return null;
    }

    public Boolean matchesProject(IProject project) {
        return null;
    }

    public void setData(String data) {
        this._pattern = data;
    }

    public String toString() {
        return String.valueOf(this.getDisplayableType()) + ": " + this._pattern;
    }

    public String getName() {
        return this.toString();
    }

    public String getPattern() {
        return this._pattern;
    }

    public abstract String getType();

    public abstract String getDisplayableType();

    public boolean asBoolean(String value, boolean aDefault) {
        if (value == null) {
            return aDefault;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return aDefault;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public abstract FilterRule copy();

    public void save(Preferences rid) {
        rid.put("type", this.getType());
        rid.put("pattern", this.getPattern());
    }

    public void load(Preferences rule) {
        this.setData(rule.get("pattern", null));
    }

    protected void load(Deserializer des) {
        this.setData(des.getString());
    }

    public void save(Serializer ser) {
        ser.put(this.getType());
        ser.put(this.getPattern());
    }

    public int hashCodeForConfig() {
        int h = this.getType().hashCode();
        if (this._pattern != null) {
            h += this._pattern.hashCode();
        }
        return h;
    }

    public static class ContentType
    extends FilterRule {
        private transient IContentType _type;
        private boolean _exactMatch = true;

        public FilterRule copy() {
            ContentType rule = new ContentType();
            rule._pattern = this._pattern;
            rule._type = this._type;
            rule._exactMatch = this._exactMatch;
            return rule;
        }

        public String getType() {
            return "contentType";
        }

        public int hashCodeForConfig() {
            int h = super.hashCodeForConfig();
            if (this._exactMatch) {
                h += 301;
            }
            return h;
        }

        public String getDisplayableType() {
            return ValMessages.RuleContentType;
        }

        public void load(Preferences rid) {
            this._exactMatch = rid.getBoolean("exactMatch", true);
            super.load(rid);
        }

        public void save(Preferences rid) {
            rid.putBoolean("exactMatch", this._exactMatch);
            super.save(rid);
        }

        protected void load(Deserializer des) {
            super.load(des);
            this._exactMatch = des.getBoolean();
        }

        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._exactMatch);
        }

        public void setData(IConfigurationElement rule) {
            this.setData(rule.getAttribute("id"));
            boolean exactMatch = true;
            String exact = rule.getAttribute("exactMatch");
            if ("false".equals(exact)) {
                exactMatch = false;
            }
            this.setExactMatch(exactMatch);
        }

        public void setData(String pattern) {
            this._pattern = pattern;
            this._type = Platform.getContentTypeManager().getContentType(pattern);
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            if (this._type == null) {
                return Boolean.FALSE;
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                IContentType ct = contentTypeWrapper.getContentType(file);
                if (ct == null) {
                    return Boolean.FALSE;
                }
                boolean match = false;
                match = this._exactMatch ? ct.getId().equals(this._type.getId()) : ct.isKindOf(this._type);
                if (match && Tracing.isTraceMatches()) {
                    Tracing.log("FilterRule-01: ", String.valueOf(this.toString()) + " has matched " + resource);
                }
                return match;
            }
            return Boolean.FALSE;
        }

        public void setExactMatch(boolean exactMatch) {
            this._exactMatch = exactMatch;
        }

        public String toString() {
            if (this._exactMatch) {
                return NLS.bind((String)ValMessages.ContentTypeExact, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.ContentTypeNotExact, (Object)this.getDisplayableType(), (Object)this._pattern);
        }
    }

    public static class Facet
    extends FilterRule {
        private String _versionExpression;

        public FilterRule copy() {
            Facet rule = new Facet();
            rule._pattern = this._pattern;
            rule._versionExpression = this._versionExpression;
            return rule;
        }

        public String getType() {
            return "facet";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFacet;
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("id");
            this._versionExpression = rule.getAttribute("version");
        }

        public Boolean matchesProject(IProject project) {
            try {
                if (this._versionExpression == null) {
                    return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this._pattern);
                }
                return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this._pattern, (String)this._versionExpression);
            }
            catch (CoreException e) {
                if (Tracing.isLogging()) {
                    ValidationPlugin.getPlugin().handleException(e);
                }
                return Boolean.FALSE;
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer(200);
            b.append(this.getDisplayableType());
            b.append(": ");
            b.append(this._pattern);
            if (this._versionExpression != null) {
                b.append(" (");
                b.append(this._versionExpression);
                b.append(")");
            }
            return b.toString();
        }
    }

    public static class File
    extends FilterRuleCaseSensitive {
        private String _patternAsLowercase;
        private int _type;
        public static final int FileTypeFile = 1;
        public static final int FileTypeFolder = 2;
        public static final int FileTypeFull = 3;

        public FilterRule copy() {
            File rule = new File();
            rule.copy(this);
            rule._patternAsLowercase = this._patternAsLowercase;
            rule._type = this._type;
            return rule;
        }

        public String getType() {
            return "file";
        }

        public String getDisplayableType() {
            if (this._type == 2) {
                return ValMessages.RuleFolder;
            }
            if (this._type == 3) {
                return ValMessages.RuleFull;
            }
            return ValMessages.RuleFile;
        }

        public void setData(String pattern) {
            this._patternAsLowercase = pattern != null ? pattern.toLowerCase() : null;
            this._pattern = pattern;
        }

        public void setData(IConfigurationElement rule) {
            super.setData(rule);
            this.setData(rule.getAttribute("name"));
            if (this._pattern == null) {
                throw new IllegalStateException(ValMessages.ErrPatternAttrib);
            }
            String type = rule.getAttribute("type");
            if (type == null) {
                throw new IllegalStateException(ValMessages.ErrTypeReq);
            }
            if ("file".equals(type)) {
                this._type = 1;
            } else if ("folder".equals(type)) {
                this._type = 2;
                if (!this._pattern.endsWith(FilterRule.PortableFileDelim)) {
                    this.setData(String.valueOf(this._pattern) + FilterRule.PortableFileDelim);
                }
            } else if ("full".equals(type)) {
                this._type = 3;
            } else {
                Object[] parms = new Object[]{type, "file", "folder", "full"};
                throw new IllegalStateException(NLS.bind((String)ValMessages.ErrType, (Object[])parms));
            }
        }

        public String toString() {
            if (this.isCaseSensitive()) {
                return NLS.bind((String)ValMessages.FileExtWithCase, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.FileExtWithoutCase, (Object)this.getDisplayableType(), (Object)this._pattern);
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            String name = null;
            switch (this._type) {
                case 1: {
                    name = resource.getName();
                    break;
                }
                case 2: {
                    name = String.valueOf(resource.getProjectRelativePath().removeLastSegments(1).toString()) + FilterRule.PortableFileDelim;
                    break;
                }
                case 3: {
                    name = resource.getProjectRelativePath().toPortableString();
                }
            }
            if (name == null) {
                return Boolean.FALSE;
            }
            if (this.isCaseSensitive()) {
                return name.startsWith(this._pattern);
            }
            return name.toLowerCase().startsWith(this._patternAsLowercase);
        }

        public void load(Preferences rid) {
            super.load(rid);
            this._type = rid.getInt("fileType", -1);
        }

        public void save(Preferences rid) {
            super.save(rid);
            rid.putInt("fileType", this._type);
        }

        protected void load(Deserializer des) {
            super.load(des);
            this._type = des.getInt();
        }

        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._type);
        }

        public void setType(int type) {
            this._type = type;
        }
    }

    public static class FileExt
    extends FilterRuleCaseSensitive {
        public FilterRule copy() {
            FileExt rule = new FileExt();
            rule.copy(this);
            return rule;
        }

        public String getType() {
            return "fileext";
        }

        public String getDisplayableType() {
            return ValMessages.RuleFileExt;
        }

        public String getName() {
            return this.toString();
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("ext");
            super.setData(rule);
        }

        public String toString() {
            if (this.isCaseSensitive()) {
                return NLS.bind((String)ValMessages.FileExtWithCase, (Object)this.getDisplayableType(), (Object)this._pattern);
            }
            return NLS.bind((String)ValMessages.FileExtWithoutCase, (Object)this.getDisplayableType(), (Object)this._pattern);
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper contentTypeWrapper) {
            String ext = resource.getFileExtension();
            if (this.isCaseSensitive()) {
                return this._pattern.equals(ext);
            }
            return this._pattern.equalsIgnoreCase(ext);
        }
    }

    public static class FilePattern
    extends FilterRuleCaseSensitive {
        private transient Pattern _compiledPattern;

        public FilterRule copy() {
            FilePattern fp = new FilePattern();
            fp.copy(this);
            fp._compiledPattern = Pattern.compile(this._compiledPattern.pattern(), this._compiledPattern.flags());
            return fp;
        }

        public String getDisplayableType() {
            return ValMessages.RuleFile;
        }

        public String getType() {
            return "pattern";
        }

        public Boolean matchesResource(IResource resource, ContentTypeWrapper wrapper) {
            String name = FilterRule.PortableFileDelim + resource.getProjectRelativePath().toPortableString();
            if (name == null) {
                return Boolean.FALSE;
            }
            return this._compiledPattern.matcher(name).matches();
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("regex");
            super.setData(rule);
            int flags = 0;
            if (this.isCaseSensitive()) {
                flags = 2;
            }
            this._compiledPattern = Pattern.compile(this._pattern, flags);
        }
    }

    public static abstract class FilterRuleCaseSensitive
    extends FilterRule {
        private boolean _caseSensitive;

        protected void copy(FilterRuleCaseSensitive rule) {
            this._pattern = rule.getPattern();
            this._caseSensitive = rule.isCaseSensitive();
        }

        public int hashCodeForConfig() {
            int h = super.hashCodeForConfig();
            if (this._caseSensitive) {
                h += 401;
            }
            return h;
        }

        protected void load(Deserializer des) {
            super.load(des);
            this._caseSensitive = des.getBoolean();
        }

        public void save(Serializer ser) {
            super.save(ser);
            ser.put(this._caseSensitive);
        }

        public void load(Preferences rid) {
            super.load(rid);
            this._caseSensitive = rid.getBoolean("case", false);
        }

        public void save(Preferences rid) {
            super.save(rid);
            rid.putBoolean("case", this._caseSensitive);
        }

        public void setData(IConfigurationElement rule) {
            this._caseSensitive = this.asBoolean(rule.getAttribute("caseSensitive"), false);
        }

        public boolean isCaseSensitive() {
            return this._caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this._caseSensitive = caseSensitive;
        }
    }

    public static class ProjectNature
    extends FilterRule {
        public FilterRule copy() {
            ProjectNature rule = new ProjectNature();
            rule._pattern = this._pattern;
            return rule;
        }

        public void setData(IConfigurationElement rule) {
            this._pattern = rule.getAttribute("id");
        }

        public String getDisplayableType() {
            return ValMessages.RuleProjectNature;
        }

        public String getType() {
            return "projectNature";
        }

        public Boolean matchesProject(IProject project) {
            try {
                return project.hasNature(this._pattern);
            }
            catch (CoreException coreException) {
                return Boolean.FALSE;
            }
        }
    }
}

