/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.ManyToManyAnnotation;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaManyToManyMappingTests
extends ContextModelTestCase {
    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createManyToManyAnnotation() throws Exception {
        this.createAnnotationAndMembers("ManyToMany", "");
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithManyToManyMapping() throws Exception {
        this.createEntityAnnotation();
        this.createManyToManyAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        this.createEntityAnnotation();
        this.createManyToManyAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithCollectionManyToManyMapping() throws Exception {
        this.createEntityAnnotation();
        this.createManyToManyAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonCollectionManyToManyMapping() throws Exception {
        this.createEntityAnnotation();
        this.createManyToManyAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Address addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("import java.util.Map;");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.ManyToMany").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Map<Integer, Employee> employees;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    public JavaManyToManyMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("basic");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Basic"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaManyToManyMappingTests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
        JavaManyToManyMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("version");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Version"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("id");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Id"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embedded");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Embedded"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("embeddedId");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.EmbeddedId"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("transient");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.Transient"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToOne");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToOne"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("oneToMany");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.OneToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        manyToManyMapping.setOrderBy("asdf");
        manyToManyMapping.getJoinTable().setSpecifiedName("FOO");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        persistentAttribute.setSpecifiedMappingKey("manyToOne");
        JavaManyToManyMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaManyToManyMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToMany"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getMappingAnnotation("javax.persistence.ManyToOne"));
        JavaManyToManyMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity("newTargetEntity");
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedTargetEntity());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
        manyToMany.setFetch(FetchType.EAGER);
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToMany.setFetch(FetchType.LAZY);
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)manyToMany.getFetch());
        manyToMany.setFetch(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
        manyToManyMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.EAGER);
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.EAGER, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)manyToMany.getFetch());
        manyToManyMapping.setSpecifiedFetch(org.eclipse.jpt.core.context.FetchType.LAZY);
        JavaManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.context.FetchType.LAZY, (Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)manyToMany.getFetch());
        manyToManyMapping.setSpecifiedFetch(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getSpecifiedFetch());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMappedBy());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("newMappedBy");
        JavaManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToManyMapping.getMappedBy());
        JavaManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMappedBy());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        ManyToManyAnnotation manyToMany = (ManyToManyAnnotation)attributeResource.getMappingAnnotation();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMappedBy());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToManyMapping.setMappedBy("newTargetEntity");
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToManyMapping.getMappedBy());
        JavaManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getMappedBy());
        manyToManyMapping.setMappedBy(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMappedBy());
        JavaManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.candidateMappedByAttributeNames();
        JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.candidateMappedByAttributeNames();
        JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.candidateMappedByAttributeNames();
        JavaManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        JavaManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
    }

    public void testDefaultTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
        this.addXmlClassRef("test.Address");
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaPersistentType addressPersistentType = addressClassRef.getJavaPersistentType();
        addressPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityCollectionType() throws Exception {
        this.createTestEntityWithCollectionManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getDefaultTargetEntity());
    }

    public void testDefaultTargetEntityNonCollectionType() throws Exception {
        this.createTestEntityWithNonCollectionManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getDefaultTargetEntity());
    }

    public void testTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        JavaManyToManyMappingTests.assertEquals((String)"foo", (String)manyToManyMapping.getTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaManyToManyMappingTests.assertEquals((String)"test.Address", (String)manyToManyMapping.getTargetEntity());
    }

    public void testResolvedTargetEntity() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getResolvedTargetEntity());
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.Address");
        ListIterator classRefs = this.persistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef addressClassRef = (ClassRef)classRefs.next();
        JavaTypeMapping addressTypeMapping = addressClassRef.getJavaPersistentType().getMapping();
        JavaManyToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToManyMapping.getResolvedTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getResolvedTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity("test.Address");
        JavaManyToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToManyMapping.getResolvedTargetEntity());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaManyToManyMappingTests.assertEquals((Object)addressTypeMapping, (Object)manyToManyMapping.getResolvedTargetEntity());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        attributeResource.addAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        attributeResource.removeAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        manyToManyMapping.setMapKey("myMapKey");
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        manyToManyMapping.setMapKey(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getMapKey());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testUpdateOrderBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToManyMapping.getOrderBy());
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)orderBy.getValue());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testModifyOrderBy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        manyToManyMapping.setOrderBy("newOrderBy");
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToManyMapping.getOrderBy());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)orderBy.getValue());
        manyToManyMapping.setOrderBy(null);
        JavaManyToManyMappingTests.assertNull((Object)manyToManyMapping.getOrderBy());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateNoOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.isNoOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isNoOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isNoOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.isNoOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testModifyNoOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.isNoOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdatePkOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isPkOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.isPkOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isPkOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isPkOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testUpdateCustomOrdering() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.javaPersistentType().attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.jpaProject().getJavaPersistentTypeResource("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.attributes().next();
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isCustomOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
        attributeResource.addAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isCustomOrdering());
        OrderByAnnotation orderBy = (OrderByAnnotation)attributeResource.getAnnotation("javax.persistence.OrderBy");
        orderBy.setValue("newOrderBy");
        JavaManyToManyMappingTests.assertTrue((boolean)manyToManyMapping.isCustomOrdering());
        attributeResource.removeAnnotation("javax.persistence.OrderBy");
        JavaManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isCustomOrdering());
        JavaManyToManyMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.OrderBy"));
    }

    public void testDefaultTargetEntityForMap() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.addXmlClassRef("test.Department");
        this.addXmlClassRef("test.Employee");
        JavaPersistentType departmentPersistentType = this.javaPersistentType();
        ManyToManyMapping employeesMapping = (ManyToManyMapping)departmentPersistentType.getAttributeNamed("employees").getSpecifiedMapping();
        JavaManyToManyMappingTests.assertEquals((String)"test.Employee", (String)employeesMapping.getTargetEntity());
    }
}

