/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.SequenceGenerator;
import org.eclipse.jpt.core.context.TableGenerator;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGeneratorImpl;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGeneratorImpl;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class EntityMappingsTests
extends ContextModelTestCase {
    public EntityMappingsTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    public void testGetVersion() throws Exception {
        EntityMappingsTests.assertEquals((String)"1.0", (String)this.entityMappings().getVersion());
    }

    public void testUpdateDescription() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getDescription());
        this.ormResource().getEntityMappings().setDescription("newDescription");
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.entityMappings().getDescription());
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.ormResource().getEntityMappings().getDescription());
        this.ormResource().getEntityMappings().setDescription(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getDescription());
    }

    public void testModifyDescription() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getDescription());
        this.entityMappings().setDescription("newDescription");
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.entityMappings().getDescription());
        EntityMappingsTests.assertEquals((String)"newDescription", (String)this.ormResource().getEntityMappings().getDescription());
        this.entityMappings().setDescription(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDescription());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getDescription());
    }

    public void testUpdatePackage() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getPackage());
        this.ormResource().getEntityMappings().setPackage("foo.model");
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.entityMappings().getPackage());
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.ormResource().getEntityMappings().getPackage());
        this.ormResource().getEntityMappings().setPackage(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getPackage());
    }

    public void testModifyPackage() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getPackage());
        this.entityMappings().setPackage("foo.model");
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.entityMappings().getPackage());
        EntityMappingsTests.assertEquals((String)"foo.model", (String)this.ormResource().getEntityMappings().getPackage());
        this.entityMappings().setPackage(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getPackage());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getPackage());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        this.ormResource().getEntityMappings().setSchema("MY_SCHEMA");
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getSchema());
        this.ormResource().getEntityMappings().setSchema(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
    }

    public void testModifySpecifiedSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        this.entityMappings().setSpecifiedSchema("MY_SCHEMA");
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getSchema());
        this.entityMappings().setSpecifiedSchema(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        this.ormResource().getEntityMappings().setCatalog("MY_CATALOG");
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getCatalog());
        this.ormResource().getEntityMappings().setCatalog(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
    }

    public void testUpdateDefaultSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        XmlPersistenceUnitDefaults persistenceUnitDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(persistenceUnitDefaults);
        persistenceUnitDefaults.setSchema("MY_SCHEMA");
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
        persistenceUnitDefaults.setSchema(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getSchema());
    }

    public void testUpdateSchema() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        this.ormResource().getEntityMappings().setSchema("MY_SCHEMA");
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.entityMappings().getSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertEquals((String)"MY_SCHEMA", (String)this.ormResource().getEntityMappings().getSchema());
        this.ormResource().getEntityMappings().setSchema(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("DEFAULT_SCHEMA");
        EntityMappingsTests.assertEquals((String)"DEFAULT_SCHEMA", (String)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertEquals((String)"DEFAULT_SCHEMA", (String)this.entityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSchema());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedSchema());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getSchema());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        this.entityMappings().setSpecifiedCatalog("MY_CATALOG");
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getCatalog());
        this.entityMappings().setSpecifiedCatalog(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
    }

    public void testUpdateDefaultCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        XmlPersistenceUnitDefaults persistenceUnitDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(persistenceUnitDefaults);
        persistenceUnitDefaults.setCatalog("MY_CATALOG");
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
        persistenceUnitDefaults.setCatalog(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().getCatalog());
    }

    public void testUpdateCatalog() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        this.ormResource().getEntityMappings().setCatalog("MY_CATALOG");
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.entityMappings().getCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertEquals((String)"MY_CATALOG", (String)this.ormResource().getEntityMappings().getCatalog());
        this.ormResource().getEntityMappings().setCatalog(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog("DEFAULT_CATALOG");
        EntityMappingsTests.assertEquals((String)"DEFAULT_CATALOG", (String)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertEquals((String)"DEFAULT_CATALOG", (String)this.entityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedCatalog(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getCatalog());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedCatalog());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getCatalog());
    }

    public void testUpdateSpecifiedAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        this.ormResource().getEntityMappings().setAccess(org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY);
        EntityMappingsTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)this.ormResource().getEntityMappings().getAccess());
        this.ormResource().getEntityMappings().setAccess(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
    }

    public void testModifySpecifiedAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        this.entityMappings().setSpecifiedAccess(AccessType.PROPERTY);
        EntityMappingsTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY, (Object)this.ormResource().getEntityMappings().getAccess());
        this.entityMappings().setSpecifiedAccess(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
    }

    public void testUpdateDefaultAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        this.ormResource().getEntityMappings().setPersistenceUnitMetadata(OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata());
        XmlPersistenceUnitDefaults persistenceUnitDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        this.ormResource().getEntityMappings().getPersistenceUnitMetadata().setPersistenceUnitDefaults(persistenceUnitDefaults);
        persistenceUnitDefaults.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.PROPERTY);
        EntityMappingsTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        persistenceUnitDefaults.setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        persistenceUnitDefaults.setAccess(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
    }

    public void testUpdateAccess() throws Exception {
        EntityMappingsTests.assertNull((Object)this.entityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        this.ormResource().getEntityMappings().setAccess(org.eclipse.jpt.core.resource.orm.AccessType.FIELD);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.entityMappings().getAccess());
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.AccessType.FIELD, (Object)this.ormResource().getEntityMappings().getAccess());
        this.ormResource().getEntityMappings().setAccess(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertEquals((Object)AccessType.FIELD, (Object)this.entityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
        this.entityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setAccess(null);
        EntityMappingsTests.assertNull((Object)this.entityMappings().getDefaultAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getAccess());
        EntityMappingsTests.assertNull((Object)this.entityMappings().getSpecifiedAccess());
        EntityMappingsTests.assertNull((Object)this.ormResource().getEntityMappings().getAccess());
    }

    public void testUpdateOrmPersistentTypes() throws Exception {
        EntityMappingsTests.assertFalse((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        XmlEmbeddable embeddable = OrmFactory.eINSTANCE.createXmlEmbeddable();
        this.ormResource().getEntityMappings().getEmbeddables().add((Object)embeddable);
        embeddable.setClassName("model.Foo");
        EntityMappingsTests.assertTrue((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getClass_());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((XmlEmbeddable)this.ormResource().getEntityMappings().getEmbeddables().get(0)).getClassName());
        XmlEntity entity = OrmFactory.eINSTANCE.createXmlEntity();
        this.ormResource().getEntityMappings().getEntities().add((Object)entity);
        entity.setClassName("model.Foo2");
        EntityMappingsTests.assertTrue((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getClass_());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getClassName());
        XmlMappedSuperclass mappedSuperclass = OrmFactory.eINSTANCE.createXmlMappedSuperclass();
        this.ormResource().getEntityMappings().getMappedSuperclasses().add((Object)mappedSuperclass);
        mappedSuperclass.setClassName("model.Foo3");
        EntityMappingsTests.assertTrue((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getClass_());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0)).getClassName());
    }

    public void testAddOrmPersistentType() throws Exception {
        EntityMappingsTests.assertFalse((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        this.entityMappings().addOrmPersistentType("embeddable", "model.Foo");
        EntityMappingsTests.assertTrue((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getClass_());
        EntityMappingsTests.assertEquals((String)"embeddable", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getKey());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo", (String)((XmlEmbeddable)this.ormResource().getEntityMappings().getEmbeddables().get(0)).getClassName());
        this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        EntityMappingsTests.assertTrue((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getClass_());
        EntityMappingsTests.assertEquals((String)"entity", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getKey());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo2", (String)((XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0)).getClassName());
        this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo3");
        EntityMappingsTests.assertTrue((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getClass_());
        EntityMappingsTests.assertEquals((String)"mappedSuperclass", (String)((OrmPersistentType)this.entityMappings().ormPersistentTypes().next()).getMapping().getKey());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        EntityMappingsTests.assertEquals((String)"model.Foo3", (String)((XmlMappedSuperclass)this.ormResource().getEntityMappings().getMappedSuperclasses().get(0)).getClassName());
    }

    public void testRemoveOrmPersistentType() throws Exception {
        EntityMappingsTests.assertFalse((boolean)this.entityMappings().ormPersistentTypes().hasNext());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        this.entityMappings().addOrmPersistentType("embeddable", "model.Foo");
        this.entityMappings().addOrmPersistentType("entity", "model.Foo2");
        this.entityMappings().addOrmPersistentType("mappedSuperclass", "model.Foo3");
        this.entityMappings().removeOrmPersistentType(1);
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        this.entityMappings().removeOrmPersistentType(1);
        EntityMappingsTests.assertFalse((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
        this.entityMappings().removeOrmPersistentType(0);
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getMappedSuperclasses().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEntities().isEmpty());
        EntityMappingsTests.assertTrue((boolean)this.ormResource().getEntityMappings().getEmbeddables().isEmpty());
    }

    public void testUpdateTableGenerators() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().tableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        XmlTableGeneratorImpl tableGeneratorResource = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        this.ormResource().getEntityMappings().getTableGenerators().add((Object)tableGeneratorResource);
        tableGeneratorResource.setName("FOO");
        TableGenerator tableGenerator = (TableGenerator)this.entityMappings().tableGenerators().next();
        EntityMappingsTests.assertEquals((String)"FOO", (String)tableGenerator.getName());
        EntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        XmlTableGeneratorImpl tableGeneratorResource2 = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        this.ormResource().getEntityMappings().getTableGenerators().add(0, (Object)tableGeneratorResource2);
        tableGeneratorResource2.setName("BAR");
        ListIterator tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        XmlTableGeneratorImpl tableGeneratorResource3 = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        this.ormResource().getEntityMappings().getTableGenerators().add(1, (Object)tableGeneratorResource3);
        tableGeneratorResource3.setName("BAZ");
        tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getTableGenerators().move(2, 0);
        tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getTableGenerators().remove(0);
        tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getTableGenerators().remove(1);
        tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getTableGenerators().clear();
        tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
    }

    public void testAddTableGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().tableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        this.entityMappings().addTableGenerator(0).setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        this.entityMappings().addTableGenerator(0).setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((int)2, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        ListIterator tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmTableGenerator)tableGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
    }

    public void testRemoveTableGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().tableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        OrmTableGenerator tableGenerator = this.entityMappings().addTableGenerator(0);
        tableGenerator.setName("FOO");
        OrmTableGenerator tableGenerator2 = this.entityMappings().addTableGenerator(1);
        tableGenerator2.setName("BAR");
        OrmTableGenerator tableGenerator3 = this.entityMappings().addTableGenerator(2);
        tableGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        this.entityMappings().removeTableGenerator(0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(1)).getName());
        ListIterator tableGenerators = this.entityMappings().tableGenerators();
        OrmTableGenerator xmlTableGenerator = (OrmTableGenerator)tableGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlTableGenerator.getName());
        EntityMappingsTests.assertEquals((Object)tableGenerator2, (Object)xmlTableGenerator);
        xmlTableGenerator = (OrmTableGenerator)tableGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)xmlTableGenerator.getName());
        EntityMappingsTests.assertEquals((Object)tableGenerator3, (Object)xmlTableGenerator);
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        this.entityMappings().removeTableGenerator(1);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        tableGenerators = this.entityMappings().tableGenerators();
        xmlTableGenerator = (OrmTableGenerator)tableGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlTableGenerator.getName());
        EntityMappingsTests.assertEquals((Object)tableGenerator2, (Object)xmlTableGenerator);
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
        this.entityMappings().removeTableGenerator(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        tableGenerators = this.entityMappings().tableGenerators();
        EntityMappingsTests.assertFalse((boolean)tableGenerators.hasNext());
    }

    public void testMoveTableGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().tableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        OrmTableGenerator tableGenerator = this.entityMappings().addTableGenerator(0);
        tableGenerator.setName("FOO");
        OrmTableGenerator tableGenerator2 = this.entityMappings().addTableGenerator(1);
        tableGenerator2.setName("BAR");
        OrmTableGenerator tableGenerator3 = this.entityMappings().addTableGenerator(2);
        tableGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        this.entityMappings().moveTableGenerator(2, 0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        this.entityMappings().moveTableGenerator(0, 2);
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlTableGenerator)this.ormResource().getEntityMappings().getTableGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
    }

    public void testTableGeneratorsSize() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().tableGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getTableGenerators().size());
        OrmTableGenerator tableGenerator = this.entityMappings().addTableGenerator(0);
        tableGenerator.setName("FOO");
        OrmTableGenerator tableGenerator2 = this.entityMappings().addTableGenerator(1);
        tableGenerator2.setName("BAR");
        OrmTableGenerator tableGenerator3 = this.entityMappings().addTableGenerator(2);
        tableGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.entityMappings().tableGeneratorsSize());
        this.ormResource().getEntityMappings().getTableGenerators().remove(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.entityMappings().tableGeneratorsSize());
    }

    public void testUpdateSequenceGenerators() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().sequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        XmlSequenceGeneratorImpl sequenceGeneratorResource = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        this.ormResource().getEntityMappings().getSequenceGenerators().add((Object)sequenceGeneratorResource);
        sequenceGeneratorResource.setName("FOO");
        SequenceGenerator sequenceGenerator = (SequenceGenerator)this.entityMappings().sequenceGenerators().next();
        EntityMappingsTests.assertEquals((String)"FOO", (String)sequenceGenerator.getName());
        EntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        XmlSequenceGeneratorImpl sequenceGeneratorResource2 = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        this.ormResource().getEntityMappings().getSequenceGenerators().add(0, (Object)sequenceGeneratorResource2);
        sequenceGeneratorResource2.setName("BAR");
        ListIterator sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        XmlSequenceGeneratorImpl sequenceGeneratorResource3 = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        this.ormResource().getEntityMappings().getSequenceGenerators().add(1, (Object)sequenceGeneratorResource3);
        sequenceGeneratorResource3.setName("BAZ");
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getSequenceGenerators().move(2, 0);
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        this.ormResource().getEntityMappings().getSequenceGenerators().remove(0);
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getSequenceGenerators().remove(1);
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
        this.ormResource().getEntityMappings().getSequenceGenerators().clear();
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allGenerators()));
    }

    public void testAddSequenceGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().sequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        this.entityMappings().addSequenceGenerator(0).setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        this.entityMappings().addSequenceGenerator(0).setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((int)2, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        ListIterator sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmSequenceGenerator)sequenceGenerators.next()).getName());
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
    }

    public void testRemoveSequenceGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().sequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGenerator sequenceGenerator2 = this.entityMappings().addSequenceGenerator(1);
        sequenceGenerator2.setName("BAR");
        OrmSequenceGenerator sequenceGenerator3 = this.entityMappings().addSequenceGenerator(2);
        sequenceGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        this.entityMappings().removeSequenceGenerator(0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(1)).getName());
        ListIterator sequenceGenerators = this.entityMappings().sequenceGenerators();
        SequenceGenerator xmlSequenceGenerator = (SequenceGenerator)sequenceGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlSequenceGenerator.getName());
        EntityMappingsTests.assertEquals((Object)sequenceGenerator2, (Object)xmlSequenceGenerator);
        xmlSequenceGenerator = (SequenceGenerator)sequenceGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)xmlSequenceGenerator.getName());
        EntityMappingsTests.assertEquals((Object)sequenceGenerator3, (Object)xmlSequenceGenerator);
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        this.entityMappings().removeSequenceGenerator(1);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        xmlSequenceGenerator = (SequenceGenerator)sequenceGenerators.next();
        EntityMappingsTests.assertEquals((String)"BAR", (String)xmlSequenceGenerator.getName());
        EntityMappingsTests.assertEquals((Object)sequenceGenerator2, (Object)xmlSequenceGenerator);
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
        this.entityMappings().removeSequenceGenerator(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        sequenceGenerators = this.entityMappings().sequenceGenerators();
        EntityMappingsTests.assertFalse((boolean)sequenceGenerators.hasNext());
    }

    public void testMoveSequenceGenerator() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().sequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGenerator sequenceGenerator2 = this.entityMappings().addSequenceGenerator(1);
        sequenceGenerator2.setName("BAR");
        OrmSequenceGenerator sequenceGenerator3 = this.entityMappings().addSequenceGenerator(2);
        sequenceGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        this.entityMappings().moveSequenceGenerator(2, 0);
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        this.entityMappings().moveSequenceGenerator(0, 2);
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlSequenceGenerator)this.ormResource().getEntityMappings().getSequenceGenerators().get(2)).getName());
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
    }

    public void testSequenceGeneratorsSize() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)this.entityMappings().sequenceGeneratorsSize());
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getSequenceGenerators().size());
        OrmSequenceGenerator sequenceGenerator = this.entityMappings().addSequenceGenerator(0);
        sequenceGenerator.setName("FOO");
        OrmSequenceGenerator sequenceGenerator2 = this.entityMappings().addSequenceGenerator(1);
        sequenceGenerator2.setName("BAR");
        OrmSequenceGenerator sequenceGenerator3 = this.entityMappings().addSequenceGenerator(2);
        sequenceGenerator3.setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.entityMappings().sequenceGeneratorsSize());
        this.ormResource().getEntityMappings().getSequenceGenerators().remove(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.entityMappings().sequenceGeneratorsSize());
    }

    public void testAddNamedQuery() throws Exception {
        OrmNamedQuery namedQuery = this.entityMappings().addNamedQuery(0);
        namedQuery.setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        OrmNamedQuery namedQuery2 = this.entityMappings().addNamedQuery(0);
        namedQuery2.setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(1)).getName());
        OrmNamedQuery namedQuery3 = this.entityMappings().addNamedQuery(1);
        namedQuery3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(2)).getName());
        ListIterator namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((Object)namedQuery2, namedQueries.next());
        EntityMappingsTests.assertEquals((Object)namedQuery3, namedQueries.next());
        EntityMappingsTests.assertEquals((Object)namedQuery, namedQueries.next());
        namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
    }

    public void testRemoveNamedQuery() throws Exception {
        this.entityMappings().addNamedQuery(0).setName("FOO");
        this.entityMappings().addNamedQuery(1).setName("BAR");
        this.entityMappings().addNamedQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getNamedQueries().size());
        this.entityMappings().removeNamedQuery(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.ormResource().getEntityMappings().getNamedQueries().size());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(1)).getName());
        this.entityMappings().removeNamedQuery(0);
        EntityMappingsTests.assertEquals((int)1, (int)this.ormResource().getEntityMappings().getNamedQueries().size());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        this.entityMappings().removeNamedQuery(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getNamedQueries().size());
    }

    public void testMoveNamedQuery() throws Exception {
        this.entityMappings().addNamedQuery(0).setName("FOO");
        this.entityMappings().addNamedQuery(1).setName("BAR");
        this.entityMappings().addNamedQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getNamedQueries().size());
        this.entityMappings().moveNamedQuery(2, 0);
        ListIterator namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(2)).getName());
        this.entityMappings().moveNamedQuery(0, 1);
        namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(2)).getName());
    }

    public void testUpdateNamedQueries() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        this.ormResource().getEntityMappings().getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        this.ormResource().getEntityMappings().getNamedQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        ((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(0)).setName("FOO");
        ((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(1)).setName("BAR");
        ((XmlNamedQuery)this.ormResource().getEntityMappings().getNamedQueries().get(2)).setName("BAZ");
        ListIterator namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedQueries().move(2, 0);
        namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        this.ormResource().getEntityMappings().getNamedQueries().move(0, 1);
        namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        this.ormResource().getEntityMappings().getNamedQueries().remove(1);
        namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedQueries().remove(1);
        namedQueries = this.entityMappings().namedQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedQuery)namedQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedQueries.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedQueries().remove(0);
        EntityMappingsTests.assertFalse((boolean)this.entityMappings().namedQueries().hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
    }

    public void testAddNamedNativeQuery() throws Exception {
        OrmNamedNativeQuery namedNativeQuery = this.entityMappings().addNamedNativeQuery(0);
        namedNativeQuery.setName("FOO");
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        OrmNamedNativeQuery namedNativeQuery2 = this.entityMappings().addNamedNativeQuery(0);
        namedNativeQuery2.setName("BAR");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(1)).getName());
        OrmNamedNativeQuery namedNativeQuery3 = this.entityMappings().addNamedNativeQuery(1);
        namedNativeQuery3.setName("BAZ");
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(2)).getName());
        ListIterator namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((Object)namedNativeQuery2, namedNativeQueries.next());
        EntityMappingsTests.assertEquals((Object)namedNativeQuery3, namedNativeQueries.next());
        EntityMappingsTests.assertEquals((Object)namedNativeQuery, namedNativeQueries.next());
        namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
    }

    public void testRemoveNamedNativeQuery() throws Exception {
        this.entityMappings().addNamedNativeQuery(0).setName("FOO");
        this.entityMappings().addNamedNativeQuery(1).setName("BAR");
        this.entityMappings().addNamedNativeQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getNamedNativeQueries().size());
        this.entityMappings().removeNamedNativeQuery(0);
        EntityMappingsTests.assertEquals((int)2, (int)this.ormResource().getEntityMappings().getNamedNativeQueries().size());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(1)).getName());
        this.entityMappings().removeNamedNativeQuery(0);
        EntityMappingsTests.assertEquals((int)1, (int)this.ormResource().getEntityMappings().getNamedNativeQueries().size());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        this.entityMappings().removeNamedNativeQuery(0);
        EntityMappingsTests.assertEquals((int)0, (int)this.ormResource().getEntityMappings().getNamedNativeQueries().size());
    }

    public void testMoveNamedNativeQuery() throws Exception {
        this.entityMappings().addNamedNativeQuery(0).setName("FOO");
        this.entityMappings().addNamedNativeQuery(1).setName("BAR");
        this.entityMappings().addNamedNativeQuery(2).setName("BAZ");
        EntityMappingsTests.assertEquals((int)3, (int)this.ormResource().getEntityMappings().getNamedNativeQueries().size());
        this.entityMappings().moveNamedNativeQuery(2, 0);
        ListIterator namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(2)).getName());
        this.entityMappings().moveNamedNativeQuery(0, 1);
        namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(1)).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(2)).getName());
    }

    public void testUpdateNamedNativeQueries() throws Exception {
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        this.ormResource().getEntityMappings().getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        this.ormResource().getEntityMappings().getNamedNativeQueries().add((Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        ((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(0)).setName("FOO");
        ((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(1)).setName("BAR");
        ((XmlNamedNativeQuery)this.ormResource().getEntityMappings().getNamedNativeQueries().get(2)).setName("BAZ");
        ListIterator namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        EntityMappingsTests.assertEquals((int)3, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedNativeQueries().move(2, 0);
        namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        this.ormResource().getEntityMappings().getNamedNativeQueries().move(0, 1);
        namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"BAR", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        this.ormResource().getEntityMappings().getNamedNativeQueries().remove(1);
        namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertEquals((String)"FOO", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        EntityMappingsTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedNativeQueries().remove(1);
        namedNativeQueries = this.entityMappings().namedNativeQueries();
        EntityMappingsTests.assertEquals((String)"BAZ", (String)((OrmNamedNativeQuery)namedNativeQueries.next()).getName());
        EntityMappingsTests.assertFalse((boolean)namedNativeQueries.hasNext());
        EntityMappingsTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
        this.ormResource().getEntityMappings().getNamedNativeQueries().remove(0);
        EntityMappingsTests.assertFalse((boolean)this.entityMappings().namedNativeQueries().hasNext());
        EntityMappingsTests.assertEquals((int)0, (int)CollectionTools.size((Iterator)this.entityMappings().getPersistenceUnit().allQueries()));
    }
}

