/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmPrimaryKeyJoinColumnTests
extends ContextModelTestCase {
    public OrmPrimaryKeyJoinColumnTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.xmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.persistenceResource().save(null);
    }

    private void createEntityAnnotation() throws Exception {
        this.createAnnotationAndMembers("Entity", "String name() default \"\";");
    }

    private void createIdAnnotation() throws Exception {
        this.createAnnotationAndMembers("Id", "");
    }

    private ICompilationUnit createTestEntity() throws Exception {
        this.createEntityAnnotation();
        this.createIdAnnotation();
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getName());
        primaryKeyJoinColumnResource.setName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getName());
        primaryKeyJoinColumnResource.setName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getName());
        primaryKeyJoinColumnResource.setName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getName());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmPrimaryKeyJoinColumnTests.assertFalse((boolean)ormEntity.specifiedPrimaryKeyJoinColumns().hasNext());
        OrmPrimaryKeyJoinColumnTests.assertTrue((boolean)entityResource.getPrimaryKeyJoinColumns().isEmpty());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getName());
        ormPrimaryKeyJoinColumn.setSpecifiedName("foo");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)primaryKeyJoinColumnResource.getName());
        ormPrimaryKeyJoinColumn.setSpecifiedName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getName());
    }

    public void testUpdateSpecifiedReferencedColumnName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getReferencedColumnName());
        primaryKeyJoinColumnResource.setReferencedColumnName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getReferencedColumnName());
        primaryKeyJoinColumnResource.setReferencedColumnName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getReferencedColumnName());
        primaryKeyJoinColumnResource.setReferencedColumnName("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getReferencedColumnName());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmPrimaryKeyJoinColumnTests.assertFalse((boolean)ormEntity.specifiedPrimaryKeyJoinColumns().hasNext());
        OrmPrimaryKeyJoinColumnTests.assertTrue((boolean)entityResource.getPrimaryKeyJoinColumns().isEmpty());
    }

    public void testModifySpecifiedReferencedColumnName() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getReferencedColumnName());
        ormPrimaryKeyJoinColumn.setSpecifiedReferencedColumnName("foo");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)primaryKeyJoinColumnResource.getReferencedColumnName());
        ormPrimaryKeyJoinColumn.setSpecifiedReferencedColumnName(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getSpecifiedReferencedColumnName());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getReferencedColumnName());
    }

    public void testUpdateSpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getColumnDefinition());
        primaryKeyJoinColumnResource.setColumnDefinition("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getColumnDefinition());
        primaryKeyJoinColumnResource.setColumnDefinition(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getColumnDefinition());
        primaryKeyJoinColumnResource.setColumnDefinition("FOO");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)primaryKeyJoinColumnResource.getColumnDefinition());
        entityResource.getPrimaryKeyJoinColumns().remove(0);
        OrmPrimaryKeyJoinColumnTests.assertFalse((boolean)ormEntity.specifiedPrimaryKeyJoinColumns().hasNext());
        OrmPrimaryKeyJoinColumnTests.assertTrue((boolean)entityResource.getPrimaryKeyJoinColumns().isEmpty());
    }

    public void testModifySpecifiedColumnDefinition() throws Exception {
        OrmPersistentType ormPersistentType = this.entityMappings().addOrmPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = ormEntity.addSpecifiedPrimaryKeyJoinColumn(0);
        XmlEntity entityResource = (XmlEntity)this.ormResource().getEntityMappings().getEntities().get(0);
        XmlPrimaryKeyJoinColumn primaryKeyJoinColumnResource = (XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)primaryKeyJoinColumnResource.getColumnDefinition());
        ormPrimaryKeyJoinColumn.setColumnDefinition("foo");
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)primaryKeyJoinColumnResource.getColumnDefinition());
        ormPrimaryKeyJoinColumn.setColumnDefinition(null);
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)ormPrimaryKeyJoinColumn.getColumnDefinition());
        OrmPrimaryKeyJoinColumnTests.assertNull((Object)((XmlPrimaryKeyJoinColumn)entityResource.getPrimaryKeyJoinColumns().get(0)).getColumnDefinition());
    }
}

