/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.internal.GenericJpaProject;
import org.eclipse.jpt.core.internal.SimpleJpaProjectConfig;
import org.eclipse.jpt.core.internal.resource.java.JavaResourceModelImpl;
import org.eclipse.jpt.core.internal.utility.jdt.NullAnnotationEditFormatter;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.StringTools;

public class JavaResourceModelTestCase
extends AnnotationTestCase {
    private JavaElementChangeListener javaElementChangeListener;
    protected JavaResourceModel javaResourceModel;

    public JavaResourceModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.javaElementChangeListener = null;
    }

    protected ICompilationUnit createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        return this.javaProject.createCompilationUnit("javax.persistence", String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    protected ICompilationUnit createEnumAndMembers(String enumName, String enumBody) throws Exception {
        return this.javaProject.createCompilationUnit("javax.persistence", String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    protected JpaProject buildJpaProject() throws CoreException {
        return new TestJpaProject(this.buildJpaProjectConfig(this.javaProject.getProject()));
    }

    private JpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setProject(project);
        config.setJpaPlatform(JptCorePlugin.getJpaPlatform((IProject)project));
        config.setConnectionProfileName(JptCorePlugin.getConnectionProfileName((IProject)project));
        config.setDiscoverAnnotatedClasses(JptCorePlugin.discoverAnnotatedClasses((IProject)project));
        return config;
    }

    protected JavaResourcePersistentType buildJavaTypeResource(ICompilationUnit cu) throws CoreException {
        this.javaResourceModel = this.buildJavaResourceModel(cu);
        this.javaResourceModel.resolveTypes();
        return this.javaResourceModel.getJpaCompilationUnit().getPersistentType();
    }

    protected JavaResourceModel buildJavaResourceModel(ICompilationUnit cu) throws CoreException {
        if (this.javaResourceModel != null) {
            throw new IllegalStateException();
        }
        IFile file = (IFile)cu.getResource();
        JpaProject jpaProject = this.buildJpaProject();
        return new JavaResourceModelImpl(file, jpaProject.getJpaPlatform().getAnnotationProvider(), CommandExecutorProvider.Default.instance(), NullAnnotationEditFormatter.instance());
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (JavaResourceModelTestCase.this.javaResourceModel != null) {
                JavaResourceModelTestCase.this.javaResourceModel.javaElementChanged(event);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected class TestJpaProject
    extends GenericJpaProject {
        protected TestJpaProject(JpaProject.Config config) throws CoreException {
            super(config);
            this.setUpdater(JpaProject.Updater.Null.instance());
        }

        protected IResourceProxyVisitor buildInitialResourceProxyVisitor() {
            return new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    return false;
                }
            };
        }

        protected JpaRootContextNode buildRootContextNode() {
            return null;
        }
    }
}

