/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinColumn
extends AbstractJavaBaseColumn<JoinColumnAnnotation>
implements JavaJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected JoinColumnAnnotation joinColumn;

    public GenericJavaJoinColumn(JavaJpaContextNode parent, JavaJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    protected JoinColumnAnnotation getColumnResource() {
        return this.joinColumn;
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.joinColumn.setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public JavaJoinColumn.Owner getOwner() {
        return (JavaJoinColumn.Owner)super.getOwner();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    public Table getDbReferencedColumnTable() {
        return this.getOwner().getDbReferencedColumnTable();
    }

    @Override
    public Column getDbReferencedColumn() {
        Table table = this.getDbReferencedColumnTable();
        return table == null ? null : table.columnNamed(this.getReferencedColumnName());
    }

    @Override
    public boolean tableIsAllowed() {
        return this.getOwner().tableIsAllowed();
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.getColumnResource().referencedColumnNameTouches(pos, astRoot);
    }

    private Iterator<String> candidateReferencedColumnNames() {
        Table table = this.getOwner().getDbReferencedColumnTable();
        return table != null ? table.columnNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateReferencedColumnNames(), filter);
    }

    private Iterator<String> quotedCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.quote(this.candidateReferencedColumnNames(filter));
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.quotedCandidateReferencedColumnNames(filter);
        }
        return null;
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getDbReferencedColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getColumnResource().getReferencedColumnNameTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public void initializeFromResource(JoinColumnAnnotation joinColumn) {
        this.joinColumn = joinColumn;
        super.initializeFromResource(joinColumn);
        this.specifiedReferencedColumnName = joinColumn.getReferencedColumnName();
        this.defaultReferencedColumnName = this.defaultReferencedColumnName();
    }

    @Override
    public void update(JoinColumnAnnotation joinColumn) {
        this.joinColumn = joinColumn;
        super.update(joinColumn);
        this.setSpecifiedReferencedColumnName_(joinColumn.getReferencedColumnName());
        this.setDefaultReferencedColumnName(this.defaultReferencedColumnName());
    }

    @Override
    protected String defaultName() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!this.getOwner().getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return MappingTools.buildJoinColumnDefaultName(this);
    }

    protected String defaultReferencedColumnName() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!this.getOwner().getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return MappingTools.buildJoinColumnDefaultReferencedColumnName(this);
    }

    @Override
    protected String defaultTable() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        if (!this.getOwner().getRelationshipMapping().isRelationshipOwner()) {
            return null;
        }
        return super.defaultTable();
    }
}

