/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.resource.orm.XmlId;
import org.eclipse.jpt.core.resource.orm.XmlIdImpl;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmIdMapping
extends AbstractOrmAttributeMapping<XmlId>
implements OrmIdMapping {
    protected final OrmColumn column = this.getJpaFactory().buildOrmColumn(this, this);
    protected OrmGeneratedValue generatedValue;
    protected TemporalType temporal;
    protected OrmTableGenerator tableGenerator;
    protected OrmSequenceGenerator sequenceGenerator;

    public GenericOrmIdMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public int getXmlSequence() {
        return 0;
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmIdMapping(this);
    }

    @Override
    public void initializeFromXmlColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromXmlColumnMapping(oldMapping);
        this.setTemporal(oldMapping.getTemporal());
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        ((XmlId)this.getAttributeMapping()).setTemporal(TemporalType.toOrmResourceModel(newTemporal));
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    protected void setTemporal_(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    @Override
    public OrmGeneratedValue addGeneratedValue() {
        if (this.getGeneratedValue() != null) {
            throw new IllegalStateException("gemeratedValue already exists");
        }
        this.generatedValue = this.getJpaFactory().buildOrmGeneratedValue(this);
        ((XmlId)this.getAttributeMapping()).setGeneratedValue(OrmFactory.eINSTANCE.createXmlGeneratedValueImpl());
        this.firePropertyChanged("generatedValueProperty", null, this.generatedValue);
        return this.generatedValue;
    }

    @Override
    public void removeGeneratedValue() {
        if (this.getGeneratedValue() == null) {
            throw new IllegalStateException("gemeratedValue does not exist, cannot be removed");
        }
        OrmGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = null;
        ((XmlId)this.getAttributeMapping()).setGeneratedValue(null);
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, null);
    }

    @Override
    public OrmGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    protected void setGeneratedValue(OrmGeneratedValue newGeneratedValue) {
        OrmGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        this.firePropertyChanged("generatedValueProperty", oldGeneratedValue, newGeneratedValue);
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildOrmSequenceGenerator(this);
        ((XmlId)this.getAttributeMapping()).setSequenceGenerator(OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl());
        this.firePropertyChanged("sequenceGeneratorProperty", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        ((XmlId)this.getAttributeMapping()).setSequenceGenerator(null);
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, null);
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(OrmSequenceGenerator newSequenceGenerator) {
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildOrmTableGenerator(this);
        ((XmlId)this.getAttributeMapping()).setTableGenerator(OrmFactory.eINSTANCE.createXmlTableGeneratorImpl());
        this.firePropertyChanged("tableGeneratorProperty", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        ((XmlId)this.getAttributeMapping()).setTableGenerator(null);
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, null);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(OrmTableGenerator newTableGenerator) {
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, newTableGenerator);
    }

    protected Iterator<OrmGenerator> generators() {
        return new CompositeIterator(new Iterator[]{this.getSequenceGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getSequenceGenerator()), this.getTableGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getTableGenerator())});
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public boolean isIdMapping() {
        return true;
    }

    @Override
    public XmlId addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlIdImpl id = OrmFactory.eINSTANCE.createXmlIdImpl();
        this.getPersistentAttribute().initialize(id);
        typeMapping.getAttributes().getIds().add((Object)id);
        return id;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getIds().remove(this.getAttributeMapping());
        if (typeMapping.getAttributes().isAllFeaturesUnset()) {
            typeMapping.setAttributes(null);
        }
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getTableName();
    }

    @Override
    public void initialize(XmlId id) {
        super.initialize(id);
        this.temporal = this.specifiedTemporal(id);
        this.column.initialize(id.getColumn());
        this.initializeSequenceGenerator(id);
        this.initializeTableGenerator(id);
        this.initializeGeneratedValue(id);
        this.updatePersistenceUnitGenerators();
    }

    protected TemporalType specifiedTemporal(XmlId id) {
        return TemporalType.fromOrmResourceModel(id.getTemporal());
    }

    protected void initializeSequenceGenerator(XmlId id) {
        if (id.getSequenceGenerator() != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(id.getSequenceGenerator());
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator xmlSequenceGenerator) {
        OrmSequenceGenerator sequenceGenerator = this.getJpaFactory().buildOrmSequenceGenerator(this);
        sequenceGenerator.initialize(xmlSequenceGenerator);
        return sequenceGenerator;
    }

    protected void initializeTableGenerator(XmlId id) {
        if (id.getTableGenerator() != null) {
            this.tableGenerator = this.buildTableGenerator(id.getTableGenerator());
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator tableGeneratorResource) {
        OrmTableGenerator tableGenerator = this.getJpaFactory().buildOrmTableGenerator(this);
        tableGenerator.initialize(tableGeneratorResource);
        return tableGenerator;
    }

    protected void initializeGeneratedValue(XmlId id) {
        if (id.getGeneratedValue() != null) {
            this.generatedValue = this.buildGeneratedValue(id.getGeneratedValue());
        }
    }

    protected OrmGeneratedValue buildGeneratedValue(XmlGeneratedValue xmlGeneratedValue) {
        OrmGeneratedValue ormGeneratedValue = this.getJpaFactory().buildOrmGeneratedValue(this);
        ormGeneratedValue.initialize(xmlGeneratedValue);
        return ormGeneratedValue;
    }

    @Override
    public void update(XmlId id) {
        super.update(id);
        this.setTemporal_(this.specifiedTemporal(id));
        this.column.update(id.getColumn());
        this.updateSequenceGenerator(id);
        this.updateTableGenerator(id);
        this.updateGeneratedValue(id);
        this.updatePersistenceUnitGenerators();
    }

    protected void updateSequenceGenerator(XmlId id) {
        if (id.getSequenceGenerator() == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(id.getSequenceGenerator()));
        } else {
            this.getSequenceGenerator().update(id.getSequenceGenerator());
        }
    }

    protected void updateTableGenerator(XmlId id) {
        if (id.getTableGenerator() == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(id.getTableGenerator()));
        } else {
            this.getTableGenerator().update(id.getTableGenerator());
        }
    }

    protected void updateGeneratedValue(XmlId id) {
        if (id.getGeneratedValue() == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else if (this.getGeneratedValue() == null) {
            this.setGeneratedValue(this.buildGeneratedValue(id.getGeneratedValue()));
            this.getGeneratedValue().initialize(id.getGeneratedValue());
        } else {
            this.getGeneratedValue().update(id.getGeneratedValue());
        }
    }

    protected void updatePersistenceUnitGenerators() {
        if (this.getTableGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getTableGenerator());
        }
        if (this.getSequenceGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getSequenceGenerator());
        }
    }

    @Override
    public XmlColumn getColumnResource() {
        return ((XmlId)this.getAttributeMapping()).getColumn();
    }

    @Override
    public void addColumnResource() {
        ((XmlId)this.getAttributeMapping()).setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeColumnResource() {
        ((XmlId)this.getAttributeMapping()).setColumn(null);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned()) {
            this.addColumnMessages(messages);
        }
        this.addGeneratedValueMessages(messages);
        this.addGeneratorMessages(messages);
    }

    protected void addColumnMessages(List<IMessage> messages) {
        OrmColumn column = this.getColumn();
        String table = column.getTable();
        boolean doContinue = this.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getPersistentAttribute().getName(), table, column.getName()}, column, column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getPersistentAttribute().getName(), column.getName()}, column, column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange()));
            }
        }
    }

    protected void addGeneratedValueMessages(List<IMessage> messages) {
        OrmGeneratedValue generatedValue = this.getGeneratedValue();
        if (generatedValue == null) {
            return;
        }
        String generatorName = generatedValue.getGenerator();
        if (generatorName == null) {
            return;
        }
        for (Generator nextMasterGenerator : CollectionTools.iterable(this.getPersistenceUnit().allGenerators())) {
            if (!generatorName.equals(nextMasterGenerator.getName())) continue;
            return;
        }
        messages.add(DefaultJpaValidationMessages.buildMessage(1, "ID_MAPPING_UNRESOLVED_GENERATOR_NAME", new String[]{generatorName}, this, generatedValue.getGeneratorTextRange()));
    }

    protected void addGeneratorMessages(List<IMessage> messages) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allGenerators());
        Iterator<OrmGenerator> stream = this.generators();
        while (stream.hasNext()) {
            OrmGenerator current = stream.next();
            if (current.isVirtual()) {
                return;
            }
            masterList.remove(current);
            for (Generator each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange()));
            }
            masterList.add(current);
        }
    }
}

