/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.core.context.java.DefaultJavaAttributeMappingProvider;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingProvider;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.java.JavaTypeMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaBasicMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEmbeddableProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEmbeddedIdMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEmbeddedMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaEntityProvider;
import org.eclipse.jpt.core.internal.context.java.JavaIdMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaManyToManyMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaManyToOneMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaMappedSuperclassProvider;
import org.eclipse.jpt.core.internal.context.java.JavaNullAttributeMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaNullTypeMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaOneToManyMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaOneToOneMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaTransientMappingProvider;
import org.eclipse.jpt.core.internal.context.java.JavaVersionMappingProvider;
import org.eclipse.jpt.core.internal.platform.GenericJpaAnnotationProvider;
import org.eclipse.jpt.core.internal.platform.GenericJpaFactory;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaPlatform
implements JpaPlatform {
    public static String ID = "generic";
    private String id;
    protected JpaFactory jpaFactory;
    protected JpaAnnotationProvider annotationProvider;
    protected Collection<JavaTypeMappingProvider> javaTypeMappingProviders;
    protected Collection<JavaAttributeMappingProvider> javaAttributeMappingProviders;
    protected List<DefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String theId) {
        this.id = theId;
    }

    @Override
    public JpaFactory getJpaFactory() {
        if (this.jpaFactory == null) {
            this.jpaFactory = this.buildJpaFactory();
        }
        return this.jpaFactory;
    }

    protected JpaFactory buildJpaFactory() {
        return new GenericJpaFactory();
    }

    @Override
    public JpaFile buildJpaFile(JpaProject jpaProject, IFile file) {
        if (this.getJpaFactory().hasRelevantContent(file)) {
            ResourceModel resourceModel = this.getJpaFactory().buildResourceModel(jpaProject, file);
            return this.getJpaFactory().buildJpaFile(jpaProject, file, resourceModel);
        }
        return null;
    }

    @Override
    public JpaAnnotationProvider getAnnotationProvider() {
        if (this.annotationProvider == null) {
            this.annotationProvider = this.buildAnnotationProvider();
        }
        return this.annotationProvider;
    }

    protected JpaAnnotationProvider buildAnnotationProvider() {
        return new GenericJpaAnnotationProvider();
    }

    @Override
    public JavaTypeMapping buildJavaTypeMappingFromMappingKey(String typeMappingKey, JavaPersistentType parent) {
        return this.javaTypeMappingProviderFromMappingKey(typeMappingKey).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaTypeMapping buildJavaTypeMappingFromAnnotation(String mappingAnnotationName, JavaPersistentType parent) {
        return this.javaTypeMappingProviderFromAnnotation(mappingAnnotationName).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaAttributeMapping buildJavaAttributeMappingFromMappingKey(String attributeMappingKey, JavaPersistentAttribute parent) {
        return this.javaAttributeMappingProviderFromMappingKey(attributeMappingKey).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaAttributeMapping buildJavaAttributeMappingFromAnnotation(String mappingAnnotationName, JavaPersistentAttribute parent) {
        return this.javaAttributeMappingProviderFromAnnotation(mappingAnnotationName).buildMapping(parent, this.getJpaFactory());
    }

    @Override
    public JavaAttributeMapping buildDefaultJavaAttributeMapping(JavaPersistentAttribute parent) {
        return this.defaultJavaAttributeMappingProvider(parent).buildMapping(parent, this.getJpaFactory());
    }

    protected Iterator<JavaTypeMappingProvider> javaTypeMappingProviders() {
        if (this.javaTypeMappingProviders == null) {
            this.javaTypeMappingProviders = new ArrayList<JavaTypeMappingProvider>();
            this.addJavaTypeMappingProvidersTo(this.javaTypeMappingProviders);
        }
        return new CloneIterator(this.javaTypeMappingProviders);
    }

    protected void addJavaTypeMappingProvidersTo(Collection<JavaTypeMappingProvider> providers) {
        providers.add(JavaEntityProvider.instance());
        providers.add(JavaMappedSuperclassProvider.instance());
        providers.add(JavaEmbeddableProvider.instance());
        providers.add(JavaNullTypeMappingProvider.instance());
    }

    protected JavaTypeMappingProvider javaTypeMappingProviderFromMappingKey(String typeMappingKey) {
        Iterator<JavaTypeMappingProvider> i = this.javaTypeMappingProviders();
        while (i.hasNext()) {
            JavaTypeMappingProvider provider = i.next();
            if (provider.getKey() != typeMappingKey) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + typeMappingKey);
    }

    protected JavaTypeMappingProvider javaTypeMappingProviderFromAnnotation(String annotationName) {
        Iterator<JavaTypeMappingProvider> i = this.javaTypeMappingProviders();
        while (i.hasNext()) {
            JavaTypeMappingProvider provider = i.next();
            if (provider.getAnnotationName() != annotationName) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal annotation name: " + annotationName);
    }

    protected Iterator<JavaAttributeMappingProvider> javaAttributeMappingProviders() {
        if (this.javaAttributeMappingProviders == null) {
            this.javaAttributeMappingProviders = new ArrayList<JavaAttributeMappingProvider>();
            this.addJavaAttributeMappingProvidersTo(this.javaAttributeMappingProviders);
        }
        return new CloneIterator(this.javaAttributeMappingProviders);
    }

    protected void addJavaAttributeMappingProvidersTo(Collection<JavaAttributeMappingProvider> providers) {
        providers.add(JavaBasicMappingProvider.instance());
        providers.add(JavaEmbeddedMappingProvider.instance());
        providers.add(JavaEmbeddedIdMappingProvider.instance());
        providers.add(JavaIdMappingProvider.instance());
        providers.add(JavaManyToManyMappingProvider.instance());
        providers.add(JavaManyToOneMappingProvider.instance());
        providers.add(JavaOneToManyMappingProvider.instance());
        providers.add(JavaOneToOneMappingProvider.instance());
        providers.add(JavaTransientMappingProvider.instance());
        providers.add(JavaVersionMappingProvider.instance());
    }

    protected JavaAttributeMappingProvider javaAttributeMappingProviderFromMappingKey(String attributeMappingKey) {
        Iterator<JavaAttributeMappingProvider> i = this.javaAttributeMappingProviders();
        while (i.hasNext()) {
            JavaAttributeMappingProvider provider = i.next();
            if (provider.getKey() != attributeMappingKey) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal attribute mapping key: " + attributeMappingKey);
    }

    protected JavaAttributeMappingProvider javaAttributeMappingProviderFromAnnotation(String annotationName) {
        Iterator<JavaAttributeMappingProvider> i = this.javaAttributeMappingProviders();
        while (i.hasNext()) {
            JavaAttributeMappingProvider provider = i.next();
            if (provider.getAnnotationName() != annotationName) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal annotation name: " + annotationName);
    }

    protected ListIterator<DefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders() {
        if (this.defaultJavaAttributeMappingProviders == null) {
            this.defaultJavaAttributeMappingProviders = new ArrayList<DefaultJavaAttributeMappingProvider>();
            this.addDefaultJavaAttributeMappingProvidersTo(this.defaultJavaAttributeMappingProviders);
        }
        return new CloneListIterator(this.defaultJavaAttributeMappingProviders);
    }

    protected void addDefaultJavaAttributeMappingProvidersTo(List<DefaultJavaAttributeMappingProvider> providers) {
        providers.add(JavaEmbeddedMappingProvider.instance());
        providers.add(JavaBasicMappingProvider.instance());
    }

    protected JavaAttributeMappingProvider defaultJavaAttributeMappingProvider(JavaPersistentAttribute persistentAttribute) {
        ListIterator<DefaultJavaAttributeMappingProvider> i = this.defaultJavaAttributeMappingProviders();
        while (i.hasNext()) {
            DefaultJavaAttributeMappingProvider provider = (DefaultJavaAttributeMappingProvider)i.next();
            if (!provider.defaultApplies(persistentAttribute)) continue;
            return provider;
        }
        return this.nullAttributeMappingProvider();
    }

    @Override
    public String defaultJavaAttributeMappingKey(JavaPersistentAttribute persistentAttribute) {
        return this.defaultJavaAttributeMappingProvider(persistentAttribute).getKey();
    }

    protected JavaAttributeMappingProvider nullAttributeMappingProvider() {
        return JavaNullAttributeMappingProvider.instance();
    }

    @Override
    public void addToMessages(JpaProject project, List<IMessage> messages) {
        project.addToMessages(messages);
    }
}

