/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.AbstractJavaResourceNode;
import org.eclipse.jpt.core.internal.resource.java.AbstractResourceAnnotation;
import org.eclipse.jpt.core.internal.resource.java.ContainerAnnotationTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHint;
import org.eclipse.jpt.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedQuery
extends AbstractResourceAnnotation<Type>
implements QueryAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> queryAdapter;
    private String name;
    private String query;
    private final List<NestableQueryHint> hints;
    private final HintsContainerAnnotation hintsContainerAnnotation;

    protected AbstractNamedQuery(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.nameAdapter(daa);
        this.queryDeclarationAdapter = this.queryAdapter(daa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.queryAdapter = this.buildAdapter(this.queryDeclarationAdapter);
        this.hints = new ArrayList<NestableQueryHint>();
        this.hintsContainerAnnotation = new HintsContainerAnnotation();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.name(astRoot);
        this.query = this.query(astRoot);
        ContainerAnnotationTools.initializeNestedAnnotations(astRoot, this.hintsContainerAnnotation);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>((Member)this.getMember(), daea);
    }

    protected DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, this.nameElementName());
    }

    protected DeclarationAnnotationElementAdapter<String> queryAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, this.queryElementName());
    }

    protected abstract String nameElementName();

    protected abstract String queryElementName();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        if (this.attributeValueHasNotChanged(this.name, newName)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.nameAdapter.setValue(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        if (this.attributeValueHasNotChanged(this.query, newQuery)) {
            return;
        }
        String oldQuery = this.query;
        this.query = newQuery;
        this.queryAdapter.setValue(newQuery);
        this.firePropertyChanged("queryProperty", oldQuery, newQuery);
    }

    @Override
    public ListIterator<QueryHintAnnotation> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public NestableQueryHint hintAt(int index) {
        return this.hints.get(index);
    }

    @Override
    public int indexOfHint(QueryHintAnnotation queryHint) {
        return this.hints.indexOf(queryHint);
    }

    @Override
    public NestableQueryHint addHint(int index) {
        NestableQueryHint queryHint = (NestableQueryHint)ContainerAnnotationTools.addNestedAnnotation(index, this.hintsContainerAnnotation);
        this.fireItemAdded("hintsList", index, queryHint);
        return queryHint;
    }

    private void addHint(int index, NestableQueryHint queryHint) {
        this.addItemToList(index, queryHint, this.hints, "hintsList");
    }

    @Override
    public void removeHint(int index) {
        NestableQueryHint queryHint = this.hintAt(index);
        this.removeHint(queryHint);
        queryHint.removeAnnotation();
        ContainerAnnotationTools.synchAnnotationsAfterRemove(index, this.hintsContainerAnnotation);
    }

    private void removeHint(NestableQueryHint queryHint) {
        this.removeItemFromList(queryHint, this.hints, "hintsList");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.moveHintInternal(targetIndex, sourceIndex);
        ContainerAnnotationTools.synchAnnotationsAfterMove(targetIndex, sourceIndex, this.hintsContainerAnnotation);
        this.fireItemMoved("hintsList", targetIndex, sourceIndex);
    }

    protected void moveHintInternal(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.hints, (int)targetIndex, (int)sourceIndex);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.queryDeclarationAdapter, astRoot);
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.name(astRoot));
        this.setQuery(this.query(astRoot));
        this.updateQueryHintsFromJava(astRoot);
    }

    protected String name(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    protected String query(CompilationUnit astRoot) {
        return this.queryAdapter.getValue(astRoot);
    }

    private void updateQueryHintsFromJava(CompilationUnit astRoot) {
        ContainerAnnotationTools.updateNestedAnnotationsFromJava(astRoot, this.hintsContainerAnnotation);
    }

    protected abstract NestableQueryHint createQueryHint(int var1);

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)super.getAnnotationAdapter();
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        AbstractNamedQuery oldNamedQuery = (AbstractNamedQuery)((Object)oldAnnotation);
        this.setName(oldNamedQuery.getName());
        this.setQuery(oldNamedQuery.getQuery());
        for (QueryHintAnnotation queryHint : CollectionTools.iterable(oldNamedQuery.hints())) {
            NestableQueryHint newQueryHint = this.addHint(oldNamedQuery.indexOfHint(queryHint));
            newQueryHint.initializeFrom((NestableQueryHint)queryHint);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HintsContainerAnnotation
    extends AbstractJavaResourceNode
    implements ContainerAnnotation<NestableQueryHint> {
        public HintsContainerAnnotation() {
            super(AbstractNamedQuery.this);
        }

        @Override
        public void initialize(CompilationUnit astRoot) {
        }

        @Override
        public NestableQueryHint add(int index) {
            NestableQueryHint queryHint = AbstractNamedQuery.this.createQueryHint(index);
            AbstractNamedQuery.this.addHint(index, queryHint);
            return queryHint;
        }

        @Override
        public NestableQueryHint addInternal(int index) {
            NestableQueryHint queryHint = AbstractNamedQuery.this.createQueryHint(index);
            AbstractNamedQuery.this.hints.add(index, queryHint);
            return queryHint;
        }

        @Override
        public String getAnnotationName() {
            return AbstractNamedQuery.this.getAnnotationName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.QueryHint";
        }

        @Override
        public int indexOf(NestableQueryHint hint) {
            return AbstractNamedQuery.this.indexOfHint(hint);
        }

        @Override
        public void move(int targetIndex, int sourceIndex) {
            AbstractNamedQuery.this.moveHint(targetIndex, sourceIndex);
        }

        @Override
        public void moveInternal(int targetIndex, int sourceIndex) {
            AbstractNamedQuery.this.moveHintInternal(targetIndex, sourceIndex);
        }

        @Override
        public NestableQueryHint nestedAnnotationAt(int index) {
            return AbstractNamedQuery.this.hintAt(index);
        }

        @Override
        public NestableQueryHint nestedAnnotationFor(Annotation jdtAnnotation) {
            for (NestableQueryHint uniqueConstraint : CollectionTools.iterable(this.nestedAnnotations())) {
                if (jdtAnnotation != uniqueConstraint.getJdtAnnotation((CompilationUnit)jdtAnnotation.getRoot())) continue;
                return uniqueConstraint;
            }
            return null;
        }

        @Override
        public ListIterator<NestableQueryHint> nestedAnnotations() {
            return new CloneListIterator(AbstractNamedQuery.this.hints);
        }

        @Override
        public int nestedAnnotationsSize() {
            return AbstractNamedQuery.this.hintsSize();
        }

        @Override
        public void remove(NestableQueryHint queryHint) {
            AbstractNamedQuery.this.removeHint(queryHint);
        }

        @Override
        public void remove(int index) {
            AbstractNamedQuery.this.removeHint(this.nestedAnnotationAt(index));
        }

        @Override
        public Annotation getJdtAnnotation(CompilationUnit astRoot) {
            return AbstractNamedQuery.this.getJdtAnnotation(astRoot);
        }

        @Override
        public void newAnnotation() {
            AbstractNamedQuery.this.newAnnotation();
        }

        @Override
        public void removeAnnotation() {
            AbstractNamedQuery.this.removeAnnotation();
        }

        @Override
        public void updateFromJava(CompilationUnit astRoot) {
            AbstractNamedQuery.this.updateFromJava(astRoot);
        }

        @Override
        public TextRange getTextRange(CompilationUnit astRoot) {
            return AbstractNamedQuery.this.getTextRange(astRoot);
        }

        @Override
        public String getElementName() {
            return "hints";
        }
    }
}

