/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.tests.internal.options;

import org.eclipse.jpt.core.internal.context.persistence.GenericProperty;
import org.eclipse.jpt.eclipselink.core.internal.context.EclipseLinkJpaProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.PersistenceUnitPropertyListListener;
import org.eclipse.jpt.eclipselink.core.internal.context.options.EclipseLinkOptions;
import org.eclipse.jpt.eclipselink.core.internal.context.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.options.TargetDatabase;
import org.eclipse.jpt.eclipselink.core.tests.internal.PersistenceUnitTestCase;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

public class OptionsAdapterTests
extends PersistenceUnitTestCase {
    private Options options;
    private static final String SESSION_NAME_KEY = "eclipselink.session-name";
    private static final String SESSION_NAME_TEST_VALUE = "session-name.test";
    private static final String SESSION_NAME_TEST_VALUE_2 = "session-name-2.test";
    private static final String SESSIONS_XML_KEY = "eclipselink.sessions-xml";
    private static final String SESSIONS_XML_TEST_VALUE = "sessions-xml.test";
    private static final String SESSIONS_XML_TEST_VALUE_2 = "sessions-xml-2.test";
    public static final String TARGET_DATABASE_KEY = "eclipselink.target-database";
    public static final TargetDatabase TARGET_DATABASE_TEST_VALUE = TargetDatabase.cloudscape;
    public static final TargetDatabase TARGET_DATABASE_TEST_VALUE_2 = TargetDatabase.oracle;
    public static final String INCLUDE_DESCRIPTOR_QUERIES_KEY = "eclipselink.session.include.descriptor.queries";
    public static final Boolean INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE = false;
    public static final Boolean INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE_2 = INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE == false;
    public static final String SESSION_EVENT_LISTENER_KEY = "eclipselink.session-event-listener";
    public static final String SESSION_EVENT_LISTENER_TEST_VALUE = "acme.CustomSessionEventListener";
    public static final String SESSION_EVENT_LISTENER_TEST_VALUE_2 = "oracle.sessions.CustomSessionEventListener";

    public OptionsAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.options = this.persistenceUnitProperties.getOptions();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.options.addPropertyChangeListener("sessionNameProperty", propertyChangeListener);
        this.options.addPropertyChangeListener("sessionsXmlProperty", propertyChangeListener);
        this.options.addPropertyChangeListener("targetDatabaseProperty", propertyChangeListener);
        this.options.addPropertyChangeListener("eventListenerProperty", propertyChangeListener);
        this.options.addPropertyChangeListener("includeDescriptorQueriesProperty", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 5;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitPut(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE);
        this.persistenceUnitPut(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE);
        this.persistenceUnitPut("misc.property.1", "value.1");
        this.persistenceUnitPut(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE.toString());
        this.persistenceUnitPut("misc.property.2", "value.2");
        this.persistenceUnitPut("misc.property.3", "value.3");
        this.persistenceUnitPut(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE);
        this.persistenceUnitPut(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE);
        this.persistenceUnitPut("misc.property.4", "value.4");
    }

    public void testHasListeners() throws Exception {
        ListAspectAdapter propertiesAdapter = (ListAspectAdapter)((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertiesAdapter();
        GenericProperty ctdProperty = (GenericProperty)this.persistenceUnit().getProperty(INCLUDE_DESCRIPTOR_QUERIES_KEY);
        ListValueModel propertyListAdapter = ((EclipseLinkJpaProperties)this.persistenceUnitProperties).propertyListAdapter();
        OptionsAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        OptionsAdapterTests.assertTrue((boolean)ctdProperty.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "sessionNameProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "sessionsXmlProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "includeDescriptorQueriesProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "targetDatabaseProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "eventListenerProperty");
        this.verifyHasListeners(propertyListAdapter);
        EclipseLinkOptions elOptions = (EclipseLinkOptions)this.options;
        PersistenceUnitPropertyListListener propertyListListener = elOptions.propertyListListener();
        propertyListAdapter.removeListChangeListener("list values", (ListChangeListener)propertyListListener);
        OptionsAdapterTests.assertTrue((boolean)propertiesAdapter.hasAnyListChangeListeners("list values"));
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "sessionNameProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "sessionsXmlProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "includeDescriptorQueriesProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "targetDatabaseProperty");
        this.verifyHasListeners((PersistenceUnitProperties)this.options, "eventListenerProperty");
    }

    public void testSetSessionName() throws Exception {
        this.verifyModelInitialized(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE);
        this.verifySetProperty(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE, SESSION_NAME_TEST_VALUE_2);
    }

    public void testAddRemoveSessionName() throws Exception {
        this.verifyAddRemoveProperty(SESSION_NAME_KEY, SESSION_NAME_TEST_VALUE, SESSION_NAME_TEST_VALUE_2);
    }

    public void testSetSessionsXml() throws Exception {
        this.verifyModelInitialized(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE);
        this.verifySetProperty(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE, SESSIONS_XML_TEST_VALUE_2);
    }

    public void testAddRemoveSessionsXml() throws Exception {
        this.verifyAddRemoveProperty(SESSIONS_XML_KEY, SESSIONS_XML_TEST_VALUE, SESSIONS_XML_TEST_VALUE_2);
    }

    public void testSetIncludeDescriptorQueries() throws Exception {
        this.verifyModelInitialized(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE);
        this.verifySetProperty(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE_2);
    }

    public void testAddRemoveIncludeDescriptorQueries() throws Exception {
        this.verifyAddRemoveProperty(INCLUDE_DESCRIPTOR_QUERIES_KEY, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE, INCLUDE_DESCRIPTOR_QUERIES_TEST_VALUE_2);
    }

    public void testSetTargetDatabase() throws Exception {
        this.verifyModelInitialized(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE);
        this.verifySetProperty(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE, TARGET_DATABASE_TEST_VALUE_2);
    }

    public void testAddRemoveTargetDatabase() throws Exception {
        this.verifyAddRemoveProperty(TARGET_DATABASE_KEY, TARGET_DATABASE_TEST_VALUE, TARGET_DATABASE_TEST_VALUE_2);
    }

    public void testSetEventListener() throws Exception {
        this.verifyModelInitialized(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE);
        this.verifySetProperty(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE, SESSION_EVENT_LISTENER_TEST_VALUE_2);
    }

    public void testAddRemoveEventListener() throws Exception {
        this.verifyAddRemoveProperty(SESSION_EVENT_LISTENER_KEY, SESSION_EVENT_LISTENER_TEST_VALUE, SESSION_EVENT_LISTENER_TEST_VALUE_2);
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("sessionNameProperty")) {
            this.options.setSessionName((String)newValue);
        } else if (propertyName.equals("sessionsXmlProperty")) {
            this.options.setSessionsXml((String)newValue);
        } else if (propertyName.equals("includeDescriptorQueriesProperty")) {
            this.options.setIncludeDescriptorQueries((Boolean)newValue);
        } else if (propertyName.equals("targetDatabaseProperty")) {
            this.options.setTargetDatabase((TargetDatabase)newValue);
        } else if (propertyName.equals("eventListenerProperty")) {
            this.options.setEventListener((String)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("sessionNameProperty")) {
            modelValue = this.options.getSessionName();
        } else if (propertyName.equals("sessionsXmlProperty")) {
            modelValue = this.options.getSessionsXml();
        } else if (propertyName.equals("includeDescriptorQueriesProperty")) {
            modelValue = this.options.getIncludeDescriptorQueries();
        } else if (propertyName.equals("targetDatabaseProperty")) {
            modelValue = this.options.getTargetDatabase();
        } else if (propertyName.equals("eventListenerProperty")) {
            modelValue = this.options.getEventListener();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }

    protected PersistenceUnitProperties model() {
        return this.options;
    }
}

