/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.logging;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logger;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logging;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerComposite
extends AbstractPane<Logging> {
    public LoggerComposite(AbstractPane<? extends Logging> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyValueModel<String> buildDefaultLoggerHolder() {
        return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{Logging.DEFAULT_LOGGER}){

            protected String buildValue_() {
                return LoggerComposite.this.defaultValue((Logging)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultLoggerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultLoggerHolder());
    }

    private String buildDisplayString(String loggerName) {
        switch (Logger.valueOf((String)loggerName)) {
            case default_logger: {
                return EclipseLinkUiMessages.LoggerComposite_default_logger;
            }
            case java_logger: {
                return EclipseLinkUiMessages.LoggerComposite_java_logger;
            }
            case server_logger: {
                return EclipseLinkUiMessages.LoggerComposite_server_logger;
            }
        }
        return null;
    }

    private Comparator<String> buildLoggerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String logger1, String logger2) {
                logger1 = LoggerComposite.this.buildDisplayString(logger1);
                logger2 = LoggerComposite.this.buildDisplayString(logger2);
                return Collator.getInstance().compare(logger1, logger2);
            }
        };
    }

    private StringConverter<String> buildLoggerConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    Logger.valueOf((String)value);
                    value = LoggerComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildLoggerHolder() {
        return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{"loggerProperty"}){

            protected String buildValue_() {
                String name = ((Logging)this.subject).getLogger();
                if (name == null) {
                    name = LoggerComposite.this.defaultValue((Logging)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (LoggerComposite.this.defaultValue((Logging)this.subject).equals(value)) {
                    value = null;
                }
                ((Logging)this.subject).setLogger(value);
            }
        };
    }

    private ListValueModel<String> buildLoggerListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultLoggerListHolder());
        holders.add(this.buildLoggersListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildLoggers() {
        return new TransformationIterator<Logger, String>(CollectionTools.iterator((Object[])Logger.values())){

            protected String transform(Logger next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildLoggersCollectionHolder() {
        return new SimpleCollectionValueModel(CollectionTools.collection(this.buildLoggers()));
    }

    private ListValueModel<String> buildLoggersListHolder() {
        return new SortedListValueModelAdapter(this.buildLoggersCollectionHolder(), this.buildLoggerComparator());
    }

    private String defaultValue(Logging subject) {
        String defaultValue = subject.getDefaultLogger();
        if (defaultValue != null) {
            return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_defaultWithOneParam, (Object)defaultValue);
        }
        return EclipseLinkUiMessages.PersistenceXmlLoggingTab_defaultEmpty;
    }

    protected void initializeLayout(Composite container) {
        CCombo combo = this.buildLabeledEditableCCombo(container, EclipseLinkUiMessages.PersistenceXmlLoggingTab_loggerLabel, this.buildLoggerListHolder(), this.buildLoggerHolder(), this.buildLoggerConverter(), null);
        SWTUtil.attachDefaultValueHandler((CCombo)combo);
    }
}

