/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.EmptyIterable;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.ReverseComparator;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyEnumeration;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToolsTests
extends TestCase {
    public CollectionToolsTests(String name) {
        super(name);
    }

    public void testAddObjectArrayObject_Object() {
        Object[] a = CollectionTools.add((Object[])this.buildObjectArray1(), (Object)"twenty");
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
        CollectionToolsTests.assertEquals((Object)"twenty", (Object)a[a.length - 1]);
    }

    public void testAddObjectArrayObject_String() {
        Object[] a = (String[])CollectionTools.add((Object[])this.buildStringArray1(), (Object)"twenty");
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
        CollectionToolsTests.assertEquals((String)"twenty", (String)a[a.length - 1]);
    }

    public void testAddObjectArrayObject_EmptyArray() {
        Object[] a = new String[]{};
        a = (String[])CollectionTools.add((Object[])a, (Object)"twenty");
        CollectionToolsTests.assertEquals((int)1, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"twenty"));
        CollectionToolsTests.assertEquals((String)"twenty", (String)a[0]);
    }

    public void testAddObjectArrayIntObject_Object() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.add((Object[])a, (int)2, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject_String() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.add((Object[])a, (int)2, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject_End() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.add((Object[])a, (int)4, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "d", "X"}, a));
    }

    public void testAddObjectArrayIntObject_Zero() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.add((Object[])a, (int)0, (Object)"X");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"X", "a", "b", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject_Exception() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        boolean exCaught = false;
        try {
            a = CollectionTools.add((Object[])a, (int)33, (Object)"X");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAddCharArrayChar() {
        char[] a = CollectionTools.add((char[])this.buildCharArray(), (char)'d');
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
    }

    public void testAddCharArrayChar_Empty() {
        char[] a = new char[]{};
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)1, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'d'}, a));
    }

    public void testAddCharArrayIntChar() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.add((char[])a, (int)2, (char)'X');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'c', 'd'}, a));
    }

    public void testAddCharArrayIntChar_Zero() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.add((char[])a, (int)0, (char)'X');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'X', 'a', 'b', 'c', 'd'}, a));
    }

    public void testAddCharArrayIntChar_End() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.add((char[])a, (int)4, (char)'X');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd', 'X'}, a));
    }

    public void testAddIntArrayInt() {
        int[] a = CollectionTools.add((int[])this.buildIntArray(), (int)30);
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
    }

    public void testAddIntArrayInt_Empty() {
        int[] a = new int[]{};
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)1, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{30}, a));
    }

    public void testAddIntArrayIntInt() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.add((int[])a, (int)2, (int)99);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 3, 4}, a));
    }

    public void testAddIntArrayIntInt_Zero() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.add((int[])a, (int)0, (int)99);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{99, 1, 2, 3, 4}, a));
    }

    public void testAddIntArrayIntInt_End() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.add((int[])a, (int)4, (int)99);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4, 99}, a));
    }

    public void testAddAllCollectionIterable_StringModified() {
        List<String> list1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(this.buildStringList2()));
    }

    public void testAddAllCollectionIterable_StringUnmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> iterable3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(this.buildStringList1()));
    }

    public void testAddAllCollectionIterable_ObjectModified() {
        List<Object> list1 = this.buildObjectList1();
        List<String> iterable2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(iterable2));
    }

    public void testAddAllCollectionIterable_ObjectUnmodified() {
        Set<Object> set1 = this.buildObjectSet1();
        List<String> iterable3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(iterable3));
    }

    public void testAddAllCollectionIterable_EmptyIterable() {
        Set<Object> set1 = this.buildObjectSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, (Iterable)EmptyIterable.instance()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
    }

    public void testAddAllCollectionIterableInt_Modified() {
        List<String> list2;
        List<String> list1 = this.buildStringList1();
        List<String> iterable2 = list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2.iterator(), (int)list2.size()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(this.buildStringList2()));
    }

    public void testAddAllCollectionIterableInt_Unmodified() {
        List<String> list1;
        Set<String> set1 = this.buildStringSet1();
        List<String> iterable3 = list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3.iterator(), (int)list1.size()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(this.buildStringList1()));
    }

    public void testAddAllCollectionIterator_StringModified() {
        List<String> list1 = this.buildStringList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIterator_StringUnmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIterator_ObjectModified() {
        List<Object> list1 = this.buildObjectList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIterator_ObjectUnmodified() {
        Set<Object> set1 = this.buildObjectSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIterator_EmptyIterator() {
        List<String> list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list1, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)3, (int)list1.size());
    }

    public void testAddAllCollectionIteratorInt_Modified() {
        List<String> list1 = this.buildStringList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIteratorInt_Unmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIteratorInt_EmptyIterator() {
        List<String> list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list1, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)3, (int)list1.size());
    }

    public void testAddAllCollectionObjectArray_StringModified() {
        List<String> list = this.buildStringList1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.containsAll(CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray_StringListEmptyArray() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_StringUnmodified() {
        Set<String> set = this.buildStringSet1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)set.size());
        CollectionToolsTests.assertTrue((boolean)set.containsAll(CollectionTools.collection((Object[])a)));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_StringSetEmptyArray() {
        Set<String> set = this.buildStringSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_ObjectModified() {
        List<Object> list = this.buildObjectList1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.containsAll(CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray_ObjectUnmodified() {
        Object[] a = this.buildStringArray1();
        Set<Object> set = this.buildObjectSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)set.size());
        CollectionToolsTests.assertTrue((boolean)set.containsAll(CollectionTools.collection((Object[])a)));
    }

    public void testAddAllListIntObjectArray() {
        List<String> list = this.buildStringList1();
        CollectionTools.addAll(list, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntObjectArray_Zero() {
        ArrayList list = new ArrayList();
        CollectionTools.addAll(list, (int)0, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntObjectArray_EmptyArray() {
        List<String> list = this.buildStringList1();
        CollectionTools.addAll(list, (int)2, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)2, (Iterable)iterable);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterable_Zero() {
        ArrayList list = new ArrayList();
        Iterable iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)0, (Iterable)iterable);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterable_EmptyIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = EmptyIterable.instance();
        CollectionTools.addAll(list, (int)2, (Iterable)iterable);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt() {
        List<String> list = this.buildStringList1();
        Iterable iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)2, (Iterable)iterable, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt_Zero() {
        ArrayList list = new ArrayList();
        Iterable iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)0, (Iterable)iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt_EmptyIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = EmptyIterable.instance();
        CollectionTools.addAll(list, (int)2, (Iterable)iterable, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterator() {
        List<String> list = this.buildStringList1();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)2, iterator);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterator_Zero() {
        ArrayList list = new ArrayList();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)0, iterator);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterator_EmptyIterator() {
        List<String> list = this.buildStringList1();
        Iterator iterator = EmptyIterator.instance();
        CollectionTools.addAll(list, (int)2, (Iterator)iterator);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt() {
        List<String> list = this.buildStringList1();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)2, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt_Zero() {
        ArrayList list = new ArrayList();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)0, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt_EmptyIterator() {
        List<String> list = this.buildStringList1();
        Iterator iterator = EmptyIterator.instance();
        CollectionTools.addAll(list, (int)2, (Iterator)iterator, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllObjectArrayCollection_String() {
        Object[] a = this.buildStringArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, c);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection_Object() {
        Object[] a = this.buildObjectArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = CollectionTools.addAll((Object[])a, c);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection_EmptyArray() {
        Object[] a = new String[]{};
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, c);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection_EmptyCollection() {
        Object[] a = this.buildStringArray1();
        ArrayList c = new ArrayList();
        String[] newArray = (String[])CollectionTools.addAll((Object[])a, c);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntCollection_String() {
        Object[] a = this.buildStringArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, c);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayIntCollection_EmptyArray() {
        Object[] a = new String[]{};
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)0, c);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayIntCollection_EmptyCollection() {
        Object[] a = this.buildStringArray1();
        ArrayList c = new ArrayList();
        String[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, c);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIterable_String() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, iterable);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterable_EmptyArray() {
        Object[] a = new String[]{};
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)0, iterable);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterable_EmptyIterable() {
        Object[] a = this.buildStringArray1();
        ArrayList iterable = new ArrayList();
        String[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, iterable);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIterableInt_String() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, iterable, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterableInt_EmptyArray() {
        Object[] a = new String[]{};
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)0, iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterableInt_EmptyIterable() {
        Object[] a = this.buildStringArray1();
        ArrayList iterable = new ArrayList();
        String[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, iterable, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIterator_String() {
        Object[] a = this.buildStringArray1();
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, iterator);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIterator_EmptyArray() {
        Object[] a = new String[]{};
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)0, iterator);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIterator_EmptyIterable() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        String[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, (Iterator)iterator);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIteratorInt_String() {
        Object[] a = this.buildStringArray1();
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIteratorInt_EmptyArray() {
        Object[] a = new String[]{};
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)0, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIteratorInt_EmptyIterator() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        String[] newArray = (String[])CollectionTools.addAll((Object[])a, (int)1, (Iterator)iterator, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIterable() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList1();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, iterable);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterableInt() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList1();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, iterable, (int)33);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterator_String() {
        Object[] a = this.buildStringArray1();
        Iterator<String> iterator = this.buildStringList1().iterator();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, iterator);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterator_Object() {
        Object[] a = this.buildStringArray1();
        Iterator<Object> iterator = this.buildObjectList1().iterator();
        Object[] newArray = CollectionTools.addAll((Object[])a, iterator);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildObjectList1()));
    }

    public void testAddAllObjectArrayIterator_EmptyIterator() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (Iterator)iterator);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIteratorInt() {
        Object[] a = this.buildStringArray1();
        Iterator<Object> iterator = this.buildObjectList1().iterator();
        Object[] newArray = CollectionTools.addAll((Object[])a, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildObjectList1()));
    }

    public void testAddAllObjectArrayIteratorInt_EmptyIterator() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a, (Iterator)iterator, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayObjectArray_Object() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = this.buildObjectArray2();
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_String() {
        Object[] a1 = this.buildStringArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = (String[])CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_ObjectString() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)6, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_EmptyArray1() {
        Object[] a1 = new Object[]{};
        Object[] a2 = this.buildObjectArray2();
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_EmptyArray2() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = new Object[]{};
        Object[] newArray = CollectionTools.addAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)3, (int)newArray.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])newArray, (Object[])a1));
    }

    public void testAddAllObjectArrayIntObjectArray_Object() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)2, (Object[])new Object[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_String() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])CollectionTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_ObjectString() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_End() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)4, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "c", "d", "X", "X", "X"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_Zero() {
        Object[] a = new Object[]{};
        a = CollectionTools.addAll((Object[])a, (int)0, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_EmptyArray2() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = CollectionTools.addAll((Object[])a, (int)4, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_EmptyArray1() {
        Object[] a = new String[]{};
        a = CollectionTools.addAll((Object[])a, (int)0, (Object[])new Object[]{"a", "b", "c", "d"});
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "c", "d"}, a));
    }

    public void testAddAllCharArrayCharArray() {
        char[] a = CollectionTools.addAll((char[])this.buildCharArray(), (char[])new char[]{'d', 'e'});
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'e'));
    }

    public void testAddAllCharArrayCharArray_EmptyArray2() {
        char[] a = CollectionTools.addAll((char[])this.buildCharArray(), (char[])new char[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
    }

    public void testAddAllCharArrayCharArrayEmptyArray1() {
        char[] a = CollectionTools.addAll((char[])new char[0], (char[])new char[]{'d', 'e'});
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'e'));
    }

    public void testAddAllCharArrayIntCharArray() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.addAll((char[])a, (int)2, (char[])new char[]{'X', 'X', 'X'});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'X', 'X', 'c', 'd'}, a));
    }

    public void testAddAllCharArrayIntCharArray_End() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.addAll((char[])a, (int)4, (char[])new char[]{'X', 'X', 'X'});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd', 'X', 'X', 'X'}, a));
    }

    public void testAddAllCharArrayIntCharArray_EmptyArray1() {
        char[] a = new char[]{};
        a = CollectionTools.addAll((char[])a, (int)0, (char[])new char[]{'X', 'X', 'X'});
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'X'));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'X', 'X', 'X'}, a));
    }

    public void testAddAllCharArrayIntCharArray_EmptyArray2() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = CollectionTools.addAll((char[])a, (int)2, (char[])new char[0]);
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd'}, a));
    }

    public void testAddAllIntArrayIntArray() {
        int[] a = CollectionTools.addAll((int[])this.buildIntArray(), (int[])new int[]{30, 40});
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)40));
    }

    public void testAddAllIntArrayIntArray_EmptyArray2() {
        int[] a = CollectionTools.addAll((int[])this.buildIntArray(), (int[])new int[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
    }

    public void testAddAllIntArrayIntArray_EmptyArray1() {
        int[] a = CollectionTools.addAll((int[])new int[0], (int[])new int[]{30, 40});
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)40));
    }

    public void testAddAllIntArrayIntIntArray() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.addAll((int[])a, (int)2, (int[])new int[]{99, 99, 99});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 99, 99, 3, 4}, a));
    }

    public void testAddAllIntArrayIntIntArray_End() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.addAll((int[])a, (int)4, (int[])new int[]{99, 99, 99});
        CollectionToolsTests.assertEquals((int)7, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4, 99, 99, 99}, a));
    }

    public void testAddAllIntArrayIntIntArray_EmptyArray2() {
        int[] a = new int[]{1, 2, 3, 4};
        a = CollectionTools.addAll((int[])a, (int)2, (int[])new int[0]);
        CollectionToolsTests.assertEquals((int)4, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4}, a));
    }

    public void testAddAllIntArrayIntIntArray_EmptyArray1() {
        int[] a = new int[]{};
        a = CollectionTools.addAll((int[])a, (int)0, (int[])new int[]{99, 99, 99});
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)99));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{99, 99, 99}, a));
    }

    public void testArrayIterable() {
        List<String> iterable = this.buildStringList1();
        Object[] a = CollectionTools.array(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableInt() {
        List<String> iterable = this.buildStringList1();
        Object[] a = CollectionTools.array(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableObjectArray_String() {
        List<String> iterable = this.buildStringList1();
        Object[] a = (String[])CollectionTools.array(iterable, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableObjectArray_Object() {
        List<String> iterable = this.buildStringList1();
        Object[] a = CollectionTools.array(iterable, (Object[])new Object[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableIntObjectArray() {
        List<String> iterable = this.buildStringList1();
        Object[] a = (String[])CollectionTools.array(iterable, (int)3, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterator() {
        Object[] a = CollectionTools.array(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterator_Empty() {
        Object[] a = CollectionTools.array((Iterator)EmptyIterator.instance());
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testArrayIteratorInt() {
        Object[] a = CollectionTools.array(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorInt_Empty() {
        Object[] a = CollectionTools.array((Iterator)EmptyIterator.instance(), (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testArrayIteratorObjectArray_String() {
        Object[] a = (String[])CollectionTools.array(this.buildStringList1().iterator(), (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorObjectArray_Empty() {
        String[] a = (String[])CollectionTools.array((Iterator)EmptyIterator.instance(), (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testArrayIteratorObjectArray_Object() {
        Object[] a = CollectionTools.array(this.buildStringList1().iterator(), (Object[])new Object[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorIntObjectArray() {
        Object[] a = (String[])CollectionTools.array(this.buildStringList1().iterator(), (int)3, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorIntObjectArray_Empty() {
        String[] a = (String[])CollectionTools.array((Iterator)EmptyIterator.instance(), (int)3, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testBagEnumeration_String() {
        Bag b = CollectionTools.bag(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumeration_Object() {
        Bag b = CollectionTools.bag(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumeration_Empty() {
        Bag b = CollectionTools.bag((Enumeration)EmptyEnumeration.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagEnumerationInt() {
        Bag b = CollectionTools.bag(this.buildStringVector1().elements(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumerationInt_Empty() {
        Bag b = CollectionTools.bag((Enumeration)EmptyEnumeration.instance(), (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagIterable() {
        List<String> iterable = this.buildStringList1();
        Bag b = CollectionTools.bag(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterableInt() {
        List<String> iterable = this.buildStringList1();
        Bag b = CollectionTools.bag(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator_String() {
        Bag b = CollectionTools.bag(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator_StringObject() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        Bag b = CollectionTools.bag(c.iterator());
        CollectionToolsTests.assertEquals((int)4, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(c));
    }

    public void testBagIterator_Empty() {
        Bag b = CollectionTools.bag((Iterator)EmptyIterator.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagIteratorInt() {
        Bag b = CollectionTools.bag(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIteratorInt_Empty() {
        Bag b = CollectionTools.bag((Iterator)EmptyIterator.instance(), (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagObjectArray() {
        Bag b = CollectionTools.bag((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])this.buildStringArray1()));
    }

    public void testBagObjectArray_Vararg() {
        Bag b = CollectionTools.bag((Object[])new String[]{"foo", "bar", "baz"});
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])new Object[]{"foo", "bar", "baz"}));
    }

    public void testBagObjectArray_Empty() {
        Bag b = CollectionTools.bag((Iterable)((Iterable)Bag.Empty.instance()));
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testCollectionEnumeration() {
        Collection c = CollectionTools.collection(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionEnumeration_ObjectString() {
        Collection c = CollectionTools.collection(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionEnumerationInt() {
        Collection c = CollectionTools.collection(this.buildStringVector1().elements(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionIterable() {
        List<String> iterable = this.buildStringList1();
        Collection c = CollectionTools.collection(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterableInt() {
        List<String> iterable = this.buildStringList1();
        Collection c = CollectionTools.collection(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator() {
        Collection c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator_ObjectString() {
        Collection c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIteratorInt() {
        Collection c = CollectionTools.collection(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionObjectArray() {
        Collection c = CollectionTools.collection((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)c, (Object[])this.buildStringArray1()));
    }

    public void testContainsEnumerationObject_String() {
        Vector<String> v = this.buildStringVector1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(v.elements(), (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(v.elements(), null));
        v.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(v.elements(), null));
    }

    public void testContainsEnumerationObject_Object() {
        Vector<String> c = new Vector<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.elements(), (Object)one));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.elements(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.elements(), null));
    }

    public void testContainsIterableObject() {
        List<String> c;
        List<String> iterable = c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(iterable, (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(iterable, null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(iterable, null));
    }

    public void testContainsIteratorObject_String() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsIteratorObject_Object() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), (Object)one));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, null));
        Object[] a2 = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a2, null));
    }

    public void testContainsCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'a'));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((char[])a, (char)'z'));
        char[] a2 = CollectionTools.add((char[])a, (char)'z');
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a2, (char)'z'));
    }

    public void testContainsIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)10));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((int[])a, (int)55));
        int[] a2 = CollectionTools.add((int[])a, (int)55);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a2, (int)55));
    }

    public void testContainsAllCollectionIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), iterable));
    }

    public void testContainsAllCollectionIterator_String() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), this.buildStringList1().iterator()));
    }

    public void testContainsAllCollectionIterator_Object() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("two");
        c2.add("zero");
        c2.add("one");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1, c2.iterator()));
    }

    public void testContainsAllCollectionObjectArray_StringObject() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllCollectionObjectArray() {
        Object[] a = new Object[]{"zero", "one", "two"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])a));
    }

    public void testContainsAllIterableCollection() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, this.buildStringList1()));
    }

    public void testContainsAllIterableIntCollection() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (int)3, this.buildStringList1()));
    }

    public void testContainsAllIterableIterable() {
        List<String> iterable1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable1, iterable2));
    }

    public void testContainsAllIterableIntIterable() {
        List<String> iterable1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable1, (int)3, iterable2));
    }

    public void testContainsAllIterableIterator() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, this.buildStringList1().iterator()));
    }

    public void testContainsAllIterableIntIterator() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (int)3, this.buildStringList1().iterator()));
    }

    public void testContainsAllIterableObjectArray() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (Object[])this.buildObjectArray1()));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(iterable, (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllIterableIntObjectArray() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (int)3, (Object[])this.buildObjectArray1()));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(iterable, (int)3, (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllIteratorCollection_StringString() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList2()));
    }

    public void testContainsAllIteratorCollection_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1.iterator(), c2));
    }

    public void testContainsAllIteratorIntCollection() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)5, this.buildStringList1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)5, this.buildStringList2()));
    }

    public void testContainsAllIteratorIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), iterable));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), iterable));
    }

    public void testContainsAllIteratorIntIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, iterable));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, iterable));
    }

    public void testContainsAllIteratorIterator_StringString() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1().iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList2().iterator()));
    }

    public void testContainsAllIteratorIterator_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1.iterator(), c2.iterator()));
    }

    public void testContainsAllIteratorIntIterator() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, this.buildStringList1().iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, this.buildStringList2().iterator()));
    }

    public void testContainsAllIteratorObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllIteratorIntObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllObjectArrayCollection() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList2()));
    }

    public void testContainsAllObjectArrayIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), iterable));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), iterable));
    }

    public void testContainsAllObjectArrayIterator() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList1().iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList2().iterator()));
    }

    public void testContainsAllObjectArrayIterator_Empty() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), (Iterator)EmptyIterator.instance()));
    }

    public void testContainsAllObjectArrayObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll((Object[])this.buildObjectArray1(), (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllCharArrayCharArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((char[])this.buildCharArray(), (char[])this.buildCharArray()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll((char[])this.buildCharArray(), (char[])new char[]{'x', 'y'}));
    }

    public void testContainsAllIntArrayIntArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((int[])this.buildIntArray(), (int[])this.buildIntArray()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll((int[])this.buildIntArray(), (int[])new int[]{444, 888}));
    }

    public void testDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        CollectionToolsTests.assertTrue((a != a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b != b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c != c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d != d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd((Object[])array1, (Object[])array2));
    }

    public void testDiffRange() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((Object)new Range(1, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 2), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 0), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((Object)new Range(3, 3), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(2, 2), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.diffRange((Object[])array1, (Object[])array2));
    }

    public void testDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        CollectionToolsTests.assertTrue((a != a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b != b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c != c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d != d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c__) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.diffStart((Object[])array1, (Object[])array2));
    }

    public void testEqualsIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 0;
        while (i < list1.size()) {
            list2.add(String.valueOf((i + 1) * 1000));
            ++i;
        }
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.equals((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
    }

    public void testGetListIteratorInt() {
        List<String> list = this.buildStringList1();
        String o = (String)CollectionTools.get(list.listIterator(), (int)1);
        CollectionToolsTests.assertEquals((String)"one", (String)o);
        list.add(null);
        o = (String)CollectionTools.get(list.listIterator(), (int)(list.size() - 1));
        CollectionToolsTests.assertNull((Object)o);
        boolean exCaught = false;
        try {
            CollectionTools.get(list.listIterator(), (int)list.size());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testIdenticalObjectArrayObjectArray() {
        Object[] a1 = new Object[4];
        int i = 0;
        while (i < a1.length) {
            a1[i] = String.valueOf(i * 1000);
            ++i;
        }
        Object[] a2 = new Object[a1.length];
        int i2 = 0;
        while (i2 < a2.length) {
            a2[i2] = a1[i2];
            ++i2;
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
        a2[2] = "2000";
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testIdenticalObjectArrayObjectArray_BothNull() {
        Object[] a1 = null;
        Object[] a2 = null;
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
    }

    public void testIdenticalObjectArrayObjectArray_OneNull() {
        Object[] a1 = null;
        Object[] a2 = new Object[]{};
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
    }

    public void testIdenticalObjectArrayObjectArray_DifferentLengths() {
        Object[] a1 = new String[]{"foo", "bar"};
        Object[] a2 = new String[]{"foo", "bar", "baz"};
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Object[])a1, (Object[])a2));
    }

    public void testIdenticalListIteratorListIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.identical((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.equals((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
    }

    public void testIdenticalListIteratorListIterator_Not() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(0);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.equals((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
    }

    public void testIdenticalListIteratorListIterator_DifferentSizes() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(3);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.identical((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.equals((Iterator)list1.listIterator(), (Iterator)list2.listIterator()));
    }

    public void testIdentityDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffRange() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((Object)new Range(1, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, 4), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((Object)new Range(0, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 2), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(0, 0), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((Object)new Range(3, 3), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(2, 2), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((Object)new Range(2, 2), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((Object)new Range(5, -1), (Object)CollectionTools.identityDiffRange((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        CollectionToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        CollectionToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        CollectionToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.identityDiffStart((Object[])array1, (Object[])array2));
    }

    public void testIndexOfListIteratorObject_String() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((Iterator)list.listIterator(), (Object)"one"));
    }

    public void testIndexOfListIteratorObject_Null() {
        List<String> list = this.buildStringList1();
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.indexOf((Iterator)list.listIterator(), null));
    }

    public void testIndexOfListIteratorObject_Object() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        String one = "1";
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((Iterator)list.listIterator(), (Object)one));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.indexOf((Iterator)list.listIterator(), null));
    }

    public void testIndexOfObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((Object[])a, (Object)"one"));
    }

    public void testIndexOfObjectArrayObject_Null() {
        Object[] a = this.buildObjectArray1();
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((Object[])a, null));
    }

    public void testIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((char[])a, (char)'b'));
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((char[])a, (char)'d'));
    }

    public void testIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf((int[])a, (int)10));
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.indexOf((int[])a, (int)30));
    }

    public void testInsertionIndexOfListComparable() {
        List<String> list = Arrays.asList("A", "C", "D");
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"E")));
        list = Arrays.asList("B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
        list = Arrays.asList("A", "A", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfListObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        List<String> list = Arrays.asList("D", "C", "A");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "A");
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Object)"E", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "A", "A");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
    }

    public void testInsertionIndexOfObjectArrayComparable() {
        String[] a = new String[]{"A", "C", "D"};
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"E")));
        a = new String[]{"B", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"A")));
        a = new String[]{"A", "A", "B", "B", "C", "D"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfObjectArrayObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        Object[] a = new String[]{"D", "C", "A"};
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "A"};
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B", "A"};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B", "A"};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"E", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B"};
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "A", "A"};
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
    }

    public void testIterableIterator() {
        Iterator emptyIterator = EmptyIterator.instance();
        Iterable emptyIterable = CollectionTools.iterable((Iterator)emptyIterator);
        CollectionToolsTests.assertFalse((boolean)emptyIterable.iterator().hasNext());
        boolean exceptionThrown = false;
        try {
            emptyIterator = emptyIterable.iterator();
            CollectionToolsTests.fail((String)("invalid iterator: " + emptyIterator));
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        CollectionToolsTests.assertTrue((String)"IllegalStateException not thrown.", (boolean)exceptionThrown);
    }

    public void testIterableObjectArray() {
        Object[] strings = this.buildStringArray1();
        int i = 0;
        for (String string : CollectionTools.iterable((Object[])strings)) {
            CollectionToolsTests.assertEquals((String)strings[i++], (String)string);
        }
    }

    public void testIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        Iterator stream = CollectionTools.iterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testLastIndexOfIteratorObject() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((Iterator)list.listIterator(), (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.lastIndexOf((Iterator)list.listIterator(), null));
    }

    public void testLastIndexOfIteratorObject_Empty() {
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.lastIndexOf((Iterator)EmptyIterator.instance(), (Object)"foo"));
    }

    public void testLastIndexOfObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((Object[])a, (Object)"one"));
    }

    public void testLastIndexOfObjectArrayObject_Null() {
        Object[] a = this.buildObjectArray1();
        a = CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.lastIndexOf((Object[])a, null));
    }

    public void testLastIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((char[])a, (char)'b'));
        a = CollectionTools.add((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.lastIndexOf((char[])a, (char)'d'));
    }

    public void testLastIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf((int[])a, (int)10));
        a = CollectionTools.add((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)(a.length - 1), (int)CollectionTools.lastIndexOf((int[])a, (int)30));
    }

    public void testListIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)CollectionTools.list(iterable));
    }

    public void testListIterableInt() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)CollectionTools.list(iterable, (int)3));
    }

    public void testListIterator_String() {
        List list = CollectionTools.list(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIterator_StringObject() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        List list2 = CollectionTools.list(list1.iterator());
        CollectionToolsTests.assertEquals(list1, (Object)list2);
    }

    public void testListIterator_Empty() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.list((Iterator)EmptyIterator.instance()).size());
    }

    public void testListIteratorInt() {
        List list = CollectionTools.list(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIteratorInt_Empty() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.list((Iterator)EmptyIterator.instance(), (int)5).size());
    }

    public void testListObjectArray() {
        List list = CollectionTools.list((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        ListIterator stream = CollectionTools.listIterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testListIteratorObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        int i = 1;
        ListIterator stream = CollectionTools.listIterator((Object[])a, (int)1);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testMaxCharArray() {
        CollectionToolsTests.assertEquals((char)'c', (char)CollectionTools.max((char[])this.buildCharArray()));
    }

    public void testMaxIntArray() {
        CollectionToolsTests.assertEquals((int)20, (int)CollectionTools.max((int[])this.buildIntArray()));
    }

    public void testMinCharArray() {
        CollectionToolsTests.assertEquals((char)'a', (char)CollectionTools.min((char[])this.buildCharArray()));
    }

    public void testMinIntArray() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.min((int[])this.buildIntArray()));
    }

    public void testMoveObjectArrayIntInt() {
        Object[] array = new String[]{"0", "1", "2", "3", "4", "5"};
        Object[] result = (String[])CollectionTools.move((Object[])array, (int)4, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)0, (int)5);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)2, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)4, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result));
    }

    public void testMoveObjectArrayIntIntInt() {
        Object[] array = new String[]{"0", "1", "2", "3", "4", "5"};
        Object[] result = (String[])CollectionTools.move((Object[])array, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
        result = (String[])CollectionTools.move((Object[])array, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
    }

    public void testMoveIntArrayIntInt() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] array = nArray;
        int[] result = CollectionTools.move((int[])array, (int)4, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 2;
        nArray2[5] = 5;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray2, result));
        result = CollectionTools.move((int[])array, (int)0, (int)5);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray3 = new int[6];
        nArray3[0] = 5;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 2;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray3, result));
        result = CollectionTools.move((int[])array, (int)2, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray4 = new int[6];
        nArray4[0] = 5;
        nArray4[2] = 4;
        nArray4[3] = 1;
        nArray4[4] = 3;
        nArray4[5] = 2;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray4, result));
        result = CollectionTools.move((int[])array, (int)2, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray5 = new int[6];
        nArray5[0] = 5;
        nArray5[2] = 4;
        nArray5[3] = 1;
        nArray5[4] = 3;
        nArray5[5] = 2;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray5, result));
    }

    public void testMoveIntArrayIntIntInt() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] array = nArray;
        int[] result = CollectionTools.move((int[])array, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 2;
        nArray2[5] = 5;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray2, result));
        result = CollectionTools.move((int[])array, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray3 = new int[6];
        nArray3[0] = 5;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 2;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray3, result));
        result = CollectionTools.move((int[])array, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray4 = new int[6];
        nArray4[0] = 5;
        nArray4[2] = 4;
        nArray4[3] = 1;
        nArray4[4] = 3;
        nArray4[5] = 2;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray4, result));
        result = CollectionTools.move((int[])array, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray5 = new int[6];
        nArray5[0] = 5;
        nArray5[2] = 3;
        nArray5[3] = 2;
        nArray5[4] = 4;
        nArray5[5] = 1;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray5, result));
        result = CollectionTools.move((int[])array, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray6 = new int[6];
        nArray6[1] = 3;
        nArray6[2] = 2;
        nArray6[3] = 4;
        nArray6[4] = 5;
        nArray6[5] = 1;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray6, result));
        result = CollectionTools.move((int[])array, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray7 = new int[6];
        nArray7[0] = 5;
        nArray7[2] = 3;
        nArray7[3] = 2;
        nArray7[4] = 4;
        nArray7[5] = 1;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray7, result));
        result = CollectionTools.move((int[])array, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray8 = new int[6];
        nArray8[0] = 5;
        nArray8[2] = 3;
        nArray8[3] = 2;
        nArray8[4] = 4;
        nArray8[5] = 1;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray8, result));
        result = CollectionTools.move((int[])array, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray9 = new int[6];
        nArray9[0] = 5;
        nArray9[2] = 3;
        nArray9[3] = 2;
        nArray9[4] = 4;
        nArray9[5] = 1;
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(nArray9, result));
    }

    public void testMoveCharArrayIntInt() {
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] result = CollectionTools.move((char[])array, (int)4, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'd', 'e', 'c', 'f'}, result));
        result = CollectionTools.move((char[])array, (int)0, (int)5);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'f', 'a', 'b', 'd', 'e', 'c'}, result));
        result = CollectionTools.move((char[])array, (int)2, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'f', 'a', 'e', 'b', 'd', 'c'}, result));
        result = CollectionTools.move((char[])array, (int)2, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'f', 'a', 'e', 'b', 'd', 'c'}, result));
    }

    public void testMoveCharArrayIntIntInt() {
        char[] array = new char[]{'a', 'b', 'b', 'c', 'd', 'e'};
        char[] result = CollectionTools.move((char[])array, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd', 'b', 'e'}, result));
        result = CollectionTools.move((char[])array, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'b', 'c', 'd', 'b'}, result));
        result = CollectionTools.move((char[])array, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'd', 'b', 'c', 'b'}, result));
        result = CollectionTools.move((char[])array, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
        result = CollectionTools.move((char[])array, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c', 'b', 'd', 'e', 'b'}, result));
        result = CollectionTools.move((char[])array, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
        result = CollectionTools.move((char[])array, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
        result = CollectionTools.move((char[])array, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame((Object)array, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
    }

    public void testMoveListIntIntRandomAccess() {
        ArrayList list = new ArrayList();
        CollectionTools.addAll(list, (Object[])new String[]{"0", "1", "2", "3", "4", "5"});
        List result = CollectionTools.move(list, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
    }

    public void testMoveListIntIntSequentialAccess() {
        LinkedList list = new LinkedList();
        CollectionTools.addAll(list, (Object[])new String[]{"0", "1", "2", "3", "4", "5"});
        List result = CollectionTools.move(list, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
    }

    public void testMoveListIntIntIntRandomAccess() {
        ArrayList list = new ArrayList(Arrays.asList("0", "1", "2", "3", "4", "5"));
        List result = CollectionTools.move(list, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
    }

    public void testMoveListIntIntIntSequentialAccess() {
        LinkedList list = new LinkedList(Arrays.asList("0", "1", "2", "3", "4", "5"));
        List result = CollectionTools.move(list, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
    }

    public void testRemoveAllObjectArrayObjectArray() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{"E", "B"};
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayObjectArray_Empty() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{};
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayObjectArray_NoMatches() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{"X", "Y", "Z"};
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayIterable() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterable iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Iterable)iterable);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIterableInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterable iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Iterable)iterable, (int)7);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIterator() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterable iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, iterable.iterator());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIteratorInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterable iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, iterable.iterator(), (int)7);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayCollection() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Collection collection = Arrays.asList("E", "B");
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Collection)collection);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayCollection_Empty() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        ArrayList collection = new ArrayList();
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, collection);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayCollection_NoMatches() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Collection collection = Arrays.asList("X", "Y", "Z");
        Object[] a3 = (String[])CollectionTools.removeAll((Object[])a1, (Collection)collection);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'A', 'C', 'C', 'D', 'D', 'F', 'F'}, CollectionTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllCharArrayCharArray_Empty() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, CollectionTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllCharArrayCharArray_NoMatches() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'X', 'Z'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, CollectionTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 1, 3, 3, 4, 4, 6, 6}, CollectionTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveAllIntArrayIntArray_Empty() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, CollectionTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveAllIntArrayIntArray_NoMatches() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{52, 67};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, CollectionTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveObjectArrayObject_Object() {
        Object[] a = this.buildObjectArray1();
        a = CollectionTools.add((Object[])a, (Object)"three");
        a = CollectionTools.add((Object[])a, (Object)"four");
        a = CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        a = CollectionTools.remove((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveObjectArrayObject_String() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.add((Object[])a, (Object)"three");
        a = (String[])CollectionTools.add((Object[])a, (Object)"four");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        a = (String[])CollectionTools.remove((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((Object[])a, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"four"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveCharArrayChar() {
        char[] a = this.buildCharArray();
        a = CollectionTools.add((char[])a, (char)'d');
        a = CollectionTools.add((char[])a, (char)'e');
        a = CollectionTools.add((char[])a, (char)'f');
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'d'));
        a = CollectionTools.remove((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((char[])a, (char)'d'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'e'));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((char[])a, (char)'f'));
    }

    public void testRemoveIntArrayInt() {
        int[] a = this.buildIntArray();
        a = CollectionTools.add((int[])a, (int)30);
        a = CollectionTools.add((int[])a, (int)40);
        a = CollectionTools.add((int[])a, (int)50);
        CollectionToolsTests.assertEquals((int)6, (int)a.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)30));
        a = CollectionTools.remove((int[])a, (int)30);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains((int[])a, (int)30));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)40));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains((int[])a, (int)50));
    }

    public void testRemoveAllCollectionIterable() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, iterable));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterableInt() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, iterable, (int)3));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, iterable, (int)3));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator_Duplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = new ArrayIterator(a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = new ArrayIterator(a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionIterator_ObjectString() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = new ArrayIterator(a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = new ArrayIterator(a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionIteratotInt() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = new ArrayIterator(a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator, (int)2));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = new ArrayIterator(a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionObjectArray_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionObjectArray_Duplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllCollectionObjectArray_MoreDuplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("a");
        c.add("d");
        c.add("d");
        c.add("a");
        c.add("c");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllOccurrencesCollectionObject() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add("five");
        c.add("five");
        c.add("five");
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add(null);
        c.add(null);
        c.add(null);
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
    }

    public void testRemoveAllOccurrencesObjectArrayObject() {
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"three");
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"two");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"two");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        a = (String[])CollectionTools.add((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, (Object)"five");
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.add((Object[])a, null);
        a = (String[])CollectionTools.add((Object[])a, null);
        a = (String[])CollectionTools.add((Object[])a, null);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, null);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])CollectionTools.removeAllOccurrences((Object[])a, null);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesCharArrayChar() {
        char[] a = this.buildCharArray();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'d');
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'b');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'b');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((char[])a, (char)'g');
        a = CollectionTools.add((char[])a, (char)'g');
        a = CollectionTools.add((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((char[])a, (char)'g');
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesIntArrayInt() {
        int[] a = this.buildIntArray();
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)55);
        CollectionToolsTests.assertEquals((int)3, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)10);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)10);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.add((int[])a, (int)77);
        a = CollectionTools.add((int[])a, (int)77);
        a = CollectionTools.add((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)5, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
        a = CollectionTools.removeAllOccurrences((int[])a, (int)77);
        CollectionToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveElementAtIndexObjectArrayInt() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])CollectionTools.removeElementAtIndex((Object[])a, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "A", "D"}, a));
    }

    public void testRemoveElementAtIndexCharArrayInt() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.removeElementAtIndex((char[])a, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'B', 'A', 'A', 'D'}, a));
    }

    public void testRemoveElementAtIndexIntArrayInt() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = CollectionTools.removeElementsAtIndex((int[])a, (int)3, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{8, 6, 7}, a));
    }

    public void testRemoveElementsAtIndexListIntInt() {
        ArrayList list = new ArrayList(Arrays.asList("A", "B", "A", "C", "A", "D"));
        List removed = CollectionTools.removeElementsAtIndex(list, (int)3, (int)2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "D"}, list.toArray()));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"C", "A"}, removed.toArray()));
        list = new ArrayList(Arrays.asList("A", "B", "C", "D", "E", "F"));
        removed = CollectionTools.removeElementsAtIndex(list, (int)3, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C"}, list.toArray()));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"D", "E", "F"}, removed.toArray()));
        list = new ArrayList(Arrays.asList("A", "B", "C", "D", "E", "F"));
        removed = CollectionTools.removeElementsAtIndex(list, (int)0, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"D", "E", "F"}, list.toArray()));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C"}, removed.toArray()));
    }

    public void testRemoveElementsAtIndexObjectArrayIntInt() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])CollectionTools.removeElementsAtIndex((Object[])a, (int)3, (int)2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "D"}, a));
    }

    public void testRemoveElementsAtIndexObjectArrayIntInt_Empty() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])CollectionTools.removeElementsAtIndex((Object[])a, (int)0, (int)6);
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveElementsAtIndexCharArrayIntInt() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.removeElementsAtIndex((char[])a, (int)0, (int)5);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'D'}, a));
    }

    public void testRemoveElementsAtIndexCharArrayIntInt_Empty() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.removeElementsAtIndex((char[])a, (int)0, (int)6);
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveElementsAtIndexIntArrayIntInt() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = CollectionTools.removeElementsAtIndex((int[])a, (int)3, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{8, 6, 7}, a));
    }

    public void testRemoveElementsAtIndexIntArrayIntInt_Empty() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = CollectionTools.removeElementsAtIndex((int[])a, (int)0, (int)6);
        CollectionToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testReplaceAllObjectArrayObjectObject_Object() {
        Object[] a = new Object[]{"A", "B", "A", "C", "A", "D"};
        a = CollectionTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllObjectArrayObjectObject_String() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])CollectionTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllObjectArrayObjectObject_Null() {
        Object[] objectArray = new String[6];
        objectArray[1] = "B";
        objectArray[3] = "C";
        objectArray[5] = "D";
        Object[] a = objectArray;
        a = (String[])CollectionTools.replaceAll((Object[])a, null, (Object)"Z");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllCharArrayCharChar() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = CollectionTools.replaceAll((char[])a, (char)'A', (char)'Z');
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'Z', 'B', 'Z', 'C', 'Z', 'D'}, a));
    }

    public void testReplaceAllIntArrayIntInt() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[3] = 7;
        nArray[5] = 99;
        int[] a = nArray;
        a = CollectionTools.replaceAll((int[])a, (int)0, (int)13);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{13, 1, 13, 7, 13, 99}, a));
    }

    public void testRetainAllCollectionIterable() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        iterable = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterableInt() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        iterable = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, iterable, (int)7));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c1, c2.iterator()));
        CollectionToolsTests.assertEquals((int)c2.size(), (int)c1.size());
        CollectionToolsTests.assertEquals(c2, c1);
        ArrayList<String> c3 = new ArrayList<String>();
        c3.add("three");
        c3.add("four");
        c3.add("five");
    }

    public void testRetainAllCollectionIterator_EmptyIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIterator_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator(), (int)8));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator(), (int)9));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIteratorInt_EmptyIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionObjectArray_EmptyObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])new Object[0]));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])new String[]{"foo"}));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllObjectArrayObjectArray() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new Object[]{"E", "B", new Integer(7)};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, (Object[])a2)));
    }

    public void testRetainAllObjectArrayObjectArray_EmptyObjectArray1() {
        Object[] a1 = new String[]{};
        Object[] a2 = new String[]{"E", "B", ""};
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayObjectArray_EmptyObjectArray2() {
        Object[] a1 = new String[]{"E", "B", ""};
        Object[] a2 = new String[]{};
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayObjectArray_BothEmpty() {
        Object[] a1 = new String[]{};
        Object[] a2 = new String[]{};
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, (Object[])a2);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterable() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterable iterable = Arrays.asList("E", "B", "");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, (Iterable)iterable)));
    }

    public void testRetainAllObjectArrayIterable_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Iterable iterable = Arrays.asList("E", "B", "");
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, (Iterable)iterable);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterableInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterable iterable = Arrays.asList("E", "B", "");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, (Iterable)iterable, (int)3)));
    }

    public void testRetainAllObjectArrayIterableInt_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Iterable iterable = Arrays.asList("E", "B", "");
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, (Iterable)iterable, (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterator() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, iterator)));
    }

    public void testRetainAllObjectArrayIterator_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, iterator);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIteratorInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, iterator, (int)3)));
    }

    public void testRetainAllObjectArrayIteratorInt_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayCollection() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Collection collection = Arrays.asList("E", "B", "");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, CollectionTools.retainAll((Object[])a1, (Collection)collection)));
    }

    public void testRetainAllObjectArrayCollection_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Collection collection = Arrays.asList("E", "B", "");
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, (Collection)collection);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayCollection_EmptyCollection() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        ArrayList collection = new ArrayList();
        String[] a3 = (String[])CollectionTools.retainAll((Object[])a1, collection);
        CollectionToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayCollection_All() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Collection collection = Arrays.asList("A", "B", "C", "D", "E", "F");
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(a1, CollectionTools.retainAll((Object[])a1, (Collection)collection)));
    }

    public void testRetainAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'B', 'B', 'E', 'E'}, CollectionTools.retainAll((char[])a1, (char[])a2)));
    }

    public void testRetainAllCharArrayCharArray_EmptyCharArray1() {
        char[] a1 = new char[]{};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertSame((Object)a1, (Object)CollectionTools.retainAll((char[])a1, (char[])a2));
    }

    public void testRetainAllCharArrayCharArray_EmptyCharArray2() {
        char[] a1 = new char[]{'E', 'B'};
        char[] a2 = new char[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.retainAll((char[])a1, (char[])a2).length);
    }

    public void testRetainAllCharArrayCharArray_RetainAll() {
        char[] a1 = new char[]{'E', 'B', 'E', 'B', 'E', 'B', 'E', 'B', 'E'};
        char[] a2 = new char[]{'E', 'B'};
        CollectionToolsTests.assertSame((Object)a1, (Object)CollectionTools.retainAll((char[])a1, (char[])a2));
    }

    public void testRetainAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new int[]{2, 2, 5, 5}, CollectionTools.retainAll((int[])a1, (int[])a2)));
    }

    public void testRetainAllIntArrayIntArray_EmptyIntArray1() {
        int[] a1 = new int[]{};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertSame((Object)a1, (Object)CollectionTools.retainAll((int[])a1, (int[])a2));
    }

    public void testRetainAllIntArrayIntArray_EmptyIntArray2() {
        int[] a1 = new int[]{5, 2};
        int[] a2 = new int[]{};
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.retainAll((int[])a1, (int[])a2).length);
    }

    public void testRetainAllIntArrayIntArray_RetainAll() {
        int[] a1 = new int[]{5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5};
        int[] a2 = new int[]{5, 2};
        CollectionToolsTests.assertSame((Object)a1, (Object)CollectionTools.retainAll((int[])a1, (int[])a2));
    }

    public void testReverseObjectArray_Object() {
        Object[] a = this.buildObjectArray1();
        a = CollectionTools.reverse((Object[])a);
        CollectionToolsTests.assertEquals((Object)"two", (Object)a[0]);
        CollectionToolsTests.assertEquals((Object)"one", (Object)a[1]);
        CollectionToolsTests.assertEquals((Object)"zero", (Object)a[2]);
    }

    public void testReverseObjectArray_String() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.reverse((Object[])a);
        CollectionToolsTests.assertEquals((String)"two", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"one", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[2]);
    }

    public void testReverseCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.reverse((char[])a);
        CollectionToolsTests.assertEquals((char)'c', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testReverseIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.reverse((int[])a);
        CollectionToolsTests.assertEquals((int)20, (int)a[0]);
        CollectionToolsTests.assertEquals((int)10, (int)a[1]);
        CollectionToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testReverseListIterable() {
        List<String> iterable = this.buildStringList1();
        List actual = CollectionTools.reverseList(iterable);
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterableInt() {
        List<String> iterable = this.buildStringList1();
        List actual = CollectionTools.reverseList(iterable, (int)10);
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterator_String() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator());
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterator_Object() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator());
        List<Object> expected = this.buildObjectList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIteratorInt() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator(), (int)33);
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testRotateObjectArray() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.rotate((Object[])a);
        CollectionToolsTests.assertEquals((String)"two", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"one", (String)a[2]);
    }

    public void testRotateObjectArray_Zero() {
        Object[] a1 = new String[]{};
        String[] a2 = (String[])CollectionTools.rotate((Object[])a1);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArray_One() {
        Object[] a1 = new String[]{"foo  "};
        String[] a2 = (String[])CollectionTools.rotate((Object[])a1);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.rotate((Object[])a, (int)2);
        CollectionToolsTests.assertEquals((String)"one", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"two", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[2]);
    }

    public void testRotateObjectArrayInt_ZeroDistance() {
        Object[] a1 = this.buildStringArray1();
        String[] a2 = (String[])CollectionTools.rotate((Object[])a1, (int)0);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArrayInt_Zero() {
        Object[] a1 = new String[]{};
        String[] a2 = (String[])CollectionTools.rotate((Object[])a1, (int)7);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArrayInt_One() {
        Object[] a1 = new String[]{"foo  "};
        String[] a2 = (String[])CollectionTools.rotate((Object[])a1, (int)8);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.rotate((char[])a);
        CollectionToolsTests.assertEquals((char)'c', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testRotateCharArray_Zero() {
        char[] a1 = new char[]{};
        char[] a2 = CollectionTools.rotate((char[])a1);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArray_One() {
        char[] a1 = new char[]{'a'};
        char[] a2 = CollectionTools.rotate((char[])a1);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArrayInt() {
        char[] a = this.buildCharArray();
        a = CollectionTools.rotate((char[])a, (int)2);
        CollectionToolsTests.assertEquals((char)'b', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'c', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testRotateCharArrayInt_ZeroDistance() {
        char[] a1 = new char[]{'a', 'b', 'c'};
        char[] a2 = CollectionTools.rotate((char[])a1, (int)0);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArrayInt_Zero() {
        char[] a1 = new char[]{};
        char[] a2 = CollectionTools.rotate((char[])a1, (int)2001);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArrayInt_One() {
        char[] a1 = new char[]{'a'};
        char[] a2 = CollectionTools.rotate((char[])a1, (int)22);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.rotate((int[])a);
        CollectionToolsTests.assertEquals((int)20, (int)a[0]);
        CollectionToolsTests.assertEquals((int)0, (int)a[1]);
        CollectionToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRotateIntArray_Zero() {
        int[] a1 = new int[]{};
        int[] a2 = CollectionTools.rotate((int[])a1);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArray_One() {
        int[] a1 = new int[]{77};
        int[] a2 = CollectionTools.rotate((int[])a1);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArrayInt() {
        int[] a = this.buildIntArray();
        a = CollectionTools.rotate((int[])a, (int)2);
        CollectionToolsTests.assertEquals((int)10, (int)a[0]);
        CollectionToolsTests.assertEquals((int)20, (int)a[1]);
        CollectionToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testRotateIntArrayInt_ZeroDistance() {
        int[] a1 = new int[]{3, 2, 1};
        int[] a2 = CollectionTools.rotate((int[])a1, (int)0);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArrayInt_Zero() {
        int[] a1 = new int[]{};
        int[] a2 = CollectionTools.rotate((int[])a1, (int)3);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArrayInt_One() {
        int[] a1 = new int[]{77};
        int[] a2 = CollectionTools.rotate((int[])a1, (int)44);
        CollectionToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSetIterable() {
        Set<String> iterable = this.buildStringSet1();
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(iterable));
    }

    public void testSetIterableInt() {
        Set<String> iterable = this.buildStringSet1();
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(iterable, (int)22));
    }

    public void testSetIterator_String() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator()));
    }

    public void testSetIterator_Object() {
        HashSet<String> set1 = new HashSet<String>();
        set1.add("0");
        set1.add("1");
        set1.add("2");
        set1.add("3");
        Set set2 = CollectionTools.set(set1.iterator());
        CollectionToolsTests.assertEquals(set1, (Object)set2);
    }

    public void testSetIteratorInt() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator(), (int)3));
    }

    public void testSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set((Object[])this.buildStringSet1().toArray()));
    }

    public void testShuffleObjectArray() {
        Object[] array1 = this.buildStringArray1();
        Object[] array2 = (String[])CollectionTools.shuffle((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)array1.length, (int)array2.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Object[])array1, (Object[])array2));
    }

    public void testShuffleCharArray() {
        char[] array1 = this.buildCharArray();
        char[] array2 = CollectionTools.shuffle((char[])this.buildCharArray());
        CollectionToolsTests.assertEquals((int)array1.length, (int)array2.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((char[])array1, (char[])array2));
    }

    public void testShuffleIntArray() {
        int[] array1 = this.buildIntArray();
        int[] array2 = CollectionTools.shuffle((int[])this.buildIntArray());
        CollectionToolsTests.assertEquals((int)array1.length, (int)array2.length);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((int[])array1, (int[])array2));
    }

    public void testSingletonIterator_String() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((String)"foo", (String)((String)stream.next()));
    }

    public void testSingletonIterator_Object() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSingletonIterator_Cast() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSizeIterable() {
        List<Object> iterable = this.buildObjectList1();
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.size(iterable));
    }

    public void testSizeIterator() {
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.size(this.buildObjectList1().iterator()));
    }

    public void testSortedSetIterable() {
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.add("0");
        ss1.add("2");
        ss1.add("3");
        ss1.add("1");
        TreeSet<String> iterable = ss1;
        SortedSet set2 = CollectionTools.sortedSet(iterable);
        CollectionToolsTests.assertEquals(ss1, (Object)set2);
    }

    public void testSortedSetIterableInt() {
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.add("0");
        ss1.add("2");
        ss1.add("3");
        ss1.add("1");
        TreeSet<String> iterable = ss1;
        SortedSet set2 = CollectionTools.sortedSet(iterable, (int)5);
        CollectionToolsTests.assertEquals(ss1, (Object)set2);
    }

    public void testSortedSetIterator() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet(this.buildSortedStringSet1().iterator()));
    }

    public void testSortedSetIterator_TreeSet() {
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.add("0");
        ss1.add("2");
        ss1.add("3");
        ss1.add("1");
        SortedSet set2 = CollectionTools.sortedSet(ss1.iterator());
        CollectionToolsTests.assertEquals(ss1, (Object)set2);
    }

    public void testSortedSetIteratorInt() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet(this.buildSortedStringSet1().iterator(), (int)8));
    }

    public void testSortedSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.set((Object[])this.buildSortedStringSet1().toArray()));
    }

    public void testSubArrayObjectArrayIntInt() {
        Object[] array = new String[]{"foo", "bar", "baz", "joo", "jar", "jaz"};
        Object[] result = new String[]{"foo", "bar", "baz", "joo"};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((Object[])array, (int)0, (int)4)));
        result = new String[]{"jar"};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((Object[])array, (int)4, (int)1)));
        result = new String[]{};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((Object[])array, (int)5, (int)0)));
        result = new String[]{"joo", "jar", "jaz"};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((Object[])array, (int)3, (int)3)));
    }

    public void testSubArrayIntArrayIntInt() {
        int[] array = new int[]{77, 99, 333, 4, 9090, 42};
        int[] result = new int[]{77, 99, 333, 4};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((int[])array, (int)0, (int)4)));
        result = new int[]{9090};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((int[])array, (int)4, (int)1)));
        result = new int[]{};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((int[])array, (int)5, (int)0)));
        result = new int[]{4, 9090, 42};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((int[])array, (int)3, (int)3)));
    }

    public void testSubArrayCharArrayIntInt() {
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] result = new char[]{'a', 'b', 'c', 'd'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((char[])array, (int)0, (int)4)));
        result = new char[]{'e'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((char[])array, (int)4, (int)1)));
        result = new char[]{};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((char[])array, (int)5, (int)0)));
        result = new char[]{'d', 'e', 'f'};
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(result, CollectionTools.subArray((char[])array, (int)3, (int)3)));
    }

    public void testSwapObjectArray() {
        Object[] a = this.buildStringArray1();
        a = (String[])CollectionTools.swap((Object[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((String)"zero", (String)a[0]);
        CollectionToolsTests.assertEquals((String)"two", (String)a[1]);
        CollectionToolsTests.assertEquals((String)"one", (String)a[2]);
    }

    public void testSwapCharArray() {
        char[] a = this.buildCharArray();
        a = CollectionTools.swap((char[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((char)'a', (char)a[0]);
        CollectionToolsTests.assertEquals((char)'c', (char)a[1]);
        CollectionToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testSwapIntArray() {
        int[] a = this.buildIntArray();
        a = CollectionTools.swap((int[])a, (int)1, (int)2);
        CollectionToolsTests.assertEquals((int)0, (int)a[0]);
        CollectionToolsTests.assertEquals((int)20, (int)a[1]);
        CollectionToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRemoveDuplicateElementsList() {
        List<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        list = CollectionTools.removeDuplicateElements(list);
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)list.get(i++));
        CollectionToolsTests.assertEquals((String)"one", (String)list.get(i++));
        CollectionToolsTests.assertEquals((String)"two", (String)list.get(i++));
        CollectionToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsList_Empty() {
        List list = new ArrayList();
        list = CollectionTools.removeDuplicateElements(list);
        CollectionToolsTests.assertEquals((int)0, (int)list.size());
    }

    public void testRemoveDuplicateElementsList_SingleElement() {
        List list = new ArrayList<String>();
        list.add("zero");
        list = CollectionTools.removeDuplicateElements(list);
        CollectionToolsTests.assertEquals((int)1, (int)list.size());
    }

    public void testRemoveDuplicateElementsObjectArray() {
        Vector<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        String[] array = (String[])CollectionTools.removeDuplicateElements((Object[])list.toArray(new String[list.size()]));
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"one", (String)array[i++]);
        CollectionToolsTests.assertEquals((String)"two", (String)array[i++]);
        CollectionToolsTests.assertEquals((int)i, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray_Empty() {
        String[] array = (String[])CollectionTools.removeDuplicateElements((Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)0, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray_SingleElement() {
        String[] array = (String[])CollectionTools.removeDuplicateElements((Object[])new String[]{"foo"});
        CollectionToolsTests.assertEquals((int)1, (int)array.length);
    }

    public void testVectorIterable() {
        List<String> iterable = this.buildStringList1();
        Vector v = CollectionTools.vector(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterableInt() {
        List<String> iterable = this.buildStringList1();
        Vector v = CollectionTools.vector(iterable, (int)8);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator_String() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator_Object() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIteratorInt() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator(), (int)7);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorObjectArray() {
        Vector v = CollectionTools.vector((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private char[] buildCharArray() {
        return new char[]{'a', 'b', 'c'};
    }

    private int[] buildIntArray() {
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 20;
        return nArray;
    }

    private Object[] buildObjectArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private String[] buildStringArray2() {
        return new String[]{"three", "four", "five"};
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }

    private Set<String> buildStringSet1() {
        HashSet<String> s = new HashSet<String>();
        this.addToCollection1(s);
        return s;
    }

    private Set<Object> buildObjectSet1() {
        HashSet<Object> s = new HashSet<Object>();
        this.addToCollection1(s);
        return s;
    }

    private SortedSet<String> buildSortedStringSet1() {
        TreeSet<String> s = new TreeSet<String>();
        this.addToCollection1(s);
        return s;
    }
}

