/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model;

import java.io.Serializable;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractModelTests
extends TestCase
implements StateChangeListener,
PropertyChangeListener,
CollectionChangeListener,
ListChangeListener,
TreeChangeListener {
    private TestModel testModel;
    private static final String TEST_TO_STRING = "this is a test";
    private StateChangeEvent stateChangeEvent;
    private boolean stateChangedCalled = false;
    private PropertyChangeEvent propertyChangeEvent;
    private boolean propertyChangeCalled = false;
    private static final String PROPERTY_NAME = "propertyName";
    static final Object OLD_OBJECT_VALUE = new Object();
    static final Object NEW_OBJECT_VALUE = new Object();
    static final Integer OLD_INT_VALUE = new Integer(27);
    static final Integer NEW_INT_VALUE = new Integer(42);
    static final Boolean OLD_BOOLEAN_VALUE = Boolean.TRUE;
    static final Boolean NEW_BOOLEAN_VALUE = Boolean.FALSE;
    private CollectionChangeEvent collectionChangeEvent;
    private boolean itemsAddedCollectionCalled = false;
    private boolean itemsRemovedCollectionCalled = false;
    private boolean collectionChangedCalled = false;
    private boolean collectionClearedCalled = false;
    private static final String COLLECTION_NAME = "collectionName";
    static final Object ADDED_OBJECT_VALUE = new Object();
    static final Object REMOVED_OBJECT_VALUE = new Object();
    static final int TARGET_INDEX = 7;
    static final int SOURCE_INDEX = 22;
    private ListChangeEvent listChangeEvent;
    private boolean itemsAddedListCalled = false;
    private boolean itemsRemovedListCalled = false;
    private boolean itemsReplacedListCalled = false;
    private boolean itemsMovedListCalled = false;
    private boolean listChangedCalled = false;
    private boolean listClearedCalled = false;
    private static final String LIST_NAME = "listName";
    private static final int ADD_INDEX = 3;
    private static final int REMOVE_INDEX = 5;
    private static final int REPLACE_INDEX = 2;
    private TreeChangeEvent treeChangeEvent;
    private boolean nodeAddedCalled = false;
    private boolean nodeRemovedCalled = false;
    private boolean treeChangedCalled = false;
    private boolean treeClearedCalled = false;
    private static final String TREE_NAME = "treeName";
    static final Object[] OBJECT_ARRAY_PATH = new Object[]{new Object(), new Object(), new String()};
    static final Object[] EMPTY_PATH = new Object[0];
    private static final String ISE_MESSAGE = "this object is no longer listening to localA";

    public AbstractModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testModel = new TestModel();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testFireStateChange() {
        this.stateChangeEvent = null;
        this.stateChangedCalled = false;
        this.testModel.addStateChangeListener(this);
        this.testModel.testFireStateChange();
        AbstractModelTests.assertNotNull((Object)this.stateChangeEvent);
        AbstractModelTests.assertEquals((Object)this.testModel, (Object)this.stateChangeEvent.getSource());
        AbstractModelTests.assertTrue((boolean)this.stateChangedCalled);
    }

    public void testFirePropertyChangeObjectObject() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangeObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangeObjectObject();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeObjectObject();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangeObject() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangeObject();
        this.verifyPropertyChangeEvent(null, NEW_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangeObject();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeObject();
        this.verifyPropertyChangeEvent(null, NEW_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeObject();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangeIntInt() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangeIntInt();
        this.verifyPropertyChangeEvent(OLD_INT_VALUE, NEW_INT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangeIntInt();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeIntInt();
        this.verifyPropertyChangeEvent(OLD_INT_VALUE, NEW_INT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeIntInt();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFirePropertyChangeBooleanBoolean() {
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(this);
        this.testModel.testFirePropertyChangeBooleanBoolean();
        this.verifyPropertyChangeEvent(OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(this);
        this.testModel.testFirePropertyChangeBooleanBoolean();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeBooleanBoolean();
        this.verifyPropertyChangeEvent(OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        this.testModel.testFirePropertyChangeBooleanBoolean();
        AbstractModelTests.assertNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.propertyChangeCalled);
    }

    public void testFireItemAddedCollection() {
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemAddedCollection();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemAddedCollection();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemAddedCollection();
        this.verifyCollectionChangeEvent(ADDED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsAddedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsAddedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemAddedCollection();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsAddedCollectionCalled);
    }

    public void testFireItemRemovedCollection() {
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireItemRemovedCollection();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireItemRemovedCollection();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemRemovedCollection();
        this.verifyCollectionChangeEvent(REMOVED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsRemovedCollectionCalled);
        this.collectionChangeEvent = null;
        this.itemsRemovedCollectionCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireItemRemovedCollection();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsRemovedCollectionCalled);
    }

    public void testFireCollectionCleared() {
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireCollectionCleared();
        this.verifyCollectionChangeEvent(null);
        AbstractModelTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireCollectionCleared();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionCleared();
        this.verifyCollectionChangeEvent(null);
        AbstractModelTests.assertTrue((boolean)this.collectionClearedCalled);
        this.collectionChangeEvent = null;
        this.collectionClearedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionCleared();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.collectionClearedCalled);
    }

    public void testFireCollectionChanged() {
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(this);
        this.testModel.testFireCollectionChanged();
        this.verifyCollectionChangeEvent(null);
        AbstractModelTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(this);
        this.testModel.testFireCollectionChanged();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionChanged();
        this.verifyCollectionChangeEvent(null);
        AbstractModelTests.assertTrue((boolean)this.collectionChangedCalled);
        this.collectionChangeEvent = null;
        this.collectionChangedCalled = false;
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        this.testModel.testFireCollectionChanged();
        AbstractModelTests.assertNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.collectionChangedCalled);
    }

    public void testFireItemAddedList() {
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemAddedList();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemAddedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemAddedList();
        this.verifyListChangeEvent(3, ADDED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsAddedListCalled);
        this.listChangeEvent = null;
        this.itemsAddedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemAddedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsAddedListCalled);
    }

    public void testFireItemRemovedList() {
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemRemovedList();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemRemovedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemRemovedList();
        this.verifyListChangeEvent(5, REMOVED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsRemovedListCalled);
        this.listChangeEvent = null;
        this.itemsRemovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemRemovedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsRemovedListCalled);
    }

    public void testFireItemReplacedList() {
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemReplacedList();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemReplacedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemReplacedList();
        this.verifyListChangeEvent(2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.itemsReplacedListCalled);
        this.listChangeEvent = null;
        this.itemsReplacedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemReplacedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsReplacedListCalled);
    }

    public void testFireItemMovedList() {
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireItemMovedList();
        this.verifyListChangeEvent(7, 22);
        AbstractModelTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireItemMovedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemMovedList();
        this.verifyListChangeEvent(7, 22);
        AbstractModelTests.assertTrue((boolean)this.itemsMovedListCalled);
        this.listChangeEvent = null;
        this.itemsMovedListCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireItemMovedList();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.itemsMovedListCalled);
    }

    public void testFireListCleared() {
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireListCleared();
        this.verifyListChangeEvent(-1, null);
        AbstractModelTests.assertTrue((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireListCleared();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireListCleared();
        this.verifyListChangeEvent(-1, null);
        AbstractModelTests.assertTrue((boolean)this.listClearedCalled);
        this.listChangeEvent = null;
        this.listClearedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireListCleared();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.listClearedCalled);
    }

    public void testFireListChanged() {
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(this);
        this.testModel.testFireListChanged();
        this.verifyListChangeEvent(-1, null);
        AbstractModelTests.assertTrue((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(this);
        this.testModel.testFireListChanged();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.addListChangeListener(LIST_NAME, this);
        this.testModel.testFireListChanged();
        this.verifyListChangeEvent(-1, null);
        AbstractModelTests.assertTrue((boolean)this.listChangedCalled);
        this.listChangeEvent = null;
        this.listChangedCalled = false;
        this.testModel.removeListChangeListener(LIST_NAME, this);
        this.testModel.testFireListChanged();
        AbstractModelTests.assertNull((Object)this.listChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.listChangedCalled);
    }

    public void testFireNodeAddedObjectArrayPath() {
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireNodeAddedObjectArrayPath();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        AbstractModelTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireNodeAddedObjectArrayPath();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeAddedObjectArrayPath();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        AbstractModelTests.assertTrue((boolean)this.nodeAddedCalled);
        this.treeChangeEvent = null;
        this.nodeAddedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeAddedObjectArrayPath();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.nodeAddedCalled);
    }

    public void testFireNodeRemovedObjectArrayPath() {
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireNodeRemovedObjectArrayPath();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        AbstractModelTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireNodeRemovedObjectArrayPath();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeRemovedObjectArrayPath();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        AbstractModelTests.assertTrue((boolean)this.nodeRemovedCalled);
        this.treeChangeEvent = null;
        this.nodeRemovedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireNodeRemovedObjectArrayPath();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.nodeRemovedCalled);
    }

    public void testFireTreeCleared() {
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireTreeCleared();
        this.verifyTreeChangeEvent(EMPTY_PATH);
        AbstractModelTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireTreeCleared();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeCleared();
        this.verifyTreeChangeEvent(EMPTY_PATH);
        AbstractModelTests.assertTrue((boolean)this.treeClearedCalled);
        this.treeChangeEvent = null;
        this.treeClearedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeCleared();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.treeClearedCalled);
    }

    public void testFireTreeChangedObjectArrayPath() {
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(this);
        this.testModel.testFireTreeChangedObjectArrayPath();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        AbstractModelTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(this);
        this.testModel.testFireTreeChangedObjectArrayPath();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeChangedObjectArrayPath();
        this.verifyTreeChangeEvent(OBJECT_ARRAY_PATH);
        AbstractModelTests.assertTrue((boolean)this.treeChangedCalled);
        this.treeChangeEvent = null;
        this.treeChangedCalled = false;
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
        this.testModel.testFireTreeChangedObjectArrayPath();
        AbstractModelTests.assertNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertFalse((boolean)this.treeChangedCalled);
    }

    public void testHasAnyChangeListeners() {
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.removePropertyChangeListener(this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(PROPERTY_NAME, this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.removePropertyChangeListener(PROPERTY_NAME, this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.addCollectionChangeListener(this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.removeCollectionChangeListener(this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.addCollectionChangeListener(COLLECTION_NAME, this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyCollectionChangeListeners(COLLECTION_NAME));
        this.testModel.removeCollectionChangeListener(COLLECTION_NAME, this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.addListChangeListener(this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.removeListChangeListener(this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.addListChangeListener(LIST_NAME, this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyListChangeListeners(LIST_NAME));
        this.testModel.removeListChangeListener(LIST_NAME, this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.addTreeChangeListener(this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.removeTreeChangeListener(this);
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.addTreeChangeListener(TREE_NAME, this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyTreeChangeListeners(TREE_NAME));
        this.testModel.removeTreeChangeListener(TREE_NAME, this);
    }

    public void testAttributeValueHasChanged() {
        this.testModel.testAttributeValueHasChanged();
    }

    public void testClone() {
        AbstractModelTests.assertFalse((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.testModel.addPropertyChangeListener(this);
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        TestModel clone = this.testModel.clone();
        AbstractModelTests.assertFalse((boolean)clone.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        clone.addPropertyChangeListener(this);
        AbstractModelTests.assertTrue((boolean)clone.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        AbstractModelTests.assertTrue((boolean)this.testModel.hasAnyPropertyChangeListeners(PROPERTY_NAME));
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        this.testModel.testFirePropertyChangeObjectObject();
        this.verifyPropertyChangeEvent(OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
        this.propertyChangeEvent = null;
        this.propertyChangeCalled = false;
        clone.testFirePropertyChangeObjectObject();
        this.verifyPropertyChangeEvent(clone, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        AbstractModelTests.assertTrue((boolean)this.propertyChangeCalled);
    }

    public void testAddNullStateListener() {
        boolean exCaught = false;
        try {
            this.testModel.addStateChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullPropertyListener() {
        boolean exCaught = false;
        try {
            this.testModel.addPropertyChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullCollectionListener() {
        boolean exCaught = false;
        try {
            this.testModel.addCollectionChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullListListener() {
        boolean exCaught = false;
        try {
            this.testModel.addListChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullTreeListener() {
        boolean exCaught = false;
        try {
            this.testModel.addTreeChangeListener(null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullPropertyListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addPropertyChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullCollectionListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addCollectionChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullListListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addListChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testAddNullTreeListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.addTreeChangeListener("foo", null);
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusStateListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeStateChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addStateChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeStateChangeListener(new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusPropertyListener() {
        boolean exCaught = false;
        try {
            this.testModel.removePropertyChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener(new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusCollectionListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener(new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusListListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeListChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addListChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener(new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusTreeListener() {
        boolean exCaught = false;
        try {
            this.testModel.removeTreeChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener(this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addTreeChangeListener(this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener(new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusPropertyListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removePropertyChangeListener("foo", new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusCollectionListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addCollectionChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeCollectionChangeListener("foo", new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusListListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addListChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeListChangeListener("foo", new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveBogusTreeListenerName() {
        boolean exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addPropertyChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
        this.testModel.addTreeChangeListener("foo", this);
        exCaught = false;
        try {
            this.testModel.removeTreeChangeListener("foo", new AbstractModelTests("dummy"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractModelTests.assertTrue((boolean)exCaught);
    }

    public void testToString() {
        AbstractModelTests.assertTrue((this.testModel.toString().indexOf(TEST_TO_STRING) != -1 ? 1 : 0) != 0);
    }

    private void verifyPropertyChangeEvent(Object oldValue, Object newValue) {
        this.verifyPropertyChangeEvent(this.testModel, oldValue, newValue);
    }

    private void verifyPropertyChangeEvent(Object source, Object oldValue, Object newValue) {
        AbstractModelTests.assertNotNull((Object)this.propertyChangeEvent);
        AbstractModelTests.assertEquals((Object)source, (Object)this.propertyChangeEvent.getSource());
        AbstractModelTests.assertEquals((String)PROPERTY_NAME, (String)this.propertyChangeEvent.getPropertyName());
        AbstractModelTests.assertEquals((Object)oldValue, (Object)this.propertyChangeEvent.getOldValue());
        AbstractModelTests.assertEquals((Object)newValue, (Object)this.propertyChangeEvent.getNewValue());
    }

    private void verifyCollectionChangeEvent(Object item) {
        AbstractModelTests.assertNotNull((Object)this.collectionChangeEvent);
        AbstractModelTests.assertEquals((Object)this.testModel, (Object)this.collectionChangeEvent.getSource());
        AbstractModelTests.assertEquals((String)COLLECTION_NAME, (String)this.collectionChangeEvent.getCollectionName());
        if (item == null) {
            AbstractModelTests.assertFalse((boolean)this.collectionChangeEvent.items().hasNext());
        } else {
            AbstractModelTests.assertEquals((Object)item, this.collectionChangeEvent.items().next());
        }
    }

    private void verifyListChangeEvent(int index, Object item) {
        this.verifyListChangeEvent(index, item, null);
    }

    private void verifyListChangeEvent(int targetIndex, int sourceIndex) {
        AbstractModelTests.assertNotNull((Object)this.listChangeEvent);
        AbstractModelTests.assertEquals((Object)this.testModel, (Object)this.listChangeEvent.getSource());
        AbstractModelTests.assertEquals((String)LIST_NAME, (String)this.listChangeEvent.getListName());
        AbstractModelTests.assertEquals((int)targetIndex, (int)this.listChangeEvent.getTargetIndex());
        AbstractModelTests.assertEquals((int)sourceIndex, (int)this.listChangeEvent.getSourceIndex());
    }

    private void verifyListChangeEvent(int index, Object item, Object replacedItem) {
        AbstractModelTests.assertNotNull((Object)this.listChangeEvent);
        AbstractModelTests.assertEquals((Object)this.testModel, (Object)this.listChangeEvent.getSource());
        AbstractModelTests.assertEquals((String)LIST_NAME, (String)this.listChangeEvent.getListName());
        AbstractModelTests.assertEquals((int)index, (int)this.listChangeEvent.getIndex());
        if (item == null) {
            AbstractModelTests.assertFalse((boolean)this.listChangeEvent.items().hasNext());
        } else {
            AbstractModelTests.assertEquals((Object)item, this.listChangeEvent.items().next());
        }
        if (replacedItem == null) {
            AbstractModelTests.assertFalse((boolean)this.listChangeEvent.replacedItems().hasNext());
        } else {
            AbstractModelTests.assertEquals((Object)replacedItem, this.listChangeEvent.replacedItems().next());
        }
    }

    private void verifyTreeChangeEvent(Object[] path) {
        AbstractModelTests.assertNotNull((Object)this.treeChangeEvent);
        AbstractModelTests.assertEquals((Object)this.testModel, (Object)this.treeChangeEvent.getSource());
        AbstractModelTests.assertEquals((String)TREE_NAME, (String)this.treeChangeEvent.getTreeName());
        AbstractModelTests.assertTrue((boolean)Arrays.equals(path, this.treeChangeEvent.getPath()));
    }

    public void stateChanged(StateChangeEvent e) {
        this.stateChangedCalled = true;
        this.stateChangeEvent = e;
    }

    public void propertyChanged(PropertyChangeEvent e) {
        this.propertyChangeCalled = true;
        this.propertyChangeEvent = e;
    }

    public void itemsAdded(CollectionChangeEvent e) {
        this.itemsAddedCollectionCalled = true;
        this.collectionChangeEvent = e;
    }

    public void itemsRemoved(CollectionChangeEvent e) {
        this.itemsRemovedCollectionCalled = true;
        this.collectionChangeEvent = e;
    }

    public void collectionCleared(CollectionChangeEvent e) {
        this.collectionClearedCalled = true;
        this.collectionChangeEvent = e;
    }

    public void collectionChanged(CollectionChangeEvent e) {
        this.collectionChangedCalled = true;
        this.collectionChangeEvent = e;
    }

    public void itemsAdded(ListChangeEvent e) {
        this.itemsAddedListCalled = true;
        this.listChangeEvent = e;
    }

    public void itemsRemoved(ListChangeEvent e) {
        this.itemsRemovedListCalled = true;
        this.listChangeEvent = e;
    }

    public void itemsReplaced(ListChangeEvent e) {
        this.itemsReplacedListCalled = true;
        this.listChangeEvent = e;
    }

    public void itemsMoved(ListChangeEvent e) {
        this.itemsMovedListCalled = true;
        this.listChangeEvent = e;
    }

    public void listCleared(ListChangeEvent e) {
        this.listClearedCalled = true;
        this.listChangeEvent = e;
    }

    public void listChanged(ListChangeEvent e) {
        this.listChangedCalled = true;
        this.listChangeEvent = e;
    }

    public void nodeAdded(TreeChangeEvent e) {
        this.nodeAddedCalled = true;
        this.treeChangeEvent = e;
    }

    public void nodeRemoved(TreeChangeEvent e) {
        this.nodeRemovedCalled = true;
        this.treeChangeEvent = e;
    }

    public void treeCleared(TreeChangeEvent e) {
        this.treeClearedCalled = true;
        this.treeChangeEvent = e;
    }

    public void treeChanged(TreeChangeEvent e) {
        this.treeChangedCalled = true;
        this.treeChangeEvent = e;
    }

    private ChangeListener[] listeners(LocalModel model, Class<? extends ChangeListener> listenerClass) {
        ChangeSupport changeSupport = (ChangeSupport)ClassTools.fieldValue((Object)model, (String)"changeSupport");
        return (ChangeListener[])ClassTools.executeMethod((Object)changeSupport, (String)"listeners", Class.class, listenerClass);
    }

    public void testIndirectRemoveStateListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyStateListeners();
            }
        });
    }

    public void testIndirectRemovePropertyListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyPropertyListeners();
            }
        });
    }

    public void testIndirectRemoveCollectionListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyCollectionListeners();
            }
        });
    }

    public void testIndirectRemoveListListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyListListeners();
            }
        });
    }

    public void testIndirectRemoveTreeListener() {
        this.verifyIndirectRemoveListener(new NotifyCommand(){

            public void notifyListeners(LocalA localA) {
                localA.notifyTreeListeners();
            }
        });
    }

    public void verifyIndirectRemoveListener(NotifyCommand command) {
        LocalA localA = new LocalA();
        LocalB localB = new LocalB(localA);
        LocalC[] localCs = new LocalC[1000];
        int i = localCs.length;
        while (i-- > 0) {
            localCs[i] = new LocalC(localA, localB);
        }
        boolean exCaught = false;
        try {
            command.notifyListeners(localA);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() == ISE_MESSAGE) {
                exCaught = true;
            }
            throw ex;
        }
        AbstractModelTests.assertFalse((boolean)exCaught);
        int i2 = localCs.length;
        while (i2-- > 0) {
            AbstractModelTests.assertFalse((boolean)localCs[i2].isListeningToLocalA());
        }
    }

    private static class Bar
    implements StateChangeListener {
        Bar() {
        }

        public void stateChanged(StateChangeEvent event) {
        }
    }

    private static class Foo
    implements Serializable,
    StateChangeListener {
        Foo() {
        }

        public void stateChanged(StateChangeEvent event) {
        }
    }

    private static class Jar
    extends ListChangeAdapter {
        Jar() {
        }
    }

    private static class Joo
    extends ListChangeAdapter
    implements Serializable {
        Joo() {
        }
    }

    private static class LocalA
    extends AbstractModel {
        LocalA() {
        }

        void notifyStateListeners() {
            this.fireStateChanged();
        }

        void notifyPropertyListeners() {
            this.firePropertyChanged("foo", 1, 2);
        }

        void notifyCollectionListeners() {
            this.fireCollectionChanged("foo");
        }

        void notifyListListeners() {
            this.fireListChanged("foo");
        }

        void notifyTreeListeners() {
            this.fireTreeChanged("foo");
        }
    }

    private static class LocalB
    extends AbstractModel
    implements StateChangeListener,
    PropertyChangeListener,
    CollectionChangeListener,
    ListChangeListener,
    TreeChangeListener {
        LocalB(LocalA localA) {
            localA.addStateChangeListener(this);
            localA.addPropertyChangeListener(this);
            localA.addCollectionChangeListener(this);
            localA.addListChangeListener(this);
            localA.addTreeChangeListener(this);
        }

        public void stateChanged(StateChangeEvent e) {
            this.fireStateChanged();
        }

        public void propertyChanged(PropertyChangeEvent evt) {
            this.firePropertyChanged("bar", 1, 2);
        }

        public void collectionChanged(CollectionChangeEvent e) {
            this.fireCollectionChanged("bar");
        }

        public void collectionCleared(CollectionChangeEvent e) {
        }

        public void itemsAdded(CollectionChangeEvent e) {
        }

        public void itemsRemoved(CollectionChangeEvent e) {
        }

        public void listChanged(ListChangeEvent e) {
            this.fireListChanged("bar");
        }

        public void listCleared(ListChangeEvent e) {
        }

        public void itemsAdded(ListChangeEvent e) {
        }

        public void itemsRemoved(ListChangeEvent e) {
        }

        public void itemsReplaced(ListChangeEvent e) {
        }

        public void itemsMoved(ListChangeEvent e) {
        }

        public void treeChanged(TreeChangeEvent e) {
            this.fireTreeChanged("bar");
        }

        public void treeCleared(TreeChangeEvent e) {
        }

        public void nodeAdded(TreeChangeEvent e) {
        }

        public void nodeRemoved(TreeChangeEvent e) {
        }
    }

    private static class LocalC
    extends AbstractModel
    implements StateChangeListener,
    PropertyChangeListener,
    CollectionChangeListener,
    ListChangeListener,
    TreeChangeListener {
        private LocalA localA;
        private LocalB localB;
        private boolean listeningToLocalA;

        LocalC(LocalA localA, LocalB localB) {
            this.localA = localA;
            this.localB = localB;
            localA.addStateChangeListener(this);
            localA.addPropertyChangeListener(this);
            localA.addCollectionChangeListener(this);
            localA.addListChangeListener(this);
            localA.addTreeChangeListener(this);
            this.listeningToLocalA = true;
            localB.addStateChangeListener(this);
            localB.addPropertyChangeListener(this);
            localB.addCollectionChangeListener(this);
            localB.addListChangeListener(this);
            localB.addTreeChangeListener(this);
        }

        boolean isListeningToLocalA() {
            return this.listeningToLocalA;
        }

        public void stateChanged(StateChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(AbstractModelTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeStateChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void propertyChanged(PropertyChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(AbstractModelTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removePropertyChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void collectionChanged(CollectionChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(AbstractModelTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeCollectionChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void collectionCleared(CollectionChangeEvent e) {
        }

        public void itemsAdded(CollectionChangeEvent e) {
        }

        public void itemsRemoved(CollectionChangeEvent e) {
        }

        public void listChanged(ListChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(AbstractModelTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeListChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void listCleared(ListChangeEvent e) {
        }

        public void itemsAdded(ListChangeEvent e) {
        }

        public void itemsRemoved(ListChangeEvent e) {
        }

        public void itemsReplaced(ListChangeEvent e) {
        }

        public void itemsMoved(ListChangeEvent e) {
        }

        public void treeChanged(TreeChangeEvent e) {
            Model source = e.getSource();
            if (source == this.localA) {
                if (!this.listeningToLocalA) {
                    throw new IllegalStateException(AbstractModelTests.ISE_MESSAGE);
                }
            } else if (source == this.localB) {
                this.localA.removeTreeChangeListener(this);
                this.listeningToLocalA = false;
            } else {
                throw new IllegalStateException("bogus event source: " + source);
            }
        }

        public void treeCleared(TreeChangeEvent e) {
        }

        public void nodeAdded(TreeChangeEvent e) {
        }

        public void nodeRemoved(TreeChangeEvent e) {
        }
    }

    private static class LocalModel
    extends AbstractModel
    implements Serializable {
        LocalModel() {
        }
    }

    private static interface NotifyCommand {
        public void notifyListeners(LocalA var1);
    }

    private static class TestModel
    extends AbstractModel
    implements Cloneable {
        TestModel() {
        }

        public void testFireStateChange() {
            this.fireStateChanged();
        }

        public void testFirePropertyChangeObjectObject() {
            this.firePropertyChanged(AbstractModelTests.PROPERTY_NAME, OLD_OBJECT_VALUE, NEW_OBJECT_VALUE);
        }

        public void testFirePropertyChangeObject() {
            this.firePropertyChanged(AbstractModelTests.PROPERTY_NAME, NEW_OBJECT_VALUE);
        }

        public void testFirePropertyChangeIntInt() {
            this.firePropertyChanged(AbstractModelTests.PROPERTY_NAME, OLD_INT_VALUE, NEW_INT_VALUE);
        }

        public void testFirePropertyChangeBooleanBoolean() {
            this.firePropertyChanged(AbstractModelTests.PROPERTY_NAME, OLD_BOOLEAN_VALUE, NEW_BOOLEAN_VALUE);
        }

        public void testFireItemAddedCollection() {
            this.fireItemAdded(AbstractModelTests.COLLECTION_NAME, ADDED_OBJECT_VALUE);
        }

        public void testFireItemRemovedCollection() {
            this.fireItemRemoved(AbstractModelTests.COLLECTION_NAME, REMOVED_OBJECT_VALUE);
        }

        public void testFireCollectionCleared() {
            this.fireCollectionCleared(AbstractModelTests.COLLECTION_NAME);
        }

        public void testFireCollectionChanged() {
            this.fireCollectionChanged(AbstractModelTests.COLLECTION_NAME);
        }

        public void testFireItemAddedList() {
            this.fireItemAdded(AbstractModelTests.LIST_NAME, 3, ADDED_OBJECT_VALUE);
        }

        public void testFireItemRemovedList() {
            this.fireItemRemoved(AbstractModelTests.LIST_NAME, 5, REMOVED_OBJECT_VALUE);
        }

        public void testFireItemReplacedList() {
            this.fireItemReplaced(AbstractModelTests.LIST_NAME, 2, ADDED_OBJECT_VALUE, REMOVED_OBJECT_VALUE);
        }

        public void testFireItemMovedList() {
            this.fireItemMoved(AbstractModelTests.LIST_NAME, 7, 22);
        }

        public void testFireListCleared() {
            this.fireListCleared(AbstractModelTests.LIST_NAME);
        }

        public void testFireListChanged() {
            this.fireListChanged(AbstractModelTests.LIST_NAME);
        }

        public void testFireNodeAddedObjectArrayPath() {
            this.fireNodeAdded(AbstractModelTests.TREE_NAME, OBJECT_ARRAY_PATH);
        }

        public void testFireNodeRemovedObjectArrayPath() {
            this.fireNodeRemoved(AbstractModelTests.TREE_NAME, OBJECT_ARRAY_PATH);
        }

        public void testFireTreeCleared() {
            this.fireTreeCleared(AbstractModelTests.TREE_NAME);
        }

        public void testFireTreeChangedObjectArrayPath() {
            this.fireTreeChanged(AbstractModelTests.TREE_NAME, OBJECT_ARRAY_PATH);
        }

        public void testAttributeValueHasChanged() {
            AbstractModelTests.assertTrue((boolean)this.attributeValueHasChanged(null, new Object()));
            AbstractModelTests.assertTrue((boolean)this.attributeValueHasChanged(new Object(), null));
            AbstractModelTests.assertTrue((boolean)this.attributeValueHasChanged(new Object(), new Object()));
            Object same = new Object();
            AbstractModelTests.assertFalse((boolean)this.attributeValueHasChanged(same, same));
            AbstractModelTests.assertFalse((boolean)this.attributeValueHasChanged(null, null));
        }

        public TestModel clone() {
            try {
                return (TestModel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public void toString(StringBuilder sb) {
            sb.append(AbstractModelTests.TEST_TO_STRING);
        }
    }
}

