/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.ExtendedListValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedListValueModelWrapperTests
extends TestCase {
    private SimpleListValueModel<String> listHolder;
    private ListValueModel<String> extendedListHolder;
    ListChangeEvent event;
    String eventType;
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String REPLACE = "replace";
    private static final String MOVE = "move";
    private static final String CLEAR = "clear";
    private static final String CHANGE = "change";

    public ExtendedListValueModelWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.listHolder = new SimpleListValueModel(this.buildList());
        this.extendedListHolder = this.buildExtendedListHolder((ListValueModel<String>)this.listHolder);
    }

    private List<String> buildList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("A");
        result.add("B");
        result.add("C");
        result.add("D");
        return result;
    }

    private List<String> buildExtendedList() {
        ArrayList<String> extendedList = new ArrayList<String>();
        extendedList.addAll(this.buildPrefix());
        extendedList.addAll(this.buildList());
        extendedList.addAll(this.buildSuffix());
        return extendedList;
    }

    private List<String> buildPrefix() {
        ArrayList<String> prefix = new ArrayList<String>();
        prefix.add("x");
        prefix.add("y");
        prefix.add("z");
        return prefix;
    }

    private List<String> buildSuffix() {
        ArrayList<String> suffix = new ArrayList<String>();
        suffix.add("i");
        suffix.add("j");
        return suffix;
    }

    private ListValueModel<String> buildExtendedListHolder(ListValueModel<String> lvm) {
        return new ExtendedListValueModelWrapper(this.buildPrefix(), lvm, this.buildSuffix());
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        ExtendedListValueModelWrapperTests.assertEquals(this.buildExtendedList(), (Object)CollectionTools.list((Iterator)this.extendedListHolder.iterator()));
    }

    public void testSize() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        ExtendedListValueModelWrapperTests.assertEquals((int)this.buildExtendedList().size(), (int)CollectionTools.size((Iterator)this.extendedListHolder.iterator()));
        ExtendedListValueModelWrapperTests.assertEquals((int)this.buildExtendedList().size(), (int)this.extendedListHolder.size());
    }

    private boolean extendedListContains(Object item) {
        return CollectionTools.contains((Iterator)this.extendedListHolder.iterator(), (Object)item);
    }

    private boolean extendedListContainsAll(Collection<String> items) {
        return CollectionTools.containsAll((Iterator)this.extendedListHolder.iterator(), items);
    }

    private boolean extendedListContainsAny(Collection<String> items) {
        List extendedList = CollectionTools.list((Iterator)this.extendedListHolder.iterator());
        Iterator<String> stream = items.iterator();
        while (stream.hasNext()) {
            if (!extendedList.contains(stream.next())) continue;
            return true;
        }
        return false;
    }

    private boolean listContains(Object item) {
        return CollectionTools.contains((Iterator)this.listHolder.iterator(), (Object)item);
    }

    private boolean listContainsAll(Collection<String> items) {
        return CollectionTools.containsAll((Iterator)this.listHolder.iterator(), items);
    }

    public void testAdd1() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.extendedListContains("E"));
        this.listHolder.add(4, (Object)"E");
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.extendedListContains("E"));
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.listContains("E"));
    }

    public void testAdd2() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.extendedListContains(null));
        this.listHolder.add(4, null);
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.extendedListContains(null));
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.listContains(null));
    }

    private List<String> buildAddList() {
        ArrayList<String> addList = new ArrayList<String>();
        addList.add("E");
        addList.add("F");
        return addList;
    }

    public void testAddAll1() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.extendedListContainsAny(this.buildAddList()));
        this.listHolder.addAll(4, this.buildAddList());
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.extendedListContainsAll(this.buildAddList()));
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.listContainsAll(this.buildAddList()));
    }

    public void testRemove1() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.extendedListContains("B"));
        this.listHolder.remove(this.buildList().indexOf("B"));
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.extendedListContains("B"));
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.listContains("B"));
    }

    public void testListChangeGeneric() {
        this.extendedListHolder.addListChangeListener(this.buildListener());
        this.verifyListChange();
    }

    public void testListChangeNamed() {
        this.extendedListHolder.addListChangeListener("list values", this.buildListener());
        this.verifyListChange();
    }

    private void verifyListChange() {
        this.event = null;
        this.eventType = null;
        this.listHolder.add(4, (Object)"E");
        this.verifyEvent(ADD, 7, "E");
        this.event = null;
        this.eventType = null;
        this.listHolder.add(5, null);
        this.verifyEvent(ADD, 8, null);
        this.event = null;
        this.eventType = null;
        this.listHolder.remove(5);
        this.verifyEvent(REMOVE, 8, null);
        this.event = null;
        this.eventType = null;
        this.listHolder.remove(4);
        this.verifyEvent(REMOVE, 7, "E");
        this.event = null;
        this.eventType = null;
        this.listHolder.addAll(0, this.buildList());
        this.verifyEvent(ADD);
        ExtendedListValueModelWrapperTests.assertEquals(this.buildList(), (Object)CollectionTools.list((Iterator)this.event.items()));
        this.event = null;
        this.eventType = null;
        this.listHolder.set(0, (Object)"AA");
        this.verifyEvent(REPLACE);
        ExtendedListValueModelWrapperTests.assertFalse((boolean)CollectionTools.contains((Iterator)this.event.items(), (Object)"A"));
        ExtendedListValueModelWrapperTests.assertTrue((boolean)CollectionTools.contains((Iterator)this.event.items(), (Object)"AA"));
    }

    private ListChangeListener buildListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ExtendedListValueModelWrapperTests.this.eventType = ExtendedListValueModelWrapperTests.ADD;
                ExtendedListValueModelWrapperTests.this.event = e;
            }

            public void itemsRemoved(ListChangeEvent e) {
                ExtendedListValueModelWrapperTests.this.eventType = ExtendedListValueModelWrapperTests.REMOVE;
                ExtendedListValueModelWrapperTests.this.event = e;
            }

            public void itemsReplaced(ListChangeEvent e) {
                ExtendedListValueModelWrapperTests.this.eventType = ExtendedListValueModelWrapperTests.REPLACE;
                ExtendedListValueModelWrapperTests.this.event = e;
            }

            public void itemsMoved(ListChangeEvent e) {
                ExtendedListValueModelWrapperTests.this.eventType = ExtendedListValueModelWrapperTests.MOVE;
                ExtendedListValueModelWrapperTests.this.event = e;
            }

            public void listCleared(ListChangeEvent e) {
                ExtendedListValueModelWrapperTests.this.eventType = ExtendedListValueModelWrapperTests.CLEAR;
                ExtendedListValueModelWrapperTests.this.event = e;
            }

            public void listChanged(ListChangeEvent e) {
                ExtendedListValueModelWrapperTests.this.eventType = ExtendedListValueModelWrapperTests.CHANGE;
                ExtendedListValueModelWrapperTests.this.event = e;
            }
        };
    }

    private void verifyEvent(String type) {
        ExtendedListValueModelWrapperTests.assertEquals((String)type, (String)this.eventType);
        ExtendedListValueModelWrapperTests.assertEquals(this.extendedListHolder, (Object)this.event.getSource());
        ExtendedListValueModelWrapperTests.assertEquals((String)"list values", (String)this.event.getListName());
    }

    private void verifyEvent(String type, int index, Object item) {
        this.verifyEvent(type);
        ExtendedListValueModelWrapperTests.assertEquals((int)index, (int)this.event.getIndex());
        ExtendedListValueModelWrapperTests.assertEquals((Object)item, this.event.items().next());
    }

    public void testHasListeners() {
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        ListChangeListener listener = this.buildListener();
        this.extendedListHolder.addListChangeListener("list values", listener);
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        this.extendedListHolder.removeListChangeListener("list values", listener);
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        this.extendedListHolder.addListChangeListener(listener);
        ExtendedListValueModelWrapperTests.assertTrue((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
        this.extendedListHolder.removeListChangeListener(listener);
        ExtendedListValueModelWrapperTests.assertFalse((boolean)this.listHolder.hasAnyListChangeListeners("list values"));
    }
}

