/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAspectAdapterTests
extends TestCase {
    private TestSubject subject1;
    private WritablePropertyValueModel<TestSubject> subjectHolder1;
    private LocalListAspectAdapter aa1;
    private ListChangeEvent event1;
    private ListChangeListener listener1;
    private TestSubject subject2;

    public ListAspectAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject1 = new TestSubject();
        this.subject1.addNames(this.subject1Names());
        this.subject1.addDescriptions(this.subject1Descriptions());
        this.subjectHolder1 = new SimplePropertyValueModel((Object)this.subject1);
        this.aa1 = this.buildAspectAdapter((PropertyValueModel<TestSubject>)this.subjectHolder1);
        this.listener1 = this.buildValueChangeListener1();
        this.aa1.addListChangeListener("list values", this.listener1);
        this.event1 = null;
        this.subject2 = new TestSubject();
        this.subject2.addNames(this.subject2Names());
        this.subject2.addDescriptions(this.subject2Descriptions());
    }

    private List<String> subject1Names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("foo");
        result.add("bar");
        result.add("baz");
        result.add("bam");
        return result;
    }

    private List<String> subject1Descriptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("this.subject1 description1");
        result.add("this.subject1 description2");
        return result;
    }

    private List<String> subject2Names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("joo");
        result.add("jar");
        result.add("jaz");
        result.add("jam");
        return result;
    }

    private List<String> subject2Descriptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("this.subject2 description1");
        result.add("this.subject2 description2");
        return result;
    }

    private LocalListAspectAdapter buildAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new LocalListAspectAdapter(subjectHolder);
    }

    private ListChangeListener buildValueChangeListener1() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed(e);
            }

            public void itemsMoved(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed(e);
            }

            public void listCleared(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListAspectAdapterTests.this.value1Changed(e);
            }
        };
    }

    void value1Changed(ListChangeEvent e) {
        this.event1 = e;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSubjectHolder() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        this.subjectHolder1.setValue((Object)this.subject2);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)-1, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertFalse((boolean)this.event1.items().hasNext());
        ListAspectAdapterTests.assertEquals(this.subject2Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        this.subjectHolder1.setValue(null);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)-1, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertFalse((boolean)this.event1.items().hasNext());
        ListAspectAdapterTests.assertFalse((boolean)this.aa1.iterator().hasNext());
        this.event1 = null;
        this.subjectHolder1.setValue((Object)this.subject1);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)-1, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertFalse((boolean)this.event1.items().hasNext());
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testAdd() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addName("jam");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jam", this.event1.items().next());
        List<String> namesPlus = this.subject1Names();
        namesPlus.add("jam");
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        this.aa1.add(2, "jaz");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)2, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jaz", this.event1.items().next());
        namesPlus.add(2, "jaz");
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testDefaultAdd() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        ArrayList<String> items = new ArrayList<String>();
        items.add("joo");
        items.add("jar");
        items.add("jaz");
        items.add("jam");
        this.event1 = null;
        this.aa1.addAll(2, items);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)5, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jam", this.event1.items().next());
        List<String> namesPlus = this.subject1Names();
        namesPlus.addAll(2, items);
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testRemove() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        String removedName = this.subject1.removeName(0);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)0, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)removedName, this.event1.items().next());
        List<String> namesMinus = this.subject1Names();
        namesMinus.remove(0);
        ListAspectAdapterTests.assertEquals(namesMinus, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        String removedItem = this.aa1.remove(0);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)0, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)removedItem, this.event1.items().next());
        namesMinus.remove(0);
        ListAspectAdapterTests.assertEquals(namesMinus, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testDefaultLength() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        ArrayList<String> items = new ArrayList<String>();
        items.add("bar");
        items.add("baz");
        this.event1 = null;
        this.aa1.remove(1, 2);
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)1, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)"baz", this.event1.items().next());
        List<String> namesPlus = this.subject1Names();
        namesPlus.remove(1);
        namesPlus.remove(1);
        ListAspectAdapterTests.assertEquals(namesPlus, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testReplace() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        String replacedName = this.subject1.setName(0, "jelly");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)0, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)"jelly", this.event1.items().next());
        ListAspectAdapterTests.assertEquals((Object)replacedName, this.event1.replacedItems().next());
        List<String> namesChanged = this.subject1Names();
        namesChanged.set(0, "jelly");
        ListAspectAdapterTests.assertEquals(namesChanged, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        this.event1 = null;
        replacedName = this.subject1.setName(1, "roll");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)1, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertEquals((Object)"roll", this.event1.items().next());
        ListAspectAdapterTests.assertEquals((Object)replacedName, this.event1.replacedItems().next());
        namesChanged = this.subject1Names();
        namesChanged.set(0, "jelly");
        namesChanged.set(1, "roll");
        ListAspectAdapterTests.assertEquals(namesChanged, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testListChange() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
        ListAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addTwoNames("jam", "jaz");
        ListAspectAdapterTests.assertNotNull((Object)this.event1);
        ListAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        ListAspectAdapterTests.assertEquals((String)"list values", (String)this.event1.getListName());
        ListAspectAdapterTests.assertEquals((int)-1, (int)this.event1.getIndex());
        ListAspectAdapterTests.assertFalse((boolean)this.event1.items().hasNext());
        List<String> namesPlus2 = this.subject1Names();
        namesPlus2.add(0, "jaz");
        namesPlus2.add(0, "jam");
        ListAspectAdapterTests.assertEquals(namesPlus2, (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testIterator() {
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list(this.subject1.names()));
        ListAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.list((Iterator)this.aa1.listIterator()));
    }

    public void testGet() {
        ListAspectAdapterTests.assertEquals((String)this.subject1Names().get(0), (String)this.subject1.getName(0));
        ListAspectAdapterTests.assertEquals((String)this.subject1Names().get(0), (String)((String)this.aa1.get(0)));
    }

    public void testSize() {
        ListAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)CollectionTools.size(this.subject1.names()));
        ListAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)CollectionTools.size((Iterator)this.aa1.listIterator()));
    }

    public void testHasListeners() {
        ListAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyListChangeListeners("list values"));
        ListAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyListChangeListeners("names"));
        this.aa1.removeListChangeListener("list values", this.listener1);
        ListAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyListChangeListeners("names"));
        ListAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyListChangeListeners("list values"));
        ListChangeListener listener2 = this.buildValueChangeListener1();
        this.aa1.addListChangeListener(listener2);
        ListAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyListChangeListeners("list values"));
        ListAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyListChangeListeners("names"));
        this.aa1.removeListChangeListener(listener2);
        ListAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyListChangeListeners("names"));
        ListAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyListChangeListeners("list values"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalListAspectAdapter
    extends ListAspectAdapter<TestSubject, String> {
        LocalListAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
            super(subjectHolder, new String[]{"names"});
        }

        protected ListIterator<String> listIterator_() {
            if (this.listNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).names();
            }
            if (this.listNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).descriptions();
            }
            throw new IllegalStateException("invalid aspect name: " + this.listNames[0]);
        }

        public void add(int index, Object item) {
            if (this.listNames[0] == "names") {
                ((TestSubject)((Object)this.subject)).addName(index, (String)item);
            } else if (this.listNames[0] == "descriptions") {
                ((TestSubject)((Object)this.subject)).addDescription(index, (String)item);
            } else {
                throw new IllegalStateException("invalid aspect name: " + this.listNames[0]);
            }
        }

        public void addAll(int index, List<String> items) {
            int i = 0;
            while (i < items.size()) {
                this.add(index + i, items.get(i));
                ++i;
            }
        }

        public String remove(int index) {
            if (this.listNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).removeName(index);
            }
            if (this.listNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).removeDescription(index);
            }
            throw new IllegalStateException("invalid aspect name: " + this.listNames[0]);
        }

        public List<String> remove(int index, int length) {
            ArrayList<String> removedItems = new ArrayList<String>(length);
            int i = 0;
            while (i < length) {
                removedItems.add(this.remove(index));
                ++i;
            }
            return removedItems;
        }

        public Object replace(int index, Object item) {
            if (this.listNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).setName(index, (String)item);
            }
            if (this.listNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).setDescription(index, (String)item);
            }
            throw new IllegalStateException("invalid aspect name: " + this.listNames[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestSubject
    extends AbstractModel {
        private List<String> names = new ArrayList<String>();
        public static final String NAMES_LIST = "names";
        private List<String> descriptions = new ArrayList<String>();
        public static final String DESCRIPTIONS_LIST = "descriptions";

        public ListIterator<String> names() {
            return new ReadOnlyListIterator(this.names);
        }

        public String getName(int index) {
            return this.names.get(index);
        }

        public void addName(int index, String name) {
            this.names.add(index, name);
            this.fireItemAdded(NAMES_LIST, index, name);
        }

        public void addName(String name) {
            this.addName(this.names.size(), name);
        }

        public void addNames(ListIterator<String> newNames) {
            while (newNames.hasNext()) {
                this.addName(newNames.next());
            }
        }

        public void addNames(List<String> newNames) {
            this.addNames(newNames.listIterator());
        }

        public void addTwoNames(String name1, String name2) {
            this.names.add(0, name2);
            this.names.add(0, name1);
            this.fireListChanged(NAMES_LIST);
        }

        public String removeName(int index) {
            String removedName = this.names.remove(index);
            this.fireItemRemoved(NAMES_LIST, index, removedName);
            return removedName;
        }

        public String setName(int index, String name) {
            String replacedName = this.names.set(index, name);
            this.fireItemReplaced(NAMES_LIST, index, name, replacedName);
            return replacedName;
        }

        public ListIterator<String> descriptions() {
            return new ReadOnlyListIterator(this.descriptions);
        }

        public String getDescription(int index) {
            return this.descriptions.get(index);
        }

        public void addDescription(int index, String description) {
            this.descriptions.add(index, description);
            this.fireItemAdded(DESCRIPTIONS_LIST, index, description);
        }

        public void addDescription(String description) {
            this.addDescription(this.descriptions.size(), description);
        }

        public void addDescriptions(ListIterator<String> newDescriptions) {
            while (newDescriptions.hasNext()) {
                this.addDescription(newDescriptions.next());
            }
        }

        public void addDescriptions(List<String> newDescriptions) {
            this.addDescriptions(newDescriptions.listIterator());
        }

        public String removeDescription(int index) {
            String removedDescription = this.descriptions.remove(index);
            this.fireItemRemoved(DESCRIPTIONS_LIST, index, removedDescription);
            return removedDescription;
        }

        public String setDescription(int index, String description) {
            String replacedDescription = this.descriptions.set(index, description);
            this.fireItemReplaced(DESCRIPTIONS_LIST, index, description, replacedDescription);
            return replacedDescription;
        }
    }
}

