/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;

public class AWTPropertyChangeListenerWrapper
implements PropertyChangeListener {
    private final PropertyChangeListener listener;

    public AWTPropertyChangeListenerWrapper(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void propertyChanged(PropertyChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.propertyChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildRunnable(event));
        }
    }

    private Runnable buildRunnable(final PropertyChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTPropertyChangeListenerWrapper.this.propertyChanged_(event);
            }
        };
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void propertyChanged_(PropertyChangeEvent event) {
        this.listener.propertyChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ")";
    }
}

