/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JavaEEProjectUtilities
extends ProjectUtilities
implements IJ2EEFacetConstants {
    protected static final IVirtualReference[] NO_REFERENCES = new IVirtualReference[0];

    public static boolean isProjectOfType(IProject project, String typeID) {
        return JavaEEProjectUtilities.getProjectFacetVersion(project, typeID) != null;
    }

    public static IProjectFacetVersion getProjectFacetVersion(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            if (projectFacet == null) {
                return null;
            }
            return facetedProject.getProjectFacetVersion(projectFacet);
        }
        return null;
    }

    private static boolean isProjectOfType(IFacetedProject facetedProject, String typeID) {
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    private static boolean isEARProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ear");
    }

    private static boolean isDynamicWebProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.web");
    }

    private static boolean isStaticWebProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "wst.web");
    }

    private static boolean isEJBProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ejb");
    }

    private static boolean isJCAProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.connector");
    }

    private static boolean isApplicationClientProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.appclient");
    }

    private static boolean isUtilityProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.utility");
    }

    public static boolean isEARProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ear");
    }

    public static boolean isDynamicWebComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 4);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.web");
    }

    public static boolean isDynamicWebProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.web");
    }

    public static boolean isStaticWebProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "wst.web");
    }

    public static boolean isEJBComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 0);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.ejb");
    }

    public static boolean isEJBProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ejb");
    }

    public static boolean isJCAComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 2);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.connector");
    }

    public static boolean isJCAProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.connector");
    }

    public static boolean isApplicationClientComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 3);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.appclient");
    }

    public static boolean isApplicationClientProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.appclient");
    }

    public static boolean isUtilityProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.utility");
    }

    public static IProject[] getAllProjectsInWorkspaceOfType(String type) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (JavaEEProjectUtilities.isProjectOfType(projects[i], type)) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private static boolean isBinaryType(IVirtualComponent aBinaryComponent, int quickPeekType) {
        JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(aBinaryComponent);
        int type = qp.getType();
        return quickPeekType == type;
    }

    public static String getJ2EEComponentType(IVirtualComponent component) {
        if (component != null) {
            if (component.isBinary()) {
                JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(component);
                switch (qp.getType()) {
                    case 3: {
                        return "jst.appclient";
                    }
                    case 4: {
                        return "jst.web";
                    }
                    case 0: {
                        return "jst.ejb";
                    }
                    case 2: {
                        return "jst.connector";
                    }
                    case 1: {
                        return "jst.ear";
                    }
                }
                return "jst.utility";
            }
            return JavaEEProjectUtilities.getJ2EEProjectType(component.getProject());
        }
        return "";
    }

    public static String getJ2EEProjectType(IProject project) {
        if (project != null && project.isAccessible()) {
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {
                return "";
            }
            if (JavaEEProjectUtilities.isApplicationClientProject(facetedProject)) {
                return "jst.appclient";
            }
            if (JavaEEProjectUtilities.isDynamicWebProject(facetedProject)) {
                return "jst.web";
            }
            if (JavaEEProjectUtilities.isEJBProject(facetedProject)) {
                return "jst.ejb";
            }
            if (JavaEEProjectUtilities.isEARProject(facetedProject)) {
                return "jst.ear";
            }
            if (JavaEEProjectUtilities.isJCAProject(facetedProject)) {
                return "jst.connector";
            }
            if (JavaEEProjectUtilities.isStaticWebProject(facetedProject)) {
                return "wst.web";
            }
            if (JavaEEProjectUtilities.isUtilityProject(facetedProject)) {
                return "jst.utility";
            }
        }
        return "";
    }

    public static String getJ2EEDDProjectVersion(IProject project) {
        IVirtualComponent comp;
        int type = -1;
        String ddURI = null;
        if (JavaEEProjectUtilities.isEARProject(project)) {
            type = 1;
            ddURI = "META-INF/application.xml";
        } else if (JavaEEProjectUtilities.isEJBProject(project)) {
            type = 0;
            ddURI = "META-INF/ejb-jar.xml";
        } else if (JavaEEProjectUtilities.isApplicationClientProject(project)) {
            type = 3;
            ddURI = "META-INF/application-client.xml";
        } else if (JavaEEProjectUtilities.isJCAProject(project)) {
            type = 2;
            ddURI = "META-INF/ra.xml";
        } else if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            type = 4;
            ddURI = "WEB-INF/web.xml";
        }
        if (type != -1 && (comp = ComponentCore.createComponent((IProject)project)) != null) {
            IVirtualFile vFile = comp.getRootFolder().getFile((IPath)new Path(ddURI));
            if (vFile.exists()) {
                InputStream in = null;
                try {
                    in = vFile.getUnderlyingFile().getContents();
                    JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                    int vers = quickPeek.getVersion() == -1 ? JavaEEProjectUtilities.getJEEVersion(project) : quickPeek.getVersion();
                    String string = J2EEVersionUtil.convertVersionIntToString(vers);
                    return string;
                }
                catch (CoreException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    }
                }
            }
            return J2EEVersionUtil.convertVersionIntToString(JavaEEProjectUtilities.getJEEVersion(project));
        }
        return null;
    }

    private static int getJEEVersion(IProject project) {
        if (JavaEEProjectUtilities.isEARProject(project) || JavaEEProjectUtilities.isApplicationClientProject(project)) {
            return 50;
        }
        if (JavaEEProjectUtilities.isEJBProject(project)) {
            return 30;
        }
        if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            return 25;
        }
        return -1;
    }

    public static int getJ2EEVersion(IProject javaEEProject) {
        int retVal = 0;
        return retVal;
    }

    public static boolean isJEEComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(component);
            int javaEEVersion = qp.getJavaEEVersion();
            return javaEEVersion >= 50;
        }
        IProject project = component.getProject();
        IProjectFacetVersion facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.ear");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_12 && facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_13 && facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_14;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.appclient");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_12 && facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_13 && facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_14;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.ejb");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.EJB_11 && facetVersion != IJ2EEFacetConstants.EJB_20 && facetVersion != IJ2EEFacetConstants.EJB_21;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.web");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_22 && facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_23 && facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_24;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.connector");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.JCA_10 && facetVersion != IJ2EEFacetConstants.JCA_15;
        }
        return false;
    }

    public static boolean isLegacyJ2EEComponent(IVirtualComponent component) {
        return !JavaEEProjectUtilities.isJEEComponent(component);
    }
}

