/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.single;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.single.ColorSupport;
import org.eclipse.jst.pagedesigner.actions.single.SelectEditPartAction;
import org.eclipse.jst.pagedesigner.actions.single.SelectNodeAction;
import org.eclipse.jst.pagedesigner.actions.single.SelectParentAction;
import org.eclipse.jst.pagedesigner.actions.single.StyleClassSupport;
import org.eclipse.jst.pagedesigner.actions.single.StyleSupport;
import org.eclipse.jst.pagedesigner.dom.DOMStyleUtil;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SingleElementActionGroup
extends ActionGroup {
    private static final Action action = new Action(){};

    public void fillContextMenu(IMenuManager menu) {
        ElementEditPart part = this.fixUpSelection(this.getContext().getSelection());
        if (part == null) {
            return;
        }
        IDOMElement ele = (IDOMElement)part.getIDOMNode();
        this.addPositionRelativeMenu(menu, part, ele);
        this.addStylelMenu(menu, part, ele);
        IElementEdit elementEdit = part.getElementEdit();
        if (elementEdit != null) {
            elementEdit.fillContextMenu(menu, (Element)ele);
        }
    }

    private ElementEditPart fixUpSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() != 1) {
                return null;
            }
            if (sel.getFirstElement() instanceof ElementEditPart) {
                return (ElementEditPart)((Object)sel.getFirstElement());
            }
        }
        return null;
    }

    private void addPositionRelativeMenu(IMenuManager menu, ElementEditPart part, IDOMElement ele) {
        IContributionItem subMenuItem = menu.find("org.eclipse.jst.pagedesigner.context.submenu.select");
        if (subMenuItem instanceof IMenuManager) {
            IMenuManager subMenu = (IMenuManager)subMenuItem;
            SelectParentAction selectParentAction = SelectParentAction.create((Node)ele, (EditPart)part);
            subMenu.add((IAction)selectParentAction);
            ArrayList<SelectEditPartAction> children = new ArrayList<SelectEditPartAction>();
            for (EditPart childPart : part.getChildren()) {
                if (!(childPart instanceof ElementEditPart) || !((ElementEditPart)childPart).isSelectable() || !(((ElementEditPart)childPart).getModel() instanceof Element)) continue;
                children.add(SelectNodeAction.create(((Element)((ElementEditPart)childPart).getModel()).getNodeName(), childPart));
            }
            if (children.size() > 0) {
                MenuManager selectChildMenu = new MenuManager("Children");
                subMenu.add((IContributionItem)selectChildMenu);
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    selectChildMenu.add((IAction)((Action)it.next()));
                }
            } else {
                Action childrenAction = new Action("Children"){};
                childrenAction.setEnabled(false);
                subMenu.add((IAction)childrenAction);
            }
        }
    }

    private void addStylelMenu(IMenuManager menu, ElementEditPart part, IDOMElement ele) {
        IContributionItem subMenu = menu.find("org.eclipse.jst.pagedesigner.context.submenu.style");
        if (subMenu instanceof IMenuManager) {
            IMenuManager subMenuManager = (IMenuManager)subMenu;
            this.addStyle(subMenuManager, part, ele);
            this.addStyleClassesMenu(subMenuManager, part, ele);
            if (DOMStyleUtil.supportStyleAttribute(ele)) {
                this.addColorMenu(subMenuManager, part, ele);
                this.addBackgroundMenu(subMenuManager, part, ele);
            }
        }
    }

    private void addStyle(IMenuManager subMenu, ElementEditPart part, IDOMElement ele) {
        StyleSupport.createStyleAction(subMenu, part, ele);
    }

    private void addStyleClassesMenu(IMenuManager subMenu, ElementEditPart part, IDOMElement ele) {
        MenuManager classmenu = new MenuManager(PDPlugin.getResourceString("ActionGroup.Submenu.StyleClasses"));
        StyleClassSupport.createStyleClassActions((IMenuManager)classmenu, ele);
        subMenu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IContributionItem)classmenu);
    }

    private void addColorMenu(IMenuManager subMenu, ElementEditPart part, IDOMElement ele) {
        MenuManager colorSub = new MenuManager(PDPlugin.getResourceString("ActionGroup.Submenu.Color"));
        colorSub.add((IAction)action);
        colorSub.addMenuListener(new IMenuListener((IMenuManager)colorSub, ele){
            private final /* synthetic */ IMenuManager val$colorSub;
            private final /* synthetic */ IDOMElement val$ele;
            {
                this.val$colorSub = iMenuManager;
                this.val$ele = iDOMElement;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$colorSub.removeAll();
                ColorSupport.createColorActions(this.val$colorSub, this.val$ele, "color");
            }
        });
        subMenu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IContributionItem)colorSub);
    }

    private void addBackgroundMenu(IMenuManager subMenu, ElementEditPart part, IDOMElement ele) {
        MenuManager colorSub = new MenuManager(PDPlugin.getResourceString("ActionGroup.Submenu.BackgroundColor"));
        colorSub.add((IAction)action);
        colorSub.addMenuListener(new IMenuListener((IMenuManager)colorSub, ele){
            private final /* synthetic */ IMenuManager val$colorSub;
            private final /* synthetic */ IDOMElement val$ele;
            {
                this.val$colorSub = iMenuManager;
                this.val$ele = iDOMElement;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$colorSub.removeAll();
                ColorSupport.createColorActions(this.val$colorSub, this.val$ele, "background-color");
            }
        });
        subMenu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IContributionItem)colorSub);
    }
}

