/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public class TestEnvironment {
    public static final boolean DEBUG = true;
    private IWorkspace _workspace;
    private HashMap<String, IProject> _projects = new HashMap(20);

    public TestEnvironment() throws CoreException {
        this._workspace = ResourcesPlugin.getWorkspace();
        this._workspace.getRoot().delete(true, true, null);
    }

    public IPath addFolder(IPath root, String folderName) throws CoreException {
        IPath path = root.append(folderName);
        this.createFolder(path);
        return path;
    }

    public void incrementalBuild() throws CoreException {
        this.getWorkspace().build(10, null);
    }

    public void incrementalBuildAndWait(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.getWorkspace().build(10, monitor);
        Thread.sleep(2000L);
        ValidationFramework.getDefault().join(monitor);
    }

    public void fullBuild2(IProgressMonitor monitor) throws CoreException {
        this.getWorkspace().build(6, monitor);
    }

    public void fullBuild(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.fullBuild2(monitor);
        Thread.sleep(1000L);
        ValidationFramework.getDefault().join(monitor);
        Thread.sleep(2000L);
    }

    public void cleanBuild(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.getWorkspace().build(15, monitor);
        Thread.sleep(1000L);
        ValidationFramework.getDefault().join(monitor);
    }

    private IFolder createFolder(IPath path) throws CoreException {
        if (path.segmentCount() <= 1) {
            return null;
        }
        IFolder folder = this._workspace.getRoot().getFolder(path);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        return folder;
    }

    public IProject createProject(String name) throws CoreException {
        final IProject project = this._workspace.getRoot().getProject(name);
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(monitor);
                project.open(monitor);
                ValidatorManager.addProjectBuildValidationSupport((IProject)project);
            }
        };
        this._workspace.run(create, null);
        this._projects.put(name, project);
        return project;
    }

    public void dispose() throws CoreException {
    }

    public IFile addFile(IPath folder, String fileName, String contents) throws CoreException, UnsupportedEncodingException {
        IPath filePath = folder.append(fileName);
        return this.createFile(filePath, contents.getBytes("UTF8"));
    }

    private IFile createFile(IPath filePath, byte[] contents) throws CoreException {
        IFile file = this._workspace.getRoot().getFile(filePath);
        ByteArrayInputStream in = new ByteArrayInputStream(contents);
        if (file.exists()) {
            file.setContents((InputStream)in, true, false, null);
        } else {
            file.create((InputStream)in, true, null);
        }
        return file;
    }

    public IWorkspace getWorkspace() {
        return this._workspace;
    }

    public IProject findProject(String name) {
        IProject project = this._workspace.getRoot().getProject(name);
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public static void enableOnlyTheseValidators(String validatorPrefix) throws InvocationTargetException {
        Validator[] vals = ValManager.getDefault().getValidatorsCopy();
        String name = "org.eclipse.wst.validation.tests." + validatorPrefix;
        Validator[] validatorArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            boolean enable = v.getValidatorClassname().startsWith(name);
            v.setBuildValidation(enable);
            v.setManualValidation(enable);
            ++n2;
        }
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(vals);
        TestEnvironment.saveV1Preferences(vals);
    }

    public static void enableOnlyThisValidator(String name) throws InvocationTargetException {
        Validator[] vals;
        Validator[] validatorArray = vals = ValManager.getDefault().getValidatorsCopy();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            boolean enable = v.getValidatorClassname().equals(name);
            v.setBuildValidation(enable);
            v.setManualValidation(enable);
            ++n2;
        }
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(vals);
        TestEnvironment.saveV1Preferences(vals);
    }

    public static void saveV1Preferences(Validator[] validators) throws InvocationTargetException {
        GlobalConfiguration gc = ConfigurationManager.getManager().getGlobalConfiguration();
        LinkedList<ValidatorMetaData> manual = new LinkedList<ValidatorMetaData>();
        LinkedList<ValidatorMetaData> build = new LinkedList<ValidatorMetaData>();
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            Validator.V1 v1 = v.asV1Validator();
            if (v1 != null) {
                if (v1.isManualValidation()) {
                    manual.add(v1.getVmd());
                }
                if (v1.isBuildValidation()) {
                    build.add(v1.getVmd());
                }
            }
            ++n2;
        }
        ValidatorMetaData[] array = new ValidatorMetaData[manual.size()];
        gc.setEnabledManualValidators(manual.toArray(array));
        array = new ValidatorMetaData[build.size()];
        gc.setEnabledBuildValidators(build.toArray(array));
        gc.passivate();
        gc.store();
    }

    public void turnoffAutoBuild() throws CoreException {
        IWorkspaceDescription wd = this._workspace.getDescription();
        if (wd.isAutoBuilding()) {
            wd.setAutoBuilding(false);
            this._workspace.setDescription(wd);
        }
    }

    public void turnOnAutoBuild() throws CoreException {
        IWorkspaceDescription wd = this._workspace.getDescription();
        if (!wd.isAutoBuilding()) {
            wd.setAutoBuilding(true);
            this._workspace.setDescription(wd);
        }
    }

    public int getErrors(IResource resource) {
        int errors = 0;
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.wst.validation.problemmarker2", false, 0);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int severity = marker.getAttribute("severity", -1);
                if (severity == 2) {
                    ++errors;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return errors;
    }
}

