/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite3
extends TestCase {
    private TestEnvironment _env;
    private IProject _testProject;
    private IResource _folder;
    private IFile _firstTest1;

    public static Test suite() {
        return new TestSuite(TestSuite3.class);
    }

    public TestSuite3(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._testProject = this._env.findProject("TestProject");
        if (this._testProject != null) {
            return;
        }
        this._env.turnoffAutoBuild();
        TestSuite3.enableOnlyTestValidators();
        this._testProject = this._env.createProject("TestProject");
        IPath folder = this._env.addFolder(this._testProject.getFullPath(), "source");
        ResourcesPlugin.getWorkspace().getRoot().findMember(folder);
        this._env.addFile(folder, "first.test1", "include map.test1\ninfo - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._env.addFile(folder, "second.test1", "info - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
        this._env.addFile(folder, "map.test1", "# will hold future mappings\n\n# syntax: map target replacement\n# for example map t1error error - would replace all t1error tokens with error");
        this._env.addFile(folder, "first.test2", "# sample file");
        this._env.addFile(folder, "third.test4", "# Doesn't really matter\n# We just want to make the build a bit slower.");
        this._env.addFile(folder, "fourth.test4", "# Doesn't really matter");
        this._env.addFile(folder, "fifth.test5", "# Doesn't really matter");
        folder = this._env.addFolder(this._testProject.getFullPath(), "disabled");
        this._folder = ResourcesPlugin.getWorkspace().getRoot().findMember(folder);
        this._firstTest1 = this._env.addFile(folder, "first.test1", "include map.test1\ninfo - information\nwarning - warning\nerror - error\n\nt1error - extra error\nt1warning - extra warning");
    }

    private static void enableOnlyTestValidators() throws InvocationTargetException {
        Validator[] vals;
        Validator[] validatorArray = vals = ValManager.getDefault().getValidatorsCopy();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            boolean enable = v.getValidatorClassname().startsWith("org.eclipse.wst.validation.tests.Test");
            v.setBuildValidation(enable);
            v.setManualValidation(enable);
            ++n2;
        }
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(vals);
        TestEnvironment.saveV1Preferences(vals);
    }

    protected void tearDown() throws Exception {
        this._env.dispose();
        super.tearDown();
    }

    public void testTest1() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite3-01: testTest1 starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationFramework vf = ValidationFramework.getDefault();
        vf.disableValidation(this._folder);
        this._env.fullBuild((IProgressMonitor)monitor);
        IMarker[] markers = this._firstTest1.findMarkers(null, true, 0);
        TestSuite3.assertEquals((String)"The file should not have been validated.", (int)0, (int)markers.length);
        vf.enableValidation(this._folder);
        this._env.fullBuild((IProgressMonitor)monitor);
        markers = this._firstTest1.findMarkers(null, true, 0);
        TestSuite3.assertTrue((String)"The file should have some markers", (markers.length > 0 ? 1 : 0) != 0);
        vf.disableValidation(this._folder);
        this._env.fullBuild((IProgressMonitor)monitor);
        markers = this._firstTest1.findMarkers(null, true, 0);
        TestSuite3.assertEquals((String)"The file should not have been validated.", (int)0, (int)markers.length);
        Tracing.log((String)"TestSuite3-02:testTest1 finished");
    }
}

