/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.BindingKey;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.tests.dom.AbstractASTTests;
import org.eclipse.wst.jsdt.core.tests.dom.BatchASTCreationTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public class BatchASTCreationTests
extends AbstractASTTests {
    public WorkingCopyOwner owner = new WorkingCopyOwner(){};
    static /* synthetic */ Class class$0;

    public BatchASTCreationTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.BatchASTCreationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return BatchASTCreationTests.buildModelTestSuite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    private void assertRequestedBindingFound(String[] pathAndSources, String expectedKey) throws JavaScriptModelException {
        this.assertRequestedBindingsFound(pathAndSources, new String[]{expectedKey});
    }

    private void assertRequestedBindingsFound(String[] pathAndSources, String[] expectedKeys) throws JavaScriptModelException {
        BindingResolver resolver = this.requestBindings(pathAndSources, expectedKeys);
        this.assertStringsEqual("Unexpected binding for marked node", expectedKeys, resolver.getBindingKeys());
        this.assertStringsEqual("Unexpected binding found by acceptBinding", expectedKeys, resolver.getFoundKeys());
    }

    private void assertBindingCreated(String[] pathAndSources, String expectedKey) throws JavaScriptModelException {
        this.assertBindingsCreated(pathAndSources, new String[]{expectedKey});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void assertBindingsCreated(String[] pathAndSources, String[] expectedKeys) throws JavaScriptModelException {
        IJavaScriptUnit[] copies = null;
        try {
            BindingResolver resolver;
            String[] markedKeys;
            copies = this.createWorkingCopies(pathAndSources);
            class Requestor
            extends TestASTRequestor {
                ArrayList createdBindingKeys;
                final /* synthetic */ BatchASTCreationTests this$0;
                private final /* synthetic */ String[] val$expectedKeys;

                Requestor(BatchASTCreationTests batchASTCreationTests, String[] stringArray) {
                    this.this$0 = batchASTCreationTests;
                    this.val$expectedKeys = stringArray;
                    this.createdBindingKeys = new ArrayList<E>();
                }

                public void acceptAST(IJavaScriptUnit source, JavaScriptUnit cu) {
                    super.acceptAST(source, cu);
                    IBinding[] bindings = this.createBindings(this.val$expectedKeys);
                    if (bindings != null && bindings.length > 0 && bindings[0] != null) {
                        this.createdBindingKeys.add(bindings[0].getKey());
                    }
                }

                public String getCreatedKeys() {
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    int length = this.createdBindingKeys.size();
                    while (i < length) {
                        buffer.append(this.createdBindingKeys.get(i));
                        if (i < length - 1) {
                            buffer.append('\n');
                        }
                        ++i;
                    }
                    return buffer.toString();
                }
            }
            Requestor requestor = new Requestor(this, expectedKeys);
            IJavaScriptUnit[] dummyWorkingCopies = null;
            try {
                dummyWorkingCopies = this.createWorkingCopies(new String[]{"/P/Test.js", "public class Test {\n}"});
                this.resolveASTs(dummyWorkingCopies, new String[0], requestor, this.getJavaProject("P"), this.owner);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.discardWorkingCopies(dummyWorkingCopies);
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            this.discardWorkingCopies(dummyWorkingCopies);
            String expectedKey = this.toString(expectedKeys);
            String actualKey = requestor.getCreatedKeys();
            if (!expectedKey.equals(actualKey) && (markedKeys = (resolver = this.requestBindings(pathAndSources, null)).getBindingKeys()).length > 0) {
                this.assertStringsEqual("Inconsistent expected key ", expectedKeys, markedKeys);
            }
            BatchASTCreationTests.assertEquals((String)"Unexpected created binding", (String)expectedKey, (String)actualKey);
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.discardWorkingCopies(copies);
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        this.discardWorkingCopies(copies);
    }

    private void createASTs(IJavaScriptUnit[] cus, TestASTRequestor requestor) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.createASTs(cus, new String[0], (ASTRequestor)requestor, null);
    }

    protected IJavaScriptUnit[] createWorkingCopies(String[] pathAndSources) throws JavaScriptModelException {
        return this.createWorkingCopies(pathAndSources, this.owner);
    }

    protected IJavaScriptUnit[] createWorkingCopies(String[] pathAndSources, boolean resolve) throws JavaScriptModelException {
        IProblemRequestor problemRequestor = resolve ? new IProblemRequestor(){

            public void acceptProblem(IProblem problem) {
            }

            public void beginReporting() {
            }

            public void endReporting() {
            }

            public boolean isActive() {
                return true;
            }
        } : null;
        AbstractASTTests.MarkerInfo[] markerInfos = this.createMarkerInfos(pathAndSources);
        return this.createWorkingCopies(markerInfos, this.owner, problemRequestor);
    }

    private void resolveASTs(IJavaScriptUnit[] cus, TestASTRequestor requestor) {
        this.resolveASTs(cus, new String[0], requestor, this.getJavaProject("P"), this.owner);
    }

    private BindingResolver requestBindings(String[] pathAndSources, String[] expectedKeys) throws JavaScriptModelException {
        BindingResolver bindingResolver;
        IJavaScriptUnit[] copies = null;
        try {
            AbstractASTTests.MarkerInfo[] markerInfos = this.createMarkerInfos(pathAndSources);
            copies = this.createWorkingCopies(markerInfos, this.owner);
            BindingResolver resolver = new BindingResolver(markerInfos);
            this.resolveASTs(copies, expectedKeys == null ? new String[]{} : expectedKeys, resolver, copies.length > 0 ? copies[0].getJavaScriptProject() : this.getJavaProject("P"), this.owner);
            bindingResolver = resolver;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.discardWorkingCopies(copies);
            throw throwable;
        }
        this.discardWorkingCopies(copies);
        return bindingResolver;
    }

    public void test001() throws CoreException {
        this.workingCopies = this.createWorkingCopies(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends Y {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"});
        TestASTRequestor requestor = new TestASTRequestor();
        this.createASTs(this.workingCopies, requestor);
        this.assertASTNodesEqual("package p1;\npublic class X extends Y {\n}\n\npackage p1;\npublic class Y {\n}\n\n", requestor.asts);
    }

    public void test002() throws CoreException {
        AbstractASTTests.MarkerInfo[] markerInfos = this.createMarkerInfos(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends /*start*/Y/*end*/ {\n}", "/P/p1/Y.js", "package p1;\n/*start*/public class Y {\n}/*end*/"});
        this.workingCopies = this.createWorkingCopies(markerInfos, this.owner);
        TestASTRequestor requestor = new TestASTRequestor();
        this.resolveASTs(this.workingCopies, requestor);
        this.assertASTNodesEqual("package p1;\npublic class X extends Y {\n}\n\npackage p1;\npublic class Y {\n}\n\n", requestor.asts);
        Type superX = (Type)this.findNode((JavaScriptUnit)requestor.asts.get(0), markerInfos[0]);
        TypeDeclaration typeY = (TypeDeclaration)this.findNode((JavaScriptUnit)requestor.asts.get(1), markerInfos[1]);
        ITypeBinding superXBinding = superX.resolveBinding();
        ITypeBinding typeYBinding = typeY.resolveBinding();
        BatchASTCreationTests.assertTrue((String)"Super of X and Y should be the same", (superXBinding == typeYBinding ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test003() throws CoreException {
        IJavaScriptUnit[] otherWorkingCopies = null;
        try {
            this.workingCopies = this.createWorkingCopies(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends Y {\n}"});
            otherWorkingCopies = this.createWorkingCopies(new String[]{"/P/p1/Y.js", "package p1;\npublic class Y {\n}"});
            TestASTRequestor requestor = new TestASTRequestor();
            this.resolveASTs(this.workingCopies, requestor);
            this.assertASTNodesEqual("package p1;\npublic class X extends Y {\n}\n\n", requestor.asts);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.discardWorkingCopies(otherWorkingCopies);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.discardWorkingCopies(otherWorkingCopies);
    }

    public void test004() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "/*start*/package p1;/*end*/\npublic class X {\n}"}, "p1");
    }

    public void test005() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\n/*start*/public class X extends Y {\n}/*end*/", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"}, "Lp1/X;");
    }

    public void test006() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends Y {\n}", "/P/p1/Y.js", "package p1;\n/*start*/public class Y {\n}/*end*/"}, "Lp1/Y;");
    }

    public void test007() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  /*start*/class Member {\n  }/*end*/}"}, "Lp1/X$Member;");
    }

    public void test008() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  class Member1 {\n    /*start*/class Member2 {\n    }/*end*/  }\n}"}, "Lp1/X$Member1$Member2;");
    }

    public void test009() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    new X() /*start*/{\n    }/*end*/;  }\n}"}, "Lp1/X$52;");
    }

    public void test010() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    /*start*/class Y {\n    }/*end*/;  }\n}"}, "Lp1/X$54$Y;");
    }

    public void test011() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}"}, "p1");
    }

    public void test012() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends Y {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"}, "Lp1/X;");
    }

    public void test013() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends Y {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}"}, "Lp1/Y;");
    }

    public void test014() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  class Member {\n  }}"}, "Lp1/X$Member;");
    }

    public void test015() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  class Member1 {\n    class Member2 {\n    }  }\n}"}, "Lp1/X$Member1$Member2;");
    }

    public void test016() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    new X() /*start*/{\n    }/*end*/;  }\n}"}, "Lp1/X$52;");
    }

    public void test017() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    /*start*/class Y {\n    }/*end*/;  }\n}"}, "Lp1/X$54$Y;");
    }

    public void test018() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}"}, "Lp1/X;.foo()V");
    }

    public void test019() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo(Object o) {\n  }\n}"}, "Lp1/X;.foo(Ljava/lang/Object;)V");
    }

    public void test020() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  X(Object o) {\n  }\n}"}, "Lp1/X;.(Ljava/lang/Object;)V");
    }

    public void test021() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  int field;\n}"}, "Lp1/X;.field)I");
    }

    public void test022() throws CoreException {
        this.assertBindingCreated(new String[0], "I");
    }

    public void test023() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}"}, "[Lp1/X;");
    }

    public void test024() throws CoreException {
        this.assertBindingCreated(new String[0], "[[I");
    }

    public void test025() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  class Y {\n  }\n  void foo() {\n    new X() {\n      /*start*/void bar(int i, X x, String[][] s, Y[] args, boolean b, Object o) {\n      }/*end*/\n    };\n  }\n}"}, "Lp1/X$68;.bar(ILp1/X;[[Ljava/lang/String;[Lp1/X$Y;ZLjava/lang/Object;)V");
    }

    public void test026() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n}"}, "Lp1/X<TT;>;");
    }

    public void test027() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T extends Y & I, U extends Y> {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n}", "/P/p1/I.js", "package p1;\npublic interface I {\n}"}, "Lp1/X<TT;TU;>;");
    }

    public void test028() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  X<String> field;\n}"}, "Lp1/X<Ljava/lang/String;>;");
    }

    public void test029() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T,U> {\n  class Y<V> {\n    X<Error,Exception>.Y<String> field;\n  }\n}"}, "Lp1/X<Ljava/lang/Error;Ljava/lang/Exception;>.Y<Ljava/lang/String;>;");
    }

    public void test030() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T,U> {\n   X field;\n}"}, "Lp1/X<>;");
    }

    public void test031() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T,U> {\n  class Y<V> {\n    X<Error,Exception>.Y field;\n  }\n}"}, "Lp1/X<Ljava/lang/Error;Ljava/lang/Exception;>.Y<>;");
    }

    public void test032() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  <T> void foo() {\n  }\n}"}, "Lp1/X;.foo<T:Ljava/lang/Object;>()V");
    }

    public void test033() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    int i;\n  }\n}"}, "Lp1/X;.foo()V#i");
    }

    public void test034() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    int i = 1;\n    if (i == 0) {\n      int a;\n    } else {\n      int b;\n    }\n  }\n}"}, "Lp1/X;.foo()V#1#b");
    }

    public void test035() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  void foo(T t) {\n  }\n  void bar() {\n    new X<String>().foo(\"\");\n  }\n}"}, "Lp1/X<Ljava/lang/String;>;.foo(Ljava/lang/String;)V");
    }

    public void test036() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  <U> void foo(T t, U u) {\n  }\n  void bar() {\n    /*start*/new X<String>().foo(\"\", this)/*end*/;\n  }\n}"}, "Lp1/X<Ljava/lang/String;>;.foo<U:Ljava/lang/Object;>(Ljava/lang/String;TU;)V%<Lp1/X;>");
    }

    public void test037() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  <U> void foo(T t, U u) {\n  }\n  void bar() {\n    /*start*/new X().foo(\"\", this)/*end*/;\n  }\n}"}, "Lp1/X;.foo<U:Ljava/lang/Object;>(TT;TU;)V%<>");
    }

    public void test038() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  void foo() {\n  }\n  void bar(X<?> x) {\n    x.foo();\n  }\n}"}, "Lp1/X<Lp1/X;*>;.foo()V");
    }

    public void test039() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  void foo() {\n  }\n  void bar(X<? extends Object> x) {\n    x.foo();\n  }\n}"}, "Lp1/X<Lp1/X;+Ljava/lang/Object;>;.foo()V");
    }

    public void test040() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  void foo() {\n  }\n  void bar(X<? super Error> x) {\n    x.foo();\n  }\n}"}, "Lp1/X<Lp1/X;-Ljava/lang/Error;>;.foo()V");
    }

    public void test041() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T, U, V, W> {\n  void foo() {\n  }\n  void bar(X<? super Error, ?, String, ? extends Object> x) {\n    x.foo();\n  }\n}"}, "Lp1/X<Lp1/X;-Ljava/lang/Error;Lp1/X;*Ljava/lang/String;Lp1/X;+Ljava/lang/Object;>;.foo()V");
    }

    /*
     * Exception decompiling
     */
    public void test042() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 102->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void test043() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  X<? super T> field;\n}"}, "Lp1/X<Lp1/X;-Lp1/X;:TT;>;");
    }

    public void test044() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<E> {\n  Class<? extends E> field;\n}"}, "Ljava/lang/Class<Lp1/X;+Lp1/X;:TE;>;");
    }

    public void test045() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n}", "/P/p1/Y.js", "package p1;\npublic class Y<E> {\n}"}, new String[]{"Lp1/X;", "Lp1/Y<Lp1/Y;+Lp1/X;>;"});
        this.assertBindingsEqual("Lp1/X;\nLp1/Y<Lp1/Y;+Lp1/X;>;", (IBinding[])bindings);
    }

    public void test046() throws CoreException {
        this.assertBindingCreated(new String[0], "[Ljava/lang/Class<Ljava/lang/Object;>;");
    }

    public void test047() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"N"});
        this.assertBindingsEqual("N", (IBinding[])bindings);
    }

    public void test048() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"[Ljava/lang/Object;"});
        this.assertBindingsEqual("[Ljava/lang/Object;", (IBinding[])bindings);
    }

    public void test049() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"Ljava/lang/Class<TT;>;:TT;"});
        this.assertBindingsEqual("Ljava/lang/Class;:TT;", (IBinding[])bindings);
    }

    public void test050() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"Ljava/lang/Class<Ljava/lang/Class<TT;>;+[Ljava/lang/Object;>;"});
        this.assertBindingsEqual("Ljava/lang/Class<Ljava/lang/Class;+[Ljava/lang/Object;>;", (IBinding[])bindings);
    }

    public void test051() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"Lp1/DoesNotExist;"});
        this.assertBindingsEqual("<null>", (IBinding[])bindings);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test052() throws CoreException {
        try {
            this.createFolder("/P/p1");
            this.createFile("/P/p1/X.js", "package p1;\npublic class X {\n}\nclass Y {\n}");
            this.assertBindingCreated(new String[0], "Lp1/X~Y;");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.deleteFolder("/P/p1");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.deleteFolder("/P/p1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test053() throws CoreException {
        try {
            this.createFolder("/P/p1");
            this.createFile("/P/p1/X.js", "package p1;\npublic class X {\n}\nclass Y {\n  void foo() {\n    new Y() {};\n  }\n}");
            this.assertBindingCreated(new String[0], "Lp1/X~Y$64;");
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.deleteFolder("/P/p1");
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.deleteFolder("/P/p1");
    }

    public void test054() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n    class Y {\n      void bar() {\n        new X() /*start*/{\n        }/*end*/;      }\n    }\n  }\n}"}, "Lp1/X$89;");
    }

    public void test055() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n  <U> void foo(U u) {\n  }\n  void bar() {\n    /*start*/new X<String>().foo(new X() {})/*end*/;\n  }\n}"}, "Lp1/X<Ljava/lang/String;>;.foo<U:Ljava/lang/Object;>(TU;)V%<Lp1/X$101;>");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test056() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("BinaryProject", new String[0], new String[]{"JCL15_LIB"}, "", "1.5");
            this.addLibrary(project, "lib.jar", "src.zip", new String[]{"/BinaryProject/p/X.js", "package p;\npublic class X<K, V> {\n  public class Y<K1, V1> {\n  }\n}"}, "1.5");
            ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"Lp/X<>.Y<Lp/X;:TK;Lp/X;:TV;>;"}, project);
            this.assertBindingsEqual("Lp/X<>.Y<Lp/X;:TK;Lp/X;:TV;>;", (IBinding[])bindings);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("BinaryProject");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("BinaryProject");
    }

    public void test057() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[0], new String[]{"Lp/Missing$Member;"});
        this.assertBindingsEqual("<null>", (IBinding[])bindings);
    }

    public void test058() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  </*start*/T/*end*/> void foo(T t) {\n  }}"}, "Lp1/X;.foo<T:Ljava/lang/Object;>(TT;)V:TT;");
    }

    public void test059() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X<T> {\n    Object foo(X<?> list) {\n       return /*start*/list.get()/*end*/;\n    }\n    T get() {\n    \treturn null;\n    }\n}"}, "Lp1/X;&!Lp1/X;*77;");
    }

    public void test060() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/xy/Cap.js", "package xy;\nimport java.util.Vector;\npublic class Cap {\n\t{\n\t\tVector<?> v= null;\n\t\t/*start*/v.get(0)/*end*/;\n\t}\n}", "/P/java/util/Vector.js", "package java.util;\npublic class Vector<T> {\n  public T get(int i) {\n    return null;\n  }\n}"}, "Lxy/Cap;&!Ljava/util/Vector;*82;");
    }

    public void test061() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n    /*start*/<T> X() {\n    }/*end*/\n}"}, "Lp1/X;.<T:Ljava/lang/Object;>()V");
    }

    public void test062() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  <T> /*start*/T[]/*end*/ foo(T[] a) {\n    return null;\n  }\n}"}, "[Lp1/X;.foo<T:Ljava/lang/Object;>([TT;)[TT;:TT;");
    }

    public void test063() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n\tpublic static <T extends Y<? super T>> void foo(Z<T> z) {\n    }\n    /**\n     * @see #foo(Z)\n     */\n    void bar() {\n        /*start*/foo(new W())/*end*/;\n    }\n}\nclass Y<T> {\n}\nclass Z<T> {\n}\nclass W<T> extends Z<T> {\n}"}, "Lp1/X;.foo<T:Lp1/Y<-TT;>;>(Lp1/Z<TT;>;)V%<>");
    }

    public void test064() throws CoreException {
        this.assertRequestedBindingsFound(new String[]{"/P/p1/X.js", "package p1;\n/*start1*/public class X {\n\tObject o= null;\n\tY<?> field;\n\tvoid foo() {\n\t\t/*start2*/o = field/*end2*/;\n\t}\n}/*end1*/\n", "/P/p1/Y.js", "package p1;\npublic class Y<T> {\n}"}, new String[]{"Lp1/X;", "Lp1/X;&Lp1/Y<!Lp1/Y;*83;>;"});
    }

    public void test065() throws CoreException {
        this.assertRequestedBindingFound(new String[]{"/P/p1/X.js", "package p1;\npublic class X {\n  <T> void foo(/*start*/Y<T>/*end*/ y) {\n  }\n}\nclass Y<E> {\n}"}, "Lp1/X~Y<Lp1/X;:1TT;>;");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test066() throws CoreException {
        IJavaScriptUnit ownedWorkingcopy;
        block4: {
            IJavaScriptUnit primaryWorkingCopy = null;
            ownedWorkingcopy = null;
            try {
                primaryWorkingCopy = this.getCompilationUnit("/P/p1/X.js");
                primaryWorkingCopy.becomeWorkingCopy(null, null);
                primaryWorkingCopy.getBuffer().setContents("package p1;\npublic class X {\n}");
                primaryWorkingCopy.reconcile(0, false, null, null);
                ownedWorkingcopy = this.getWorkingCopy("/P/p1/X.js", "package p1;\npublic class X {\n  void foo() {}\n}", this.owner, false);
                this.assertRequestedBindingFound(new String[]{"/P/p1/Y.js", "package p1;\npublic class Y {\n  void bar() {\n    /*start*/new X().foo()/*end*/;\n}"}, "Lp1/X;.foo()V");
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (primaryWorkingCopy != null) {
                    primaryWorkingCopy.discardWorkingCopy();
                }
                if (ownedWorkingcopy == null) throw throwable;
                ownedWorkingcopy.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (primaryWorkingCopy == null) break block4;
            }
            primaryWorkingCopy.discardWorkingCopy();
        }
        if (ownedWorkingcopy == null) return;
        ownedWorkingcopy.discardWorkingCopy();
    }

    public void test067() throws CoreException {
        ITypeBinding[] bindings = this.createTypeBindings(new String[]{"/P/p1/X.js", "package p1;\npublic class X<K, V> {\n  public class Y<K1, V1> {\n  }\n  /*start*/Y<K, V>/*end*/ field;\n}"}, new String[]{"Lp1/X$Y<Lp1/X;:TK;Lp1/X;:TV;>;"});
        this.assertBindingEquals("Lp1/X<>;", (IBinding)(bindings.length == 0 ? null : bindings[0].getDeclaringClass()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test068() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            this.addLibrary(project, "lib.jar", "src.zip", new String[]{"/P1/p/X.js", "package p;\npublic class X<K, V> {\n  public static class Member<K1, V1> {\n  }\n}", "/P1/p/Y.js", "package p;\npublic class Y {\n  void foo(X.Member x) {\n  }\n}"}, "1.5");
            this.assertRequestedBindingFound(new String[]{"/P1/p1/Z.js", "package p1;\npublic class Z extends p.Y {\n  /*start*/p.X.Member/*end*/ field;\n}"}, "Lp/X$Member<>;");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P1");
    }

    public void test069() throws CoreException {
        this.workingCopies = this.createWorkingCopies(new String[]{"/P/pkg/RefAnnoAndClassWithAnno.js", "package pkg;\npublic class RefMyAnnoAndClassWithAnno {\n\tfinal Class anno = MyAnno.class;\n\tfinal Class withAnno = ClassWithAnnotation.class;\n}", "/P/pkg/MyAnno.js", "package pkg;\npublic @interface MyAnno {\n\tpublic enum EnumColor{\n\t\tBLUE, RED, WHITE;\n\t}\n\tEnumColor aEnum();\n}", "/P/pkg/ClassWithAnnotation.js", "package pkg;\nimport pkg.MyAnno.EnumColor;\n@MyAnno(aEnum = EnumColor.BLUE)\npublic class ClassWithAnnotation {}"});
        String key = BindingKey.createTypeBindingKey((String)"pkg.RefMyAnnoAndClassWithAnno");
        BindingResolver resolver = new BindingResolver(new AbstractASTTests.MarkerInfo[0]);
        this.resolveASTs(new IJavaScriptUnit[0], new String[]{key}, resolver, this.getJavaProject("P"), this.owner);
        this.assertStringsEqual("Unexpected bindings", "Lpkg/RefAnnoAndClassWithAnno~RefMyAnnoAndClassWithAnno;\n", resolver.getFoundKeys());
    }

    public void test070() throws CoreException {
        AbstractASTTests.MarkerInfo[] markerInfos = this.createMarkerInfos(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends /*start*/Y/*end*/ {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n  static final int CONST = 2 + 3;\n}"});
        this.workingCopies = this.createWorkingCopies(markerInfos, this.owner);
        TestASTRequestor requestor = new TestASTRequestor();
        this.resolveASTs(new IJavaScriptUnit[]{this.workingCopies[0]}, requestor);
        Type y = (Type)this.findNode((JavaScriptUnit)requestor.asts.get(0), markerInfos[0]);
        ITypeBinding yBinding = y.resolveBinding();
        this.assertBindingsEqual("", (IBinding[])yBinding.getDeclaredFields());
    }

    public void test071() throws CoreException {
        AbstractASTTests.MarkerInfo[] markerInfos = this.createMarkerInfos(new String[]{"/P/p1/X.js", "package p1;\npublic class X extends /*start*/Y/*end*/ {\n}", "/P/p1/Y.js", "package p1;\npublic class Y {\n  static final int CONST = 2 + 3;\n}"});
        this.workingCopies = this.createWorkingCopies(markerInfos, this.owner);
        class Requestor
        extends TestASTRequestor {
            Object constantValue;
            final /* synthetic */ BatchASTCreationTests this$0;
            private final /* synthetic */ AbstractASTTests.MarkerInfo[] val$markerInfos;

            Requestor(BatchASTCreationTests batchASTCreationTests, AbstractASTTests.MarkerInfo[] markerInfoArray) {
                this.this$0 = batchASTCreationTests;
                this.val$markerInfos = markerInfoArray;
                this.constantValue = null;
            }

            public void acceptAST(IJavaScriptUnit source, JavaScriptUnit ast) {
                super.acceptAST(source, ast);
                Type y = (Type)this.this$0.findNode(ast, this.val$markerInfos[0]);
                ITypeBinding typeBinding = y.resolveBinding();
                IVariableBinding fieldBinding = typeBinding.getDeclaredFields()[0];
                this.constantValue = fieldBinding.getConstantValue();
            }
        }
        Requestor requestor = new Requestor(this, markerInfos);
        this.resolveASTs(new IJavaScriptUnit[]{this.workingCopies[0]}, requestor);
        BatchASTCreationTests.assertEquals((String)"Unexpected constant value", (Object)new Integer(5), (Object)requestor.constantValue);
    }

    public void _test072() throws CoreException {
        IVariableBinding[] bindings = this.createVariableBindings(new String[]{"/P/X.js", "public class X {\n    void m() {\n        Object o;\n    }\n}"}, new String[]{"LX;.m()V#o"});
        this.assertBindingEquals("LX;.m()V", (IBinding)bindings[0].getDeclaringMethod());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test073() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P072", new String[0], Util.getJavaClassLibs(), "", "1.5");
            IJavaScriptUnit[] compilationUnits = new IJavaScriptUnit[]{this.getWorkingCopy("P072/X.js", "public class X {\n  @Override  public boolean equals(Object o) {\n    return true;\n  }\n}"), this.getWorkingCopy("P072/Y.js", "public class Y extends X {\n}"), this.getWorkingCopy("P072/Z.js", "public class Z {\n  Y m;\n  boolean foo(Object p) {\n    return this.m.equals(p);\n  }\n}")};
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(project);
            class Requestor
            extends ASTRequestor {
                final /* synthetic */ BatchASTCreationTests this$0;

                Requestor(BatchASTCreationTests batchASTCreationTests) {
                    this.this$0 = batchASTCreationTests;
                }
            }
            parser.createASTs(compilationUnits, new String[0], (ASTRequestor)new Requestor(this), null);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P072");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P072");
    }

    public void test074_Bug155003() throws CoreException {
        this.assertBindingCreated(new String[]{"/P/X.js", "public class X {\n    public void foo() throws InterruptedException, IllegalMonitorStateException {\n    }\n    void test() throws InterruptedException, IllegalMonitorStateException {\n    \t/*start*/foo()/*end*/;\n    }\n}"}, "LX;.foo()V|Ljava/lang/InterruptedException;|Ljava/lang/IllegalMonitorStateException;");
        String content = "public class X {\n    public void foo() throws InterruptedException, IllegalMonitorStateException {\n    }\n    void test() throws InterruptedException, IllegalMonitorStateException {\n    \t/*start*/foo()/*end*/;\n    }\n}";
        this.workingCopies = this.createWorkingCopies(new String[]{"/P/X.js", content}, true);
        ASTNode node = this.buildAST(content, this.workingCopies[0]);
        BatchASTCreationTests.assertEquals((String)"Invalid node type!", (int)32, (int)node.getNodeType());
        IBinding binding = this.resolveBinding(node);
        BindingKey bindingKey = new BindingKey(binding.getKey());
        this.assertStringsEqual("Unexpected thrown exceptions", "Ljava.lang.InterruptedException;\nLjava.lang.IllegalMonitorStateException;\n", bindingKey.getThrownExceptions());
    }

    public void test075_Bug155003() throws CoreException {
        String content = "public class X<T> {\n\t<U extends Exception> X<T> foo(X<T> x) throws RuntimeException, U {\n\t\treturn null;\n\t}\n\tvoid test() throws Exception {\n\t\t/*start*/foo(this)/*end*/;\n\t}\n}";
        this.workingCopies = this.createWorkingCopies(new String[]{"/P/X.js", content}, true);
        ASTNode node = this.buildAST(content, this.workingCopies[0]);
        BatchASTCreationTests.assertEquals((String)"Invalid node type!", (int)32, (int)node.getNodeType());
        IBinding binding = this.resolveBinding(node);
        BindingKey bindingKey = new BindingKey(binding.getKey());
        this.assertStringsEqual("Unexpected thrown exceptions", "Ljava.lang.RuntimeException;\nTU;\n", bindingKey.getThrownExceptions());
    }

    public void test076_Bug155003() throws CoreException {
        String content = "public class X<T> {\n\t<K, V> V bar(K key, V value) throws Exception {\n\t\treturn value;\n\t}\n\tvoid test() throws Exception {\n\t\t/*start*/bar(\"\", \"\")/*end*/;\n\t}\n}";
        this.workingCopies = this.createWorkingCopies(new String[]{"/P/X.js", content}, true);
        ASTNode node = this.buildAST(content, this.workingCopies[0]);
        BatchASTCreationTests.assertEquals((String)"Invalid node type!", (int)32, (int)node.getNodeType());
        IBinding binding = this.resolveBinding(node);
        BindingKey bindingKey = new BindingKey(binding.getKey());
        this.assertStringsEqual("Unexpected thrown exceptions", "Ljava.lang.Exception;\n", bindingKey.getThrownExceptions());
    }

    public void test077_Bug163647() throws CoreException {
        String content = "public class Test {\n    public X<? extends Object> getX() { return null; }\n    public void bar() {\n\t\ttry {\n\t\t\t/*start*/getX().foo()/*end*/;\n\t\t} catch (Exception e) {\n\t\t\t// skip\n\t\t}\n    }\n}\nclass X<T> {\n    public void foo() throws CloneNotSupportedException, IllegalMonitorStateException, InterruptedException {\n    }\n}";
        this.workingCopies = this.createWorkingCopies(new String[]{"/P/Test.js", content}, true);
        ASTNode node = this.buildAST(content, this.workingCopies[0]);
        BatchASTCreationTests.assertEquals((String)"Invalid node type!", (int)32, (int)node.getNodeType());
        IBinding binding = this.resolveBinding(node);
        BindingKey bindingKey = new BindingKey(binding.getKey());
        this.assertStringsEqual("Unexpected thrown exceptions", "Ljava.lang.CloneNotSupportedException;\nLjava.lang.IllegalMonitorStateException;\nLjava.lang.InterruptedException;\n", bindingKey.getThrownExceptions());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test078() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P078", new String[0], Util.getJavaClassLibs(), "", "1.5");
            IJavaScriptUnit[] compilationUnits = new IJavaScriptUnit[]{this.getWorkingCopy("P078/Test.js", "import java.util.*;\npublic class Test {\n        public interface ExtraIterator<T> extends Iterator {\n                public void extra();\n        }\n        public class Test2<T> implements ExtraIterator<T> {\n            public boolean hasNext() {\n                return false;\n            }\n            public T next() {\n                return null;\n            }\n            public void remove() {\n            }\n            public void extra() {\n            }\n        }\n}")};
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(project);
            final IBinding[] bindings = new IBinding[1];
            parser.createASTs(compilationUnits, new String[]{"LTest$ExtraIterator<>;"}, new ASTRequestor(){

                public void acceptAST(IJavaScriptUnit source, JavaScriptUnit localAst) {
                }

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("LTest$ExtraIterator<>;".equals(bindingKey)) {
                        bindings[0] = binding;
                    }
                }
            }, null);
            IBinding binding = bindings[0];
            BatchASTCreationTests.assertNotNull((String)"Should not be null", (Object)binding);
            BatchASTCreationTests.assertEquals((String)"Not a type binding", (int)2, (int)binding.getKind());
            ITypeBinding typeBinding = (ITypeBinding)binding;
            BatchASTCreationTests.assertEquals((String)"Wrong name", (String)"Test.ExtraIterator", (String)typeBinding.getQualifiedName());
            BatchASTCreationTests.assertTrue((String)"Not a raw type", (boolean)typeBinding.isRawType());
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P078");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P078");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test079() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P079", new String[]{"src"}, Util.getJavaClassLibs(), "bin", "1.5");
            this.createFolder("/P079/src/test");
            this.createFile("/P079/src/test/Test.js", "package test;\nimport java.util.*;\ninterface ExtraIterator<T> extends Iterator {\n        public void extra();\n}\npublic class Test<T> implements ExtraIterator<T> {\n    public boolean hasNext() {\n        return false;\n    }\n    public T next() {\n        return null;\n    }\n    public void remove() {\n    }\n    public void extra() {\n    }\n}");
            IJavaScriptUnit[] compilationUnits = new IJavaScriptUnit[]{this.getCompilationUnit("P079", "src", "test", "Test.js")};
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(project);
            final IBinding[] bindings = new IBinding[1];
            parser.createASTs(compilationUnits, new String[]{"Ltest/Test~ExtraIterator<>;"}, new ASTRequestor(){

                public void acceptAST(IJavaScriptUnit source, JavaScriptUnit localAst) {
                }

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Ltest/Test~ExtraIterator<>;".equals(bindingKey)) {
                        bindings[0] = binding;
                    }
                }
            }, null);
            IBinding binding = bindings[0];
            BatchASTCreationTests.assertNotNull((String)"Should not be null", (Object)binding);
            BatchASTCreationTests.assertEquals((String)"Not a type binding", (int)2, (int)binding.getKind());
            ITypeBinding typeBinding = (ITypeBinding)binding;
            BatchASTCreationTests.assertEquals((String)"Wrong type", (String)"test.ExtraIterator", (String)typeBinding.getQualifiedName());
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P079");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P079");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test080() throws CoreException, IOException {
        try {
            IJavaScriptProject project = this.createJavaProject("P080", new String[]{"src"}, Util.getJavaClassLibs(), "bin", "1.5");
            this.createFolder("/P080/src/test");
            this.createFile("/P080/src/test/Test.js", "package test;\nimport java.util.*;\npublic class Test {\n        public interface ExtraIterator<T> extends Iterator {\n                public void extra();\n        }\n        public class Test2<T> implements ExtraIterator<T> {\n            public boolean hasNext() {\n                return false;\n            }\n            public T next() {\n                return null;\n            }\n            public void remove() {\n            }\n            public void extra() {\n            }\n        }\n}");
            IJavaScriptUnit[] compilationUnits = new IJavaScriptUnit[]{this.getCompilationUnit("P080", "src", "test", "Test.js")};
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(project);
            final IBinding[] bindings = new IBinding[1];
            parser.createASTs(compilationUnits, new String[]{"Ltest/Test$ExtraIterator<>;"}, new ASTRequestor(){

                public void acceptAST(IJavaScriptUnit source, JavaScriptUnit localAst) {
                }

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if ("Ltest/Test$ExtraIterator<>;".equals(bindingKey)) {
                        bindings[0] = binding;
                    }
                }
            }, null);
            IBinding binding = bindings[0];
            BatchASTCreationTests.assertNotNull((String)"Should not be null", (Object)binding);
            BatchASTCreationTests.assertEquals((String)"Not a type binding", (int)2, (int)binding.getKind());
            ITypeBinding typeBinding = (ITypeBinding)binding;
            BatchASTCreationTests.assertEquals((String)"Wrong name", (String)"test.Test.ExtraIterator", (String)typeBinding.getQualifiedName());
            BatchASTCreationTests.assertTrue((String)"Not a raw type", (boolean)typeBinding.isRawType());
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P080");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P080");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test081() throws CoreException, IOException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P081", new String[]{"src"}, Util.getJavaClassLibs(), "bin", "1.5");
            String typeName = "java.util.List<java.lang.Integer>";
            String[] keys = new String[]{BindingKey.createTypeBindingKey((String)typeName)};
            class BindingRequestor
            extends ASTRequestor {
                ITypeBinding _result;
                final /* synthetic */ BatchASTCreationTests this$0;

                BindingRequestor(BatchASTCreationTests batchASTCreationTests) {
                    this.this$0 = batchASTCreationTests;
                    this._result = null;
                }

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if (this._result == null && binding != null && binding.getKind() == 2) {
                        this._result = (ITypeBinding)binding;
                    }
                }
            }
            BindingRequestor requestor = new BindingRequestor(this);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(javaProject);
            parser.createASTs(new IJavaScriptUnit[0], keys, (ASTRequestor)requestor, null);
            ITypeBinding typeBinding = requestor._result;
            BatchASTCreationTests.assertNotNull((String)"No binding", (Object)typeBinding);
            BatchASTCreationTests.assertTrue((String)"Not a parameterized type binding", (boolean)typeBinding.isParameterizedType());
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P081");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P081");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test082() throws CoreException, IOException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P082", new String[]{"src"}, Util.getJavaClassLibs(), "bin", "1.5");
            String typeName = "java.util.List<Integer>";
            String[] keys = new String[]{BindingKey.createTypeBindingKey((String)typeName)};
            class BindingRequestor
            extends ASTRequestor {
                ITypeBinding _result;
                final /* synthetic */ BatchASTCreationTests this$0;

                BindingRequestor(BatchASTCreationTests batchASTCreationTests) {
                    this.this$0 = batchASTCreationTests;
                    this._result = null;
                }

                public void acceptBinding(String bindingKey, IBinding binding) {
                    if (this._result == null && binding != null && binding.getKind() == 2) {
                        this._result = (ITypeBinding)binding;
                    }
                }
            }
            BindingRequestor requestor = new BindingRequestor(this);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(javaProject);
            parser.createASTs(new IJavaScriptUnit[0], keys, (ASTRequestor)requestor, null);
            ITypeBinding typeBinding = requestor._result;
            BatchASTCreationTests.assertNull((String)"Got a binding", (Object)typeBinding);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("P082");
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("P082");
    }

    class BindingResolver
    extends TestASTRequestor {
        private ArrayList bindingKeys = new ArrayList();
        int index = -1;
        private ArrayList foundKeys = new ArrayList();
        AbstractASTTests.MarkerInfo[] markerInfos;

        public BindingResolver(AbstractASTTests.MarkerInfo[] markerInfos) {
            this.markerInfos = markerInfos;
        }

        public void acceptAST(IJavaScriptUnit source, JavaScriptUnit cu) {
            super.acceptAST(source, cu);
            ASTNode[] nodes = BatchASTCreationTests.this.findNodes(cu, this.markerInfos[++this.index]);
            int i = 0;
            int length = nodes.length;
            while (i < length) {
                String bindingKey;
                IBinding binding = BatchASTCreationTests.this.resolveBinding(nodes[i]);
                String string = bindingKey = binding == null ? "null" : binding.getKey();
                if (bindingKey.indexOf(33) != -1 && binding.getKind() == 4) {
                    bindingKey = ((IFunctionBinding)binding).getReturnType().getKey();
                }
                this.bindingKeys.add(bindingKey);
                ++i;
            }
        }

        public void acceptBinding(String key, IBinding binding) {
            super.acceptBinding(key, binding);
            this.foundKeys.add(binding == null ? "null" : binding.getKey());
        }

        public String[] getBindingKeys() {
            int length = this.bindingKeys.size();
            String[] result = new String[length];
            this.bindingKeys.toArray(result);
            return result;
        }

        public String[] getFoundKeys() {
            int length = this.foundKeys.size();
            String[] result = new String[length];
            this.foundKeys.toArray(result);
            return result;
        }
    }

    public class TestASTRequestor
    extends ASTRequestor {
        public ArrayList asts = new ArrayList();

        public void acceptAST(IJavaScriptUnit source, JavaScriptUnit ast) {
            this.asts.add(ast);
        }

        public void acceptBinding(String bindingKey, IBinding binding) {
        }
    }
}

