/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.libraries.SystemLibraryLocation;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.tests.dom.AbstractASTTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public abstract class ConverterTestSetup
extends AbstractASTTests {
    public static final int AST_INTERNAL_JLS2 = 2;
    protected AST ast;
    static List TEST_SUITES = null;
    static boolean PROJECT_SETUP = false;

    protected ConverterTestSetup(String name) {
        super(name);
    }

    protected IPath getConverterJCLPath() {
        return this.getConverterJCLPath("");
    }

    protected IPath getConverterJCLPath(String compliance) {
        return new Path(new SystemLibraryLocation().getLibraryPath("system.js"));
    }

    protected IPath getConverterJCLSourcePath() {
        return this.getConverterJCLSourcePath("");
    }

    protected IPath getConverterJCLSourcePath(String compliance) {
        return new Path(String.valueOf(this.getExternalPath()) + "converterJclMin" + compliance + "src.zip");
    }

    protected IPath getConverterJCLRootSourcePath() {
        return new Path("");
    }

    public void tearDownSuite() throws Exception {
        this.ast = null;
        if (TEST_SUITES == null) {
            this.deleteProject("Converter");
            this.deleteProject("Converter15");
        } else {
            TEST_SUITES.remove(((Object)((Object)this)).getClass());
            if (TEST_SUITES.size() == 0) {
                this.deleteProject("Converter");
                this.deleteProject("Converter15");
            }
        }
        super.tearDown();
    }

    public void setUpJCLClasspathVariables(String compliance) throws JavaScriptModelException, IOException {
        if ("1.5".equals(compliance)) {
            if (JavaScriptCore.getIncludepathVariable((String)"CONVERTER_JCL15_LIB") == null) {
                JavaScriptCore.setIncludepathVariables((String[])new String[]{"CONVERTER_JCL15_LIB", "CONVERTER_JCL15_SRC", "CONVERTER_JCL15_SRCROOT"}, (IPath[])new IPath[]{this.getConverterJCLPath(compliance), this.getConverterJCLSourcePath(compliance), this.getConverterJCLRootSourcePath()}, null);
            }
        } else if (JavaScriptCore.getIncludepathVariable((String)"CONVERTER_JCL_LIB") == null) {
            JavaScriptCore.setIncludepathVariables((String[])new String[]{"CONVERTER_JCL_LIB", "CONVERTER_JCL_SRC", "CONVERTER_JCL_SRCROOT"}, (IPath[])new IPath[]{this.getConverterJCLPath(), this.getConverterJCLSourcePath(), this.getConverterJCLRootSourcePath()}, null);
        }
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        if (!PROJECT_SETUP) {
            this.setUpJavaProject("Converter");
            this.setUpJavaProject("Converter15", "1.5");
            ConverterTestSetup.waitUntilIndexesReady();
            PROJECT_SETUP = true;
        }
    }

    public ASTNode runConversion(IJavaScriptUnit unit, boolean resolveBindings) {
        return this.runConversion(2, unit, resolveBindings);
    }

    public ASTNode runConversion(IJavaScriptUnit unit, int position, boolean resolveBindings) {
        return this.runConversion(2, unit, position, resolveBindings);
    }

    public ASTNode runConversion(IClassFile classFile, int position, boolean resolveBindings) {
        return this.runConversion(2, classFile, position, resolveBindings);
    }

    public ASTNode runConversion(char[] source, String unitName, IJavaScriptProject project) {
        return this.runConversion(2, source, unitName, project);
    }

    public ASTNode runConversion(char[] source, String unitName, IJavaScriptProject project, boolean resolveBindings) {
        return this.runConversion(2, source, unitName, project, resolveBindings);
    }

    public ASTNode runConversion(int astLevel, IJavaScriptUnit unit, boolean resolveBindings) {
        return this.runConversion(astLevel, unit, resolveBindings, false);
    }

    public ASTNode runConversion(int astLevel, IJavaScriptUnit unit, boolean resolveBindings, boolean statementsRecovery) {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(unit);
        parser.setResolveBindings(resolveBindings);
        parser.setStatementsRecovery(statementsRecovery);
        return parser.createAST(null);
    }

    public ASTNode runJLS3Conversion(IJavaScriptUnit unit, boolean resolveBindings, boolean checkJLS2) {
        ASTParser parser;
        if (checkJLS2) {
            parser = ASTParser.newParser((int)2);
            parser.setSource(unit);
            parser.setResolveBindings(resolveBindings);
            parser.createAST(null);
        }
        parser = ASTParser.newParser((int)3);
        parser.setSource(unit);
        parser.setResolveBindings(resolveBindings);
        ASTNode result = parser.createAST(null);
        ConverterTestSetup.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        if (resolveBindings && compilationUnit.getProblems().length == 0) {
            compilationUnit.accept((ASTVisitor)new NullBindingVerifier());
        }
        return result;
    }

    public ASTNode runConversion(int astLevel, IJavaScriptUnit unit, int position, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(unit);
        parser.setFocalPosition(position);
        parser.setResolveBindings(resolveBindings);
        ASTNode result = parser.createAST(null);
        ConverterTestSetup.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        if (resolveBindings && compilationUnit.getProblems().length == 0) {
            compilationUnit.accept((ASTVisitor)new NullBindingVerifier());
        }
        return result;
    }

    public ASTNode runConversion(int astLevel, IClassFile classFile, int position, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(classFile);
        parser.setFocalPosition(position);
        parser.setResolveBindings(resolveBindings);
        ASTNode result = parser.createAST(null);
        ConverterTestSetup.assertTrue((String)"Not a compilation unit", (result.getNodeType() == 15 ? 1 : 0) != 0);
        JavaScriptUnit compilationUnit = (JavaScriptUnit)result;
        if (resolveBindings && compilationUnit.getProblems().length == 0) {
            compilationUnit.accept((ASTVisitor)new NullBindingVerifier());
        }
        return result;
    }

    public ASTNode runConversion(int astLevel, char[] source, String unitName, IJavaScriptProject project) {
        return this.runConversion(astLevel, source, unitName, project, false);
    }

    public ASTNode runConversion(int astLevel, char[] source, String unitName, IJavaScriptProject project, boolean resolveBindings) {
        return this.runConversion(astLevel, source, unitName, project, null, resolveBindings);
    }

    public ASTNode runConversion(int astLevel, char[] source, String unitName, IJavaScriptProject project, Map options, boolean resolveBindings) {
        ASTParser parser = ASTParser.newParser((int)astLevel);
        parser.setSource(source);
        parser.setUnitName(unitName);
        parser.setProject(project);
        if (options != null) {
            parser.setCompilerOptions(options);
        }
        parser.setResolveBindings(resolveBindings);
        return parser.createAST(null);
    }

    public ASTNode runConversion(int astLevel, char[] source, String unitName, IJavaScriptProject project, Map options) {
        return this.runConversion(astLevel, source, unitName, project, options, false);
    }

    public ASTNode runConversion(char[] source, String unitName, IJavaScriptProject project, Map options, boolean resolveBindings) {
        return this.runConversion(2, source, unitName, project, options, resolveBindings);
    }

    public ASTNode runConversion(char[] source, String unitName, IJavaScriptProject project, Map options) {
        return this.runConversion(2, source, unitName, project, options);
    }

    protected ASTNode getASTNodeToCompare(JavaScriptUnit unit) {
        ExpressionStatement statement = (ExpressionStatement)this.getASTNode(unit, 0, 0, 0);
        return (ASTNode)((FunctionInvocation)statement.getExpression()).arguments().get(0);
    }

    protected ASTNode getASTNode(JavaScriptUnit unit, int typeIndex, int bodyIndex, int statementIndex) {
        BodyDeclaration bodyDeclaration = (BodyDeclaration)this.getASTNode(unit, typeIndex, bodyIndex);
        if (bodyDeclaration instanceof FunctionDeclaration) {
            FunctionDeclaration methodDeclaration = (FunctionDeclaration)bodyDeclaration;
            Block block = methodDeclaration.getBody();
            return (ASTNode)block.statements().get(statementIndex);
        }
        if (bodyDeclaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)bodyDeclaration;
            return (ASTNode)typeDeclaration.bodyDeclarations().get(statementIndex);
        }
        if (bodyDeclaration instanceof Initializer) {
            Initializer initializer = (Initializer)bodyDeclaration;
            Block block = initializer.getBody();
            return (ASTNode)block.statements().get(statementIndex);
        }
        return null;
    }

    protected ASTNode getASTNode(JavaScriptUnit unit, int typeIndex, int bodyIndex) {
        return (ASTNode)unit.statements().get(bodyIndex);
    }

    protected ASTNode getASTNode(JavaScriptUnit unit, int typeIndex) {
        return (ASTNode)unit.types().get(typeIndex);
    }

    protected void checkSourceRange(ASTNode node, String expectedContents, String source) {
        ConverterTestSetup.assertNotNull((String)"The node is null", (Object)node);
        ConverterTestSetup.assertTrue((String)("The node(" + node.getClass() + ").getLength() == 0"), (node.getLength() != 0 ? 1 : 0) != 0);
        ConverterTestSetup.assertTrue((String)"The node.getStartPosition() == -1", (node.getStartPosition() != -1 ? 1 : 0) != 0);
        int length = node.getLength();
        int start = node.getStartPosition();
        String actualContentsString = source.substring(start, start + length);
        this.assertSourceEquals("Unexpected source", Util.convertToIndependantLineDelimiter((String)expectedContents), Util.convertToIndependantLineDelimiter((String)actualContentsString));
    }

    protected void checkSourceRange(ASTNode node, String expectedContents, char[] source) {
        ConverterTestSetup.assertNotNull((String)"The node is null", (Object)node);
        ConverterTestSetup.assertTrue((String)("The node(" + node.getClass() + ").getLength() == 0"), (node.getLength() != 0 ? 1 : 0) != 0);
        ConverterTestSetup.assertTrue((String)"The node.getStartPosition() == -1", (node.getStartPosition() != -1 ? 1 : 0) != 0);
        int length = node.getLength();
        int start = node.getStartPosition();
        char[] actualContents = new char[length];
        System.arraycopy(source, start, actualContents, 0, length);
        String actualContentsString = new String(actualContents);
        this.assertSourceEquals("Unexpected source", Util.convertToIndependantLineDelimiter((String)expectedContents), Util.convertToIndependantLineDelimiter((String)actualContentsString));
    }

    protected boolean isMalformed(ASTNode node) {
        return (node.getFlags() & 1) != 0;
    }

    protected boolean isRecovered(ASTNode node) {
        return (node.getFlags() & 8) != 0;
    }

    protected boolean isOriginal(ASTNode node) {
        return (node.getFlags() & 2) != 0;
    }

    protected void assertProblemsSize(JavaScriptUnit compilationUnit, int expectedSize) {
        this.assertProblemsSize(compilationUnit, expectedSize, "");
    }

    protected void assertProblemsSize(JavaScriptUnit compilationUnit, int expectedSize, String expectedOutput) {
        IProblem[] problems = compilationUnit.getProblems();
        int length = problems.length;
        if (length != expectedSize) {
            this.checkProblemMessages(expectedOutput, problems, length);
            ConverterTestSetup.assertEquals((String)"Wrong size", (int)expectedSize, (int)length);
        }
        this.checkProblemMessages(expectedOutput, problems, length);
    }

    private void checkProblemMessages(String expectedOutput, IProblem[] problems, int length) {
        if (length != 0 && expectedOutput != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < length) {
                buffer.append(problems[i].getMessage());
                if (i < length - 1) {
                    buffer.append('\n');
                }
                ++i;
            }
            String actualOutput = String.valueOf(buffer);
            if (!(expectedOutput = Util.convertToIndependantLineDelimiter((String)expectedOutput)).equals(actualOutput = Util.convertToIndependantLineDelimiter((String)actualOutput))) {
                System.out.println(Util.displayString((String)actualOutput));
                ConverterTestSetup.assertEquals((String)"different output", (String)expectedOutput, (String)actualOutput);
            }
        }
    }

    class NullBindingVerifier
    extends ASTVisitor {
        NullBindingVerifier() {
        }

        public void endVisit(ArrayAccess node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(ArrayCreation node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(ArrayInitializer node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(Assignment node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(BooleanLiteral node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(CastExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(CharacterLiteral node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(ClassInstanceCreation node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(ConditionalExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(FieldAccess node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(InfixExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(InstanceofExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(FunctionInvocation node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(NullLiteral node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(NumberLiteral node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(ParenthesizedExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(PostfixExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(PrefixExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(StringLiteral node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(SuperFieldAccess node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(SuperMethodInvocation node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(ThisExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(TypeLiteral node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(VariableDeclarationExpression node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveTypeBinding());
            super.endVisit(node);
        }

        public void endVisit(AnonymousClassDeclaration node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(ArrayType node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(ImportDeclaration node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(MemberRef node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(FunctionDeclaration node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(FunctionRef node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(PackageDeclaration node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(ParameterizedType node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(PrimitiveType node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(QualifiedName node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(QualifiedType node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(SimpleName node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(SimpleType node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(SingleVariableDeclaration node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(TypeDeclaration node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(TypeDeclarationStatement node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(TypeParameter node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(VariableDeclarationFragment node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }

        public void endVisit(WildcardType node) {
            ConverterTestSetup.assertNotNull((String)(node + " should have a binding"), (Object)node.resolveBinding());
            super.endVisit(node);
        }
    }
}

