/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.SourceType;

public class ClassNameTests
extends ModifyingResourceTests {
    static IJavaScriptProject TEST_PROJECT;
    static final int SF_LENGTH = 5;
    static int TESTS_COUNT;
    static /* synthetic */ Class class$0;

    public ClassNameTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.ClassNameTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Test suite = ClassNameTests.buildModelTestSuite(clazz);
        TESTS_COUNT = suite.countTestCases();
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (TEST_PROJECT == null) {
            String[] sourceFolders = new String[5];
            int i = 0;
            while (i < 5) {
                sourceFolders[i] = "src" + i;
                ++i;
            }
            TEST_PROJECT = this.createJavaProject("TestProject", sourceFolders, new String[]{"JCL_LIB"}, "bin");
            this.createFolder("/TestProject/src0/org/eclipse/jdt/core/test0");
            this.createFile("/TestProject/src0/org/eclipse/jdt/core/test0/Foo.js", "package org.eclipse.wst.jsdt.core.test0;\npublic class Foo {\n\tclass InFoo {}\n}\nclass Secondary {\n\tclass InSecondary {}\n}\n");
            this.createFile("/TestProject/src1/Foo.js", "public class Foo {\n\tclass InFoo {}\n}\nclass Secondary {\n\tclass InSecondary {}\n}\n");
            int length = 4;
            this.createFolder("/TestProject/src" + length + "/org/eclipse/jdt/core/test" + length);
            this.createFile("/TestProject/src" + length + "/org/eclipse/jdt/core/test" + length + "/Foo.js", "package org.eclipse.wst.jsdt.core.test" + length + ";\n" + "public class Foo {\n" + "}\n" + "class Secondary {\n" + "}\n");
            this.createFile("/TestProject/src" + length + "/org/eclipse/jdt/core/test" + length + "/Test.js", "package org.eclipse.wst.jsdt.core.test" + length + ";\n" + "public class Test {\n" + "\tpublic static void main(String[] args) {\n" + "\t\tSecondary s = new Secondary();\n" + "\t}\n" + "}\n");
        }
    }

    protected void tearDown() throws Exception {
        if (TEST_PROJECT != null && --TESTS_COUNT == 0) {
            this.deleteResource((IResource)TEST_PROJECT.getProject());
        }
        super.tearDown();
    }

    protected void assertTypeFound(String typeName, String expectedResult) throws JavaScriptModelException {
        ClassNameTests.assertNotNull((String)"TEST_PROJECT should not be null!!!", (Object)TEST_PROJECT);
        IType type = TEST_PROJECT.findType(typeName, (IProgressMonitor)new NullProgressMonitor());
        ClassNameTests.assertTrue((String)("type " + typeName + " should exist!"), (type != null && type.exists() ? 1 : 0) != 0);
        ClassNameTests.assertEquals((String)("Expected type " + typeName + " NOT found!"), (String)expectedResult, (String)((SourceType)type).toStringWithAncestors());
    }

    protected void assertTypeFound(String packageName, String typeName, String expectedResult) throws JavaScriptModelException {
        ClassNameTests.assertNotNull((String)"TEST_PROJECT should not be null!!!", (Object)TEST_PROJECT);
        IType type = TEST_PROJECT.findType(packageName, typeName, (IProgressMonitor)new NullProgressMonitor());
        ClassNameTests.assertTrue((String)("type " + typeName + " should exist!"), (type != null && type.exists() ? 1 : 0) != 0);
        ClassNameTests.assertEquals((String)("Expected type " + typeName + " NOT found!"), (String)expectedResult, (String)((SourceType)type).toStringWithAncestors());
    }

    protected void assertTypeNotFound(String typeName) throws JavaScriptModelException {
        ClassNameTests.assertNotNull((String)"TEST_PROJECT should not be null!!!", (Object)TEST_PROJECT);
        IType type = TEST_PROJECT.findType(typeName, (IProgressMonitor)new NullProgressMonitor());
        ClassNameTests.assertNotNull((String)("type " + typeName + " should NOT be null!"), (Object)type);
        ClassNameTests.assertFalse((String)("type " + typeName + " should NOT exist!"), (boolean)type.exists());
    }

    protected void assertTypeNotFound(String packageName, String typeName) throws JavaScriptModelException {
        ClassNameTests.assertNotNull((String)"TEST_PROJECT should not be null!!!", (Object)TEST_PROJECT);
        IType type = TEST_PROJECT.findType(packageName, typeName, (IProgressMonitor)new NullProgressMonitor());
        ClassNameTests.assertNotNull((String)("type " + typeName + " should NOT be null!"), (Object)type);
        ClassNameTests.assertFalse((String)("type " + typeName + " should NOT exist!"), (boolean)type.exists());
    }

    protected void assertTypeUnknown(String typeName) throws JavaScriptModelException {
        ClassNameTests.assertNotNull((String)"TEST_PROJECT should not be null!!!", (Object)TEST_PROJECT);
        IType type = TEST_PROJECT.findType(typeName, (IProgressMonitor)new NullProgressMonitor());
        ClassNameTests.assertNull((String)("type " + typeName + " should NOT be found!"), (Object)type);
    }

    protected void assertTypeUnknown(String packageName, String typeName) throws JavaScriptModelException {
        ClassNameTests.assertNotNull((String)"TEST_PROJECT should not be null!!!", (Object)TEST_PROJECT);
        IType type = TEST_PROJECT.findType(packageName, typeName, (IProgressMonitor)new NullProgressMonitor());
        ClassNameTests.assertNull((String)("type " + typeName + " should NOT be found!"), (Object)type);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testClassNameWithDollar() throws JavaScriptModelException, CoreException {
        try {
            try {
                byte[] tab = new byte[]{80, 75, 3, 4, 20, 0, 8, 0, 8, 0, -63, 88, -102, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 112, 49, 47, 65, 36, 46, 99, 108, 97, 115, 115, 93, 78, -63, 74, -61, 64, 16, 125, -45, 77, -78, 53, 86, 91, 99, 127, 64, -24, -95, 21, 106, -16, -84, 8, -91, -48, 83, 48, -121, 74, -17, -101, -72, -42, 45, 49, 43, 49, -11, -69, -12, 84, -16, -32, 7, -8, 81, -30, 108, 12, 42, -50, -31, 61, 102, -26, -67, 121, -13, -15, -7, -10, 14, -127, 41, -122, 4, -1, -15, 60, -98, -115, 36, -120, 48, -40, -88, 103, 21, 23, -86, 92, -57, 105, -74, -47, 121, 45, 33, 8, -63, -91, 41, 77, 125, 69, 16, -29, -55, -118, -32, -51, -19, -83, -18, -63, 71, 16, -62, 67, -105, -48, 79, 76, -87, -81, -73, 15, -103, -82, 110, 84, 86, 104, 66, -108, -40, 92, 21, 43, 85, 25, -41, -73, 67, -81, -66, 55, 79, 4, -103, 52, 121, 23, 124, -18, -50, 90, -62, 112, 60, 73, 126, 99, -105, 117, 101, -54, -75, 91, 46, -46, -76, -117, 1, 33, 92, -38, 109, -107, -21, -123, 113, 55, -28, 108, 116, -26, -60, 56, 65, -121, -61, 93, 117, 64, -18, 23, 70, -55, 93, -52, 76, -52, -2, -23, 14, 123, -81, -51, 58, 100, 12, -102, -95, -64, 62, 99, -17, 91, -64, 124, -64, 76, 56, 68, -65, 53, 79, 91, -77, -120, -114, 94, -2, 89, -125, 63, 86, -15, 99, -115, 26, -43, -15, 23, 80, 75, 7, 8, 122, -92, 103, 15, -20, 0, 0, 0, 78, 1, 0, 0, 80, 75, 1, 2, 20, 0, 20, 0, 8, 0, 8, 0, -63, 88, -102, 44, 122, -92, 103, 15, -20, 0, 0, 0, 78, 1, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 49, 47, 65, 36, 46, 99, 108, 97, 115, 115, 80, 75, 5, 6, 0, 0, 0, 0, 1, 0, 1, 0, 57, 0, 0, 0, 37, 1, 0, 0, 0, 0};
                IJavaScriptProject javaProject = this.createJavaProject("P", new String[]{"src"}, "bin");
                IFile jarFile = this.createFile("P/lib.jar", tab);
                javaProject.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)jarFile.getFullPath(), null, null, (boolean)false)}, (IProgressMonitor)new NullProgressMonitor());
                javaProject.findType("p1.A$");
            }
            catch (CoreException e) {
                e.printStackTrace();
                ClassNameTests.assertTrue((boolean)false);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindTypeWithDot() throws JavaScriptModelException, CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("/P/p");
            this.createFile("/P/p/X.js", "package p;\npublic class X {\n  public class Y {\n  }\n}");
            IType type = javaProject.findType("p.X.Y");
            ClassNameTests.assertEquals((String)"Unexpected type found", (String)"class Y [in X [in X.java [in p [in <project root> [in P]]]]]", (String)(type == null ? "null" : type.toString()));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSearchTypeNameInJars() throws JavaScriptModelException, CoreException {
        try {
            try {
                byte[] tab = new byte[]{80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 19, 87, -95, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 112, 49, 47, 112, 50, 47, 112, 51, 47, 3, 0, 80, 75, 7, 8, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 80, 75, 3, 4, 20, 0, 8, 0, 8, 0, 19, 87, -95, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 112, 49, 47, 112, 50, 47, 112, 51, 47, 88, 46, 99, 108, 97, 115, 115, 93, 79, -53, 78, -61, 64, 12, 28, 55, -81, -110, 6, 8, -3, 3, 110, 60, -44, -82, 10, 71, 16, 23, 36, 78, 81, 57, 20, 69, -67, 110, -62, -74, 108, -107, 102, -93, 52, -27, -65, 56, 33, 113, -32, 3, -8, 40, -124, 55, -115, 0, 117, 37, -49, -56, -10, -116, -19, -3, -6, -2, -8, -124, -125, 17, 78, 8, 97, 53, 17, -43, -107, -88, -82, -59, 60, 0, 17, -30, -107, 124, -107, -94, -112, -27, 82, 60, 102, 43, -107, 55, 1, 28, -126, 127, -85, 75, -35, -36, 17, -100, -77, -13, -108, -32, -34, -101, 103, 21, -63, -125, 31, -62, 69, -97, 112, -100, -24, 82, 77, -73, -21, 76, -43, 79, 50, 43, 20, 97, -104, -104, 92, 22, -87, -84, -75, -51, -69, -94, -37, -68, -24, 13, 33, 74, -2, -106, -34, -16, -52, -123, 49, 124, -56, -52, 108, -21, 92, 61, 104, 43, -12, -25, 99, 123, 7, 78, -47, -29, 5, -10, -11, 64, 118, 31, 99, -64, -103, 96, 38, 102, -17, -30, 29, 7, 111, 109, 59, 100, -12, -37, -94, -125, 1, 99, -76, 19, 48, 31, -74, 3, -114, 126, -51, -105, 28, -74, 71, -5, 70, -9, -97, -111, 58, 35, -1, -83, 85, -59, 63, 80, 75, 7, 8, -99, 105, 77, -38, -36, 0, 0, 0, 53, 1, 0, 0, 80, 75, 1, 2, 20, 0, 20, 0, 8, 0, 8, 0, 19, 87, -95, 44, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 49, 47, 112, 50, 47, 112, 51, 47, 80, 75, 1, 2, 20, 0, 20, 0, 8, 0, 8, 0, 19, 87, -95, 44, -99, 105, 77, -38, -36, 0, 0, 0, 53, 1, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 112, 49, 47, 112, 50, 47, 112, 51, 47, 88, 46, 99, 108, 97, 115, 115, 80, 75, 5, 6, 0, 0, 0, 0, 2, 0, 2, 0, 117, 0, 0, 0, 83, 1, 0, 0, 0, 0};
                IJavaScriptProject javaProject = this.createJavaProject("P1", new String[]{"src"}, "bin");
                IFile jarFile = this.createFile("P1/lib.jar", tab);
                javaProject.setRawIncludepath(new IIncludePathEntry[]{JavaScriptCore.newLibraryEntry((IPath)jarFile.getFullPath(), null, null, (boolean)false)}, (IProgressMonitor)new NullProgressMonitor());
                ClassNameTests.assertNotNull((Object)javaProject.findType("p1.p2.p3.X"));
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
                ClassNameTests.assertTrue((boolean)false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                ClassNameTests.assertTrue((boolean)false);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var4_8 = null;
        }
        this.deleteProject("P1");
    }

    public void testFindSecondaryType_Exist01() throws JavaScriptModelException, CoreException {
        int length = 4;
        this.assertTypeFound("org.eclipse.wst.jsdt.core.test" + length + ".Foo", "Foo [in Foo.java [in org.eclipse.wst.jsdt.core.test" + length + " [in src" + length + " [in TestProject]]]]");
    }

    public void testFindSecondaryType_Exist02() throws JavaScriptModelException, CoreException {
        int length = 4;
        this.assertTypeFound("org.eclipse.wst.jsdt.core.test" + length + ".Secondary", "Secondary [in Foo.java [in org.eclipse.wst.jsdt.core.test" + length + " [in src" + length + " [in TestProject]]]]");
    }

    public void testFindSecondaryType_Exist03() throws JavaScriptModelException, CoreException {
        this.assertTypeFound("org.eclipse.wst.jsdt.core.test0.Foo.InFoo", "InFoo [in Foo [in Foo.java [in org.eclipse.wst.jsdt.core.test0 [in src0 [in TestProject]]]]]");
    }

    public void testFindSecondaryType_Exist04() throws JavaScriptModelException, CoreException {
        this.assertTypeFound("org.eclipse.wst.jsdt.core.test0.Secondary.InSecondary", "InSecondary [in Secondary [in Foo.java [in org.eclipse.wst.jsdt.core.test0 [in src0 [in TestProject]]]]]");
    }

    public void testFindSecondaryType_Exist05() throws JavaScriptModelException, CoreException {
        this.assertTypeFound("Foo", "Foo [in Foo.java [in <default> [in src1 [in TestProject]]]]");
    }

    public void testFindSecondaryType_Exist06() throws JavaScriptModelException, CoreException {
        this.assertTypeFound("Secondary", "Secondary [in Foo.java [in <default> [in src1 [in TestProject]]]]");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFindSecondaryType_Bug72179() throws JavaScriptModelException, CoreException {
        try {
            IJavaScriptProject javaProject = this.createJavaProject("P", new String[]{""}, "");
            this.createFolder("/P/p1");
            this.createFile("/P/p1/jc.js", "package p1;\nclass jc008{}\nclass jc009{}\nclass jc010 extends jc009 {\n\tjc008 a;\n}\n");
            IType type = javaProject.findType("p1", "jc008", (IProgressMonitor)new NullProgressMonitor());
            ClassNameTests.assertTrue((String)"type 'jc008' should exist!", (type != null && type.exists() ? 1 : 0) != 0);
            ClassNameTests.assertEquals((String)"Expected type 'jc008' NOT found!", (String)"class jc008 [in jc.java [in p1 [in <project root> [in P]]]]", (String)type.toString());
            type = javaProject.findType("p1", "jc009", (IProgressMonitor)new NullProgressMonitor());
            ClassNameTests.assertTrue((String)"type 'jc009' should exist!", (type != null && type.exists() ? 1 : 0) != 0);
            ClassNameTests.assertEquals((String)"Expected type 'jc009' NOT found!", (String)"class jc009 [in jc.java [in p1 [in <project root> [in P]]]]", (String)type.toString());
            type = javaProject.findType("p1", "jc010", (IProgressMonitor)new NullProgressMonitor());
            ClassNameTests.assertTrue((String)"type 'jc010' should exist!", (type != null && type.exists() ? 1 : 0) != 0);
            ClassNameTests.assertEquals((String)"Expected type 'jc010' NOT found!", (String)"class jc010 [in jc.java [in p1 [in <project root> [in P]]]]\n  jc008 a", (String)type.toString());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P");
    }

    public void testFindSecondaryType_NotFound01() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("test.Foo");
    }

    public void testFindSecondaryType_NotFound02() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("InFoo");
    }

    public void testFindSecondaryType_NotFound03() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("InSecondary");
    }

    public void testFindSecondaryType_NotFound04() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("Foo.inFoo");
    }

    public void testFindSecondaryType_NotFound05() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("Secondary.inBar");
    }

    public void testFindSecondaryType_Unknown01() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("Unknown");
    }

    public void testFindSecondaryType_Unknown02() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("Foo.Unknown");
    }

    public void testFindSecondaryType_Unknown03() throws JavaScriptModelException, CoreException {
        this.assertTypeUnknown("org.eclipse.wst.jsdt.core.test.Unknown");
    }
}

