/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import junit.framework.ComparisonFailure;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.tests.model.CompletionTestsRequestor2;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.codeassist.RelevanceConstants;

public class CompletionWithMissingTypesTests2
extends ModifyingResourceTests
implements RelevanceConstants {
    static /* synthetic */ Class class$0;

    public CompletionWithMissingTypesTests2(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("Completion");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("Completion");
        super.tearDownSuite();
    }

    protected static void assertResults(String expected, String actual) {
        try {
            CompletionWithMissingTypesTests2.assertEquals((String)expected, (String)actual);
        }
        catch (ComparisonFailure c) {
            System.out.println(actual);
            System.out.println();
            throw c;
        }
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CompletionWithMissingTypesTests2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CompletionWithMissingTypesTests2.buildModelTestSuite(clazz);
    }

    File createFile(File parent, String name, String content) throws IOException {
        File file = new File(parent, name);
        FileOutputStream out = new FileOutputStream(file);
        out.write(content.getBytes());
        out.close();
        return file;
    }

    File createDirectory(File parent, String name) {
        File dir = new File(parent, name);
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0001() throws Exception {
        Hashtable oldOptions = JavaScriptCore.getOptions();
        try {
            Hashtable<String, String> options = new Hashtable<String, String>(oldOptions);
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", "error");
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.discouragedReference", "warning");
            options.put("org.eclipse.wst.jsdt.core.codeComplete.forbiddenReferenceCheck", "disabled");
            options.put("org.eclipse.wst.jsdt.core.codeComplete.discouragedReferenceCheck", "disabled");
            JavaScriptCore.setOptions(options);
            this.createJavaProject("P1", new String[]{"src"}, new String[]{"JCL_LIB"}, "bin");
            this.createFolder("/P1/src/a");
            this.createFile("/P1/src/a/XX.js", "package a;\npublic class XX {\n  void foo() {}\n}");
            this.createFolder("/P1/src/b");
            this.createFile("/P1/src/b/XX.js", "package b;\npublic class XX {\n  void foo() {}\n}");
            this.createJavaProject("P2", new String[]{"src"}, new String[]{"JCL_LIB"}, null, null, new String[]{"/P1"}, new String[][]{new String[0]}, new String[][]{{"a/*"}}, new boolean[1], "bin", null, null, null, "1.4");
            this.createFile("/P2/src/YY.js", "public class YY {\n  void foo() {\n    XX x = null;\n    x.fo\n  }\n}");
            CompletionWithMissingTypesTests2.waitUntilIndexesReady();
            CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(true, false, true, false, true);
            requestor.allowAllRequiredProposals();
            IJavaScriptUnit cu = this.getCompilationUnit("P2", "src", "", "YY.js");
            String str = cu.getSource();
            String completeBehind = "x.fo";
            int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
            cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
            int relevance1 = 30;
            int start1 = str.lastIndexOf("x.fo") + "x.".length();
            int end1 = start1 + "fo".length();
            int start2 = str.lastIndexOf("XX");
            int end2 = start2 + "XX".length();
            CompletionWithMissingTypesTests2.assertResults("foo[FUNCTION_REF]{foo(), La.XX;, ()V, foo, null, [" + start1 + ", " + end1 + "], " + relevance1 + "}\n" + "   XX[TYPE_REF]{a.XX, a, La.XX;, null, null, [" + start2 + ", " + end2 + "], " + relevance1 + "}\n" + "foo[FUNCTION_REF]{foo(), Lb.XX;, ()V, foo, null, [" + start1 + ", " + end1 + "], " + relevance1 + "}\n" + "   XX[TYPE_REF]{b.XX, b, Lb.XX;, null, null, [" + start2 + ", " + end2 + "], " + relevance1 + "}", requestor.getResults());
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            JavaScriptCore.setOptions((Hashtable)oldOptions);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
        JavaScriptCore.setOptions((Hashtable)oldOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test0002() throws Exception {
        Hashtable oldOptions = JavaScriptCore.getOptions();
        try {
            Hashtable<String, String> options = new Hashtable<String, String>(oldOptions);
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.forbiddenReference", "error");
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.discouragedReference", "warning");
            options.put("org.eclipse.wst.jsdt.core.codeComplete.forbiddenReferenceCheck", "enabled");
            options.put("org.eclipse.wst.jsdt.core.codeComplete.discouragedReferenceCheck", "disabled");
            JavaScriptCore.setOptions(options);
            this.createJavaProject("P1", new String[]{"src"}, new String[]{"JCL_LIB"}, "bin");
            this.createFolder("/P1/src/a");
            this.createFile("/P1/src/a/XX.js", "package a;\npublic class XX {\n  void foo() {}\n}");
            this.createFolder("/P1/src/b");
            this.createFile("/P1/src/b/XX.js", "package b;\npublic class XX {\n  void foo() {}\n}");
            this.createJavaProject("P2", new String[]{"src"}, new String[]{"JCL_LIB"}, null, null, new String[]{"/P1"}, new String[][]{new String[0]}, new String[][]{{"a/*"}}, new boolean[1], "bin", null, null, null, "1.4");
            this.createFile("/P2/src/YY.js", "public class YY {\n  void foo() {\n    XX x = null;\n    x.fo\n  }\n}");
            CompletionWithMissingTypesTests2.waitUntilIndexesReady();
            CompletionTestsRequestor2 requestor = new CompletionTestsRequestor2(true, false, true, false, true);
            requestor.allowAllRequiredProposals();
            IJavaScriptUnit cu = this.getCompilationUnit("P2", "src", "", "YY.js");
            String str = cu.getSource();
            String completeBehind = "x.fo";
            int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
            cu.codeComplete(cursorLocation, (CompletionRequestor)requestor);
            int relevance1 = 30;
            int start1 = str.lastIndexOf("x.fo") + "x.".length();
            int end1 = start1 + "fo".length();
            int start2 = str.lastIndexOf("XX");
            int end2 = start2 + "XX".length();
            CompletionWithMissingTypesTests2.assertResults("foo[FUNCTION_REF]{foo(), Lb.XX;, ()V, foo, null, [" + start1 + ", " + end1 + "], " + relevance1 + "}\n" + "   XX[TYPE_REF]{b.XX, b, Lb.XX;, null, null, [" + start2 + ", " + end2 + "], " + relevance1 + "}", requestor.getResults());
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            JavaScriptCore.setOptions((Hashtable)oldOptions);
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
        JavaScriptCore.setOptions((Hashtable)oldOptions);
    }
}

