/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class JavaConventionTests
extends AbstractJavaModelTests {
    static final int COMPILATION_UNIT_NAME = 1;
    static final int CLASS_FILE_NAME = 2;
    static final int FIELD_NAME = 3;
    static final int IDENTIFIER = 4;
    static final int IMPORT_DECLARATION = 5;
    static final int JAVA_TYPE_NAME = 6;
    static final int METHOD_NAME = 7;
    static final int PACKAGE_NAME = 8;
    static final int TYPE_VARIABLE_NAME = 9;
    static final String[] VERSIONS = new String[]{"1.1", "1.2", "1.3", "1.4", "1.5", "1.6"};
    static /* synthetic */ Class class$0;

    public JavaConventionTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaConventionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaConventionTests.buildModelTestSuite(clazz);
    }

    protected void verifyStatus(IStatus status, String[] expectedMessages) {
        int length = expectedMessages.length;
        IStatus[] allStatus = status.getChildren();
        switch (length) {
            case 0: {
                JavaConventionTests.assertTrue((String)"Status should be OK!", (boolean)status.isOK());
                return;
            }
            case 1: {
                JavaConventionTests.assertFalse((String)"Unexpected type of status!", (boolean)status.isMultiStatus());
                JavaConventionTests.assertEquals((String)"Unexpected number of errors!", (int)length, (int)1);
                allStatus = new IStatus[]{status};
                break;
            }
            default: {
                JavaConventionTests.assertTrue((String)"Unexpected type of status!", (boolean)status.isMultiStatus());
                JavaConventionTests.assertEquals((String)"Unexpected number of errors!", (int)length, (int)allStatus.length);
            }
        }
        ArrayList<String> failuresMessages = new ArrayList<String>();
        int i = 0;
        while (i < length) {
            JavaConventionTests.assertFalse((String)"Status should be KO!", (boolean)allStatus[i].isOK());
            if (!allStatus[i].getMessage().equals(expectedMessages[i])) {
                failuresMessages.add(allStatus[i].getMessage());
            }
            ++i;
        }
        int count = failuresMessages.size();
        if (count > 0) {
            System.out.println("Test " + this.getName() + " fails. Add this declaration to fix it:");
            System.out.println("\t\tString[] expectedMessages = {");
            int i2 = 0;
            while (i2 < count) {
                System.out.print("\t\t\t\"" + failuresMessages.get(i2) + "\"");
                if (i2 == count - 1) {
                    System.out.println("");
                } else {
                    System.out.println(",");
                }
                ++i2;
            }
            System.out.println("\t\t};");
        }
        JavaConventionTests.assertTrue((String)("There " + (count > 1 ? "are " : "is ") + count + " unexpected status!"), (count == 0 ? 1 : 0) != 0);
    }

    int validate(String string, int kind) {
        return this.validate(string, kind, "1.3", "1.3");
    }

    int validate(String string, int kind, String sourceLevel, String complianceLevel) {
        switch (kind) {
            case 1: {
                return JavaScriptConventions.validateCompilationUnitName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 2: {
                return JavaScriptConventions.validateClassFileName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 3: {
                return JavaScriptConventions.validateFieldName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 4: {
                return JavaScriptConventions.validateIdentifier((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 5: {
                return JavaScriptConventions.validateImportDeclaration((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 6: {
                return JavaScriptConventions.validateJavaScriptTypeName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 7: {
                return JavaScriptConventions.validateFunctionName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 8: {
                return JavaScriptConventions.validatePackageName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
            case 9: {
                return JavaScriptConventions.validateTypeVariableName((String)string, (String)sourceLevel, (String)complianceLevel).getSeverity();
            }
        }
        return -1;
    }

    public void testInvalidIdentifier() {
        String[] stringArray = new String[14];
        stringArray[0] = " s\\u0069ze";
        stringArray[1] = " s\\u0069ze ";
        stringArray[2] = "";
        stringArray[3] = "1java";
        stringArray[4] = "Foo Bar";
        stringArray[5] = "#@$!";
        stringArray[6] = "Foo-Bar";
        stringArray[7] = "if";
        stringArray[8] = "InvalidEscapeSequence\\g";
        stringArray[9] = "true";
        stringArray[10] = "false";
        stringArray[11] = "null";
        stringArray[13] = " untrimmmed ";
        String[] invalidIds = stringArray;
        int i = 0;
        while (i < invalidIds.length) {
            JavaConventionTests.assertEquals((String)("identifier not recognized as invalid: " + invalidIds[i]), (int)4, (int)this.validate(invalidIds[i], 4));
            ++i;
        }
    }

    public void testInvalidImportDeclaration1() {
        JavaConventionTests.assertEquals((String)"import not reconized as invalid; java.math.", (int)4, (int)this.validate("java.math.", 5));
    }

    public void testInvalidImportDeclaration2() {
        JavaConventionTests.assertEquals((String)"import not reconized as invalid; java.math*", (int)4, (int)this.validate("java.math*", 5));
    }

    public void testInvalidImportDeclaration3() {
        JavaConventionTests.assertEquals((String)"import not reconized as invalid; empty string", (int)4, (int)this.validate("", 5));
    }

    public void testValidCompilationUnitName() {
        String[] invalidNames = new String[]{"java/lang/Object.js", "Object.class", ".js", "Object.javaaa", "A.B.js"};
        int i = 0;
        while (i < invalidNames.length) {
            JavaConventionTests.assertEquals((String)("compilation unit name not recognized as invalid: " + invalidNames[i]), (int)4, (int)this.validate(invalidNames[i], 1));
            ++i;
        }
        String[] validNames = new String[]{"Object.js", "OBJECT.js", "object.js", "package-info.js"};
        int i2 = 0;
        while (i2 < validNames.length) {
            JavaConventionTests.assertEquals((String)("compilation unit name not recognized as valid: " + validNames[i2]), (int)0, (int)this.validate(validNames[i2], 1));
            ++i2;
        }
    }

    public void testValidFieldName() {
        JavaConventionTests.assertEquals((String)"unicode field name not handled", (int)0, (int)this.validate("s\\u0069ze", 3));
    }

    public void testValidIdentifier() {
        String[] validIds = new String[]{"s\\u0069ze", "Object", "An_Extremly_Long_Class_Name_With_Words_Separated_By_Undescores"};
        int i = 0;
        while (i < validIds.length) {
            JavaConventionTests.assertEquals((String)("identifier not recognized as valid: " + validIds[i]), (int)0, (int)this.validate(validIds[i], 4));
            ++i;
        }
    }

    public void testValidImportDeclaration() {
        JavaConventionTests.assertEquals((String)"import not reconized as valid", (int)0, (int)this.validate("java.math.*", 5));
    }

    public void testValidMethodName() {
        JavaConventionTests.assertEquals((String)"unicode method name not handled", (int)0, (int)this.validate("getSiz\\u0065", 7));
    }

    public void testValidPackageName() {
        String pkgName = "org.eclipse.wst.jsdt.core.t\\u0065sts.MyPackage";
        JavaConventionTests.assertEquals((String)"unicode package name not handled", (int)0, (int)this.validate(pkgName, 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as invalid1", (int)4, (int)this.validate("", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as valid1", (int)0, (int)this.validate("java . lang", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as invalid2", (int)4, (int)this.validate("   java . lang", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as invalid3", (int)4, (int)this.validate("java . lang  ", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as invalid4", (int)4, (int)this.validate(null, 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as unconventional1", (int)2, (int)this.validate("Java.lang", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as valid2", (int)0, (int)this.validate("java.Lang", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as invalid5", (int)4, (int)this.validate("Test.sample&plugin", 8));
        JavaConventionTests.assertEquals((String)"package name not recognized as unconventional2", (int)2, (int)this.validate("Test.sample", 8));
    }

    public void testValidTypeName() {
        JavaConventionTests.assertEquals((String)"type name should not contain slashes (1)", (int)4, (int)this.validate("Object\\", 6));
        JavaConventionTests.assertEquals((String)"type name should not contain slashes (2)", (int)4, (int)this.validate("Object/", 6));
        JavaConventionTests.assertEquals((String)"type name should not contain slashes (3)", (int)4, (int)this.validate("\\Object", 6));
        JavaConventionTests.assertEquals((String)"type name should not contain slashes (4)", (int)4, (int)this.validate("java\\lang\\Object", 6));
        JavaConventionTests.assertEquals((String)"discouraged type names not handled", (int)2, (int)this.validate("alowercasetypename", 6));
        JavaConventionTests.assertEquals((String)"unicode type name not handled", (int)0, (int)this.validate("P\\u0065a", 6));
        JavaConventionTests.assertEquals((String)"qualified type names not handled", (int)0, (int)this.validate("java  .  lang\t.Object", 6));
        JavaConventionTests.assertEquals((String)"simple qualified type names not handled", (int)0, (int)this.validate("java.lang.Object", 6));
        JavaConventionTests.assertEquals((String)"simple type names not handled", (int)0, (int)this.validate("Object", 6));
        JavaConventionTests.assertEquals((String)"discouraged type names not handled", (int)2, (int)this.validate("Object$SubType", 6));
        JavaConventionTests.assertEquals((String)"invalid type name not recognized", (int)4, (int)this.validate("==?==", 6));
    }

    public void testValidTypeVariableName() {
        JavaConventionTests.assertEquals((String)"E sould be a valid variable name", (int)0, (int)this.validate("E", 9));
    }

    public void testValidUnicodeImportDeclaration() {
        String pkgName = "com.\\u0069bm.jdt.core.tests.MyPackag\\u0065";
        JavaConventionTests.assertEquals((String)"import not reconized as valid", (int)0, (int)this.validate(pkgName, 5));
    }

    public void testValidUnicodePackageName() {
        String pkgName = "com.\\u0069bm.jdt.core.tests.MyPackag\\u0065";
        JavaConventionTests.assertEquals((String)"unicode package name not handled", (int)0, (int)this.validate(pkgName, 8));
        JavaConventionTests.assertEquals((String)"Parameter modified", (String)"com.\\u0069bm.jdt.core.tests.MyPackag\\u0065", (String)pkgName);
    }

    public void testAssertIdentifier() {
        int length = VERSIONS.length;
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                if (i < 3) {
                    JavaConventionTests.assertEquals((String)("'assert' should be accepted with source level " + VERSIONS[i]), (int)0, (int)this.validate("assert", 4, VERSIONS[i], VERSIONS[j]));
                    JavaConventionTests.assertEquals((String)"By convention, Java type names usually start with an uppercase letter", (int)2, (int)this.validate("assert", 6, VERSIONS[i], VERSIONS[j]));
                } else {
                    JavaConventionTests.assertEquals((String)("'assert' should be rejected with source level " + VERSIONS[i]), (int)4, (int)this.validate("assert", 4, VERSIONS[i], VERSIONS[j]));
                }
                ++j;
            }
            ++i;
        }
    }

    public void testEnumIdentifier() {
        int length = VERSIONS.length;
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                if (i < 4) {
                    JavaConventionTests.assertEquals((String)("'enum' should be accepted with source level " + VERSIONS[i]), (int)0, (int)this.validate("enum", 4, VERSIONS[i], VERSIONS[j]));
                    JavaConventionTests.assertEquals((String)"By convention, Java type names usually start with an uppercase letter", (int)2, (int)this.validate("enum", 6, VERSIONS[i], VERSIONS[j]));
                } else {
                    JavaConventionTests.assertEquals((String)("'enum' should be rejected with source level " + VERSIONS[i]), (int)4, (int)this.validate("enum", 4, VERSIONS[i], VERSIONS[j]));
                }
                ++j;
            }
            ++i;
        }
    }
}

