/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchGenericTests;

public class JavaSearchGenericMethodTests
extends AbstractJavaSearchGenericTests {
    static /* synthetic */ Class class$0;

    public JavaSearchGenericMethodTests(String name) {
        super(name, ERASURE_RULE);
    }

    JavaSearchGenericMethodTests(String name, int matchRule) {
        super(name, matchRule);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchGenericMethodTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchGenericMethodTests.buildModelTestSuite(clazz);
    }

    long removeFirstTypeArgument(char[] line) {
        int idx = 0;
        int length = line.length;
        while (line[idx++] != '[') {
            if (idx != length) continue;
            return -1L;
        }
        if (line[idx++] != '<') {
            return -1L;
        }
        int start = idx;
        int n = 1;
        while (idx < length && n != 0) {
            switch (line[idx++]) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        }
        if (n != 0) {
            return -1L;
        }
        return ((long)start << 32) + (long)idx;
    }

    void addResultLine(StringBuffer buffer, char[] line) {
        long positions = this.removeFirstTypeArgument(line);
        if (buffer.length() > 0) {
            buffer.append('\n');
        }
        if (positions != -1L) {
            int stop = (int)(positions >>> 32) - 1;
            int restart = (int)positions;
            buffer.append(line, 0, stop);
            buffer.append(line, restart, line.length - restart);
        } else {
            buffer.append(line);
        }
    }

    public void testMethodReferencesElementPatternSingleTypeParameter01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Single.js").getType("Single");
        IFunction method = type.getFunction("standard", new String[]{"QT;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [standard(new Exception())] ERASURE_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [standard(new Object())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [standard(new Exception())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [standard(new RuntimeException())] ERASURE_MATCH");
    }

    public void testMethodReferencesElementPatternSingleTypeParameter02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Single.js").getType("Single");
        IFunction method = type.getFunction("generic", new String[]{"QU;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] ERASURE_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [generic(new Object())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] ERASURE_MATCH");
    }

    public void testMethodReferencesElementPatternSingleTypeParameter03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Single.js").getType("Single");
        IFunction method = type.getFunction("returnParamType", new String[0]);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java Single<T> g5.m.def.Single.complete(U, Single<T>) [returnParamType()] EXACT_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [returnParamType()] ERASURE_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [returnParamType()] ERASURE_MATCH");
    }

    public void testMethodReferencesElementPatternSingleTypeParameter04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Single.js").getType("Single");
        IFunction method = type.getFunction("paramTypesArgs", new String[]{"QSingle<QT;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [paramTypesArgs(gs)] ERASURE_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [paramTypesArgs(gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [paramTypesArgs(gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [paramTypesArgs(gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [paramTypesArgs(gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [paramTypesArgs(gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [paramTypesArgs(gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesElementPatternSingleTypeParameter05() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Single.js").getType("Single");
        IFunction method = type.getFunction("complete", new String[]{"QU;", "QSingle<QT;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] ERASURE_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [complete(new Object(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [complete(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [complete(new RuntimeException(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleTypeParameter01() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("standard", new String[]{"QT1;", "QT2;", "QT3;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [standard(new Object(), new Exception(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [standard(new Object(), new Exception(), new RuntimeException())] ERASURE_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleTypeParameter02() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("generic", new String[]{"QU1;", "QU2;", "QU3;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [generic(new Object(), new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] ERASURE_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleTypeParameter03() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("returnParamType", new String[0]);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [returnParamType()] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testUnbound() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [returnParamType()] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [returnParamType()] ERASURE_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleTypeParameter04() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("paramTypesArgs", new String[]{"QSingle<QT1;>;", "QSingle<QT2;>;", "QSingle<QT3;>;", "QMultiple<QT1;QT2;QT3;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [paramTypesArgs(new Single<Object>(), new Single<Exception>(), new Single<RuntimeException>(), gm)] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testUnbound() [paramTypesArgs(new Single<Object>(), new Single<Object>(), new Single<Object>(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [paramTypesArgs(new Single<Object>(), new Single<Throwable>(), new Single<Exception>(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [paramTypesArgs(new Single<Object>(), new Single<RuntimeException>(), new Single<RuntimeException>(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [paramTypesArgs(new Single<Object>(), new Single<Exception>(), new Single<RuntimeException>(), gm)] ERASURE_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleTypeParameter05() throws CoreException {
        IType type = this.getCompilationUnit("JavaSearch15/src/g5/m/def/Multiple.js").getType("Multiple");
        IFunction method = type.getFunction("complete", new String[]{"QU1;", "QU2;", "QU3;", "QMultiple<QT1;QT2;QT3;>;"});
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [complete(new Object(), new Exception(), new RuntimeException(), gm)] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] ERASURE_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternSingleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "generic", 3);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [<Object>generic(new Object())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] ERASURE_MATCH");
    }

    public void testMethodReferencesElementPatternSingleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "generic", 6);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [generic(new Object())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>generic(new Exception())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] ERASURE_MATCH");
    }

    public void testMethodReferencesElementPatternSingleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "complete");
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [<Object>complete(new Object(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [complete(new Exception(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [complete(new RuntimeException(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesElementPatternSingleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "complete", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [complete(new Object(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>complete(new Exception(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [complete(new RuntimeException(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesElementPatternSingleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "generic", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EXACT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [generic(new Object())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] EQUIVALENT_MATCH");
    }

    public void testMethodReferencesElementPatternSingleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "complete");
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] EXACT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [complete(new Object(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [complete(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [complete(new RuntimeException(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "generic", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [<Object, Exception, RuntimeException>generic(new Object(), new Exception(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [generic(new Object(), new RuntimeException(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "generic", 6);
        this.search((IJavaScriptElement)method, 2);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [<Object, RuntimeException, RuntimeException>generic(new Object(), new RuntimeException(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "complete");
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [<Object, Exception, RuntimeException>complete(new Object(), new Exception(), new RuntimeException(), gm)] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "complete", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [complete(new Object(), new Exception(), new RuntimeException(), gm)] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [<Object, RuntimeException, RuntimeException>complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "generic", 4);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [generic(new Object(), new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EXACT_RAW_MATCH");
    }

    public void testMethodReferencesElementPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "complete", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 2, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EXACT_RAW_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments01() throws CoreException {
        this.search("<Exception>generic", 1, 2);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [generic(new Object())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>generic(new Exception())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] ERASURE_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<? extends Exception> complete ", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [complete(new Object(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>complete(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [<RuntimeException>complete(new RuntimeException(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [<RuntimeException>complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<? super Exception>*e?e*", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] EQUIVALENT_RAW_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [<Object>generic(new Object())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [<Object>complete(new Object(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>generic(new Exception())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>complete(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [complete(new RuntimeException(), gs)] ERASURE_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [<Throwable>complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15("g5.m.ref", false);
        this.search("generic", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [generic(new Object(), new RuntimeException(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] EXACT_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EXACT_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [generic(new Object())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] EXACT_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("generic(Object)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [generic(new Exception())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [generic(new Object())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [generic(new RuntimeException())] EXACT_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("complete(Exception, Single<Exception>)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testSingle() [complete(new Exception(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testObject() [complete(new Object(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [complete(new Exception(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testRuntimeException() [complete(new RuntimeException(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] EXACT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] EXACT_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Exception> generic ( Exception ) ", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>generic(new Exception())] EXACT_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<? extends Exception>complete(Exception, Single<? super Exception>)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>complete(new Exception(), gs)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testUnbound() [complete(new String(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testExtends() [complete(new Throwable(), gs)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testSuper() [complete(new RuntimeException(), gs)] POTENTIAL_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments09() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single.generic(Exception)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] EQUIVALENT_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments10() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Single<Exception>.generic(Exception)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [generic(new Exception())] EQUIVALENT_MATCH");
    }

    public void testMethodReferencesStringPatternSingleParamArguments11() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Single<? extends Exception>.<? extends Exception>generic(Exception)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefSingle.java void g5.m.ref.RefSingle.testException() [<Exception>generic(new Exception())] EQUIVALENT_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<?, ? extends Exception, ? super RuntimeException>generic", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [<Object, Exception, RuntimeException>generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [<Object, RuntimeException, RuntimeException>generic(new Object(), new RuntimeException(), new RuntimeException())] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object, Exception, RuntimeException>complete", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [<Object, Exception, RuntimeException>complete(new Object(), new Exception(), new RuntimeException(), gm)] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("generic(Object,Exception,RuntimeException)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [generic(new Object(), new RuntimeException(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] EXACT_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EXACT_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("complete(Object,RuntimeException,RuntimeException,Multiple<Object, RuntimeException, RuntimeException>)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] EXACT_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EXACT_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object, RuntimeException, RuntimeException>generic(*,*,*)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] ERASURE_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [<Object, RuntimeException, RuntimeException>generic(new Object(), new RuntimeException(), new RuntimeException())] EXACT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [generic(new Object(), new RuntimeException(), new IllegalMonitorStateException())] ERASURE_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<?,? extends Throwable,? extends RuntimeException>complete", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [<Object, Exception, RuntimeException>complete(new Object(), new Exception(), new RuntimeException(), gm)] EQUIVALENT_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testExtends() [<Object, RuntimeException, RuntimeException>complete(new Object(), new RuntimeException(), new RuntimeException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.testSuper() [<Object, RuntimeException, IllegalMonitorStateException>complete(new Object(), new RuntimeException(), new IllegalMonitorStateException(), gm)] POTENTIAL_MATCH\nsrc/g5/m/ref/RefRaw.java void g5.m.ref.RefRaw.testMultiple() [complete(new Object(), new Exception(), new RuntimeException(), gm)] EQUIVALENT_RAW_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple.generic(Object,Exception,RuntimeException)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments09() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Multiple<Object, RuntimeException, RuntimeException>.generic(Object,Exception,RuntimeException)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [generic(new Object(), new Exception(), new RuntimeException())] ERASURE_MATCH");
    }

    public void testMethodReferencesStringPatternMultipleParamArguments10() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Multiple<?,? extends Throwable,? extends RuntimeException>.<?,? extends Throwable,? extends RuntimeException>generic(Object,Exception,RuntimeException)", 1, 2, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/ref/RefMultiple.java void g5.m.ref.RefMultiple.test() [<Object, Exception, RuntimeException>generic(new Object(), new Exception(), new RuntimeException())] EQUIVALENT_MATCH");
    }

    public void testMethodDeclarationsElementPatternSingleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "generic", 3);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternSingleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "generic", 6);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternSingleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "generic", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternSingleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "complete");
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java Single<T> g5.m.def.Single.complete(U, Single<T>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternSingleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefSingle.js");
        IFunction method = this.selectMethod(unit, "complete", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java Single<T> g5.m.def.Single.complete(U, Single<T>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternSingleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "complete");
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java Single<T> g5.m.def.Single.complete(U, Single<T>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "generic", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java T1 g5.m.def.Multiple.generic(U1, U2, U3) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "generic", 6);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java T1 g5.m.def.Multiple.generic(U1, U2, U3) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "generic", 4);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java T1 g5.m.def.Multiple.generic(U1, U2, U3) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "complete");
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefMultiple.js");
        IFunction method = this.selectMethod(unit, "complete", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsElementPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptUnit unit = this.getCompilationUnit("JavaSearch15/src/g5/m/ref/RefRaw.js");
        IFunction method = this.selectMethod(unit, "complete", 2);
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search((IJavaScriptElement)method, 0, scope, this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Exception>generic", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<U>complete", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java Single<T> g5.m.def.Single.complete(U, Single<T>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<T> *e?e*", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH\nsrc/g5/m/def/Single.java Single<T> g5.m.def.Single.complete(U, Single<T>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("generic(*)", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Exception>generic(*)", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Single.<Object>generic", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Single<Object>.<U>generic", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternSingleParamArguments08() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Single<?>.<?>generic", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Single.java T g5.m.def.Single.generic(U) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments01() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<?, ? extends Exception, ? super RuntimeException>generic", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java T1 g5.m.def.Multiple.generic(U1, U2, U3) [generic] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments02() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object, Exception, RuntimeException>complete", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments03() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("complete(*,*,*,*)", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments04() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("<Object, Exception, RuntimeException>complete(*,*,*,*)", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments05() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("Multiple.<Object, Exception, RuntimeException>complete", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments06() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Multiple<Object, Exception, RuntimeException>.<U1,U2,U3>complete", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }

    public void testMethodDeclarationsStringPatternMultipleParamArguments07() throws CoreException {
        IJavaScriptSearchScope scope = this.getJavaSearchScope15();
        this.search("g5.m.def.Multiple<?,?,?>.<?,?,?>complete", 1, 0, scope, (SearchRequestor)this.resultCollector);
        this.assertSearchResults("src/g5/m/def/Multiple.java Multiple<T1,T2,T3> g5.m.def.Multiple.complete(U1, U2, U3, Multiple<T1,T2,T3>) [complete] EXACT_MATCH");
    }
}

