/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeHierarchyChangedListener;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class TypeHierarchyNotificationTests
extends ModifyingResourceTests
implements ITypeHierarchyChangedListener {
    protected boolean changeReceived = false;
    protected ITypeHierarchy hierarchy = null;
    protected int notifications = 0;
    static /* synthetic */ Class class$0;

    public TypeHierarchyNotificationTests(String name) {
        super(name);
    }

    private void assertOneChange(ITypeHierarchy h) {
        TypeHierarchyNotificationTests.assertTrue((String)"Should receive change", (boolean)this.changeReceived);
        TypeHierarchyNotificationTests.assertTrue((String)"Change should be for this hierarchy", (this.hierarchy == h ? 1 : 0) != 0);
        TypeHierarchyNotificationTests.assertEquals((String)"Unexpected number of notifications", (int)1, (int)this.notifications);
    }

    private void addSuper(IJavaScriptUnit unit, String typeName, String newSuper) throws JavaScriptModelException {
        IJavaScriptUnit copy = unit.getWorkingCopy(null);
        IType type = copy.getTypes()[0];
        String source = type.getSource();
        int superIndex = -1;
        superIndex = source.indexOf(typeName) + typeName.length();
        String newSource = String.valueOf(source.substring(0, superIndex)) + " extends " + newSuper + source.substring(superIndex);
        type.delete(true, null);
        copy.createType(newSource, null, true, null);
        copy.commitWorkingCopy(true, null);
    }

    protected void changeSuper(IJavaScriptUnit unit, String existingSuper, String newSuper) throws JavaScriptModelException {
        IJavaScriptUnit copy = unit.getWorkingCopy(null);
        IType type = copy.getTypes()[0];
        String source = type.getSource();
        int superIndex = -1;
        superIndex = source.indexOf(" " + existingSuper);
        String newSource = String.valueOf(source.substring(0, superIndex)) + " " + newSuper + source.substring(superIndex + existingSuper.length() + 1);
        type.delete(true, null);
        copy.createType(newSource, null, true, null);
        copy.commitWorkingCopy(true, null);
    }

    protected void changeVisibility(IJavaScriptUnit unit, String existingModifier, String newModifier) throws JavaScriptModelException {
        IJavaScriptUnit copy = unit.getWorkingCopy(null);
        IType type = copy.getTypes()[0];
        String source = type.getSource();
        int modifierIndex = -1;
        modifierIndex = source.indexOf(existingModifier);
        String newSource = String.valueOf(source.substring(0, modifierIndex)) + " " + newModifier + source.substring(modifierIndex + existingModifier.length());
        type.delete(true, null);
        copy.createType(newSource, null, true, null);
        copy.commitWorkingCopy(true, null);
    }

    private void reset() {
        this.changeReceived = false;
        this.hierarchy = null;
        this.notifications = 0;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reset();
        this.setUpJavaProject("TypeHierarchyNotification");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.TypeHierarchyNotificationTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return TypeHierarchyNotificationTests.buildModelTestSuite(clazz);
    }

    protected void tearDown() throws Exception {
        this.deleteProject("TypeHierarchyNotification");
        super.tearDown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddAnonymousInRegion() throws CoreException {
        IJavaScriptUnit copy;
        block4: {
            ITypeHierarchy h = null;
            copy = null;
            try {
                copy = this.getCompilationUnit("TypeHierarchyNotification", "src", "p3", "A.js");
                copy.becomeWorkingCopy(null, null);
                IRegion region = JavaScriptCore.newRegion();
                region.add(copy.getParent());
                h = copy.getJavaScriptProject().newTypeHierarchy(region, null);
                h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                String newSource = "package p3;\npublic class A{\n  B field = new B() {};\n}";
                copy.getBuffer().setContents(newSource);
                copy.reconcile(0, false, null, null);
                copy.commitWorkingCopy(true, null);
                this.assertOneChange(h);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (h != null) {
                    h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                }
                if (copy == null) throw throwable;
                copy.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (h == null) break block4;
            }
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        if (copy == null) return;
        copy.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCompilationUnit1() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchyNotification", "src", "p");
        IJavaScriptUnit newCU1 = pkg.createCompilationUnit("Z1.js", "package p;\n\npublic class Z1 {\n\n\tpublic static main(String[] args) {\n\t\tSystem.out.println(\"HelloWorld\");\n\t}\n}\n", false, null);
        try {
            this.assertCreation((IJavaScriptElement)newCU1);
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive change", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCompilationUnit2() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchyNotification", "src", "p");
        IJavaScriptUnit newCU2 = pkg.createCompilationUnit("Z2.js", "package p;\n\npublic class Z2 extends e.E {\n}\n", false, null);
        try {
            this.assertCreation((IJavaScriptElement)newCU2);
            this.assertOneChange(h);
            h.refresh(null);
            IType eE = this.getCompilationUnit("TypeHierarchyNotification", "src", "e", "E.js").getType("E");
            IType[] subtypes = h.getSubtypes(eE);
            TypeHierarchyNotificationTests.assertTrue((String)"Should be one subtype of e.E", (subtypes.length == 1 ? 1 : 0) != 0);
            TypeHierarchyNotificationTests.assertEquals((String)"Subtype of e.E should be p.Z2", (Object)newCU2.getType("Z2"), (Object)subtypes[0]);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCompilationUnit3() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchyNotification", "src", "p");
        IJavaScriptUnit newCU3 = pkg.createCompilationUnit("Z3.js", "package p;\n\npublic class Z3 {\n  public class InnerZ extends d.D {\n  }\n}\n", false, null);
        try {
            this.assertCreation((IJavaScriptElement)newCU3);
            this.assertOneChange(h);
            h.refresh(null);
            IType dD = this.getCompilationUnit("TypeHierarchyNotification", "src", "d", "D.js").getType("D");
            IType[] subtypes = h.getSubtypes(dD);
            TypeHierarchyNotificationTests.assertTrue((String)"Should be one subtype of d.D", (subtypes.length == 1 ? 1 : 0) != 0);
            TypeHierarchyNotificationTests.assertEquals((String)"Subtype of d.D should be p.Z3.InnerZ", (Object)newCU3.getType("Z3").getType("InnerZ"), (Object)subtypes[0]);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddCompilationUnitInRegion() throws CoreException, IOException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IRegion region = JavaScriptCore.newRegion();
        region.add((IJavaScriptElement)javaProject);
        ITypeHierarchy h = javaProject.newTypeHierarchy(region, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            Object var9_14;
            this.setUpJavaProject("TypeHierarchyDependent");
            IPackageFragment pkg = this.getPackageFragment("TypeHierarchyDependent", "", "");
            IJavaScriptUnit newCU1 = pkg.createCompilationUnit("Z1.js", "\npublic class Z1 {\n\n\tpublic static main(String[] args) {\n\t\tSystem.out.println(\"HelloWorld\");\n\t}\n}\n", false, null);
            try {
                this.assertCreation((IJavaScriptElement)newCU1);
                TypeHierarchyNotificationTests.assertTrue((String)"Should not receive change", (!this.changeReceived ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.deleteResource(newCU1.getUnderlyingResource());
                this.reset();
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            this.deleteResource(newCU1.getUnderlyingResource());
            this.reset();
            pkg = this.getPackageFragment("TypeHierarchyNotification", "src", "p");
            IJavaScriptUnit newCU2 = pkg.createCompilationUnit("Z2.js", "package p;\n\npublic class Z2 extends e.E {\n}\n", false, null);
            try {
                this.assertCreation((IJavaScriptElement)newCU2);
                this.assertOneChange(h);
                h.refresh(null);
                IType eE = this.getCompilationUnit("TypeHierarchyNotification", "src", "e", "E.js").getType("E");
                IType[] subtypes = h.getSubtypes(eE);
                TypeHierarchyNotificationTests.assertTrue((String)"Should be one subtype of e.E", (subtypes.length == 1 ? 1 : 0) != 0);
                TypeHierarchyNotificationTests.assertEquals((String)"Subtype of e.E should be p.Z2", (Object)newCU2.getType("Z2"), (Object)subtypes[0]);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.deleteResource(newCU2.getUnderlyingResource());
                h.refresh(null);
                this.reset();
                throw throwable;
            }
            {
                var9_14 = null;
            }
            this.deleteResource(newCU2.getUnderlyingResource());
            h.refresh(null);
            this.reset();
            IJavaScriptUnit newCU3 = pkg.createCompilationUnit("Z3.js", "package p;\n\npublic class Z3 extends Throwable {\n}\n", false, null);
            try {
                this.assertCreation((IJavaScriptElement)newCU3);
                this.assertOneChange(h);
                h.refresh(null);
                IType throwableClass = this.getClassFile("TypeHierarchyNotification", this.getExternalJCLPathString(), "java.lang", "Throwable.class").getType();
                TypeHierarchyNotificationTests.assertEquals((String)"Superclass of Z3 should be java.lang.Throwable", (Object)throwableClass, (Object)h.getSuperclass(newCU3.getType("Z3")));
            }
            catch (Throwable throwable) {
                var9_14 = null;
                this.deleteResource(newCU3.getUnderlyingResource());
                h.refresh(null);
                this.reset();
                throw throwable;
            }
            {
                var9_14 = null;
                this.deleteResource(newCU3.getUnderlyingResource());
                h.refresh(null);
                this.reset();
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            this.deleteProject("TypeHierarchyDependent");
            throw throwable;
        }
        {
            Object var11_17 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        this.deleteProject("TypeHierarchyDependent");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExternalCompilationUnit() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchyNotification", "src", "p.other");
        IJavaScriptUnit newCU = pkg.createCompilationUnit("Z.js", "package p.other;\n\npublic class Z {\n\n\tpublic static main(String[] args) {\n\t\tSystem.out.println(\"HelloWorld\");\n\t}\n}\n", false, null);
        try {
            this.assertCreation((IJavaScriptElement)newCU);
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive changes", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteResource(newCU.getUnderlyingResource());
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteResource(newCU.getUnderlyingResource());
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExternalPackage() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        try {
            this.createJavaProject("Other", new String[]{"src"}, "bin");
            h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            IPackageFragmentRoot root = this.getPackageFragmentRoot("Other", "src");
            IPackageFragment frag = root.createPackageFragment("a.day.in.spain", false, null);
            try {
                this.assertCreation((IJavaScriptElement)frag);
                TypeHierarchyNotificationTests.assertTrue((String)"Should not receive changes", (!this.changeReceived ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                frag.delete(true, null);
                this.reset();
                throw throwable;
            }
            {
                Object var7_9 = null;
                frag.delete(true, null);
                this.reset();
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.deleteProject("Other");
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        this.deleteProject("Other");
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExternalProject() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        project.getJavaScriptModel().getWorkspace().getRoot().getProject("NewProject").create(null);
        try {
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive change", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("NewProject");
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("NewProject");
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddListenerTwice() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IJavaScriptUnit superCU = this.getCompilationUnit("TypeHierarchyNotification", "src", "b", "B.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IFile file = (IFile)superCU.getUnderlyingResource();
        try {
            this.deleteResource((IResource)file);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddPackage() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragmentRoot root = this.getPackageFragmentRoot("TypeHierarchyNotification", "src");
        IPackageFragment frag = root.createPackageFragment("one.two.three", false, null);
        try {
            this.assertCreation((IJavaScriptElement)frag);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddPackageFragmentRoot() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        IIncludePathEntry newEntry = JavaScriptCore.newSourceEntry((IPath)project.getProject().getFullPath().append("extra"));
        IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
        System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
        newCP[originalCP.length] = newEntry;
        try {
            project.setRawIncludepath(newCP, null);
            this.reset();
            project.getProject().getFolder("extra").create(false, true, null);
            IPackageFragmentRoot newRoot = this.getPackageFragmentRoot("TypeHierarchyNotification", "extra");
            TypeHierarchyNotificationTests.assertTrue((String)"New root should now be visible", (newRoot != null ? 1 : 0) != 0);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddProject() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        IIncludePathEntry newEntry = JavaScriptCore.newProjectEntry((IPath)new Path("/NewProject"), (boolean)false);
        IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
        System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
        newCP[originalCP.length] = newEntry;
        try {
            project.setRawIncludepath(newCP, null);
            this.reset();
            final IProject newProject = project.getJavaScriptModel().getWorkspace().getRoot().getProject("NewProject");
            IWorkspaceRunnable create = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProject.create(null, null);
                    newProject.open(null);
                }
            };
            this.getWorkspace().run(create, null);
            IProjectDescription description = newProject.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
            newProject.setDescription(description, null);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.deleteProject("NewProject");
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        this.deleteProject("NewProject");
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddRemoveClassFile() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit unit = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "MyError.js");
        IType type = unit.getType("MyError");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IFolder pathFolder = project.getProject().getFolder("patch");
        pathFolder.create(true, true, null);
        IIncludePathEntry newEntry = JavaScriptCore.newLibraryEntry((IPath)pathFolder.getFullPath(), null, null, (boolean)false);
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        IIncludePathEntry[] newClassPath = new IIncludePathEntry[classpath.length + 1];
        newClassPath[0] = newEntry;
        System.arraycopy(classpath, 0, newClassPath, 1, classpath.length);
        try {
            this.setClasspath(project, newClassPath);
            IPackageFragment pf = project.getPackageFragmentRoots()[0].createPackageFragment("java.lang", false, null);
            h.refresh(null);
            this.reset();
            IFile file = this.getProject("TypeHierarchyNotification").getFile("Error.class");
            ((IFolder)pf.getUnderlyingResource()).getFile("Error.class").create(file.getContents(false), false, null);
            this.assertOneChange(h);
            h.refresh(null);
            TypeHierarchyNotificationTests.assertEquals((String)"Superclass of MyError should be Error in patch", (Object)pf.getClassFile("Error.class").getType(), (Object)h.getSuperclass(type));
            this.reset();
            this.deleteResource(pf.getClassFile("Error.class").getUnderlyingResource());
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChangeFocusModifier() throws CoreException {
        IJavaScriptUnit workingCopy;
        block6: {
            ITypeHierarchy h = null;
            workingCopy = null;
            try {
                this.createJavaProject("P1");
                this.createFolder("/P1/p");
                this.createFile("/P1/p/X.js", "package p1;\npublic class X {\n}");
                workingCopy = this.getCompilationUnit("/P1/p/X.js");
                workingCopy.becomeWorkingCopy(null, null);
                h = workingCopy.getType("X").newTypeHierarchy(null);
                h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                workingCopy.getBuffer().setContents("package p1;\nclass X {\n}");
                workingCopy.reconcile(0, false, null, null);
                workingCopy.commitWorkingCopy(false, null);
                this.assertOneChange(h);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (h != null) {
                    h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                }
                if (workingCopy != null) {
                    workingCopy.discardWorkingCopy();
                }
                this.deleteProjects(new String[]{"P1", "P2"});
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (h == null) break block6;
            }
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        if (workingCopy != null) {
            workingCopy.discardWorkingCopy();
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCloseProject() throws Exception {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            TypeHierarchyNotificationTests.assertTrue((boolean)h.exists());
            javaProject.getProject().close(null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should have been invalidated", (!h.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEditExtendsSourceType() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            this.changeSuper(cu, "B", "a.A");
            this.assertOneChange(h);
            h.refresh(null);
            this.reset();
            this.changeSuper(cu, "a.A", "B");
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddDependentProject() throws CoreException {
        block4: {
            ITypeHierarchy h = null;
            try {
                this.createJavaProject("P1");
                this.createFolder("/P1/p");
                this.createFile("/P1/p/X.js", "package p1;\npublic class X {\n}");
                h = this.getCompilationUnit("/P1/p/X.js").getType("X").newTypeHierarchy(null);
                h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                this.createJavaProject("P2", new String[]{""}, new String[0], new String[]{"/P1"}, "");
                this.assertOneChange(h);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (h != null) {
                    h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                }
                this.deleteProjects(new String[]{"P1", "P2"});
                throw throwable;
            }
            {
                Object var2_4 = null;
                if (h == null) break block4;
            }
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        this.deleteProjects(new String[]{"P1", "P2"});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExtendsSourceType1() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p2", "A.js");
        IType type = cu.getType("A");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            this.addSuper(cu, "A", "p2.B");
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExtendsSourceType2() throws CoreException {
        IJavaScriptUnit copy;
        block4: {
            ITypeHierarchy h = null;
            copy = null;
            try {
                copy = this.getCompilationUnit("TypeHierarchyNotification", "src", "p2", "A.js");
                copy.becomeWorkingCopy(null, null);
                IRegion region = JavaScriptCore.newRegion();
                region.add(copy.getParent());
                h = copy.getJavaScriptProject().newTypeHierarchy(region, null);
                h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                String typeName = "A";
                String newSuper = "p2.B";
                String source = copy.getBuffer().getContents();
                int superIndex = -1;
                superIndex = source.indexOf(typeName) + typeName.length();
                String newSource = String.valueOf(source.substring(0, superIndex)) + " extends " + newSuper + source.substring(superIndex);
                copy.getBuffer().setContents(newSource);
                copy.reconcile(0, false, null, null);
                copy.commitWorkingCopy(true, null);
                this.assertOneChange(h);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (h != null) {
                    h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                }
                if (copy == null) throw throwable;
                copy.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (h == null) break block4;
            }
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        if (copy == null) return;
        copy.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddExtendsSourceType3() throws CoreException {
        IJavaScriptUnit copy;
        block4: {
            IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
            copy = this.getCompilationUnit("TypeHierarchyNotification", "src", "p2", "B.js");
            ITypeHierarchy h = null;
            try {
                copy.becomeWorkingCopy(null, null);
                h = this.getCompilationUnit("TypeHierarchyNotification", "src", "p2", "A.js").getType("A").newTypeHierarchy(javaProject, null);
                h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                String typeName = "B";
                String newSuper = "p2.A";
                String source = copy.getBuffer().getContents();
                int superIndex = -1;
                superIndex = source.indexOf(typeName) + typeName.length();
                String newSource = String.valueOf(source.substring(0, superIndex)) + " extends " + newSuper + source.substring(superIndex);
                copy.getBuffer().setContents(newSource);
                copy.reconcile(0, false, null, null);
                copy.commitWorkingCopy(true, null);
                this.assertOneChange(h);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (h != null) {
                    h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                }
                copy.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (h == null) break block4;
            }
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        copy.discardWorkingCopy();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEditExternalSourceType() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IJavaScriptUnit cu2 = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "External.js");
        IField field = cu2.getType("External").getField("field");
        try {
            field.delete(false, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should receive NO change", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEditFieldSourceType() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            IField field = type.getField("field");
            String source = field.getSource();
            field.delete(false, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive change", (!this.changeReceived ? 1 : 0) != 0);
            type.createField(source, null, false, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should receive change", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEditImportSourceType() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            IImportDeclaration importDecl = cu.getImport("b.*");
            importDecl.delete(false, null);
            this.assertOneChange(h);
            h.refresh(null);
            this.reset();
            importDecl = cu.getImport("i.*");
            importDecl.delete(false, null);
            this.assertOneChange(h);
            h.refresh(null);
            this.reset();
            cu.createImport("b.B", null, null);
            this.assertOneChange(h);
            h.refresh(null);
            this.reset();
            cu.createImport("i.*", null, null);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEditSourceTypes() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        final IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        final IJavaScriptUnit superCU = this.getCompilationUnit("TypeHierarchyNotification", "src", "b", "B.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            JavaScriptCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        TypeHierarchyNotificationTests.this.changeVisibility(superCU, "public", "private");
                        TypeHierarchyNotificationTests.this.changeSuper(cu, "X", "a.A");
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        TypeHierarchyNotificationTests.assertTrue((String)"No exception", (boolean)false);
                    }
                }
            }, null);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testEditSuperType() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IJavaScriptUnit superCU = this.getCompilationUnit("TypeHierarchyNotification", "src", "b", "B.js");
        IType type = cu.getType("X");
        IType superType = superCU.getType("B");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            IField superField = superType.getField("value");
            superField.delete(false, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should receive no change", (!this.changeReceived ? 1 : 0) != 0);
            this.changeVisibility(superCU, "public", "private");
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveCompilationUnit() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IJavaScriptUnit superCU = this.getCompilationUnit("TypeHierarchyNotification", "src", "b", "B.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IFile file = (IFile)superCU.getUnderlyingResource();
        try {
            this.deleteResource((IResource)file);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveExternalCompilationUnit() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IJavaScriptUnit otherCU = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "External.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IFile file = (IFile)otherCU.getUnderlyingResource();
        try {
            this.deleteResource((IResource)file);
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive changes", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveExternalPackage() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragment pkg = this.getPackageFragment("TypeHierarchyNotification", "src", "p.other");
        IFolder folder = (IFolder)pkg.getUnderlyingResource();
        try {
            this.deleteResource((IResource)folder);
            TypeHierarchyNotificationTests.assertTrue((String)"Should receive NO change", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveExternalPackageFragmentRoot() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IIncludePathEntry[] originalCP = project.getRawIncludepath();
        IIncludePathEntry newEntry = JavaScriptCore.newSourceEntry((IPath)project.getProject().getFullPath().append("extra"));
        IIncludePathEntry[] newCP = new IIncludePathEntry[originalCP.length + 1];
        System.arraycopy(originalCP, 0, newCP, 0, originalCP.length);
        newCP[originalCP.length] = newEntry;
        try {
            project.setRawIncludepath(newCP, null);
            this.reset();
            project.getProject().getFolder("extra").create(false, true, null);
            IPackageFragmentRoot newRoot = this.getPackageFragmentRoot("TypeHierarchyNotification", "extra");
            TypeHierarchyNotificationTests.assertTrue((String)"New root should now be visible", (newRoot != null ? 1 : 0) != 0);
            this.assertOneChange(h);
            h.refresh(null);
            this.reset();
            project.setRawIncludepath(originalCP, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive change", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveExternalProject() throws CoreException {
        try {
            this.createJavaProject("External", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/TypeHierarchyNotification"}, "");
            this.createFolder("/External/p");
            this.createFile("/External/p/Y.js", "package p; public class Y extends X {}");
            IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
            IType type = cu.getType("X");
            ITypeHierarchy h = type.newTypeHierarchy(null);
            h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            try {
                this.deleteProject("External");
                TypeHierarchyNotificationTests.assertTrue((String)"Should receive change", (boolean)this.changeReceived);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
                throw throwable;
            }
            {
                Object var4_6 = null;
                h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.deleteProject("External");
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.deleteProject("External");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveListener() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        final IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        final IJavaScriptUnit superCU = this.getCompilationUnit("TypeHierarchyNotification", "src", "b", "B.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        ITypeHierarchyChangedListener listener = new ITypeHierarchyChangedListener(){

            public void typeHierarchyChanged(ITypeHierarchy th) {
                TypeHierarchyNotificationTests.this.changeReceived = true;
                TypeHierarchyNotificationTests.this.hierarchy = th;
                ++TypeHierarchyNotificationTests.this.notifications;
                th.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            }
        };
        h.addTypeHierarchyChangedListener(listener);
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        TypeHierarchyNotificationTests.this.changeVisibility(superCU, "public", "private");
                        TypeHierarchyNotificationTests.this.changeSuper(cu, "B", "a.A");
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        TypeHierarchyNotificationTests.assertTrue((String)"No exception", (boolean)false);
                    }
                }
            }, null);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemovePackage() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IPackageFragment pkg = type.getPackageFragment();
        try {
            this.deleteResource(pkg.getUnderlyingResource());
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemovePackageFragmentRoots() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            project.setRawIncludepath(null, null);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveProject() throws CoreException, IOException {
        ITypeHierarchy h = null;
        try {
            this.setUpJavaProject("TypeHierarchyDependent");
            IJavaScriptProject project = this.getJavaProject("TypeHierarchyDependent");
            IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyDependent", "", "", "Dependent.js");
            IType type = cu.getType("Dependent");
            h = type.newTypeHierarchy(project, null);
            h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            TypeHierarchyNotificationTests.assertEquals((String)"Superclass of Dependent is a.A", (String)"a.A", (String)h.getSuperclass(type).getFullyQualifiedName());
            IResource folder = this.getJavaProject("TypeHierarchyNotification").getUnderlyingResource();
            this.deleteResource(folder);
            this.assertOneChange(h);
            TypeHierarchyNotificationTests.assertTrue((String)"Should still exist", (boolean)h.exists());
            h.refresh(null);
            IType superType = h.getSuperclass(type);
            TypeHierarchyNotificationTests.assertTrue((String)"Superclass of Dependent should be null", (superType == null ? 1 : 0) != 0);
            folder = this.getJavaProject("TypeHierarchyDependent").getUnderlyingResource();
            this.deleteResource(folder);
            TypeHierarchyNotificationTests.assertTrue((String)"Should have been invalidated", (!h.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.deleteProject("TypeHierarchyDependent");
            if (h == null) throw throwable;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.deleteProject("TypeHierarchyDependent");
        if (h == null) return;
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveType() throws CoreException {
        IJavaScriptProject project = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(project, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            type.delete(true, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should have been invalidated", (!h.exists() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRenameCompilationUnit() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        try {
            cu.rename("X2.js", false, null);
            this.assertOneChange(h);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRenameExternalCompilationUnit() throws CoreException {
        IJavaScriptProject javaProject = this.getJavaProject("TypeHierarchyNotification");
        IJavaScriptUnit cu = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "X.js");
        IType type = cu.getType("X");
        ITypeHierarchy h = type.newTypeHierarchy(javaProject, null);
        h.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        IJavaScriptUnit cu2 = this.getCompilationUnit("TypeHierarchyNotification", "src", "p", "External.js");
        try {
            cu2.rename("External2.js", false, null);
            TypeHierarchyNotificationTests.assertTrue((String)"Should not receive changes", (!this.changeReceived ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        h.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.changeReceived = true;
        this.hierarchy = typeHierarchy;
        ++this.notifications;
    }
}

