/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WildcardType;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingTypeDeclTest
extends ASTRewritingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTypeDeclTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingTypeDeclTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingTypeDeclTest.allTests();
    }

    public void testTypeDeclChanges() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class F implements Runnable {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        SimpleName name = type.getName();
        SimpleName newName = ast.newSimpleName("X");
        rewrite.replace((ASTNode)name, (ASTNode)newName, null);
        Name superClass = type.getSuperclass();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super type", (superClass != null ? 1 : 0) != 0);
        SimpleName newSuperclass = ast.newSimpleName("Object");
        rewrite.replace((ASTNode)superClass, (ASTNode)newSuperclass, null);
        List superInterfaces = type.superInterfaces();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super interfaces", (!superInterfaces.isEmpty() ? 1 : 0) != 0);
        SimpleName newSuperinterface = ast.newSimpleName("Cloneable");
        rewrite.replace((ASTNode)superInterfaces.get(0), (ASTNode)newSuperinterface, null);
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        FieldDeclaration newFieldDecl = this.createNewField(ast, "fCount");
        rewrite.replace((ASTNode)members.get(0), (ASTNode)newFieldDecl, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "F");
        int newModifiers = 0;
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.INTERFACE_PROPERTY, (Object)Boolean.TRUE, null);
        List members2 = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (members2.size() == 1 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = this.createNewMethod(ast, "newFoo", true);
        rewrite.replace((ASTNode)members2.get(0), (ASTNode)methodDecl, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "G");
        newModifiers = 0;
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.INTERFACE_PROPERTY, (Object)Boolean.FALSE, null);
        SimpleName newSuperclass2 = ast.newSimpleName("Object");
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_PROPERTY, (Object)newSuperclass2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class X extends Object implements Cloneable, Serializable {\n");
        buf.append("    private double fCount;\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface F extends Runnable {\n");
        buf.append("    private abstract void newFoo(String str);\n");
        buf.append("}\n");
        buf.append("class G extends Object {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclChanges2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("final class F implements Runnable {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        SimpleName name = type.getName();
        SimpleName newName = ast.newSimpleName("X");
        rewrite.replace((ASTNode)name, (ASTNode)newName, null);
        Type superClass = type.getSuperclassType();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super type", (superClass != null ? 1 : 0) != 0);
        SimpleType newSuperclass = ast.newSimpleType((Name)ast.newSimpleName("Object"));
        rewrite.replace((ASTNode)superClass, (ASTNode)newSuperclass, null);
        List superInterfaces = type.superInterfaceTypes();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super interfaces", (!superInterfaces.isEmpty() ? 1 : 0) != 0);
        SimpleType newSuperinterface = ast.newSimpleType((Name)ast.newSimpleName("Cloneable"));
        rewrite.replace((ASTNode)superInterfaces.get(0), (ASTNode)newSuperinterface, null);
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        FieldDeclaration newFieldDecl = this.createNewField(ast, "fCount");
        rewrite.replace((ASTNode)members.get(0), (ASTNode)newFieldDecl, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "F");
        rewrite.remove((ASTNode)type.modifiers().get(0), null);
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.INTERFACE_PROPERTY, (Object)Boolean.TRUE, null);
        List members2 = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (members2.size() == 1 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = this.createNewMethod(ast, "newFoo", true);
        rewrite.replace((ASTNode)members2.get(0), (ASTNode)methodDecl, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "G");
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.INTERFACE_PROPERTY, (Object)Boolean.FALSE, null);
        SimpleType newSuperclass2 = ast.newSimpleType((Name)ast.newSimpleName("Object"));
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)newSuperclass2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class X extends Object implements Cloneable, Serializable {\n");
        buf.append("    private double fCount;\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface F extends Runnable {\n");
        buf.append("    private abstract void newFoo(String str);\n");
        buf.append("}\n");
        buf.append("final class G extends Object {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclRemoves() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class F implements Runnable {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        int newModifiers = 0;
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.INTERFACE_PROPERTY, (Object)Boolean.TRUE, null);
        Name superClass = type.getSuperclass();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super type", (superClass != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)superClass, null);
        List superInterfaces = type.superInterfaces();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super interfaces", (!superInterfaces.isEmpty() ? 1 : 0) != 0);
        rewrite.remove((ASTNode)superInterfaces.get(0), null);
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        rewrite.remove((ASTNode)members.get(1), null);
        FunctionDeclaration meth = ASTRewritingTypeDeclTest.findMethodDeclaration(type, "hee");
        rewrite.remove((ASTNode)meth, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "F");
        newModifiers = 16;
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.INTERFACE_PROPERTY, (Object)Boolean.TRUE, null);
        List superInterfaces2 = type.superInterfaces();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has super interfaces", (!superInterfaces2.isEmpty() ? 1 : 0) != 0);
        rewrite.remove((ASTNode)superInterfaces2.get(0), null);
        List members2 = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (members2.size() == 1 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)members2.get(0), null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "G");
        rewrite.remove((ASTNode)type, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("interface E extends Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("final interface F {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclInserts() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class F implements Runnable {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingTypeDeclTest.assertTrue((String)"Errors in AST", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        int newModifiers = 17;
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        SimpleName newSuperinterface = ast.newSimpleName("Cloneable");
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.SUPER_INTERFACES_PROPERTY).insertFirst((ASTNode)newSuperinterface, null);
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        ASTRewritingTypeDeclTest.assertTrue((String)"Cannot find inner class", (boolean)(members.get(0) instanceof TypeDeclaration));
        TypeDeclaration innerType = (TypeDeclaration)members.get(0);
        FieldDeclaration newField = this.createNewField(ast, "fCount");
        rewrite.getListRewrite((ASTNode)innerType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newField, null);
        FunctionDeclaration newMethodDecl = this.createNewMethod(ast, "newMethod", false);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)newMethodDecl, 4, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "F");
        SimpleName newSuperclass = ast.newSimpleName("Exception");
        rewrite.set((ASTNode)type, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_PROPERTY, (Object)newSuperclass, null);
        FunctionDeclaration newMethodDecl2 = this.createNewMethod(ast, "newMethod", false);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast((ASTNode)newMethodDecl2, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "G");
        SimpleName newInterface = ast.newSimpleName("Runnable");
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.SUPER_INTERFACES_PROPERTY).insertLast((ASTNode)newInterface, null);
        newMethodDecl2 = this.createNewMethod(ast, "newMethod", true);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast((ASTNode)newMethodDecl2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public final class E extends Exception implements Cloneable, Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        private double fCount;\n");
        buf.append("\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("    private int i;\n");
        buf.append("    private int k;\n");
        buf.append("    public E() {\n");
        buf.append("    }\n");
        buf.append("    private void newMethod(String str) {\n");
        buf.append("    }\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("class F extends Exception implements Runnable {\n");
        buf.append("    public void foo() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void newMethod(String str) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        buf.append("interface G extends Runnable {\n");
        buf.append("\n");
        buf.append("    private abstract void newMethod(String str);\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclInsertFields1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("}\n");
        buf.append("class F {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingTypeDeclTest.assertTrue((String)"Errors in AST", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName("x"));
        FieldDeclaration decl = ast.newFieldDeclaration(frag);
        decl.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)decl, null);
        type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "F");
        VariableDeclarationFragment frag1 = ast.newVariableDeclarationFragment();
        frag1.setName(ast.newSimpleName("x"));
        FieldDeclaration decl1 = ast.newFieldDeclaration(frag1);
        decl1.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        VariableDeclarationFragment frag2 = ast.newVariableDeclarationFragment();
        frag2.setName(ast.newSimpleName("y"));
        FieldDeclaration decl2 = ast.newFieldDeclaration(frag2);
        decl2.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        listRewrite.insertFirst((ASTNode)decl1, null);
        listRewrite.insertAfter((ASTNode)decl2, (ASTNode)decl1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("\n");
        buf.append("    int x;\n");
        buf.append("}\n");
        buf.append("class F {\n");
        buf.append("\n");
        buf.append("    int x;\n");
        buf.append("    int y;\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeParameters() throws Exception {
        TypeDeclaration typeDecl;
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("class E extends A {}\n");
        buf.append("class F {}\n");
        buf.append("class G <T> extends A {}\n");
        buf.append("class H <T> {}\n");
        buf.append("class I<T> extends A {}\n");
        buf.append("class J<T>extends A {}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        List types = astRoot.types();
        int i = 0;
        while (i < 2) {
            typeDecl = (TypeDeclaration)types.get(i);
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)typeDecl, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            TypeParameter typeParameter = ast.newTypeParameter();
            typeParameter.setName(ast.newSimpleName("X"));
            listRewrite.insertFirst((ASTNode)typeParameter, null);
            ++i;
        }
        i = 2;
        while (i < 6) {
            typeDecl = (TypeDeclaration)types.get(i);
            rewrite.remove((ASTNode)typeDecl.typeParameters().get(0), null);
            ++i;
        }
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("class E<X> extends A {}\n");
        buf.append("class F<X> {}\n");
        buf.append("class G extends A {}\n");
        buf.append("class H {}\n");
        buf.append("class I extends A {}\n");
        buf.append("class J extends A {}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testBug22161() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class T extends Exception implements Runnable, Serializable {\n");
        buf.append("    public static class EInner {\n");
        buf.append("        public void xee() {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("T.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewritingTypeDeclTest.assertTrue((String)"Errors in AST", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "T");
        ASTRewritingTypeDeclTest.assertTrue((String)"Outer type not found", (type != null ? 1 : 0) != 0);
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Cannot find inner class", (members.size() == 1 && members.get(0) instanceof TypeDeclaration ? 1 : 0) != 0);
        TypeDeclaration innerType = (TypeDeclaration)members.get(0);
        SimpleName name = innerType.getName();
        ASTRewritingTypeDeclTest.assertTrue((String)"Name positions not correct", (name.getStartPosition() != -1 && name.getLength() > 0 ? 1 : 0) != 0);
    }

    public void testAnonymousClassDeclaration() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E2 {\n");
        buf.append("    public void foo() {\n");
        buf.append("        new Runnable() {\n");
        buf.append("        };\n");
        buf.append("        new Runnable() {\n");
        buf.append("            int i= 8;\n");
        buf.append("        };\n");
        buf.append("        new Runnable() {\n");
        buf.append("            int i= 8;\n");
        buf.append("        };\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E2.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E2");
        FunctionDeclaration methodDecl = ASTRewritingTypeDeclTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        ClassInstanceCreation creation = (ClassInstanceCreation)stmt.getExpression();
        AnonymousClassDeclaration anonym = creation.getAnonymousClassDeclaration();
        ASTRewritingTypeDeclTest.assertTrue((String)"no anonym class decl", (anonym != null ? 1 : 0) != 0);
        List decls = anonym.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of bodyDeclarations not 0", (decls.size() == 0 ? 1 : 0) != 0);
        FunctionDeclaration newMethod = this.createNewMethod(ast, "newMethod", false);
        rewrite.getListRewrite((ASTNode)anonym, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethod, null);
        stmt = (ExpressionStatement)statements.get(1);
        creation = (ClassInstanceCreation)stmt.getExpression();
        anonym = creation.getAnonymousClassDeclaration();
        ASTRewritingTypeDeclTest.assertTrue((String)"no anonym class decl", (anonym != null ? 1 : 0) != 0);
        decls = anonym.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of bodyDeclarations not 1", (decls.size() == 1 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)decls.get(0), null);
        stmt = (ExpressionStatement)statements.get(2);
        creation = (ClassInstanceCreation)stmt.getExpression();
        anonym = creation.getAnonymousClassDeclaration();
        ASTRewritingTypeDeclTest.assertTrue((String)"no anonym class decl", (anonym != null ? 1 : 0) != 0);
        decls = anonym.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of bodyDeclarations not 1", (decls.size() == 1 ? 1 : 0) != 0);
        newMethod = this.createNewMethod(ast, "newMethod", false);
        rewrite.replace((ASTNode)decls.get(0), (ASTNode)newMethod, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E2 {\n");
        buf.append("    public void foo() {\n");
        buf.append("        new Runnable() {\n");
        buf.append("\n");
        buf.append("            private void newMethod(String str) {\n");
        buf.append("            }\n");
        buf.append("        };\n");
        buf.append("        new Runnable() {\n");
        buf.append("        };\n");
        buf.append("        new Runnable() {\n");
        buf.append("            private void newMethod(String str) {\n");
        buf.append("            }\n");
        buf.append("        };\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testImportDeclaration() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.util.Vector;\n");
        buf.append("import java.net.*;\n");
        buf.append("import java.text.*;\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("Z.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List imports = astRoot.imports();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of imports not 4", (imports.size() == 4 ? 1 : 0) != 0);
        ImportDeclaration imp = (ImportDeclaration)imports.get(0);
        Name name = ast.newName(new String[]{"org", "eclipse", "X"});
        rewrite.replace((ASTNode)imp.getName(), (ASTNode)name, null);
        imp = (ImportDeclaration)imports.get(1);
        name = ast.newName(new String[]{"java", "util"});
        rewrite.replace((ASTNode)imp.getName(), (ASTNode)name, null);
        rewrite.set((ASTNode)imp, (StructuralPropertyDescriptor)ImportDeclaration.ON_DEMAND_PROPERTY, (Object)Boolean.TRUE, null);
        imp = (ImportDeclaration)imports.get(2);
        rewrite.set((ASTNode)imp, (StructuralPropertyDescriptor)ImportDeclaration.ON_DEMAND_PROPERTY, (Object)Boolean.FALSE, null);
        imp = (ImportDeclaration)imports.get(3);
        name = ast.newName(new String[]{"org", "eclipse"});
        rewrite.replace((ASTNode)imp.getName(), (ASTNode)name, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("import org.eclipse.X;\n");
        buf.append("import java.util.*;\n");
        buf.append("import java.net;\n");
        buf.append("import org.eclipse.*;\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testPackageDeclaration() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("Z.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        PackageDeclaration packageDeclaration = astRoot.getPackage();
        Name name = ast.newName(new String[]{"org", "eclipse"});
        rewrite.replace((ASTNode)packageDeclaration.getName(), (ASTNode)name, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package org.eclipse;\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testCompilationUnit() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("Z.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        PackageDeclaration packageDeclaration = astRoot.getPackage();
        rewrite.remove((ASTNode)packageDeclaration, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testCompilationUnit2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("public class Z {\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("Z.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
        Name name = ast.newName(new String[]{"org", "eclipse"});
        packageDeclaration.setName(name);
        rewrite.set((ASTNode)astRoot, (StructuralPropertyDescriptor)JavaScriptUnit.PACKAGE_PROPERTY, (Object)packageDeclaration, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package org.eclipse;\n");
        buf.append("public class Z {\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testSingleVariableDeclaration() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(int i, final int[] k, int[] x[]) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingTypeDeclTest.findMethodDeclaration(type, "foo");
        List arguments = methodDecl.parameters();
        SingleVariableDeclaration decl = (SingleVariableDeclaration)arguments.get(0);
        int newModifiers = 16;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(1), null);
        ArrayType newVarType = ast.newArrayType((Type)ast.newPrimitiveType(PrimitiveType.FLOAT), 2);
        rewrite.replace((ASTNode)decl.getType(), (ASTNode)newVarType, null);
        SimpleName newName = ast.newSimpleName("count");
        rewrite.replace((ASTNode)decl.getName(), (ASTNode)newName, null);
        decl = (SingleVariableDeclaration)arguments.get(1);
        newModifiers = 0;
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.MODIFIERS_PROPERTY, (Object)new Integer(newModifiers), null);
        newVarType = ast.newPrimitiveType(PrimitiveType.FLOAT);
        rewrite.replace((ASTNode)decl.getType(), (ASTNode)newVarType, null);
        decl = (SingleVariableDeclaration)arguments.get(2);
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)SingleVariableDeclaration.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(final float[][] count[], float k, int[] x) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testVariableDeclarationFragment() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        int i, j, k= 0, x[][], y[]= {0, 1};\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingTypeDeclTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingTypeDeclTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclStatement = (VariableDeclarationStatement)statements.get(0);
        List fragments = variableDeclStatement.fragments();
        ASTRewritingTypeDeclTest.assertTrue((String)"Number of fragments not 5", (fragments.size() == 5 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        SimpleName name = ast.newSimpleName("a");
        rewrite.replace((ASTNode)fragment.getName(), (ASTNode)name, null);
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(2), null);
        fragment = (VariableDeclarationFragment)fragments.get(1);
        ASTRewritingTypeDeclTest.assertTrue((String)"Has initializer", (fragment.getInitializer() == null ? 1 : 0) != 0);
        NumberLiteral initializer = ast.newNumberLiteral("1");
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)initializer, null);
        fragment = (VariableDeclarationFragment)fragments.get(2);
        ASTRewritingTypeDeclTest.assertTrue((String)"Has no initializer", (fragment.getInitializer() != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)fragment.getInitializer(), null);
        fragment = (VariableDeclarationFragment)fragments.get(3);
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(4), null);
        ASTRewritingTypeDeclTest.assertTrue((String)"Has initializer", (fragment.getInitializer() == null ? 1 : 0) != 0);
        initializer = ast.newNullLiteral();
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)initializer, null);
        fragment = (VariableDeclarationFragment)fragments.get(4);
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.EXTRA_DIMENSIONS_PROPERTY, (Object)new Integer(0), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        int a[][], j = 1, k, x[][][][] = null, y= {0, 1};\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclSpacingMethods1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        FunctionDeclaration newMethodDecl = this.createNewMethod(ast, "foo", false);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertLast((ASTNode)newMethodDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("    private void foo(String str) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclSpacingMethods2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        FunctionDeclaration newMethodDecl = this.createNewMethod(ast, "foo", false);
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newMethodDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    private void foo(String str) {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testTypeDeclSpacingFields() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    private int x;\n");
        buf.append("    private int y;\n");
        buf.append("\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        List members = type.bodyDeclarations();
        ASTRewritingTypeDeclTest.assertTrue((String)"Has declarations", (!members.isEmpty() ? 1 : 0) != 0);
        FieldDeclaration newField = this.createNewField(ast, "fCount");
        rewrite.getListRewrite((ASTNode)type, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)newField, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    private double fCount;\n");
        buf.append("    private int x;\n");
        buf.append("    private int y;\n");
        buf.append("\n");
        buf.append("    public void gee() {\n");
        buf.append("    }\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("    public void hee() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }

    public void testWildcardType() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    X<?, ?, ? extends A, ? super B, ? extends A, ? super B> x;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST3(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingTypeDeclTest.findTypeDeclaration(astRoot, "E");
        FieldDeclaration field = type.getFields()[0];
        ParameterizedType fieldType = (ParameterizedType)field.getType();
        List args = fieldType.typeArguments();
        WildcardType wildcardType = (WildcardType)args.get(0);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.UPPER_BOUND_PROPERTY, (Object)Boolean.TRUE, null);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.BOUND_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName("A")), null);
        wildcardType = (WildcardType)args.get(1);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.UPPER_BOUND_PROPERTY, (Object)Boolean.FALSE, null);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.BOUND_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName("B")), null);
        wildcardType = (WildcardType)args.get(2);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.UPPER_BOUND_PROPERTY, (Object)Boolean.FALSE, null);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.BOUND_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName("B")), null);
        wildcardType = (WildcardType)args.get(3);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.UPPER_BOUND_PROPERTY, (Object)Boolean.TRUE, null);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.BOUND_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName("A")), null);
        wildcardType = (WildcardType)args.get(4);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.BOUND_PROPERTY, null, null);
        wildcardType = (WildcardType)args.get(5);
        rewrite.set((ASTNode)wildcardType, (StructuralPropertyDescriptor)WildcardType.BOUND_PROPERTY, null, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    X<? extends A, ? super B, ? super B, ? extends A, ?, ?> x;\n");
        buf.append("}\n");
        ASTRewritingTypeDeclTest.assertEqualString(preview, buf.toString());
    }
}

