/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.jsdt.internal.ui.filters;


import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;


/** 
 * Filters out all output folders.
 * <p>
 * Note: Folder which are direct children of a Java element
 * are already filtered by the Java Model.
 * </p>
 * 
 * 
 */
public class OutputFolderFilter extends ViewerFilter {
	
	/**
	 * Returns the result of this filter, when applied to the
	 * given element.
	 *
	 * @param element the element to test 
	 * @return <code>true</code> if element should be included
	 * 
	 */
	public boolean select(Viewer viewer, Object parent, Object element) {
		if (element instanceof IFolder) {
			IFolder folder= (IFolder)element;
			IProject proj= folder.getProject();
			try {
				if (!proj.hasNature(JavaScriptCore.NATURE_ID))
					return true;
				
				IJavaScriptProject jProject= JavaScriptCore.create(folder.getProject());
				if (jProject == null || !jProject.exists())
					return true;
				
				// Check default output location
				IPath defaultOutputLocation= jProject.getOutputLocation();
				IPath folderPath= folder.getFullPath();
				if (defaultOutputLocation != null && defaultOutputLocation.equals(folderPath))
					return false;
				
				// Check output location for each class path entry
				IIncludePathEntry[] cpEntries= jProject.getRawIncludepath();
				for (int i= 0, length= cpEntries.length; i < length; i++) {
					IPath outputLocation= cpEntries[i].getOutputLocation();
					if (outputLocation != null && outputLocation.equals(folderPath))
						return false;
				}
			} catch (CoreException ex) {
				return true;
			}
		}
		return true;
	}
}
