/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.generator.ContentGenerator;
import org.eclipse.wst.wsdl.internal.generator.extension.ContentGeneratorExtensionFactoryRegistry;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Binding;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11SetAddressCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11SetBindingCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.specialized.W11AddressExtensibilityElementAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddEndPointAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDeleteAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDSetExistingBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDSetNewBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IEndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IService;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.util.CreateWSDLElementHelper;

public class W11EndPoint
extends WSDLBaseAdapter
implements IEndPoint,
IASDObjectListener {
    protected List addressExtensiblityElements = null;
    protected List thingsToListenTo = null;

    public String getAddress() {
        List list = this.getAddressExtensiblityElements();
        if (list.size() > 0) {
            W11AddressExtensibilityElementAdapter addressEE = (W11AddressExtensibilityElementAdapter)list.get(0);
            return addressEE.getLocationURI();
        }
        return "";
    }

    public List getApplicableProtocol() {
        ContentGeneratorExtensionFactoryRegistry factoryRegistry = ContentGeneratorExtensionFactoryRegistry.getInstance();
        List protocols = factoryRegistry.getBindingExtensionNames();
        return protocols;
    }

    public void setProtocol(String newProtocol) {
        ContentGeneratorExtensionFactoryRegistry factoryRegistry = ContentGeneratorExtensionFactoryRegistry.getInstance();
        ContentGenerator contentGenerator = factoryRegistry.getGeneratorClassFromName(newProtocol);
        if (contentGenerator != null) {
            String currentAddress = this.getAddress();
            if (currentAddress != null) {
                contentGenerator.setAddressLocation(currentAddress);
            }
            Port port = this.getPort();
            CreateWSDLElementHelper.addRequiredNamespaces(contentGenerator, port.getEnclosingDefinition());
            contentGenerator.generatePortContent(port);
        }
    }

    protected List getAddressExtensiblityElements() {
        this.addressExtensiblityElements = new ArrayList();
        this.thingsToListenTo = new ArrayList();
        Port port = (Port)this.getTarget();
        Iterator it = port.getEExtensibilityElements().iterator();
        while (it.hasNext()) {
            Notifier item = (Notifier)it.next();
            Adapter adapter = this.createAdapter(item);
            if (adapter instanceof W11AddressExtensibilityElementAdapter) {
                this.addressExtensiblityElements.add(adapter);
            }
            if (!(adapter instanceof IASDObject)) continue;
            this.thingsToListenTo.add(adapter);
        }
        Iterator i = this.thingsToListenTo.iterator();
        while (i.hasNext()) {
            IASDObject object = (IASDObject)i.next();
            object.registerListener(this);
        }
        return this.addressExtensiblityElements;
    }

    protected void clearAddressExtensiblityElements() {
        if (this.thingsToListenTo != null) {
            Iterator i = this.thingsToListenTo.iterator();
            while (i.hasNext()) {
                IASDObject object = (IASDObject)i.next();
                object.unregisterListener(this);
            }
        }
        this.thingsToListenTo = null;
        this.addressExtensiblityElements = null;
    }

    public IBinding getBinding() {
        if (this.getPort().getEBinding() != null) {
            return (IBinding)this.createAdapter((Notifier)this.getPort().getEBinding());
        }
        return null;
    }

    public String getName() {
        return this.getPort().getName();
    }

    public String getTypeName() {
        return this.getAddress();
    }

    public Object getType() {
        return this.getBinding();
    }

    private Port getPort() {
        return (Port)this.target;
    }

    public IService getOwnerService() {
        return (IService)((Object)this.owner);
    }

    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        actionIDs.add(ASDAddEndPointAction.ID);
        actionIDs.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_BINDING);
        actionIDs.add(ASDSetNewBindingAction.ID);
        actionIDs.add(ASDSetExistingBindingAction.ID);
        actionIDs.add("SUBMENU_END_ID: ");
        actionIDs.add(ASDDeleteAction.ID);
        if (this.isReadOnly()) {
            actionIDs.add("org.eclipse.wst.wsdl.ui.OpenInNewEditor");
        }
        return actionIDs.toArray(new String[0]);
    }

    public Command getSetBindingCommand(IBinding binding) {
        W11Binding w11Binding = (W11Binding)binding;
        return new W11SetBindingCommand((Port)this.target, (Binding)w11Binding.getTarget());
    }

    public Command getSetAddressCommand(String newAddress) {
        return new W11SetAddressCommand((Port)this.getTarget(), newAddress);
    }

    public void propertyChanged(Object object, String property) {
        this.clearAddressExtensiblityElements();
        this.notifyListeners(this, null);
    }

    public Image getImage() {
        return WSDLEditorPlugin.getInstance().getImage("icons/port_obj.gif");
    }

    public String getText() {
        return "port";
    }

    public ITreeElement[] getChildren() {
        return ITreeElement.EMPTY_LIST;
    }

    public boolean hasChildren() {
        return false;
    }

    public ITreeElement getParent() {
        return null;
    }

    public String getProtocol() {
        ContentGeneratorExtensionFactoryRegistry factoryRegistry;
        ContentGenerator contentGenerator;
        WSDLElement wsdlElement;
        String namespace;
        W11AddressExtensibilityElementAdapter addressEE;
        Notifier target;
        String protocol = "";
        List list = this.getAddressExtensiblityElements();
        if (list.size() > 0 && (target = (addressEE = (W11AddressExtensibilityElementAdapter)list.get(0)).getTarget()) instanceof WSDLElement && (namespace = (wsdlElement = (WSDLElement)target).getElement().getNamespaceURI()) != null && (contentGenerator = (factoryRegistry = ContentGeneratorExtensionFactoryRegistry.getInstance()).getGeneratorClassFromNamespace(namespace)) != null) {
            protocol = contentGenerator.getProtocol();
        }
        return protocol;
    }
}

