/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.tests.utils.StringCompareUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;

public class TestFormatProcessorHTML
extends TestCase {
    private static final boolean SPLIT_MULTI_ATTRS = false;
    private static final String INDENT = "\t";
    private static final boolean CLEAR_ALL_BLANK_LINES = false;
    private static final int MAX_LINE_WIDTH = 72;
    private static final String UTF_8 = "UTF-8";
    private StringCompareUtil fStringCompareUtil;
    private HTMLFormatProcessorImpl formatProcessor;

    public TestFormatProcessorHTML(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.formatProcessor = new HTMLFormatProcessorImpl();
        this.fStringCompareUtil = new StringCompareUtil();
    }

    private IStructuredModel getModelForEdit(String filename) {
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
            if (inStream == null) {
                throw new FileNotFoundException("Can't file resource stream " + filename);
            }
            String baseFile = ((Object)((Object)this)).getClass().getResource(filename).toString();
            model = modelManager.getModelForEdit(baseFile, inStream, new URIResolver(baseFile){
                String fBase;
                {
                    this.fBase = string;
                }

                public String getFileBaseLocation() {
                    return this.fBase;
                }

                public String getLocationByURI(String uri) {
                    return this.getLocationByURI(uri, this.fBase);
                }

                public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri);
                }

                public String getLocationByURI(String uri, String baseReference) {
                    int lastSlash = baseReference.lastIndexOf("/");
                    if (lastSlash > 0) {
                        return String.valueOf(baseReference.substring(0, lastSlash + 1)) + uri;
                    }
                    return baseReference;
                }

                public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
                    return this.getLocationByURI(uri, baseReference);
                }

                public IProject getProject() {
                    return null;
                }

                public IContainer getRootLocation() {
                    return null;
                }

                public InputStream getURIStream(String uri) {
                    return this.getClass().getResourceAsStream(this.getLocationByURI(uri));
                }

                public void setFileBaseLocation(String newLocation) {
                    this.fBase = newLocation;
                }

                public void setProject(IProject newProject) {
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return model;
    }

    protected void formatAndAssertEquals(String beforePath, String afterPath) throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath, boolean resetPreferences) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block5: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                TestFormatProcessorHTML.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                TestFormatProcessorHTML.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                if (resetPreferences) {
                    this.resetPreferencesToDefault();
                }
                this.formatProcessor.refreshFormatPreferences = false;
                this.formatProcessor.formatModel(beforeModel);
                this.formatProcessor.refreshFormatPreferences = true;
                ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)formattedBytes);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String expectedContents = new String(afterBytes.toByteArray(), UTF_8);
                String actualContents = new String(formattedBytes.toByteArray(), UTF_8);
                TestFormatProcessorHTML.assertTrue((String)("Formatted document differs from the expected.\nExpected Contents:\n" + expectedContents + "\nActual Contents:\n" + actualContents), (boolean)this.fStringCompareUtil.equalsIgnoreLineSeperator(expectedContents, actualContents));
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (beforeModel == null) break block5;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    private void resetPreferencesToDefault() {
        IStructuredFormatPreferences formatPreferences = this.formatProcessor.getFormatPreferences();
        formatPreferences.setLineWidth(72);
        formatPreferences.setClearAllBlankLines(false);
        formatPreferences.setIndent(INDENT);
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(false);
    }

    public void testTableFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/html/tableformat.html", "testfiles/html/tableformat-fmt.html");
    }

    public void testEmbeddedCSSFormat() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("testfiles/html/htmlwithcss.html", "testfiles/html/htmlwithcss-fmt.html");
    }

    public void testAttributeFormat() throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredFormatPreferences formatPreferences = this.formatProcessor.getFormatPreferences();
        ((StructuredFormatPreferencesXML)formatPreferences).setSplitMultiAttrs(true);
        ((StructuredFormatPreferencesXML)formatPreferences).setAlignEndBracket(true);
        this.formatAndAssertEquals("testfiles/html/attributesformat.html", "testfiles/html/attributesformat-fmt.html", false);
    }
}

