/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexDelta;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.jsp.core.taglib.TaglibIndexDelta;
import org.eclipse.jst.jsp.ui.tests.JSPUITestsPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TaglibIndexDeltaTraceView
extends ViewPart {
    static final String MEM_LISTENING = "IS_LISTENING";
    boolean isListening = false;
    ITaglibIndexListener fInternalListener = null;
    List fInput = new ArrayList();
    TableViewer fViewer = null;
    ResumeAction fResumeAction;
    SuspendAction fSuspendAction;
    IAction fClearAction;

    public TaglibIndexDeltaTraceView() {
        this.fInternalListener = new TaglibIndexListener();
    }

    void showSelectionDetail(Composite composite) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            final TaglibIndexDelta selectedDelta = (TaglibIndexDelta)selection.getFirstElement();
            final ITableLabelProvider tableLabelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
            String columnText = tableLabelProvider.getColumnText((Object)selectedDelta, 1);
            columnText = String.valueOf(columnText) + ":" + tableLabelProvider.getColumnText((Object)selectedDelta, 2);
            new Dialog(composite.getShell()){

                public void create() {
                    this.setShellStyle(this.getShellStyle() | 0x10);
                    super.create();
                }

                protected Control createDialogArea(Composite parent) {
                    Composite inner = new Composite(parent, 0);
                    inner.setLayoutData((Object)new GridData(4, 4, true, true));
                    Sash sash = new Sash(inner, 256);
                    TreeViewer treeViewer = new TreeViewer(inner);
                    treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(this, selectedDelta){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ TaglibIndexDelta val$selectedDelta;
                        {
                            this.this$1 = var1_1;
                            this.val$selectedDelta = taglibIndexDelta;
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }

                        public void dispose() {
                        }

                        public Object[] getElements(Object inputElement) {
                            return this.getChildren(inputElement);
                        }

                        public boolean hasChildren(Object element) {
                            return this.getChildren(element).length > 0;
                        }

                        public Object getParent(Object element) {
                            return this.val$selectedDelta;
                        }

                        public Object[] getChildren(Object parentElement) {
                            if (parentElement instanceof TaglibIndexDelta) {
                                TaglibIndexDelta taglibIndexDelta = (TaglibIndexDelta)parentElement;
                                if (taglibIndexDelta.getTrigger() != null) {
                                    ArrayList<Object> combined = new ArrayList<Object>();
                                    combined.add(taglibIndexDelta.getTrigger());
                                    combined.addAll(Arrays.asList(taglibIndexDelta.getAffectedChildren()));
                                    return combined.toArray();
                                }
                                return taglibIndexDelta.getAffectedChildren();
                            }
                            return new Object[0];
                        }
                    });
                    treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(this, tableLabelProvider, selectedDelta){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ ITableLabelProvider val$tableLabelProvider;
                        private final /* synthetic */ TaglibIndexDelta val$selectedDelta;
                        {
                            this.this$1 = var1_1;
                            this.val$tableLabelProvider = iTableLabelProvider;
                            this.val$selectedDelta = taglibIndexDelta;
                        }

                        public String getText(Object element) {
                            if (element instanceof ITaglibIndexDelta) {
                                ITaglibIndexDelta taglibIndexDelta = (ITaglibIndexDelta)element;
                                if (taglibIndexDelta.getTaglibRecord() != null) {
                                    return taglibIndexDelta.toString();
                                }
                                String text = this.val$tableLabelProvider.getColumnText((Object)this.val$selectedDelta, 1);
                                text = String.valueOf(text) + ":" + this.val$tableLabelProvider.getColumnText((Object)this.val$selectedDelta, 2);
                                return text;
                            }
                            return StringUtils.firstLineOf((String)super.getText(element));
                        }
                    });
                    treeViewer.setInput((Object)selectedDelta);
                    Text text = new Text(inner, 2);
                    treeViewer.addSelectionChangedListener(new ISelectionChangedListener(this, treeViewer, text){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ TreeViewer val$treeViewer;
                        private final /* synthetic */ Text val$text;
                        {
                            this.this$1 = var1_1;
                            this.val$treeViewer = treeViewer;
                            this.val$text = text;
                        }

                        public void selectionChanged(SelectionChangedEvent event) {
                            IStructuredSelection selection2 = (IStructuredSelection)this.val$treeViewer.getSelection();
                            if (!selection2.isEmpty()) {
                                this.val$text.setText("" + selection2.getFirstElement());
                            } else {
                                this.val$text.setText("");
                            }
                        }
                    });
                    FormLayout form = new FormLayout();
                    inner.setLayout((Layout)form);
                    FormData firstData = new FormData();
                    firstData.top = new FormAttachment(0, 0);
                    firstData.bottom = new FormAttachment((Control)sash, 2);
                    firstData.left = new FormAttachment(0, 0);
                    firstData.right = new FormAttachment(100, 0);
                    treeViewer.getControl().setLayoutData((Object)firstData);
                    FormData secondData = new FormData();
                    secondData.top = new FormAttachment((Control)sash, 2);
                    secondData.left = new FormAttachment(0, 0);
                    secondData.right = new FormAttachment(100, 0);
                    secondData.bottom = new FormAttachment(100, 0);
                    text.setLayoutData((Object)secondData);
                    FormData sashData = new FormData();
                    sashData.top = new FormAttachment(60, 0);
                    sashData.left = new FormAttachment(0, 0);
                    sashData.right = new FormAttachment(100, 0);
                    sash.setLayoutData((Object)sashData);
                    sash.addListener(13, new Listener(this, sashData, inner){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ FormData val$sashData;
                        private final /* synthetic */ Composite val$inner;
                        {
                            this.this$1 = var1_1;
                            this.val$sashData = formData;
                            this.val$inner = composite;
                        }

                        public void handleEvent(Event e) {
                            this.val$sashData.top = new FormAttachment(0, e.y);
                            this.val$inner.layout();
                        }
                    });
                    return sash;
                }
            }.open();
        }
    }

    public void createPartControl(final Composite parent) {
        this.fViewer = new TableViewer(parent, 65540);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TaglibIndexDeltaTraceView.this.showSelectionDetail(parent);
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Long.toString(((TaglibIndexDelta)element).getTime());
                    }
                    case 1: {
                        String kind = null;
                        switch (((ITaglibIndexDelta)element).getKind()) {
                            case 1: {
                                kind = "added";
                                break;
                            }
                            case 2: {
                                kind = "removed";
                                break;
                            }
                            case 4: {
                                kind = "changed";
                            }
                        }
                        return kind;
                    }
                    case 2: {
                        return ((ITaglibIndexDelta)element).getProject().getName();
                    }
                    case 3: {
                        return ((TaglibIndexDelta)element).getTrigger().toString();
                    }
                }
                return "";
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        String[] columnProperties = new String[]{"time", "Kind", "Project", "Trigger"};
        TableLayout tlayout = new TableLayout();
        CellEditor[] cellEditors = new CellEditor[columnProperties.length];
        int[] columnWidths = new int[]{Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 7, Display.getCurrent().getBounds().width / 7, Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 7};
        int i = 0;
        while (i < columnProperties.length) {
            tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
            TableColumn tc = new TableColumn(this.fViewer.getTable(), 0);
            tc.setText(columnProperties[i]);
            tc.setResizable(true);
            tc.setWidth(columnWidths[i]);
            ++i;
        }
        this.fViewer.setCellEditors(cellEditors);
        this.fViewer.setColumnProperties(columnProperties);
        this.fViewer.getTable().setHeaderVisible(true);
        this.fViewer.getTable().setLinesVisible(true);
        this.fViewer.setColumnProperties(columnProperties);
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.setRemoveAllWhenShown(false);
        contextMenuManager.add((IAction)new Action(){

            public void run() {
                super.run();
                TaglibIndexDeltaTraceView.this.showSelectionDetail(parent);
            }

            public String getText() {
                return "Details...";
            }

            public boolean isEnabled() {
                return !TaglibIndexDeltaTraceView.this.fViewer.getSelection().isEmpty();
            }
        });
        Menu contextMenu = contextMenuManager.createContextMenu(this.fViewer.getControl());
        this.getControl().setMenu(contextMenu);
        this.fViewer.setInput((Object)this.fInput);
    }

    public void dispose() {
        super.dispose();
        TaglibIndex.removeTaglibIndexListener((ITaglibIndexListener)this.fInternalListener);
    }

    Control getControl() {
        return this.fViewer.getControl();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        boolean shouldListen;
        super.init(site, memento);
        boolean bl = shouldListen = memento != null && Boolean.valueOf(memento.getString(MEM_LISTENING)) != false;
        if (shouldListen) {
            TaglibIndex.addTaglibIndexListener((ITaglibIndexListener)this.fInternalListener);
            this.isListening = true;
        }
        this.fResumeAction = new ResumeAction();
        this.fSuspendAction = new SuspendAction();
        this.fClearAction = new ClearAction();
        this.fSuspendAction.setEnabled(this.isListening);
        this.fResumeAction.setEnabled(!this.isListening);
        IToolBarManager mgr = site.getActionBars().getToolBarManager();
        mgr.add((IAction)this.fResumeAction);
        mgr.add((IAction)this.fSuspendAction);
        mgr.add(this.fClearAction);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(MEM_LISTENING, Boolean.toString(this.isListening));
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    private class ClearAction
    extends Action {
        public ClearAction() {
            this.setText("Clear");
            this.setImageDescriptor(JSPUITestsPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/elcl16/CLEAR"));
            this.setDisabledImageDescriptor(JSPUITestsPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/dlcl16/CLEAR"));
        }

        public void run() {
            super.run();
            TaglibIndexDeltaTraceView.this.fInput.clear();
            TaglibIndexDeltaTraceView.this.fViewer.refresh();
            this.setEnabled(false);
        }
    }

    private class ResumeAction
    extends Action {
        public ResumeAction() {
            this.setText("Resume");
            this.setImageDescriptor(JSPUITestsPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/elcl16/RESUME"));
            this.setDisabledImageDescriptor(JSPUITestsPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/dlcl16/RESUME"));
        }

        public void run() {
            super.run();
            TaglibIndex.addTaglibIndexListener((ITaglibIndexListener)TaglibIndexDeltaTraceView.this.fInternalListener);
            TaglibIndexDeltaTraceView.this.isListening = true;
            TaglibIndexDeltaTraceView.this.fSuspendAction.setEnabled(true);
            this.setEnabled(false);
        }
    }

    private class SuspendAction
    extends Action {
        public SuspendAction() {
            this.setText("Suspend");
            this.setImageDescriptor(JSPUITestsPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/elcl16/SUSPEND"));
            this.setDisabledImageDescriptor(JSPUITestsPlugin.getDefault().getImageRegistry().getDescriptor("icons/full/dlcl16/SUSPEND"));
        }

        public void run() {
            super.run();
            TaglibIndex.removeTaglibIndexListener((ITaglibIndexListener)TaglibIndexDeltaTraceView.this.fInternalListener);
            TaglibIndexDeltaTraceView.this.isListening = false;
            this.setEnabled(false);
            TaglibIndexDeltaTraceView.this.fResumeAction.setEnabled(true);
        }
    }

    class TaglibIndexListener
    implements ITaglibIndexListener {
        TaglibIndexListener() {
        }

        public void indexChanged(ITaglibIndexDelta delta) {
            TaglibIndexDeltaTraceView.this.getControl().getDisplay().syncExec(new Runnable(this, delta){
                final /* synthetic */ TaglibIndexListener this$1;
                private final /* synthetic */ ITaglibIndexDelta val$delta;
                {
                    this.this$1 = taglibIndexListener;
                    this.val$delta = iTaglibIndexDelta;
                }

                public void run() {
                    TaglibIndexListener.access$0((TaglibIndexListener)this.this$1).fInput.add(this.val$delta);
                    TaglibIndexListener.access$0((TaglibIndexListener)this.this$1).fViewer.refresh();
                    TaglibIndexListener.access$0((TaglibIndexListener)this.this$1).fViewer.setSelection((ISelection)new StructuredSelection((Object)this.val$delta));
                    TaglibIndexListener.access$0((TaglibIndexListener)this.this$1).fClearAction.setEnabled(true);
                }
            });
        }

        static /* synthetic */ TaglibIndexDeltaTraceView access$0(TaglibIndexListener taglibIndexListener) {
            return taglibIndexListener.TaglibIndexDeltaTraceView.this;
        }
    }
}

