/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.common.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;

public class EjbRefTest
extends TestCase {
    private static final EjbFactory EJBFACTORY = EjbPackage.eINSTANCE.getEjbFactory();
    private static final CommonFactory COMMONFACTORY = CommonPackage.eINSTANCE.getCommonFactory();
    static /* synthetic */ Class class$0;

    private EjbRef getInstance() {
        return COMMONFACTORY.createEjbRef();
    }

    public void test_EjbRef() {
        EjbRef tmpEjbRef = this.getInstance();
        EjbRefTest.assertNotNull((Object)tmpEjbRef);
    }

    public void test_getLinkedEjb() {
        EJBJar objEJBJar = EJBFACTORY.createEJBJar();
        AssemblyDescriptor descriptor = EJBFACTORY.createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        EjbRef ejbRef = COMMONFACTORY.createEjbRef();
        Session session1 = EJBFACTORY.createSession();
        String name1 = "Name1";
        session1.setName(name1);
        Session session2 = EJBFACTORY.createSession();
        String name2 = "Name2";
        session2.setName(name2);
        ejbRef.setLink(name2);
        ejbRef.setName("EjbRef_" + name2);
        objEJBJar.getEnterpriseBeans().add((Object)session1);
        objEJBJar.getEnterpriseBeans().add((Object)session2);
        EnterpriseBean retValue = null;
        retValue = ejbRef.getLinkedEjb(objEJBJar);
        EjbRefTest.assertEquals((Object)session2, (Object)retValue);
    }

    public void test_isEquivalent() {
        EJBJar objEJBJar = EJBFACTORY.createEJBJar();
        AssemblyDescriptor descriptor = EJBFACTORY.createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        EjbRef ejbRef1 = COMMONFACTORY.createEjbRef();
        EjbRef ejbRef2 = COMMONFACTORY.createEjbRef();
        Session session1 = EJBFACTORY.createSession();
        String name1 = "Name1";
        session1.setName(name1);
        Session session2 = EJBFACTORY.createSession();
        String name2 = "Name2";
        session2.setName(name2);
        ejbRef1.setLink(name2);
        ejbRef1.setName("EjbRef_" + name2);
        ejbRef2.setLink(name2);
        ejbRef2.setName("EjbRef_" + name2);
        String home1 = "home1";
        String home2 = "home2";
        String remote1 = "remote1";
        String remote2 = "remote2";
        ejbRef1.setHome(home1);
        ejbRef2.setHome(home1);
        ejbRef1.setRemote(remote1);
        ejbRef2.setRemote(remote1);
        objEJBJar.getEnterpriseBeans().add((Object)session1);
        objEJBJar.getEnterpriseBeans().add((Object)session2);
        boolean retValue = false;
        retValue = ejbRef1.isEquivalent(ejbRef2);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)true);
        ejbRef2.setRemote(remote2);
        retValue = ejbRef1.isEquivalent(ejbRef2);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)false);
        ejbRef2.setRemote(remote1);
        ejbRef2.setHome(home2);
        retValue = ejbRef1.isEquivalent(ejbRef2);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)false);
        ejbRef2.setHome(home1);
        ejbRef2.setLink(name1);
        retValue = ejbRef1.isEquivalent(ejbRef2);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)false);
        ejbRef2.setLink(name2);
        ejbRef2.setName("EjbRef_" + name1);
        retValue = ejbRef1.isEquivalent(ejbRef2);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isLinked() {
        Session session1 = EJBFACTORY.createSession();
        String name1 = "Name1";
        session1.setName(name1);
        EjbRef objEjbRef = this.getInstance();
        boolean retValue = false;
        retValue = objEjbRef.isLinked((EnterpriseBean)session1);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)false);
        objEjbRef.setLink(name1);
        retValue = objEjbRef.isLinked((EnterpriseBean)session1);
        EjbRefTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_isLocal() {
        EjbRef objEjbRef = this.getInstance();
        boolean retValue = false;
        retValue = objEjbRef.isLocal();
        EjbRefTest.assertEquals((boolean)retValue, (boolean)false);
        EJBLocalRef objLocalRef = CommonPackage.eINSTANCE.getCommonFactory().createEJBLocalRef();
        retValue = objLocalRef.isLocal();
        EjbRefTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.common.test.EjbRefTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }
}

