/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.contentassist.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.contentassist.tests.BaseTestClass;
import org.eclipse.jst.jsf.contentassist.tests.ContentAssistTestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class Test_bug_149224
extends BaseTestClass {
    private WebProjectTestEnvironment _testEnv;
    private IFile _jspFile;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._testEnv = new WebProjectTestEnvironment("Test_bug_149224_" + this.getName());
        this._testEnv.createProject(false);
        Test_bug_149224.assertNotNull((Object)this._testEnv);
        Test_bug_149224.assertNotNull((Object)this._testEnv.getTestProject());
        Test_bug_149224.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
        this._jspFile = (IFile)this._testEnv.loadResourceInWebRoot(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/bug_149224_1.jsp.data", "/bug_149224.jsp");
        Test_bug_149224.assertNotNull((Object)this._jspFile);
        Test_bug_149224.assertTrue((boolean)this._jspFile.isAccessible());
        JDTTestEnvironment jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        TestFileResource resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        resource = new TestFileResource();
        resource.load(ContentAssistTestsPlugin.getDefault().getBundle(), "/testdata/bug_149224.properties.data");
        jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "bundles", "bundle1.properties");
    }

    public void testSanity() throws Exception {
        Object wrapper = null;
        try {
            JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)589, (String)"value", (String)"#{bundle1.}");
            JSFCoreUtilHelper.assertELSanity((IFile)this._jspFile, (int)630, (String)"value", (String)"#{bundle1.x}");
            JSFCoreUtilHelper.assertELVariableSanity((IFile)this._jspFile, (String)"bundle1");
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }

    public void testCompletionAtCloseBrace() throws Exception {
        List<ICompletionProposal> proposals = this.getProposals(this._jspFile, 589, "bundle1.", 9);
        Test_bug_149224.assertNotNull(proposals);
        ICompletionProposal proposal = null;
        for (ICompletionProposal findProp : proposals) {
            if (!findProp.getDisplayString().startsWith("['")) continue;
            proposal = findProp;
            break;
        }
        Test_bug_149224.assertNotNull(proposal);
        this.applyAndCheck(this._jspFile, 589, proposal, "bundle1['prop.with.dots_x']");
    }

    public void testCompletionAtProperty() throws Exception {
        Object wrapper = null;
        try {
            List<ICompletionProposal> proposals = this.getProposals(this._jspFile, 630, 9);
            ICompletionProposal proposal = null;
            for (ICompletionProposal completionProposal : proposals) {
                proposal = completionProposal;
                if (proposal.getDisplayString().startsWith("['")) break;
            }
            Test_bug_149224.assertNotNull(proposal);
            this.applyAndCheck(this._jspFile, 630, proposal, "bundle1['prop.with.dots_x']x");
        }
        finally {
            if (wrapper != null) {
                wrapper.dispose();
            }
        }
    }
}

